/*
 * Decompiled with CFR 0.152.
 */
package geonoteInterface;

import geonoteOutils.BarreEtat;
import geonoteOutils.FiltreExtensible;
import geonoteOutils.Traceur;
import geonoteOutils.TraceurCarte;
import geonoteOutils.TraceurDonnee;
import geonoteOutils.TraceurSession;
import geonoteOutils.TraceurTraces;
import geonoteZones.Carnet;
import geonoteZones.Docs;
import geonoteZones.Historique;
import geonoteZones.Visualisation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class Interface
extends JFrame {
    static String version = "0.3";
    private String espaceDeTravail = "";
    private String espaceDonnees = "";
    private String espaceTraces = "";
    private String espaceSessions = "";
    private String espaceCartes = "";
    private String espaceDocs = "";
    private String espaceGeorefs = "";
    private int largeurMin = 640;
    private int hauteurMin = 480;
    private String extensionsCartes = "";
    private String extensionsDocs = "";
    private String extensionsTextes = "";
    private String userName = "";
    private String nomFichierSession = "";
    private String nomFichierTraces = "";
    private boolean sauv\u00e9 = true;
    private boolean tracesActives = true;
    private boolean carteModifi\u00e9e = false;
    private boolean docsModifi\u00e9 = false;
    private boolean modeEdition = false;
    private boolean fenetreActive = false;
    private boolean affichageArretsActif = true;
    private boolean affichageCoordActif = false;
    private TraceurSession traceurSession = null;
    private TraceurTraces traceurTraces = null;
    private TraceurCarte traceurCarteEdition = null;
    private TraceurDonnee traceurDonneeEdition = null;
    public Historique historique = null;
    private Visualisation visualisation = null;
    private Carnet carnet = null;
    private Docs docs = null;
    private BarreEtat bar = null;
    private JSplitPane splitPane1 = null;
    private JSplitPane splitPane2 = null;
    private JSplitPane splitPanePrincipal = null;
    private JMenuBar barreM = null;
    private JMenu fichierM = null;
    private JMenuItem nouvSessionM = null;
    private JMenuItem chargSessionM = null;
    private JMenuItem enregM = null;
    private JMenuItem nouvTexteM = null;
    private JMenuItem quitterM = null;
    private JMenu carnetM = null;
    private JMenuItem copierM = null;
    private JMenuItem couperM = null;
    private JMenuItem collerM = null;
    private JMenuItem insertionVisuM = null;
    private JMenuItem insertionDocsM = null;
    private JMenu affichageM = null;
    private JCheckBoxMenuItem historiqueCB = null;
    private JCheckBoxMenuItem visualisationCB = null;
    private JCheckBoxMenuItem carnetCB = null;
    private JCheckBoxMenuItem docsCB = null;
    private JCheckBoxMenuItem arretsCB = null;
    private JCheckBoxMenuItem coordCB = null;
    private JMenu aideM = null;
    private JMenuItem helpM = null;
    private JMenuItem aproposM = null;
    private JMenu outilsM = null;
    private JMenuItem docsM = null;
    private JMenuItem calendrierM = null;
    private JMenuItem parametrageM = null;
    private JMenuItem lexiqueM = null;
    private JMenu editionM = null;
    private JMenuItem edActiverM = null;
    private JMenuItem edDesactiverM = null;
    private JMenu carteM = null;
    private JMenuItem nouvCarteM = null;
    private JMenuItem nouvVueM = null;
    private JMenuItem modifCarteM = null;
    private JMenuItem suppCarteM = null;
    private JMenuItem enregCarteM = null;
    private JMenu edDocsM = null;
    private JMenuItem nouvDocsM = null;
    private JMenuItem modifDocsM = null;
    private JMenuItem suppDocsM = null;
    private JMenuItem enregDocsM = null;

    public Interface() {
        super("G\u00e9onote " + version);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.espaceDeTravail = String.valueOf(System.getProperty("user.dir")) + "\\";
        Traceur config = new Traceur();
        boolean result = config.charger(String.valueOf(this.espaceDeTravail) + "config.xml");
        if (result) {
            this.espaceTraces = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceTraces");
            this.espaceDonnees = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceDonnees");
            this.espaceSessions = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceSessions");
            this.espaceCartes = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceCartes");
            this.espaceDocs = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceDocs");
            this.espaceGeorefs = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceGeorefs");
            this.extensionsCartes = config.exporteInfo("extensionsCartes");
            this.extensionsDocs = config.exporteInfo("extensionsDocs");
            this.extensionsTextes = config.exporteInfo("extensionsTextes");
            String largeur = config.exporteInfo("largeur");
            this.largeurMin = Integer.parseInt(largeur);
            String hauteur = config.exporteInfo("hauteur");
            this.hauteurMin = Integer.parseInt(hauteur);
            this.tracesActives = config.exporteInfo("traces").matches("actives");
            this.setSize(new Dimension(this.largeurMin, this.hauteurMin));
            this.setMinimumSize(new Dimension(Integer.parseInt(largeur), Integer.parseInt(hauteur)));
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Erreur de chargement du fichier de configuration !!!", "ERREUR !", 2);
            System.out.println("Erreur de chargement du fichier de configuration !!!");
            System.exit(0);
        }
        this.setLocationRelativeTo(null);
        this.setResizable(true);
        this.setDefaultCloseOperation(3);
        this.historique = new Historique(this);
        this.visualisation = new Visualisation(this);
        this.carnet = new Carnet(this);
        this.docs = new Docs(this);
        this.splitPanePrincipal = new JSplitPane(0);
        this.splitPanePrincipal.setDividerLocation(this.getHeight() * 3 / 4);
        this.splitPanePrincipal.setPreferredSize(new Dimension(this.largeurMin, this.hauteurMin));
        this.splitPanePrincipal.setMinimumSize(new Dimension(this.largeurMin, this.hauteurMin));
        this.splitPane1 = new JSplitPane(1);
        this.splitPane1.setDividerLocation(this.getWidth() / 4);
        this.splitPane2 = new JSplitPane(1);
        this.splitPane2.setDividerLocation(this.getWidth() * 3 / 8);
        this.splitPane1.setBorder(null);
        this.splitPane2.setBorder(null);
        this.splitPanePrincipal.setDividerSize(4);
        this.splitPane1.setDividerSize(4);
        this.splitPane2.setDividerSize(4);
        this.splitPane2.setLeftComponent(this.visualisation);
        this.splitPane2.setRightComponent(this.docs);
        this.splitPane1.setLeftComponent(this.historique);
        this.splitPane1.setRightComponent(this.splitPane2);
        this.splitPanePrincipal.setTopComponent(this.splitPane1);
        this.splitPanePrincipal.setBottomComponent(this.carnet);
        this.add((Component)this.splitPanePrincipal, "Center");
        this.barreM = new JMenuBar();
        this.setJMenuBar(this.barreM);
        this.fichierM = new JMenu("Fichier");
        this.fichierM.setMnemonic(70);
        this.barreM.add(this.fichierM);
        this.nouvSessionM = new JMenuItem("Nouvelle session");
        this.nouvSessionM.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.nouvSessionM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvelleSession();
            }
        });
        this.fichierM.add(this.nouvSessionM);
        this.chargSessionM = new JMenuItem("Charger une session ...");
        this.chargSessionM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.chargerSession();
            }
        });
        this.fichierM.add(this.chargSessionM);
        this.enregM = new JMenuItem("Enregistrer la session");
        this.enregM.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.enregM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enregistrerSession();
            }
        });
        this.fichierM.add(this.enregM);
        this.fichierM.addSeparator();
        this.quitterM = new JMenuItem("Quitter");
        this.quitterM.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.quitterM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.quitter();
            }
        });
        this.fichierM.add(this.quitterM);
        this.carnetM = new JMenu("Carnet");
        this.carnetM.setMnemonic(67);
        this.barreM.add(this.carnetM);
        this.copierM = new JMenuItem("Copier");
        this.copierM.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copierM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.carnet.copier();
                Interface.this.majAffichage();
            }
        });
        this.carnetM.add(this.copierM);
        this.couperM = new JMenuItem("Couper");
        this.couperM.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.couperM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.carnet.couper();
                Interface.this.sauv\u00e9 = false;
                Interface.this.majAffichage();
            }
        });
        this.carnetM.add(this.couperM);
        this.collerM = new JMenuItem("Coller");
        this.collerM.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.collerM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.carnet.coller();
                Interface.this.sauv\u00e9 = false;
                Interface.this.majAffichage();
            }
        });
        this.carnetM.add(this.collerM);
        this.carnetM.addSeparator();
        this.insertionVisuM = new JMenuItem("Insertion depuis la zone de visualisation /!\\");
        this.insertionVisuM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.insertDepuis("visualisation");
            }
        });
        this.carnetM.add(this.insertionVisuM);
        this.insertionDocsM = new JMenuItem("Insertion depuis la zone de Docs /!\\");
        this.insertionDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.insertDepuis("cours");
            }
        });
        this.carnetM.add(this.insertionDocsM);
        this.affichageM = new JMenu("Affichage");
        this.affichageM.setMnemonic(65);
        this.barreM.add(this.affichageM);
        this.coordCB = new JCheckBoxMenuItem("Coordonn\u00e9es g\u00e9ographiques");
        this.coordCB.setSelected(false);
        this.coordCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.coordCB);
        this.arretsCB = new JCheckBoxMenuItem("Arr\u00eats");
        this.arretsCB.setSelected(true);
        this.arretsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.arretsCB);
        this.historiqueCB = new JCheckBoxMenuItem("Historique");
        this.historiqueCB.setSelected(true);
        this.historiqueCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.historiqueCB);
        this.visualisationCB = new JCheckBoxMenuItem("Visualisation");
        this.visualisationCB.setSelected(true);
        this.visualisationCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.visualisationCB);
        this.docsCB = new JCheckBoxMenuItem("Docs");
        this.docsCB.setSelected(false);
        this.docsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.docsCB);
        this.carnetCB = new JCheckBoxMenuItem("Carnet");
        this.carnetCB.setSelected(true);
        this.carnetCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.carnetCB);
        this.outilsM = new JMenu("Outils");
        this.outilsM.setMnemonic(79);
        this.barreM.add(this.outilsM);
        this.docsM = new JMenuItem("Docs");
        this.docsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.chargerDocs();
            }
        });
        this.outilsM.add(this.docsM);
        this.calendrierM = new JMenuItem("Calendrier");
        this.calendrierM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enConstruction();
            }
        });
        this.outilsM.add(this.calendrierM);
        this.lexiqueM = new JMenuItem("Lexique");
        this.lexiqueM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enConstruction();
            }
        });
        this.outilsM.add(this.lexiqueM);
        this.parametrageM = new JMenuItem("Parametrage");
        this.parametrageM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enConstruction();
            }
        });
        this.outilsM.add(this.parametrageM);
        this.editionM = new JMenu("Edition");
        this.barreM.add(this.editionM);
        this.edActiverM = new JMenuItem("Activer");
        this.edActiverM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.activerEdition(true);
            }
        });
        this.editionM.add(this.edActiverM);
        this.edDesactiverM = new JMenuItem("Desactiver");
        this.edDesactiverM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.activerEdition(false);
            }
        });
        this.editionM.add(this.edDesactiverM);
        this.editionM.addSeparator();
        this.carteM = new JMenu("Carte");
        this.editionM.add(this.carteM);
        this.nouvCarteM = new JMenuItem("Nouveau ...");
        this.nouvCarteM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvCarte();
            }
        });
        this.carteM.add(this.nouvCarteM);
        this.nouvVueM = new JMenuItem("Nouvelle vue ...");
        this.nouvVueM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvVue();
            }
        });
        this.nouvVueM.setEnabled(false);
        this.carteM.add(this.nouvVueM);
        this.modifCarteM = new JMenuItem("Modifier ...");
        this.modifCarteM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.modifCarte();
            }
        });
        this.carteM.add(this.modifCarteM);
        this.suppCarteM = new JMenuItem("Supprimer ...");
        this.suppCarteM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppCarte();
            }
        });
        this.carteM.add(this.suppCarteM);
        this.enregCarteM = new JMenuItem("Enregistrer");
        this.enregCarteM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enregistrerEditionCarte();
            }
        });
        this.carteM.add(this.enregCarteM);
        this.edDocsM = new JMenu("Donnees");
        this.editionM.add(this.edDocsM);
        this.nouvDocsM = new JMenuItem("Nouveau ...");
        this.nouvDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvDonnee();
            }
        });
        this.edDocsM.add(this.nouvDocsM);
        this.modifDocsM = new JMenuItem("Modifier ...");
        this.modifDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.modifDonnee();
            }
        });
        this.edDocsM.add(this.modifDocsM);
        this.suppDocsM = new JMenuItem("Supprimer ...");
        this.suppDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppDonnee();
            }
        });
        this.edDocsM.add(this.suppDocsM);
        this.enregDocsM = new JMenuItem("Enregistrer");
        this.enregDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enregistrerEditionDonnee();
            }
        });
        this.edDocsM.add(this.enregDocsM);
        this.aideM = new JMenu("?");
        this.barreM.add(this.aideM);
        this.helpM = new JMenuItem("Aide");
        this.helpM.setMnemonic(112);
        this.helpM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enConstruction();
            }
        });
        this.aideM.add(this.helpM);
        this.aproposM = new JMenuItem("A propos de G\u00e9onote ...");
        this.aproposM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.aPropos();
            }
        });
        this.aideM.add(this.aproposM);
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent arg0) {
                Interface.this.repaintSplit();
            }

            public void componentMoved(ComponentEvent arg0) {
            }

            public void componentShown(ComponentEvent arg0) {
            }

            public void componentHidden(ComponentEvent arg0) {
            }
        });
        this.addWindowListener(new WindowListener(){

            public void windowClosing(WindowEvent evt) {
                Interface.this.quitter();
            }

            public void windowOpened(WindowEvent arg0) {
            }

            public void windowClosed(WindowEvent arg0) {
            }

            public void windowIconified(WindowEvent arg0) {
            }

            public void windowDeiconified(WindowEvent arg0) {
            }

            public void windowActivated(WindowEvent arg0) {
            }

            public void windowDeactivated(WindowEvent arg0) {
            }
        });
        this.activation(false);
        this.pack();
        this.setVisible(true);
        Date date = new Date();
        String[] dateTab = date.toString().split(" ");
        String heure = dateTab[3].replaceFirst(":", "h");
        heure = heure.replaceFirst(":", "m");
        this.nomFichierTraces = "traces_" + dateTab[2] + "-" + dateTab[1] + "-" + dateTab[5] + "_" + heure + ".xml";
        this.traceurTraces = new TraceurTraces(String.valueOf(this.espaceTraces) + "\\" + this.nomFichierTraces, "traces");
    }

    private void insertDepuis(String provenance) {
        ImageIcon im = null;
        ImageIcon carte = null;
        JTextPane texte = null;
        if (provenance.matches("cours")) {
            im = this.docs.exporteImage();
            carte = this.docs.exporteCarte();
            texte = this.docs.exporteTexte();
        } else if (provenance.matches("visualisation")) {
            im = this.visualisation.exporteImage();
            carte = this.visualisation.exporteCarte();
            texte = this.visualisation.exporteTexte();
        }
        if (im != null) {
            this.carnet.copierImage(im);
        } else if (carte != null) {
            this.carnet.copierImage(carte);
        } else if (texte != null) {
            texte.copy();
            this.carnet.coller();
        }
        this.modifEffectuee(true);
    }

    private void nouvelleSession() {
        this.confirmation();
        this.userName = JOptionPane.showInputDialog(this, "Nom d'utilisateur :", "Nouvelle session", 1);
        if (this.userName != null && !this.userName.matches("") && !this.userName.contains(" ")) {
            JFileChooser chooser = new JFileChooser(this.espaceCartes);
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle("Choix de la carte de la nouvelle session");
            FiltreExtensible filtre = new FiltreExtensible("Cartes");
            filtre.addExtension(".jpg");
            chooser.addChoosableFileFilter(filtre);
            int returnVal = chooser.showOpenDialog(chooser.getParent());
            if (returnVal == 0) {
                this.docs.desactiver();
                String fich = chooser.getSelectedFile().getName();
                String extension = fich.substring(chooser.getSelectedFile().getName().indexOf("."));
                if (this.extensionsCartes.contains(extension)) {
                    TraceurCarte tr = new TraceurCarte();
                    String fichXml = chooser.getSelectedFile().getPath().replace(extension, ".xml");
                    boolean result = tr.charger(fichXml);
                    if (result) {
                        String type = tr.exporteType();
                        if (type.matches("carte")) {
                            String ech = tr.exporteInfo("echelle");
                            boolean regActif = tr.exporteInfo("reglet").matches("actif");
                            boolean zoomActif = tr.exporteInfo("zoom").matches("actif");
                            String unit = "";
                            if (regActif) {
                                unit = tr.exporteInfo("unite");
                            }
                            this.visualisation.chargerCarte(chooser.getSelectedFile().getPath(), Double.parseDouble(ech), unit, regActif, zoomActif, this.modeEdition, tr.construitArrets(), Integer.parseInt(tr.exporteInfo("latitude")), Integer.parseInt(tr.exporteInfo("longitude")), Double.parseDouble(tr.exporteInfo("echelleLatitude")), Double.parseDouble(tr.exporteInfo("echelleLongitude")), tr.exporteVues());
                            Date date = new Date();
                            String[] dateTab = this.traduireDate(date).split(" ");
                            String[] heureTab = dateTab[3].split(":");
                            String heure = dateTab[3].replaceFirst(":", "h");
                            heure = heure.replaceFirst(":", "m");
                            this.nomFichierSession = "session_" + this.userName + "_" + dateTab[2] + "-" + dateTab[1] + "-" + dateTab[5] + "_" + heure + ".xml";
                            this.historique.creerArbre(this.userName);
                            this.historique.ajouterCarte(fich);
                            this.historique.ajouterDate(dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                            this.carnet.nouveauTexte();
                            this.traceurSession = new TraceurSession(String.valueOf(this.espaceSessions) + "\\" + this.nomFichierSession, "session");
                            this.traceurSession.ajouterElt("nom", this.userName);
                            this.traceurSession.ajouterElt("carte", fich);
                            this.traceurSession.ajouterDate(dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                            this.activation(true);
                            this.modifEffectuee(true);
                            this.traceurTraces.ajouterTraces("menu", "nouvelleSession");
                        } else {
                            System.out.println("PAS carte !");
                            JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu charger n'est pas une carte !", "ERREUR !", 2, null);
                        }
                    } else {
                        JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu charger ne dispose pas de fichier d'informations !", "ERREUR !", 2, null);
                    }
                } else {
                    JOptionPane.showMessageDialog(new JFrame(), "Le type de fichier que vous voulez charger n'est pas support\u00e9 !", "ERREUR !", 2, null);
                }
            }
        }
    }

    private void enregistrerSession() {
        this.traceurSession.ajouteCarnet(this.carnet.exporteTexte());
        this.traceurSession.enregistrer();
        this.traceurTraces.ajouterTraces("menu", "enregistrer");
        this.sauv\u00e9 = true;
        JOptionPane.showMessageDialog(new JFrame(), "La session a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", "Information", 1);
    }

    private void chargerSession() {
        this.confirmation();
        JFileChooser chooser = new JFileChooser(this.espaceSessions);
        chooser.setDialogTitle("Chargement d'une session");
        FiltreExtensible filtre = new FiltreExtensible("Fichiers");
        filtre.addExtension(".xml");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.traceurSession = new TraceurSession();
            boolean result = this.traceurSession.charger(path);
            if (result) {
                String extension;
                TraceurCarte traceurCarte = new TraceurCarte();
                String cheminCarte = String.valueOf(this.espaceCartes) + this.traceurSession.exporteInfo("carte");
                boolean res = traceurCarte.charger(cheminCarte.replace(extension = cheminCarte.substring(cheminCarte.indexOf(".")), ".xml"));
                if (res) {
                    this.docs.desactiver();
                    this.historique.creerArbre(this.traceurSession.exporteInfo("nom"));
                    this.historique.ajouterCarte(this.traceurSession.exporteInfo("carte"));
                    this.historique.ajouterDate(this.traceurSession.exporteInfo("jour"), this.traceurSession.exporteInfo("mois"), this.traceurSession.exporteInfo("annee"), this.traceurSession.exporteInfo("heures"), this.traceurSession.exporteInfo("minutes"), this.traceurSession.exporteInfo("secondes"));
                    this.historique.ajouterDocs(this.traceurSession.exporteDocsHisto());
                    this.historique.chargeArrets(this.traceurSession.exporteArretsHisto());
                    ArrayList liste = this.traceurSession.exporteAnnotations();
                    int i = 0;
                    while (i < liste.size()) {
                        ArrayList caps = (ArrayList)liste.get(i);
                        String chemin = caps.get(0).toString();
                        String annotation = caps.get(1).toString();
                        this.historique.ajouteAnnotation(chemin, annotation);
                        ++i;
                    }
                    this.carnet.nouveauTexte();
                    this.carnet.importeTexte(this.traceurSession.exporteInfo("carnet"));
                    boolean regActif = traceurCarte.exporteInfo("reglet").matches("actif");
                    boolean zoomActif = traceurCarte.exporteInfo("zoom").matches("actif");
                    double ech = Double.parseDouble(traceurCarte.exporteInfo("echelle"));
                    String unit = "";
                    if (regActif) {
                        unit = traceurCarte.exporteInfo("unite");
                    }
                    this.visualisation.chargerCarte(cheminCarte, ech, unit, regActif, zoomActif, this.modeEdition, traceurCarte.construitArrets(), Integer.parseInt(traceurCarte.exporteInfo("latitude")), Integer.parseInt(traceurCarte.exporteInfo("longitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLatitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLongitude")), traceurCarte.exporteVues());
                    this.activation(true);
                    this.modifEffectuee(true);
                    this.traceurTraces.ajouterTraces("menu", "chargerSession");
                } else {
                    JOptionPane.showMessageDialog(new JFrame(), "Lors du chargement de la carte !", "ERREUR !", 2, null);
                }
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu charger ne dispose pas de fichier d'informations !", "ERREUR !", 2, null);
            }
        }
    }

    public void ajoutArretHisto(int idArret, String donnee) {
        this.sauv\u00e9 = false;
        Date date = new Date();
        String[] dateTab = this.traduireDate(date).split(" ");
        String[] heureTab = dateTab[3].split(":");
        this.historique.ajoutArret(idArret, donnee);
        this.traceurSession.ajouteDonneeArret(Integer.toString(idArret), donnee, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
    }

    private void confirmation() {
        if (!this.sauv\u00e9) {
            int saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre session?", "Confirmation", 0, 2, null);
            if (saveOrNot == 0) {
                this.enregistrerSession();
            }
        } else {
            int saveOrNot;
            if (this.carteModifi\u00e9e && (saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre carte ?", "Confirmation", 0, 2, null)) == 0) {
                this.enregistrerEditionCarte();
            }
            if (this.docsModifi\u00e9 && (saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre donn\u00e9e ?", "Confirmation", 0, 2, null)) == 0) {
                this.enregistrerEditionDonnee();
            }
        }
    }

    private void quitter() {
        this.confirmation();
        this.traceurTraces.ajouterTraces("menu", "quitter");
        if (this.tracesActives) {
            this.traceurTraces.enregistrer();
        }
        this.dispose();
        System.exit(0);
    }

    private void chargerDocs() {
        JFileChooser chooser = new JFileChooser(this.espaceDocs);
        chooser.setDialogTitle("Ouverture d'une donn\u00e9e du docs (donn\u00e9e non-g\u00e9or\u00e9f\u00e9renc\u00e9e)");
        FiltreExtensible filtre = new FiltreExtensible("Docs");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".rtf");
        chooser.addChoosableFileFilter(filtre);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getName();
            String extension = fich.substring(fich.indexOf("."));
            if (this.extensionsDocs.contains(extension)) {
                String fichXml = chooser.getSelectedFile().getPath().replace(extension, ".xml");
                Traceur tr = new Traceur();
                boolean result = tr.charger(fichXml);
                String ech = "";
                if (result) {
                    ech = tr.exporteInfo("echelle");
                    String type = tr.exporteType();
                    boolean regActif = tr.exporteInfo("reglet").matches("actif");
                    boolean zoomActif = tr.exporteInfo("zoom").matches("actif");
                    String unit = "";
                    if (regActif) {
                        unit = tr.exporteInfo("unite");
                    }
                    if (type.matches("image")) {
                        this.docs.chargerImage(chooser.getSelectedFile().getPath(), 1.0, unit, regActif, zoomActif, this.modeEdition);
                        Date date = new Date();
                        String[] dateTab = this.traduireDate(date).split(" ");
                        String[] heureTab = dateTab[3].split(":");
                        this.historique.ajouterDocs(fich);
                        this.traceurSession.ajouteDonneeDocs(fich, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                        this.docsCB.setSelected(true);
                        this.modifEffectuee(true);
                    } else if (type.matches("texte")) {
                        this.docs.chargerTexte(chooser.getSelectedFile().getPath());
                        Date date = new Date();
                        String[] dateTab = this.traduireDate(date).split(" ");
                        String[] heureTab = dateTab[3].split(":");
                        this.historique.ajouterDocs(chooser.getSelectedFile().getPath());
                        this.traceurSession.ajouteDonneeDocs(chooser.getSelectedFile().getPath(), dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                        this.docsCB.setSelected(true);
                        this.modifEffectuee(true);
                    } else {
                        JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu charger n'est pas une image !", "ERREUR !", 2, null);
                    }
                } else {
                    JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu charger ne dispose pas de fichier d'informations !", "ERREUR !", 2, null);
                }
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "Le type de fichier que vous voulez charger n'est pas support\u00e9 !", "ERREUR !", 2, null);
            }
        }
    }

    private void repaintSplit() {
        this.splitPane1.setDividerLocation(this.getWidth() / 4);
        this.splitPane2.setDividerLocation(this.getWidth() * 3 / 8);
        this.splitPanePrincipal.setDividerLocation(this.getHeight() * 3 / 4);
    }

    private void majAffichage() {
        if (this.modeEdition) {
            this.docs.desactiver();
        }
        this.historique.setVisible(this.historiqueCB.isSelected() && !this.modeEdition);
        this.visualisation.setVisible(this.visualisationCB.isSelected());
        this.docs.setVisible(this.docs.rapportActivit\u00e9() && this.docsCB.isSelected() && !this.modeEdition);
        this.carnet.setVisible(this.carnetCB.isSelected() && !this.modeEdition);
        this.splitPane2.setVisible(this.visualisation.isVisible() || this.docs.isVisible());
        this.splitPane1.setVisible(this.historique.isVisible() || this.splitPane2.isVisible());
        if (this.visualisation.isVisible()) {
            this.affichageArretsActif = this.arretsCB.isSelected();
            this.affichageCoordActif = this.coordCB.isSelected();
        }
        this.arretsCB.setEnabled(this.visualisation.isVisible());
        if (!this.arretsCB.isEnabled()) {
            this.arretsCB.setSelected(false);
        }
        this.coordCB.setEnabled(this.visualisation.isVisible());
        if (!this.coordCB.isEnabled()) {
            this.coordCB.setSelected(false);
        }
        this.nouvSessionM.setEnabled(!this.modeEdition);
        this.chargSessionM.setEnabled(!this.modeEdition);
        this.enregM.setEnabled(!this.sauv\u00e9 && !this.modeEdition && this.fenetreActive);
        this.docsCB.setEnabled(this.docs.rapportActivit\u00e9());
        if (!this.docs.rapportActivit\u00e9()) {
            this.docsCB.setSelected(false);
        }
        this.carnetM.setEnabled(!this.modeEdition && this.fenetreActive);
        this.affichageM.setEnabled(!this.modeEdition && this.fenetreActive);
        this.docsM.setEnabled(!this.modeEdition && this.fenetreActive);
        this.edActiverM.setEnabled(!this.modeEdition);
        this.edDesactiverM.setEnabled(this.modeEdition);
        this.carteM.setEnabled(this.modeEdition);
        this.edDocsM.setEnabled(this.modeEdition);
        this.enregCarteM.setEnabled(this.carteModifi\u00e9e);
        this.enregDocsM.setEnabled(this.docsModifi\u00e9);
        if (this.carteModifi\u00e9e) {
            this.nouvVueM.setEnabled(true);
        }
        this.repaintSplit();
        if (this.modeEdition) {
            this.setTitle("G\u00e9onote " + version + "  ~~ MODE EDITION  /!\\");
            this.affichageCoordActif = true;
        } else {
            this.setTitle("G\u00e9onote " + version);
        }
        this.validate();
        this.repaint();
    }

    private void modifCarte() {
        JFileChooser chooser = new JFileChooser(this.espaceCartes);
        chooser.setDialogTitle("Choix de la carte \u00e0 modifier");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            String ext = fich.substring(fich.indexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            this.traceurCarteEdition = new TraceurCarte();
            boolean res = this.traceurCarteEdition.charger(fichXML);
            if (!res) {
                JOptionPane.showMessageDialog(new JFrame(), "La carte que vous avez voulu ouvrir ne poss\u00e8de pas de m\u00e9tadonn\u00e9es !", "ERREUR !", 2);
            } else {
                this.visualisation.chargerCarte(fich, 1.0, "", true, true, this.modeEdition, this.traceurCarteEdition.construitArrets(), Integer.parseInt(this.traceurCarteEdition.exporteInfo("latitude")), Integer.parseInt(this.traceurCarteEdition.exporteInfo("longitude")), Double.parseDouble(this.traceurCarteEdition.exporteInfo("echelleLatitude")), Double.parseDouble(this.traceurCarteEdition.exporteInfo("echelleLongitude")), this.traceurCarteEdition.exporteVues());
                int reglet = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous activer le reglet sur cette donnee ? (Pensez \u00e0 faire une mesure ...)", "Parametrage (1/3)", 0, 3, null);
                if (reglet == 0) {
                    this.traceurCarteEdition.ajouterElt("reglet", "actif");
                    this.visualisation.activeReglet(true);
                } else {
                    this.traceurCarteEdition.ajouterElt("reglet", "inactif");
                    this.visualisation.activeReglet(false);
                }
                int zoom = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous activer le zoom sur cette donnee ?", "Parametrage (2/3)", 0, 3, null);
                if (zoom == 0) {
                    this.traceurCarteEdition.ajouterElt("zoom", "actif");
                } else {
                    this.traceurCarteEdition.ajouterElt("zoom", "inactif");
                }
                boolean nivoOK = false;
                while (!nivoOK) {
                    String nivo = JOptionPane.showInputDialog(new JFrame(), "Quel est le niveau d'utilisation de cette carte ? ('college', 'lycee' ou 'universite')", "Parametrage (3/3)", 3);
                    if (nivo == null || !nivo.matches("college") && !nivo.matches("lycee") && !nivo.matches("universite")) continue;
                    this.traceurCarteEdition.ajouterElt("niveau", nivo);
                    nivoOK = true;
                }
                this.carteModifi\u00e9e = true;
                this.majAffichage();
            }
        }
    }

    private void modifDonnee() {
        JFileChooser chooser = new JFileChooser(this.espaceDonnees);
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 modifier");
        FiltreExtensible filtre = new FiltreExtensible("Donnees");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".txt");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            String ext = fich.substring(fich.indexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            this.traceurDonneeEdition = new TraceurDonnee();
            boolean res = this.traceurDonneeEdition.charger(fichXML);
            if (!res) {
                JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu ouvrir ne poss\u00e8de pas de m\u00e9tadonn\u00e9es !", "ERREUR !", 2);
            } else {
                String type = this.traceurDonneeEdition.exporteType();
                if (type.matches("texte")) {
                    this.visualisation.chargerTexte(fich);
                } else if (type.matches("image")) {
                    this.visualisation.chargerImage(fich, 1.0, "", true, true, this.modeEdition);
                    boolean typeGOK = false;
                    String typ = "";
                    while (!typeGOK) {
                        typ = JOptionPane.showInputDialog(new JFrame(), "Quel est le type g\u00e9ologique de cette donnee ? ('paysage', 'affleurement', '\u00e9chantillon-roches', 'lame-mince', 'pal\u00e9ontologie', 'log-stratigraphique' ou 'g\u00e9ochimie')", "Parametrage (2/6)", 3);
                        if (!typ.matches("paysage") && !typ.matches("affleurement") && !typ.matches("\u00e9chantillon-roches") && !typ.matches("lame-mince") && !typ.matches("pal\u00e9ontologie") && !typ.matches("log-stratigraphique") && !typ.matches("g\u00e9ochimie")) continue;
                        this.traceurDonneeEdition.ajouterElt("typeGeologique", typ);
                        typeGOK = true;
                    }
                    int reglet = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous activer le reglet sur cette donnee ? (Pensez \u00e0 faire une mesure ...)", "Parametrage (1/4)", 0, 3, null);
                    if (reglet == 0) {
                        this.traceurDonneeEdition.ajouterElt("reglet", "actif");
                        this.visualisation.activeReglet(true);
                    } else {
                        this.traceurDonneeEdition.ajouterElt("reglet", "inactif");
                        this.visualisation.activeReglet(false);
                    }
                    int zoom = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous activer le zoom sur cette donnee ?", "Parametrage (2/4)", 0, 3, null);
                    if (zoom == 0) {
                        this.traceurDonneeEdition.ajouterElt("zoom", "actif");
                    } else {
                        this.traceurDonneeEdition.ajouterElt("zoom", "inactif");
                    }
                }
                boolean nivoOK = false;
                while (!nivoOK) {
                    String nivo = JOptionPane.showInputDialog(new JFrame(), "Quel est le niveau d'utilisation de cette donnee ? ('college', 'lycee' ou 'universite')", "Parametrage (3/4)", 3);
                    if (!nivo.matches("college") && !nivo.matches("lycee") && !nivo.matches("universite")) continue;
                    this.traceurDonneeEdition.ajouterElt("niveau", nivo);
                    nivoOK = true;
                }
                String commentaire = JOptionPane.showInputDialog(new JFrame(), "Commentaire :", "Parametrage (4/4)", 3);
                if (commentaire != null && !commentaire.matches("")) {
                    this.traceurDonneeEdition.ajouterElt("commentaire", commentaire);
                }
                this.docsModifi\u00e9 = true;
                this.majAffichage();
            }
        }
    }

    public void afficheVisu(String donnee, String ndPere) {
        String chemin = "";
        TraceurCarte tr = new TraceurCarte();
        if (ndPere.matches("carte")) {
            chemin = String.valueOf(this.espaceCartes) + donnee;
        } else if (ndPere.matches("arret")) {
            chemin = String.valueOf(this.espaceGeorefs) + donnee;
        }
        String extension = donnee.substring(donnee.indexOf("."));
        String cheminXML = chemin.replace(extension, ".xml");
        boolean result = tr.charger(cheminXML);
        if (result) {
            String type;
            boolean reglet = false;
            if (tr.exporteInfo("reglet").matches("actif")) {
                reglet = true;
            }
            boolean zoom = false;
            if (tr.exporteInfo("zoom").matches("actif")) {
                zoom = true;
            }
            if ((type = tr.exporteType()).matches("carte")) {
                this.visualisation.chargerCarte(chemin, Double.parseDouble(tr.exporteInfo("echelle")), tr.exporteInfo("unite"), reglet, zoom, this.modeEdition, tr.construitArrets(), Integer.parseInt(tr.exporteInfo("latitude")), Integer.parseInt(tr.exporteInfo("longitude")), Double.parseDouble(tr.exporteInfo("echelleLatitude")), Double.parseDouble(tr.exporteInfo("echelleLongitude")), tr.exporteVues());
            } else if (type.matches("image")) {
                this.visualisation.chargerImage(chemin, Double.parseDouble(tr.exporteInfo("echelle")), tr.exporteInfo("unite"), reglet, zoom, this.modeEdition);
            } else if (type.matches("texte")) {
                this.visualisation.chargerTexte(chemin);
            }
            this.visualisationCB.setSelected(true);
            this.majAffichage();
            this.coordCB.setEnabled(type.matches("carte"));
            if (!this.coordCB.isEnabled()) {
                this.coordCB.setSelected(false);
            }
        } else {
            System.out.println("Erreur lors du chargement de la donnee !");
        }
    }

    public void afficheDocs(String donnee) {
        String extension;
        TraceurCarte tr = new TraceurCarte();
        String chemin = String.valueOf(this.espaceDocs) + donnee;
        String cheminXML = chemin.replace(extension = chemin.substring(chemin.indexOf(".")), ".xml");
        boolean result = tr.charger(cheminXML);
        if (result) {
            String type;
            boolean reglet = false;
            if (tr.exporteInfo("reglet").matches("actif")) {
                reglet = true;
            }
            boolean zoom = false;
            if (tr.exporteInfo("zoom").matches("actif")) {
                zoom = true;
            }
            if ((type = tr.exporteType()).matches("carte")) {
                this.docs.chargerCarte(chemin, Double.parseDouble(tr.exporteInfo("echelle")), tr.exporteInfo("unite"), reglet, zoom, this.modeEdition, tr.construitArrets(), Integer.parseInt(tr.exporteInfo("latitude")), Integer.parseInt(tr.exporteInfo("longitude")), Double.parseDouble(tr.exporteInfo("echelleLatitude")), Double.parseDouble(tr.exporteInfo("echelleLongitude")));
            } else if (type.matches("image")) {
                this.docs.chargerImage(chemin, Double.parseDouble(tr.exporteInfo("echelle")), tr.exporteInfo("unite"), reglet, zoom, this.modeEdition);
            } else if (type.matches("texte")) {
                this.docs.chargerTexte(chemin);
            }
        } else {
            System.out.println("Erreur lors du chargement de la donnee !");
        }
        this.docsCB.setSelected(true);
        this.majAffichage();
    }

    public void rapportTrace(String entit\u00e9, String action) {
        this.traceurTraces.ajouterTraces(entit\u00e9, action);
    }

    public void annoter(String elt, String texte) {
        this.traceurSession.ajouterAnnotation(elt, texte);
        this.sauv\u00e9 = false;
        this.majAffichage();
    }

    public void modifAnnotation(String elt, String texte) {
        this.traceurSession.modifierAnnotation(elt, texte);
        this.sauv\u00e9 = false;
        this.majAffichage();
    }

    public void ajouteEchelle(double mesure, String cible) {
        DecimalFormat df = new DecimalFormat("#######");
        String mesureAffiche = String.valueOf(df.format(mesure)) + " pixels";
        boolean unitOK = false;
        String unit = JOptionPane.showInputDialog(new JFrame(), "Quel est l'unit\u00e9 de mesure de cette donnee ? ('mm', 'cm', 'm' ou 'km')", "Parametrage (1/2)", 3);
        while (unit != null && !unit.matches("") && !unitOK) {
            if (unit.matches("mm") || unit.matches("cm") || unit.matches("m") || unit.matches("km")) {
                if (cible.matches("carte")) {
                    this.traceurCarteEdition.ajouterElt("unite", unit);
                }
                if (cible.matches("image")) {
                    this.traceurDonneeEdition.ajouterElt("unite", unit);
                }
                this.visualisation.setUnite(unit);
                unitOK = true;
                continue;
            }
            unit = JOptionPane.showInputDialog(new JFrame(), "Erreur ! Respectez la syntaxe !\nQuel est l'unit\u00e9 de mesure de cette donnee ? ('mm', 'cm', 'm' ou 'km')", "Parametrage (1/2)", 3);
        }
        if (unitOK) {
            boolean distOK = false;
            String distance = JOptionPane.showInputDialog(this, "Mesure : " + mesureAffiche + "\nDistance equivalente en " + unit + " (par ex. 15.5) :", "Parametrage (2/2) : Saisie de l'echelle de la carte", 3);
            while (distance != null && !distance.matches("") && !distOK) {
                try {
                    double dist = Double.parseDouble(distance);
                    double rapport = dist / mesure;
                    if (cible.matches("carte")) {
                        this.traceurCarteEdition.ajouteEchelle(rapport);
                    }
                    if (cible.matches("image")) {
                        this.traceurDonneeEdition.ajouteEchelle(rapport);
                    }
                    this.visualisation.setEchelle(rapport);
                    distOK = true;
                }
                catch (Exception e) {
                    distance = JOptionPane.showInputDialog(this, "Erreur ! Vous devez saisir un nombre.\nMesure : " + mesureAffiche + "\nDistance equivalente en " + unit + " (par ex. 15.5) :", "Parametrage (2/2) : Saisie de l'echelle de la carte", 3);
                    e.printStackTrace();
                }
            }
        }
    }

    public void ajouteCoordonnees(int latOrigine, int longOrigine, double echLat, double echLong) {
        this.traceurCarteEdition.ajouteCoord(Integer.toString(latOrigine), Integer.toString(longOrigine), Double.toString(echLat), Double.toString(echLong));
    }

    public void enregistrerEditionCarte() {
        this.traceurCarteEdition.enregistrer();
        this.carteModifi\u00e9e = false;
        JOptionPane.showMessageDialog(new JFrame(), "La carte a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", "Information", 1);
        this.majAffichage();
    }

    public void enregistrerEditionDonnee() {
        this.traceurDonneeEdition.enregistrer();
        this.docsModifi\u00e9 = false;
        JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", "Information", 1);
        this.majAffichage();
    }

    public void ajouteArretCarte(int id, int latitude, int longitude) {
        this.traceurCarteEdition.ajouteArret(id, latitude, longitude);
    }

    private String traduireDate(Date date) {
        String temp = date.toString().replace("Jan", "01");
        temp = temp.replace("Feb", "02");
        temp = temp.replace("Mar", "03");
        temp = temp.replace("Apr", "04");
        temp = temp.replace("May", "05");
        temp = temp.replace("Jun", "06");
        temp = temp.replace("Jul", "07");
        temp = temp.replace("Aug", "08");
        temp = temp.replace("Sep", "09");
        temp = temp.replace("Oct", "10");
        temp = temp.replace("Nov", "11");
        temp = temp.replace("Dec", "12");
        return temp;
    }

    public void activation(boolean b) {
        this.fenetreActive = b;
        this.historique.setEnabled(b);
        this.visualisation.setEnabled(b);
        this.carnet.setEnabled(b);
        this.docs.setEnabled(b);
        this.splitPanePrincipal.setEnabled(b);
        this.splitPane1.setEnabled(b);
        this.splitPane2.setEnabled(b);
        this.enregM.setEnabled(b);
        this.affichageM.setEnabled(b);
        this.carnetM.setEnabled(b);
        this.docsM.setEnabled(b);
        this.edDesactiverM.setEnabled(this.modeEdition);
        this.carteM.setEnabled(this.modeEdition);
        this.edDocsM.setEnabled(this.modeEdition);
        this.docs.setVisible(this.docs.rapportActivit\u00e9());
    }

    private void activerEdition(boolean b) {
        this.modeEdition = b;
        this.confirmation();
        this.majAffichage();
        this.visualisation.reset();
        this.historique.reset();
        this.docs.reset();
        this.carnet.reset();
        if (!b) {
            this.docsModifi\u00e9 = false;
            this.carteModifi\u00e9e = false;
            this.nouvVueM.setEnabled(false);
        }
    }

    private void nouvDonnee() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 \u00e9diter");
        FiltreExtensible filtre = new FiltreExtensible("Donnees");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".txt");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fichDest;
            String fich = chooser.getSelectedFile().getPath();
            if (!fich.contains(fichDest = String.valueOf(this.espaceDocs) + chooser.getSelectedFile().getName())) {
                System.out.println("copie !!!!!");
                Interface.copier(chooser.getSelectedFile(), new File(fichDest));
            }
            String ext = fichDest.substring(fichDest.indexOf("."));
            String fichXML = fichDest.replace(ext, ".xml");
            this.traceurDonneeEdition = new TraceurDonnee(fichXML, "image");
            if (ext.matches(".txt")) {
                this.visualisation.chargerTexte(fichDest);
            } else {
                this.visualisation.chargerImage(fichDest, 1.0, "", true, true, this.modeEdition);
                boolean typeGOK = false;
                String typ = "";
                while (!typeGOK) {
                    typ = JOptionPane.showInputDialog(new JFrame(), "Quel est le type g\u00e9ologique de cette donnee ? ('paysage', 'affleurement', '\u00e9chantillon-roches', 'lame-mince', 'pal\u00e9ontologie', 'log-stratigraphique' ou 'g\u00e9ochimie')", "Parametrage (2/6)", 3);
                    if (typ == null || typ.matches("") || !typ.matches("paysage") && !typ.matches("affleurement") && !typ.matches("\u00e9chantillon-roches") && !typ.matches("lame-mince") && !typ.matches("pal\u00e9ontologie") && !typ.matches("log-stratigraphique") && !typ.matches("g\u00e9ochimie")) continue;
                    this.traceurDonneeEdition.ajouterElt("typeGeologique", typ);
                    typeGOK = true;
                }
                int reglet = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous activer le reglet sur cette donnee ? (Pensez \u00e0 faire une mesure ...)", "Parametrage (1/4)", 0, 3, null);
                if (reglet == 0) {
                    this.traceurDonneeEdition.ajouterElt("reglet", "actif");
                    this.visualisation.activeReglet(true);
                } else {
                    this.traceurDonneeEdition.ajouterElt("reglet", "inactif");
                    this.visualisation.activeReglet(false);
                }
                int zoom = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous activer le zoom sur cette donnee ?", "Parametrage (2/4)", 0, 3, null);
                if (zoom == 0) {
                    this.traceurDonneeEdition.ajouterElt("zoom", "actif");
                } else {
                    this.traceurDonneeEdition.ajouterElt("zoom", "inactif");
                }
            }
            boolean nivoOK = false;
            while (!nivoOK) {
                String nivo = JOptionPane.showInputDialog(new JFrame(), "Quel est le niveau d'utilisation de cette donnee ? ('college', 'lycee' ou 'universite')", "Parametrage (3/4)", 3);
                if (!nivo.matches("college") && !nivo.matches("lycee") && !nivo.matches("universite")) continue;
                this.traceurDonneeEdition.ajouterElt("niveau", nivo);
                nivoOK = true;
            }
            String commentaire = JOptionPane.showInputDialog(new JFrame(), "Commentaire :", "Parametrage (4/4)", 3);
            if (commentaire != null && !commentaire.matches("")) {
                this.traceurDonneeEdition.ajouterElt("commentaire", commentaire);
            }
            this.docsModifi\u00e9 = true;
            this.majAffichage();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean copier(File source, File destination) {
        block15: {
            resultat = false;
            sourceFile = null;
            destinationFile = null;
            try {
                try {
                    destination.createNewFile();
                    sourceFile = new FileInputStream(source);
                    destinationFile = new FileOutputStream(destination);
                    buffer = new byte[524288];
                    while (true) {
                        if ((nbLecture = sourceFile.read(buffer)) == -1) {
                            resultat = true;
                        }
                        destinationFile.write(buffer, 0, nbLecture);
                    }
                }
                catch (FileNotFoundException var5_6) {
                }
                catch (IOException var5_7) {}
            }
            catch (Throwable var8_9) {
                var7_10 = null;
                try {
                    sourceFile.close();
                }
                catch (Exception var9_12) {
                    // empty catch block
                }
                try {
                    destinationFile.close();
                    throw var8_9;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw var8_9;
            }
            {
                var7_11 = null;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 89->96)] { 
lbl38:
            // 1 sources

            sourceFile.close();
            break block15;
lbl40:
            // 1 sources

            catch (Exception var9_13) {
                // empty catch block
            }
        }
        try {}
        catch (Exception e) {
            return resultat;
        }
        destinationFile.close();
        return resultat;
    }

    private void suppCarte() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la carte \u00e0 supprimer");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            String ext = fich.substring(fich.indexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            boolean b1 = chooser.getSelectedFile().delete();
            File xml = new File(fichXML);
            boolean b2 = xml.delete();
            if (b1) {
                JOptionPane.showMessageDialog(new JFrame(), "La carte a \u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s !", "Information", 1);
            }
            if (b2) {
                JOptionPane.showMessageDialog(new JFrame(), "Les m\u00e9tadonn\u00e9es de la carte ont \u00e9t\u00e9 supprim\u00e9es avec succ\u00e8s !", "Information", 1);
            }
        }
        this.repaint();
    }

    private void suppDonnee() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 supprimer");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            String ext = fich.substring(fich.indexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            boolean b1 = chooser.getSelectedFile().delete();
            File xml = new File(fichXML);
            boolean b2 = xml.delete();
            if (b1) {
                JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e a \u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s !", "Information", 1);
            }
            if (b2) {
                JOptionPane.showMessageDialog(new JFrame(), "Les m\u00e9tadonn\u00e9es de la donn\u00e9e ont \u00e9t\u00e9 supprim\u00e9es avec succ\u00e8s !", "Information", 1);
            }
        }
        this.repaint();
    }

    private void nouvCarte() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la carte \u00e0 editer");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fichDest;
            String fich = chooser.getSelectedFile().getPath();
            if (!fich.contains(fichDest = String.valueOf(this.espaceCartes) + chooser.getSelectedFile().getName())) {
                System.out.println("copie !!!!!");
                Interface.copier(chooser.getSelectedFile(), new File(fichDest));
            }
            String ext = fichDest.substring(fichDest.indexOf("."));
            String fichXML = fichDest.replace(ext, ".xml");
            this.traceurCarteEdition = new TraceurCarte(fichXML, "carte");
            this.visualisation.chargerCarte(fichDest, 1.0, "", true, true, this.modeEdition, null, 0, 0, 1.0, 1.0, new ArrayList());
            String type = "";
            while (type == null || type.matches("")) {
                type = JOptionPane.showInputDialog(new JFrame(), "Quel est le type de cette vue (satellite, topographique, ...) ? ", "Parametrage (1/1)", 3);
            }
            this.traceurCarteEdition.ajouteVue(type, chooser.getSelectedFile().getName());
            this.visualisation.rechargeTypBarre(this.traceurCarteEdition.exporteVues(), this.espaceCartes);
            int reglet = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous activer le reglet sur cette donnee ? (Pensez \u00e0 faire une mesure ...)", "Parametrage (1/3)", 0, 3, null);
            if (reglet == 0) {
                this.traceurCarteEdition.ajouterElt("reglet", "actif");
                this.visualisation.activeReglet(true);
            } else {
                this.traceurCarteEdition.ajouterElt("reglet", "inactif");
                this.visualisation.activeReglet(false);
            }
            int zoom = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous activer le zoom sur cette donnee ?", "Parametrage (2/3)", 0, 3, null);
            if (zoom == 0) {
                this.traceurCarteEdition.ajouterElt("zoom", "actif");
            } else {
                this.traceurCarteEdition.ajouterElt("zoom", "inactif");
            }
            boolean nivoOK = false;
            while (!nivoOK) {
                String nivo = JOptionPane.showInputDialog(new JFrame(), "Quel est le niveau d'utilisation de cette carte ? ('college', 'lycee' ou 'universite')", "Parametrage (3/3)", 3);
                if (nivo == null || !nivo.matches("college") && !nivo.matches("lycee") && !nivo.matches("universite")) continue;
                this.traceurCarteEdition.ajouterElt("niveau", nivo);
                nivoOK = true;
            }
            this.carteModifi\u00e9e = true;
            this.majAffichage();
        }
    }

    private void nouvVue() {
        JFileChooser chooser = new JFileChooser(this.espaceDonnees);
        chooser.setDialogTitle("Choix de la vue \u00e0 ajouter");
        FiltreExtensible filtre = new FiltreExtensible("Donn\u00e9es");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".png");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String type;
            String fichDest;
            String fich = chooser.getSelectedFile().getPath();
            if (!fich.contains(fichDest = String.valueOf(this.espaceCartes) + chooser.getSelectedFile().getName())) {
                Interface.copier(chooser.getSelectedFile(), new File(fichDest));
            }
            if ((type = JOptionPane.showInputDialog(new JFrame(), "Quel est le type de cette vue (satellite, topographique, ...) ?\n(\u00e9vitez les accents)", "Parametrage (1/1)", 3)) != null && !type.matches("")) {
                this.traceurCarteEdition.ajouteVue(type, chooser.getSelectedFile().getName());
                this.visualisation.rechargeTypBarre(this.traceurCarteEdition.exporteVues(), this.espaceCartes);
                this.carteModifi\u00e9e = true;
            }
        }
    }

    public void ajouteDonneeCarte(int id) {
        JFileChooser chooser = new JFileChooser(this.espaceDocs);
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 lier");
        FiltreExtensible filtre = new FiltreExtensible("Donn\u00e9es");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".png");
        filtre.addExtension(".txt");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String ext;
            String fichXML;
            Traceur tr;
            boolean result;
            String fichDest;
            String fich = chooser.getSelectedFile().getPath();
            if (!fich.contains(fichDest = String.valueOf(this.espaceGeorefs) + chooser.getSelectedFile().getName())) {
                Interface.copier(chooser.getSelectedFile(), new File(fichDest));
            }
            if (result = (tr = new Traceur()).charger(fichXML = fich.replace(ext = fich.substring(fich.indexOf(".")), ".xml"))) {
                String typ = tr.exporteInfo("typeGeologique");
                this.traceurCarteEdition.ajouteDonneeArret(chooser.getSelectedFile().getName(), id, typ);
                this.carteModifi\u00e9e = true;
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu charger ne dispose pas de fichier d'informations !", "ERREUR !", 2, null);
            }
        }
    }

    public boolean getAAA() {
        return this.affichageArretsActif;
    }

    public boolean getACA() {
        return this.affichageCoordActif;
    }

    public void modifEffectuee(boolean b) {
        boolean temp = this.sauv\u00e9;
        boolean bl = this.sauv\u00e9 = !b;
        if (temp != this.sauv\u00e9) {
            this.majAffichage();
        }
    }

    private void aPropos() {
        JOptionPane.showMessageDialog(new JFrame(), "G\u00e9onote (version " + version + ")\nInstitut National de Recherche Pedagogique\nAuteur : Olivier LEFEVRE", "A PROPOS", 1);
    }

    private void enConstruction() {
        JOptionPane.showMessageDialog(new JFrame(), "Section en cours de developpement.", "ATTENTION !", 2);
    }

    public static void main(String[] args) {
        new Interface();
    }
}

