/*
 * Decompiled with CFR 0.152.
 */
package geonoteZones;

import geonoteInterface.Interface;
import geonoteTypesDonnees.Arret;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Historique
extends JPanel {
    private JTree tree = null;
    private TreePath path = null;
    private DefaultTreeModel treeModel = null;
    private Interface diplomate = null;
    private JScrollPane conteneur = null;
    private boolean selectionListenerActif = true;
    private MyTreeCellRenderer renderer = null;

    public Historique(Interface i) {
        this.setLayout(new BorderLayout());
        this.diplomate = i;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.renderer = new MyTreeCellRenderer();
    }

    public void creerArbre(String racine) {
        if (this.conteneur != null) {
            if (this.tree != null) {
                this.conteneur.remove(this.tree);
            }
            this.remove(this.conteneur);
        }
        DefaultMutableTreeNode rac = new DefaultMutableTreeNode(racine);
        this.tree = new JTree(rac);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setBorder(BorderFactory.createLineBorder(Color.white, 5));
        this.renderer.setOpenIcon(null);
        this.renderer.setClosedIcon(null);
        this.renderer.setLeafIcon(null);
        this.tree.setCellRenderer(this.renderer);
        this.tree.setVisible(true);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node;
                if (Historique.this.selectionListenerActif && (node = (DefaultMutableTreeNode)Historique.this.tree.getLastSelectedPathComponent()) != null && Historique.this.verifExtension(node.getUserObject().toString())) {
                    if (node.getParent().toString().matches("Carte")) {
                        Historique.this.diplomate.afficheVisu(node.getUserObject().toString(), "carte");
                    } else if (node.getParent().toString().contains("Arr")) {
                        Historique.this.diplomate.afficheVisu(node.getUserObject().toString(), "arret");
                    } else if (node.getParent().toString() == "Docs") {
                        Historique.this.diplomate.afficheDocs(node.getUserObject().toString());
                    }
                }
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getButton() == 3) {
                    Historique.this.ouvreMenu(arg0.getX(), arg0.getY());
                }
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
        this.conteneur = new JScrollPane(this.tree);
        this.conteneur.setBorder(null);
        this.add(this.conteneur);
        this.validate();
    }

    private void ouvreMenu(int x, int y) {
        TreePath path = this.tree.getClosestPathForLocation(x, y);
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        String noeud = node.toString();
        final JPopupMenu menu = new JPopupMenu();
        if (node.isLeaf()) {
            if (noeud.contains(".")) {
                final JCheckBoxMenuItem surligner = new JCheckBoxMenuItem("Surligner");
                surligner.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (surligner.isSelected()) {
                            Historique.this.renderer.setBackground(Color.blue);
                        } else {
                            Historique.this.renderer.setBackground(Color.white);
                        }
                        menu.setVisible(false);
                    }
                });
                JMenuItem annoter = new JMenuItem("Annoter");
                annoter.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        menu.setVisible(false);
                        Historique.this.annote(node);
                    }
                });
                menu.add(annoter);
                menu.show(this, x, y);
            } else if (noeud.contains("Annotation")) {
                JMenuItem modifier = new JMenuItem("Modifier");
                modifier.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        menu.setVisible(false);
                        Historique.this.modifieAnnotation(node);
                    }
                });
                menu.add(modifier);
                menu.show(this, x, y);
            }
        }
    }

    private void modifieAnnotation(DefaultMutableTreeNode elt) {
        this.selectionListenerActif = false;
        if (elt != null) {
            String saisie = JOptionPane.showInputDialog(this.diplomate, "Votre texte :", "Annotation", 1);
            DefaultMutableTreeNode pere = (DefaultMutableTreeNode)elt.getParent();
            pere.remove(elt);
            elt = new DefaultMutableTreeNode("Annotation : " + saisie);
            pere.add(elt);
            if (this.diplomate != null) {
                this.diplomate.modifAnnotation(elt.toString(), saisie);
            }
            this.tree.setModel(new DefaultTreeModel((DefaultMutableTreeNode)this.tree.getModel().getRoot()));
        }
        this.selectionListenerActif = true;
    }

    private void annote(DefaultMutableTreeNode elt) {
        this.selectionListenerActif = false;
        if (elt != null) {
            String saisie = JOptionPane.showInputDialog(this.diplomate, "Votre texte :", "Annotation", 1);
            DefaultMutableTreeNode annotation = new DefaultMutableTreeNode("Annotation : " + saisie);
            elt.add(annotation);
            this.tree.expandPath(new TreePath(elt.getPath()));
            if (this.diplomate != null) {
                this.diplomate.annoter(elt.toString(), saisie);
            }
        }
        this.selectionListenerActif = true;
    }

    public void ajouteAnnotation(String chemin, String annotation) {
        this.selectionListenerActif = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode elt = this.rechercher(root, chemin);
        if (elt != null) {
            DefaultMutableTreeNode eltAnnotation = new DefaultMutableTreeNode("Annotation : " + annotation);
            elt.add(eltAnnotation);
        } else {
            System.out.println("Erreur : nd non trouv\u00e9");
        }
        this.selectionListenerActif = true;
    }

    private boolean verifExtension(String chemin) {
        return chemin.endsWith(".jpg") || chemin.endsWith(".JPG") || chemin.endsWith(".jpeg") || chemin.endsWith(".JPEG") || chemin.endsWith(".gif") || chemin.endsWith(".GIF") || chemin.endsWith(".png") || chemin.endsWith(".PNG");
    }

    public void ajouterCarte(String nomCarte) {
        this.selectionListenerActif = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode carte = new DefaultMutableTreeNode("Carte");
        DefaultMutableTreeNode nouvo = new DefaultMutableTreeNode(nomCarte);
        carte.add(nouvo);
        root.add(carte);
        this.tree.setModel(new DefaultTreeModel(root));
        this.selectionListenerActif = true;
    }

    private DefaultMutableTreeNode rechercherN1(DefaultMutableTreeNode racine, String cherch\u00e9) {
        DefaultMutableTreeNode cible = null;
        DefaultMutableTreeNode temp = null;
        boolean trouv\u00e9 = false;
        Enumeration<TreeNode> enumeration = racine.children();
        while (enumeration.hasMoreElements() && !trouv\u00e9) {
            temp = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!temp.toString().matches(cherch\u00e9)) continue;
            cible = temp;
            trouv\u00e9 = true;
        }
        return cible;
    }

    private DefaultMutableTreeNode rechercher(DefaultMutableTreeNode racine, String cherch\u00e9) {
        DefaultMutableTreeNode cible = null;
        if (racine.toString() == cherch\u00e9) {
            cible = racine;
        } else {
            DefaultMutableTreeNode temp = null;
            boolean trouv\u00e9 = false;
            Enumeration<TreeNode> enumeration = racine.children();
            while (enumeration.hasMoreElements() && !trouv\u00e9) {
                temp = (DefaultMutableTreeNode)enumeration.nextElement();
                cible = this.rechercher(temp, cherch\u00e9);
                if (cible == null) continue;
                trouv\u00e9 = true;
            }
        }
        return cible;
    }

    public void ajouterDocs(String donn\u00e9e) {
        this.selectionListenerActif = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode docs = this.rechercherN1(root, "Docs");
        if (docs == null) {
            docs = new DefaultMutableTreeNode("Docs");
            root.add(docs);
        }
        DefaultMutableTreeNode nouvo = new DefaultMutableTreeNode(donn\u00e9e);
        docs.add(nouvo);
        this.tree.setModel(new DefaultTreeModel(root));
        this.tree.expandPath(new TreePath(docs.getPath()));
        this.selectionListenerActif = true;
    }

    public void ajouterDocs(ArrayList liste) {
        int i = 0;
        while (i < liste.size()) {
            this.ajouterDocs(liste.get(i).toString());
            ++i;
        }
    }

    public void ajoutArret(int id, String donnee) {
        this.selectionListenerActif = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode arret = this.rechercherN1(root, "Arr\u00eat " + id);
        if (arret == null) {
            arret = new DefaultMutableTreeNode("Arr\u00eat " + id);
            root.add(arret);
        }
        DefaultMutableTreeNode nouvo = new DefaultMutableTreeNode(donnee);
        arret.add(nouvo);
        this.tree.setModel(new DefaultTreeModel(root));
        this.tree.expandPath(new TreePath(arret.getPath()));
        this.selectionListenerActif = true;
    }

    public void reset() {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        this.tree = null;
    }

    public void ajouterDate(String j, String m, String a, String h, String min, String s) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode carte = new DefaultMutableTreeNode("Date de cr\u00e9ation");
        String chaineDate = String.valueOf(j) + " " + m + " " + a + " (\u00e0 " + h + "h" + min + "m" + s + ")";
        DefaultMutableTreeNode nouvo = new DefaultMutableTreeNode(chaineDate);
        carte.add(nouvo);
        root.add(carte);
        this.tree.setModel(new DefaultTreeModel(root));
    }

    public void chargeArrets(ArrayList liste) {
        this.selectionListenerActif = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Iterator i = liste.iterator();
        while (i.hasNext()) {
            Arret courant = (Arret)i.next();
            DefaultMutableTreeNode temp = new DefaultMutableTreeNode("Arr\u00eat " + courant.getId());
            ArrayList listLiens = courant.exporteListeLiens();
            Iterator j = listLiens.iterator();
            while (j.hasNext()) {
                DefaultMutableTreeNode lien = new DefaultMutableTreeNode(j.next().toString());
                temp.add(lien);
            }
            root.add(temp);
        }
        this.tree.setModel(new DefaultTreeModel(root));
        this.selectionListenerActif = true;
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        MyTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setText(value.toString());
            this.setForeground(Color.BLACK);
            this.setFont(new Font("Courrier", 0, 12));
            if (sel) {
                this.setBackground(Color.YELLOW);
            }
            return this;
        }
    }
}

