/*
 * Decompiled with CFR 0.152.
 */
package geonoteOutils;

import geonoteOutils.Traceur;
import geonoteTypesDonnees.Arret;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class TraceurCarte
extends Traceur {
    public TraceurCarte() {
    }

    public TraceurCarte(String path, String rac) {
        super(path, rac);
    }

    public void ajouteArret(int id, int x, int y) {
        Element arret = this.rechercheArret(this.document.getRootElement(), Integer.toString(id));
        if (arret != null) {
            System.out.println("Erreur : arret deja present !");
        } else {
            arret = new Element("arret");
            Element eltId = new Element("id");
            eltId.setText(Integer.toString(id));
            Element abs = new Element("abscisse");
            abs.setText(Integer.toString(x));
            Element ord = new Element("ordonnee");
            ord.setText(Integer.toString(y));
            arret.addContent((Content)eltId);
            arret.addContent((Content)abs);
            arret.addContent((Content)ord);
            this.document.getRootElement().addContent((Content)arret);
        }
    }

    public void ajouteVue(String nom, String fichier) {
        Element vues = this.rechercher(this.document.getRootElement(), "vues");
        if (vues == null) {
            vues = new Element("vues");
            this.document.getRootElement().addContent((Content)vues);
        }
        Element vue = new Element("vue");
        Element name = new Element("nom");
        name.setText(nom);
        Element file = new Element("fichier");
        file.setText(fichier);
        vue.addContent((Content)name);
        vue.addContent((Content)file);
        vues.addContent((Content)vue);
    }

    public ArrayList exporteVues() {
        Element vues = this.rechercher(this.document.getRootElement(), "vues");
        ArrayList liste = new ArrayList();
        if (vues != null) {
            List listeVues = vues.getChildren();
            Iterator i = listeVues.iterator();
            while (i.hasNext()) {
                Element courant = (Element)i.next();
                ArrayList<String> capsule = new ArrayList<String>();
                capsule.add(courant.getChild("nom").getText());
                capsule.add(courant.getChild("fichier").getText());
                liste.add(capsule);
            }
        }
        return liste;
    }

    public void ajouteDonneeArret(String path, int idArret, String type) {
        Element arret = this.rechercheArret(this.document.getRootElement(), Integer.toString(idArret));
        if (arret == null) {
            System.out.println("Erreur : arret inexistant !");
        } else {
            Element donnee = new Element("donnee");
            Element chemin = new Element("chemin");
            chemin.addContent(path);
            Element typeG = new Element("typeGeologique");
            typeG.setText(type);
            donnee.addContent((Content)chemin);
            donnee.addContent((Content)typeG);
            arret.addContent((Content)donnee);
        }
    }

    public void ajouteEchelle(double ech) {
        Element echelle = this.rechercher(this.document.getRootElement(), "echelle");
        if (echelle == null) {
            echelle = new Element("echelle");
            this.document.getRootElement().addContent((Content)echelle);
        }
        echelle.setText(Double.toString(ech));
    }

    public ArrayList construitArrets() {
        ArrayList<Arret> liste = new ArrayList<Arret>();
        ArrayList listArrets = new ArrayList();
        listArrets = this.rechercheArrets(this.document.getRootElement());
        Iterator i = listArrets.iterator();
        while (i.hasNext()) {
            Element arret = (Element)i.next();
            int id = Integer.parseInt(this.rechercher(arret, "id").getText());
            int abs = Integer.parseInt(this.rechercher(arret, "abscisse").getText());
            int ord = Integer.parseInt(this.rechercher(arret, "ordonnee").getText());
            ArrayList listLiens = new ArrayList();
            listLiens.addAll(this.exporteChemins(arret));
            Arret nouvArret = new Arret(id, abs, ord);
            nouvArret.importeListeLiens(listLiens);
            liste.add(nouvArret);
        }
        return liste;
    }

    public void ajouteCoord(String latitudeOrigine, String longitudeOrigine, String echelleLat, String echelleLong) {
        Element coord = new Element("coordonnees");
        Element orig = new Element("origine");
        Element lati = new Element("latitude");
        Element longi = new Element("longitude");
        lati.setText(latitudeOrigine);
        longi.setText(longitudeOrigine);
        orig.addContent((Content)lati);
        orig.addContent((Content)longi);
        Element echLat = new Element("echelleLatitude");
        Element echLong = new Element("echelleLongitude");
        echLat.setText(echelleLat);
        echLong.setText(echelleLong);
        coord.addContent((Content)orig);
        coord.addContent((Content)echLat);
        coord.addContent((Content)echLong);
        this.document.getRootElement().addContent((Content)coord);
    }
}

