/*
 * Decompiled with CFR 0.152.
 */
package geonoteTypesDonnees;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class Arret {
    private int id;
    private int x;
    private int y;
    private int diametre = 50;
    private ArrayList listeLiens = null;

    public Arret(int ident, int X, int Y) {
        this.id = ident;
        this.x = X;
        this.y = Y;
        this.listeLiens = new ArrayList();
    }

    public ArrayList exporteListeLiens() {
        return this.listeLiens;
    }

    public void ajouteLien(String lien) {
        this.listeLiens.add(lien);
    }

    public void importeListeLiens(ArrayList l) {
        if (l != null) {
            this.listeLiens.addAll(l);
        }
    }

    public void draw(Graphics2D g2, double zoom) {
        int diamAff = (int)((double)this.diametre / zoom);
        g2.setColor(Color.white);
        g2.fillRect(this.x, this.y, (diamAff + 5) / 3, (diamAff + 5) / 3);
        g2.setStroke(new BasicStroke((float)(5.0 / zoom)));
        g2.drawOval(this.x - diamAff / 2, this.y - diamAff / 2, diamAff, diamAff);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke((float)(1.0 / zoom)));
        g2.drawOval(this.x - diamAff / 2, this.y - diamAff / 2, diamAff, diamAff);
        g2.drawLine(this.x, this.y - diamAff / 2, this.x, this.y + diamAff / 2);
        g2.drawLine(this.x - diamAff / 2, this.y, this.x + diamAff / 2, this.y);
        g2.setFont(new Font("Courrier", 0, (int)(18.0 / zoom)));
        g2.drawString(Integer.toString(this.id), (int)((double)this.x + 2.0 / zoom), (int)((double)this.y + 16.0 / zoom));
    }

    public int getId() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getDiametre() {
        return this.diametre;
    }
}

