/*
 * Decompiled with CFR 0.152.
 */
package geonoteTypesDonnees;

import geonoteInterface.Interface;
import geonoteTypesDonnees.Arret;
import geonoteTypesDonnees.Images;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class Carte
extends Images {
    private int i = 0;
    private ArrayList listeArrets = new ArrayList();
    private int latitudeOrigine = 0;
    private int longitudeOrigine = 0;
    private double echelleLat = 1.0;
    private double echelleLong = 1.0;
    private int xCourant;
    private int yCourant;
    private boolean pointeurIN = false;
    private int latitude1 = -1;
    private int longitude1 = -1;
    private int x1 = -1;
    private int y1 = -1;
    private int latitude2 = -1;
    private int longitude2 = -1;
    private int x2 = -1;
    private int y2 = -1;

    public Carte(String path, double ech, String unit, boolean regletDisp, boolean zoomDisp, boolean modeEd, Interface i, ArrayList list, int latO, int longO, double echLat, double echLong) {
        super(path, ech, unit, regletDisp, zoomDisp, modeEd, i);
        this.latitudeOrigine = latO;
        this.longitudeOrigine = longO;
        this.echelleLat = echLat;
        this.echelleLong = echLong;
        if (list != null) {
            this.listeArrets.addAll(list);
        }
    }

    private Arret recherche(int x, int y) {
        Arret cible = null;
        boolean trouve = false;
        int i = 0;
        while (i < this.listeArrets.size() && !trouve) {
            Arret temp = (Arret)this.listeArrets.get(i);
            if ((double)x >= (double)temp.getX() - (double)temp.getDiametre() / (2.0 * this.zoom) && (double)x <= (double)temp.getX() + (double)temp.getDiametre() / (2.0 * this.zoom) && (double)y >= (double)temp.getY() - (double)temp.getDiametre() / (2.0 * this.zoom) && (double)y <= (double)temp.getY() + (double)temp.getDiametre() / (2.0 * this.zoom)) {
                cible = temp;
                trouve = true;
            }
            ++i;
        }
        return cible;
    }

    public void afficheMax(int x, int y, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.i == 0) {
            double rapportH = (double)this.getHeight() / (double)this.image.getIconHeight();
            double rapportL = (double)this.getWidth() / (double)this.image.getIconWidth();
            double min = Math.min(rapportL, rapportH);
            g2.scale(min, min);
        } else {
            g2.scale(this.zoom, this.zoom);
        }
        g2.drawImage(this.image.getImage(), 0, 0, this);
        int larg = (int)((double)this.image.getIconWidth() * this.zoom);
        int haut = (int)((double)this.image.getIconHeight() * this.zoom);
        Dimension dimensionImage = new Dimension(larg, haut);
        this.setPreferredSize(dimensionImage);
        this.setSize(dimensionImage);
        if (this.regletDispo && this.regletActif) {
            this.reglet.draw(g2, this.zoom, this.echelle, this.unit\u00e9);
        }
        if (!this.listeArrets.isEmpty() && this.diplomate.getAAA()) {
            int i = 0;
            while (i < this.listeArrets.size()) {
                Arret temp = (Arret)this.listeArrets.get(i);
                temp.draw(g2, this.zoom);
                ++i;
            }
        }
        g2.dispose();
        ++this.i;
    }

    public void ajoutArret(int x, int y) {
        if (this.modeEdition) {
            Arret rech = this.recherche(x, y);
            if (rech == null) {
                Arret arretCourant = new Arret(this.listeArrets.size() + 1, x, y);
                this.diplomate.ajouteArretCarte(this.listeArrets.size() + 1, x, y);
                this.listeArrets.add(arretCourant);
            } else {
                this.diplomate.ajouteDonneeCarte(rech.getId());
                System.out.println("collision !");
            }
        }
    }

    private void ajouteCoord(int x, int y) {
        int latitudeTemp = 0;
        int longitudeTemp = 0;
        String latitude = "";
        boolean latitudeOK = false;
        boolean longitudeOK = false;
        latitude = JOptionPane.showInputDialog(new JFrame(), "Quel est la latitude de ce point ? (sous la forme xx\u00b0xx'xx\") ", "Parametrage (1/2)", 3);
        while (latitude != null && !latitude.matches("") && !latitudeOK) {
            if (latitude.contains("\u00b0") && latitude.contains("'") && latitude.contains("\"") && latitude.indexOf("\u00b0") < latitude.indexOf("'") && latitude.indexOf("'") < latitude.indexOf("\"")) {
                String degres = latitude.substring(0, latitude.indexOf("\u00b0"));
                String minutes = latitude.substring(latitude.indexOf("\u00b0") + 1, latitude.indexOf("'"));
                String secondes = latitude.substring(latitude.indexOf("'") + 1, latitude.indexOf("\""));
                latitudeTemp = Integer.parseInt(degres) * 3600 + Integer.parseInt(minutes) * 60 + Integer.parseInt(secondes);
                latitudeOK = true;
                continue;
            }
            latitude = JOptionPane.showInputDialog(new JFrame(), "Erreur ! Respectez la syntaxe !\nQuel est la latitude de ce point ? (sous la forme xx\u00b0xx'xx\") ", "Parametrage (1/2)", 3);
        }
        if (latitudeOK) {
            String longitude = "";
            longitude = JOptionPane.showInputDialog(new JFrame(), "Quel est la longitude de ce point ? (sous la forme xx\u00b0xx'xx\") ", "Parametrage (2/2)", 3);
            while (longitude != null && !longitude.matches("") && !longitudeOK) {
                if (longitude.contains("\u00b0") && longitude.contains("'") && longitude.contains("\"") && longitude.indexOf("\u00b0") < longitude.indexOf("'") && longitude.indexOf("'") < longitude.indexOf("\"")) {
                    String degres = longitude.substring(0, longitude.indexOf("\u00b0"));
                    String minutes = longitude.substring(longitude.indexOf("\u00b0") + 1, longitude.indexOf("'"));
                    String secondes = longitude.substring(longitude.indexOf("'") + 1, longitude.indexOf("\""));
                    longitudeTemp = Integer.parseInt(degres) * 3600 + Integer.parseInt(minutes) * 60 + Integer.parseInt(secondes);
                    longitudeOK = true;
                    continue;
                }
                longitude = JOptionPane.showInputDialog(new JFrame(), "Erreur ! Respectez la syntaxe !\nQuel est la longitude de ce point ? (sous la forme xx\u00b0xx'xx\") ", "Parametrage (2/2)", 3);
            }
        }
        if (latitudeOK && longitudeOK) {
            if (this.x1 == -1 && this.y1 == -1) {
                this.x1 = x;
                this.y1 = y;
                this.latitude1 = latitudeTemp;
                this.longitude1 = longitudeTemp;
            } else if (this.x2 == -1 && this.y2 == -1) {
                this.x2 = x;
                this.y2 = y;
                this.latitude2 = latitudeTemp;
                this.longitude2 = longitudeTemp;
                this.echelleLat = (this.longitude2 - this.longitude1) / (this.x2 - this.x1);
                this.echelleLong = (this.latitude2 - this.latitude1) / (this.y2 - this.y1);
                this.longitudeOrigine = (int)((double)this.longitude1 - (double)this.x1 * this.echelleLong);
                this.latitudeOrigine = (int)((double)this.latitude1 - (double)this.x1 * this.echelleLat);
                this.diplomate.ajouteCoordonnees(this.latitudeOrigine, this.longitudeOrigine, this.echelleLat, this.echelleLong);
            }
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.zoom, this.zoom);
        g2.drawImage(this.image.getImage(), 0, 0, this);
        int larg = (int)((double)this.image.getIconWidth() * this.zoom);
        int haut = (int)((double)this.image.getIconHeight() * this.zoom);
        Dimension dimensionImage = new Dimension(larg, haut);
        this.setPreferredSize(dimensionImage);
        this.setSize(dimensionImage);
        if (!this.listeArrets.isEmpty() && this.diplomate.getAAA()) {
            int i = 0;
            while (i < this.listeArrets.size()) {
                Arret temp = (Arret)this.listeArrets.get(i);
                temp.draw(g2, this.zoom);
                ++i;
            }
        }
        if (this.regletDispo && this.regletActif) {
            this.reglet.draw(g2, this.zoom, this.echelle, this.unit\u00e9);
        }
        if (!this.regletActif && this.diplomate.getACA() && this.pointeurIN) {
            int xAff = (int)((double)this.xCourant + 10.0 / this.zoom);
            int yAff = (int)((double)this.yCourant + 10.0 / this.zoom);
            g2.setColor(Color.white);
            g2.fillRect(xAff, yAff, (int)(100.0 / this.zoom), (int)(25.0 / this.zoom));
            g2.setColor(Color.black);
            g2.drawRect(xAff, yAff, (int)(100.0 / this.zoom), (int)(25.0 / this.zoom));
            int longitude = (int)((double)this.longitudeOrigine + (double)this.xCourant * this.echelleLong);
            int latitude = (int)((double)this.latitudeOrigine + (double)this.yCourant * this.echelleLat);
            int degres = latitude / 3600;
            int minutes = (latitude - degres * 3600) / 60;
            int secondes = latitude - degres * 3600 - minutes * 60;
            g.setFont(new Font("Courrier", 0, (int)(10.0 / this.zoom)));
            g2.drawString("Latitude : " + Integer.toString(degres) + "\u00b0" + Integer.toString(minutes) + "'" + Integer.toString(secondes) + "\"", (int)((double)xAff + 3.0 / this.zoom), (int)((double)yAff + 23.0 / this.zoom));
            degres = longitude / 3600;
            minutes = (longitude - degres * 3600) / 60;
            secondes = longitude - degres * 3600 - minutes * 60;
            g2.drawString("Longitude : " + Integer.toString(degres) + "\u00b0" + Integer.toString(minutes) + "'" + Integer.toString(secondes) + "\"", (int)((double)xAff + 3.0 / this.zoom), (int)((double)yAff + 11.0 / this.zoom));
        }
        g2.dispose();
    }

    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getButton() == 1) {
            if (this.modeEdition && (this.x1 == -1 && this.y1 == -1 || this.x2 == -1 && this.y2 == -1)) {
                this.ajouteCoord(arg0.getX(), arg0.getY());
            } else {
                if (this.diplomate != null) {
                    this.diplomate.rapportTrace("carte", "clic");
                }
                this.ajoutArret((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
            }
            this.repaint();
        } else if (arg0.getButton() == 3) {
            this.ouvertureArret((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
            this.repaint();
        }
    }

    private void ouvertureArret(int x, int y) {
        final Arret arret = this.recherche(x, y);
        if (arret != null) {
            final JPopupMenu menu = new JPopupMenu("Donn\u00e9es disponibles :");
            ArrayList liste = arret.exporteListeLiens();
            Iterator i = liste.iterator();
            while (i.hasNext()) {
                final String lien = i.next().toString();
                JMenuItem item = new JMenuItem(lien);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        if (Carte.this.diplomate != null) {
                            Carte.this.diplomate.afficheVisu(lien, "arret");
                            Carte.this.diplomate.ajoutArretHisto(arret.getId(), lien);
                        }
                        menu.setVisible(false);
                    }
                });
                menu.add(item);
            }
            menu.show(this, x, y);
        }
    }

    public void mouseMoved(MouseEvent arg0) {
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
        Arret rech = this.recherche(this.xCourant, this.yCourant);
        if (rech != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.repaint();
        } else if (this.diplomate.getACA() && this.pointeurIN) {
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.repaint();
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseEntered(MouseEvent arg0) {
        this.pointeurIN = true;
    }

    public void mouseExited(MouseEvent arg0) {
        this.pointeurIN = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent arg0) {
        super.mouseDragged(arg0);
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
    }

    public void mouseWheelMoved(MouseWheelEvent arg0) {
        super.mouseWheelMoved(arg0);
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
    }

    public void mouseReleased(MouseEvent arg0) {
        if (this.regletDispo) {
            if (this.modeEdition && arg0.getButton() == 3) {
                this.diplomate.ajouteEchelle(this.reglet.getLongueur(), "carte");
            }
            this.regletActif = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (this.diplomate != null) {
                this.diplomate.rapportTrace("reglet", "fin");
            }
            this.repaint();
        }
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
    }
}

