/*
 * Decompiled with CFR 0.152.
 */
package geonoteZones;

import geonoteInterface.Interface;
import geonoteTypesDonnees.Carte;
import geonoteTypesDonnees.Images;
import geonoteZones.Carnet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class Visualisation
extends JPanel {
    private Images image = null;
    public Carte carte = null;
    private Carnet texte = null;
    private JScrollPane conteneur = null;
    private Interface diplomate = null;
    private JMenuBar typBarre = null;

    public Visualisation(Interface i) {
        this.setLayout(new BorderLayout());
        this.diplomate = i;
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent arg0) {
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
    }

    public void chargerImage(String path, double ech, String unit\u00e9, boolean reg, boolean zoom, boolean edition) {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        this.image = new Images(path, ech, unit\u00e9, reg, zoom, edition, this.diplomate);
        this.conteneur = new JScrollPane(this.image);
        this.conteneur.setBorder(null);
        this.conteneur.revalidate();
        this.add(this.conteneur);
        this.texte = null;
        this.carte = null;
        this.validate();
    }

    public void chargerTexte(String path) {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        this.texte = new Carnet(this.diplomate);
        this.conteneur = new JScrollPane(this.texte);
        this.conteneur.setBorder(null);
        this.conteneur.revalidate();
        this.add(this.conteneur);
        this.image = null;
        this.carte = null;
        this.validate();
    }

    public void chargerCarte(String path, double ech, String unit\u00e9, boolean reg, boolean zoom, boolean edition, ArrayList l, int latitudeO, int longitudeO, double echLati, double echLongi, ArrayList listeVues) {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        this.carte = new Carte(path, ech, unit\u00e9, reg, zoom, edition, this.diplomate, l, latitudeO, longitudeO, echLati, echLongi);
        this.conteneur = new JScrollPane(this.carte);
        this.conteneur.setBorder(null);
        this.conteneur.revalidate();
        this.add((Component)this.conteneur, "Center");
        this.texte = null;
        this.image = null;
        if (listeVues != null) {
            String esp = path.substring(0, path.lastIndexOf("\\"));
            this.rechargeTypBarre(listeVues, String.valueOf(esp) + "\\");
        }
        this.validate();
    }

    public void rechargeTypBarre(ArrayList l, final String dossier) {
        Iterator i = l.iterator();
        if (this.typBarre != null) {
            this.remove(this.typBarre);
        }
        if (!l.isEmpty()) {
            this.typBarre = new JMenuBar();
            while (i.hasNext()) {
                final ArrayList courant = (ArrayList)i.next();
                JButton bouton = new JButton((String)courant.get(0));
                bouton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        Visualisation.this.carte.charger(String.valueOf(dossier) + (String)courant.get(1));
                    }
                });
                this.typBarre.add(bouton);
            }
            this.add((Component)this.typBarre, "North");
        }
        this.validate();
    }

    public void reset() {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        if (this.typBarre != null) {
            this.remove(this.typBarre);
        }
        this.texte = null;
        this.image = null;
        this.carte = null;
    }

    public ImageIcon exporteImage() {
        if (this.image != null) {
            return this.image.getImage();
        }
        return null;
    }

    public ImageIcon exporteCarte() {
        if (this.carte != null) {
            return this.carte.getImage();
        }
        return null;
    }

    public JTextPane exporteTexte() {
        if (this.texte != null) {
            return this.texte.getTexte();
        }
        return null;
    }

    public void setUnite(String u) {
        if (this.carte != null) {
            this.carte.setUnit\u00e9(u);
        } else if (this.image != null) {
            this.image.setUnit\u00e9(u);
        }
    }

    public void setEchelle(double e) {
        if (this.carte != null) {
            this.carte.setEchelle(e);
        } else if (this.image != null) {
            this.image.setEchelle(e);
        }
    }

    public void activeReglet(boolean b) {
        if (this.carte != null) {
            this.carte.setRegletDispo(b);
        } else if (this.image != null) {
            this.image.setRegletDispo(b);
        }
    }

    public String exporteUnite() {
        String result = "";
        if (this.carte != null) {
            result = this.carte.getUnit\u00e9();
        } else if (this.image != null) {
            result = this.image.getUnit\u00e9();
        }
        return result;
    }
}

