/*
 * Decompiled with CFR 0.152.
 */
package geonoteInterface;

import geonoteInterface.FenetreAide;
import geonoteInterface.FenetreCalibrageReglet;
import geonoteInterface.FenetreParametrage;
import geonoteInterface.FenetreParametresEditionCarte;
import geonoteInterface.FenetreParametresEditionImage;
import geonoteInterface.FenetreParametresEditionTexte;
import geonoteOutils.FiltreExtensible;
import geonoteOutils.ImagePreview;
import geonoteOutils.Traceur;
import geonoteOutils.TraceurCarte;
import geonoteOutils.TraceurDonnee;
import geonoteOutils.TraceurSession;
import geonoteOutils.TraceurTraces;
import geonoteTypesDonnees.Texte;
import geonoteZones.Carnet;
import geonoteZones.Docs;
import geonoteZones.Historique;
import geonoteZones.Visualisation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class Interface
extends JFrame {
    static final String version = "0.10a";
    private Historique historique = null;
    private Carnet carnet = null;
    private Visualisation visualisation = null;
    private Docs docs = null;
    private JSplitPane splitPane1 = null;
    private JSplitPane splitPane2 = null;
    private JSplitPane splitPanePrincipal = null;
    private int hauteurMin = 480;
    private int largeurMin = 640;
    private FenetreParametresEditionCarte fpec = null;
    private FenetreParametresEditionImage fpei = null;
    private FenetreParametresEditionTexte fpet = null;
    private TraceurCarte traceurCarteEdition = null;
    private TraceurDonnee traceurDonneeEdition = null;
    private TraceurSession traceurSession = null;
    private TraceurTraces traceurTraces = null;
    private boolean affichageArretsActif = true;
    private boolean affichageCoordActif = false;
    private boolean carteEnEdition = false;
    private boolean texteEnEdition = false;
    private boolean imageEnEdition = false;
    private boolean carteModifi\u00e9e = false;
    private boolean docsModifi\u00e9 = false;
    private boolean fenetreActive = false;
    private boolean modeEdition = false;
    private boolean modeSuppArret = false;
    private boolean modeSuppLien = false;
    private boolean modeSuppVue = false;
    private boolean tracesActives = true;
    private boolean sauv\u00e9 = true;
    private String userName = "";
    private String espaceCartes = "";
    private String espaceDeTravail = "";
    private String espaceDocs = "";
    private String espaceDonnees = "";
    private String espaceGeorefs = "";
    private String espaceSessions = "";
    private String espaceTraces = "";
    private String espaceCarnet = "";
    private String extensionsCartes = "";
    private String extensionsDocs = "";
    private String extensionsTextes = "";
    private String nomFichierSession = "";
    private String nomFichierTraces = "";
    private JMenuBar barreM = null;
    private JMenu fichierM = null;
    private JMenuItem nouvSessionM = null;
    private JMenuItem chargSessionM = null;
    private JMenuItem quitterM = null;
    private JMenuItem enregM = null;
    private JMenu affichageM = null;
    private JCheckBoxMenuItem coordCB = null;
    private JCheckBoxMenuItem carnetCB = null;
    private JCheckBoxMenuItem arretsCB = null;
    private JCheckBoxMenuItem docsCB = null;
    private JCheckBoxMenuItem historiqueCB = null;
    private JCheckBoxMenuItem visualisationCB = null;
    private JMenu aideM = null;
    private JMenuItem helpM = null;
    private JMenuItem aproposM = null;
    private JMenu editionM = null;
    private JMenuItem edActiverM = null;
    private JMenuItem edDesactiverM = null;
    private JMenuItem enregEditM = null;
    private JMenuItem parametresEditM = null;
    private JMenuItem modifCarteM = null;
    private JMenuItem modifDocsM = null;
    private JMenu modifM = null;
    private JMenuItem nouvCarteM = null;
    private JMenuItem nouvDocsM = null;
    private JMenuItem nouvVueM = null;
    private JMenu nouvM = null;
    private JMenuItem suppArretM = null;
    private JMenuItem suppCarteM = null;
    private JMenuItem suppVueM = null;
    private JMenuItem suppDocsM = null;
    private JMenuItem suppLienM = null;
    private JMenu suppM = null;
    private JMenu outilsM = null;
    private JMenuItem calendrierM = null;
    private JMenuItem docsM = null;
    private JMenuItem lexiqueM = null;
    private JMenuItem parametrageM = null;
    private JMenuItem rechercheM = null;

    public Interface() {
        super(" G\u00e9onote 0.10a");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        System.out.println("JRE " + System.getProperty("java.version"));
        System.out.println("Geonote 0.10a");
        this.espaceDeTravail = String.valueOf(System.getProperty("user.dir")) + "\\";
        Traceur config = new Traceur();
        boolean result = config.charger(String.valueOf(this.espaceDeTravail) + "config.xml");
        if (result) {
            this.espaceTraces = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceTraces");
            this.espaceDonnees = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceDonnees");
            this.espaceSessions = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceSessions");
            this.espaceCartes = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceCartes");
            this.espaceDocs = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceDocs");
            this.espaceGeorefs = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceGeorefs");
            this.espaceCarnet = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceCarnet");
            this.extensionsCartes = config.exporteInfo("extensionsCartes");
            this.extensionsDocs = config.exporteInfo("extensionsDocs");
            this.extensionsTextes = config.exporteInfo("extensionsTextes");
            String largeur = config.exporteInfo("largeur");
            this.largeurMin = Integer.parseInt(largeur);
            String hauteur = config.exporteInfo("hauteur");
            this.hauteurMin = Integer.parseInt(hauteur);
            this.tracesActives = config.exporteInfo("traces").equals("actives");
            this.setSize(new Dimension(this.largeurMin, this.hauteurMin));
            this.setMinimumSize(new Dimension(640, 480));
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Erreur de chargement du fichier de configuration !!!", "ERREUR !", 2);
            System.out.println("Erreur de chargement du fichier de configuration !!!");
            System.exit(0);
        }
        this.setLocationRelativeTo(null);
        this.setResizable(true);
        this.setDefaultCloseOperation(3);
        this.historique = new Historique(this);
        this.visualisation = new Visualisation(this);
        this.carnet = new Carnet(this);
        this.docs = new Docs(this);
        this.splitPanePrincipal = new JSplitPane(0);
        this.splitPanePrincipal.setDividerLocation(this.getHeight() * 3 / 4);
        this.splitPanePrincipal.setPreferredSize(new Dimension(this.largeurMin, this.hauteurMin));
        this.splitPane1 = new JSplitPane(1);
        this.splitPane1.setDividerLocation(this.getWidth() / 4);
        this.splitPane2 = new JSplitPane(1);
        this.splitPane2.setDividerLocation(this.getWidth() * 3 / 8);
        this.splitPane1.setBorder(null);
        this.splitPane2.setBorder(null);
        this.splitPanePrincipal.setDividerSize(4);
        this.splitPane1.setDividerSize(4);
        this.splitPane2.setDividerSize(4);
        this.splitPane2.setLeftComponent(this.visualisation);
        this.splitPane2.setRightComponent(this.docs);
        this.splitPane1.setLeftComponent(this.historique);
        this.splitPane1.setRightComponent(this.splitPane2);
        this.splitPanePrincipal.setTopComponent(this.splitPane1);
        this.splitPanePrincipal.setBottomComponent(this.carnet);
        this.add((Component)this.splitPanePrincipal, "Center");
        this.barreM = new JMenuBar();
        this.setJMenuBar(this.barreM);
        this.fichierM = new JMenu("Fichier");
        this.fichierM.setMnemonic(70);
        this.barreM.add(this.fichierM);
        this.nouvSessionM = new JMenuItem("Nouvelle session");
        this.nouvSessionM.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.nouvSessionM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvelleSession();
            }
        });
        this.fichierM.add(this.nouvSessionM);
        this.chargSessionM = new JMenuItem("Charger une session ...");
        this.chargSessionM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.chargerSession();
            }
        });
        this.fichierM.add(this.chargSessionM);
        this.enregM = new JMenuItem("Enregistrer la session");
        this.enregM.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.enregM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enregistrerSession();
            }
        });
        this.fichierM.add(this.enregM);
        this.fichierM.addSeparator();
        this.quitterM = new JMenuItem("Quitter");
        this.quitterM.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.quitterM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.quitter();
            }
        });
        this.fichierM.add(this.quitterM);
        this.affichageM = new JMenu("Affichage");
        this.affichageM.setMnemonic(65);
        this.barreM.add(this.affichageM);
        this.coordCB = new JCheckBoxMenuItem("Coordonn\u00e9es g\u00e9ographiques");
        this.coordCB.setSelected(false);
        this.coordCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.coordCB);
        this.arretsCB = new JCheckBoxMenuItem("Arr\u00eats");
        this.arretsCB.setSelected(true);
        this.arretsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.arretsCB);
        this.historiqueCB = new JCheckBoxMenuItem("Historique");
        this.historiqueCB.setSelected(true);
        this.historiqueCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.historiqueCB);
        this.visualisationCB = new JCheckBoxMenuItem("Visualisation");
        this.visualisationCB.setSelected(true);
        this.visualisationCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.visualisationCB);
        this.docsCB = new JCheckBoxMenuItem("Docs");
        this.docsCB.setSelected(false);
        this.docsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.docsCB);
        this.carnetCB = new JCheckBoxMenuItem("Carnet");
        this.carnetCB.setSelected(true);
        this.carnetCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.carnetCB);
        this.outilsM = new JMenu("Outils");
        this.outilsM.setMnemonic(79);
        this.barreM.add(this.outilsM);
        this.docsM = new JMenuItem("Docs");
        this.docsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.chargerDocs();
            }
        });
        this.outilsM.add(this.docsM);
        this.calendrierM = new JMenuItem("Calendrier");
        this.calendrierM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.lancementCalendrier();
            }
        });
        this.outilsM.add(this.calendrierM);
        this.lexiqueM = new JMenuItem("Lexique");
        this.lexiqueM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enConstruction();
            }
        });
        this.outilsM.add(this.lexiqueM);
        this.parametrageM = new JMenuItem("Parametrage");
        this.parametrageM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FenetreParametrage fp = new FenetreParametrage(Interface.this.espaceCartes, Interface.this.espaceDocs, Interface.this.espaceGeorefs);
            }
        });
        this.outilsM.add(this.parametrageM);
        this.rechercheM = new JMenuItem("Recherche");
        this.rechercheM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.recherche();
            }
        });
        this.outilsM.add(this.rechercheM);
        this.editionM = new JMenu("Edition");
        this.editionM.setMnemonic(69);
        this.barreM.add(this.editionM);
        this.edActiverM = new JMenuItem("Activer");
        this.edActiverM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.activerEdition(true);
            }
        });
        this.editionM.add(this.edActiverM);
        this.edDesactiverM = new JMenuItem("Desactiver");
        this.edDesactiverM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.activerEdition(false);
            }
        });
        this.editionM.add(this.edDesactiverM);
        this.editionM.addSeparator();
        this.nouvM = new JMenu("Nouveau");
        this.editionM.add(this.nouvM);
        this.nouvCarteM = new JMenuItem("Carte ...");
        this.nouvCarteM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvCarte();
            }
        });
        this.nouvM.add(this.nouvCarteM);
        this.nouvVueM = new JMenuItem("Vue ...");
        this.nouvVueM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvVue();
            }
        });
        this.nouvVueM.setEnabled(false);
        this.nouvM.add(this.nouvVueM);
        this.nouvDocsM = new JMenuItem("Donn\u00e9e ...");
        this.nouvDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvDonnee();
            }
        });
        this.nouvM.add(this.nouvDocsM);
        this.modifM = new JMenu("Modifier");
        this.editionM.add(this.modifM);
        this.modifCarteM = new JMenuItem("Carte ...");
        this.modifCarteM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.modifCarte();
            }
        });
        this.modifM.add(this.modifCarteM);
        this.modifDocsM = new JMenuItem("Donn\u00e9e ...");
        this.modifDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.modifDonnee();
            }
        });
        this.modifM.add(this.modifDocsM);
        this.suppM = new JMenu("Supprimer");
        this.editionM.add(this.suppM);
        this.suppCarteM = new JMenuItem("Carte ...");
        this.suppCarteM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppCarte();
            }
        });
        this.suppM.add(this.suppCarteM);
        this.suppVueM = new JMenuItem("Vue ...");
        this.suppVueM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppVue();
            }
        });
        this.suppM.add(this.suppVueM);
        this.suppArretM = new JMenuItem("Arret ...");
        this.suppArretM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppArret();
            }
        });
        this.suppM.add(this.suppArretM);
        this.suppLienM = new JMenuItem("Lien ...");
        this.suppLienM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppLien();
            }
        });
        this.suppM.add(this.suppLienM);
        this.suppDocsM = new JMenuItem("Donn\u00e9e ...");
        this.suppDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppDonnee();
            }
        });
        this.suppM.add(this.suppDocsM);
        this.enregEditM = new JMenuItem("Enregistrer");
        this.enregEditM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enregistrerEdition();
            }
        });
        this.editionM.add(this.enregEditM);
        this.parametresEditM = new JMenuItem("Param\u00e8tres ...");
        this.parametresEditM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.afficheParametres();
            }
        });
        this.editionM.add(this.parametresEditM);
        this.aideM = new JMenu("?");
        this.barreM.add(this.aideM);
        this.helpM = new JMenuItem("Aide");
        this.helpM.setMnemonic(112);
        this.helpM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FenetreAide fa = new FenetreAide(Interface.this.espaceDeTravail);
            }
        });
        this.aideM.add(this.helpM);
        this.aproposM = new JMenuItem("A propos de G\u00e9onote ...");
        this.aproposM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.aPropos();
            }
        });
        this.aideM.add(this.aproposM);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent arg0) {
            }

            public void componentMoved(ComponentEvent arg0) {
            }

            public void componentResized(ComponentEvent arg0) {
                Interface.this.repaintSplit();
            }

            public void componentShown(ComponentEvent arg0) {
            }
        });
        this.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent arg0) {
            }

            public void windowClosed(WindowEvent arg0) {
            }

            public void windowClosing(WindowEvent evt) {
                Interface.this.quitter();
            }

            public void windowDeactivated(WindowEvent arg0) {
            }

            public void windowDeiconified(WindowEvent arg0) {
            }

            public void windowIconified(WindowEvent arg0) {
            }

            public void windowOpened(WindowEvent arg0) {
            }
        });
        this.activation(false);
        this.pack();
        this.setVisible(true);
        Date date = new Date();
        String[] dateTab = date.toString().split(" ");
        String heure = dateTab[3].replaceFirst(":", "h");
        heure = heure.replaceFirst(":", "m");
        String loginWin = System.getProperty("user.name");
        this.nomFichierTraces = "traces_" + loginWin + "_" + dateTab[2] + "-" + dateTab[1] + "-" + dateTab[5] + "_" + heure + ".xml";
        this.traceurTraces = new TraceurTraces(String.valueOf(this.espaceTraces) + "\\" + this.nomFichierTraces, "traces");
    }

    public void activation(boolean b) {
        this.fenetreActive = b;
        this.historique.setEnabled(b);
        this.visualisation.setEnabled(b);
        this.carnet.setEnabled(b);
        this.docs.setEnabled(b);
        this.splitPanePrincipal.setEnabled(b);
        this.splitPane1.setEnabled(b);
        this.splitPane2.setEnabled(b);
        this.enregM.setEnabled(b);
        this.affichageM.setEnabled(b);
        this.rechercheM.setEnabled(b);
        this.docsM.setEnabled(b);
        this.edDesactiverM.setEnabled(this.modeEdition);
        this.nouvM.setEnabled(this.modeEdition);
        this.modifM.setEnabled(this.modeEdition);
        this.suppM.setEnabled(this.modeEdition);
        this.enregEditM.setEnabled(this.modeEdition);
        this.parametresEditM.setEnabled(this.modeEdition && (this.carteEnEdition || this.texteEnEdition || this.imageEnEdition));
        this.docs.setVisible(this.docs.rapportActivit\u00e9());
    }

    private void activerEdition(boolean b) {
        this.confirmation();
        if (!this.fenetreActive) {
            this.activation(true);
        }
        this.sauv\u00e9 = true;
        if (b) {
            this.rapportTrace("menu", "activation edition");
            boolean verif = this.authentification();
            if (verif) {
                this.modeEdition = b;
                this.majAffichage();
                this.visualisation.reset();
                this.historique.reset();
                this.docs.reset();
                this.carnet.reset();
            } else {
                this.rapportTrace("menu", "activation edition", "echec authentification");
            }
        } else {
            this.rapportTrace("menu", "desactivation edition");
            this.modeEdition = b;
            this.majAffichage();
            this.visualisation.reset();
            this.historique.reset();
            this.docs.reset();
            this.carnet.reset();
            this.docsModifi\u00e9 = false;
            this.carteModifi\u00e9e = false;
            this.nouvVueM.setEnabled(false);
            this.carteEnEdition = false;
            this.texteEnEdition = false;
        }
    }

    public void afficheDocs(String donnee) {
        String extension;
        TraceurCarte tr = new TraceurCarte();
        String chemin = String.valueOf(this.espaceDocs) + donnee;
        String cheminXML = chemin.replace(extension = chemin.substring(chemin.lastIndexOf(".")), ".xml");
        boolean result = tr.charger(cheminXML);
        if (result) {
            String type = tr.exporteType();
            if (type.equals("texte")) {
                this.docs.chargerTexte(chemin);
            } else {
                boolean regActif = tr.exporteInfo("reglet").equals("actif");
                boolean zoomActif = tr.exporteInfo("zoom").equals("actif");
                String unit = "";
                double ech = 1.0;
                if (regActif) {
                    unit = tr.exporteInfo("unite");
                    ech = Double.parseDouble(tr.exporteInfo("echelle"));
                }
                if (type.equals("carte")) {
                    this.docs.chargerCarte(chemin, ech, unit, regActif, zoomActif, this.modeEdition, tr.construitArrets(), Integer.parseInt(tr.exporteInfo("latitude")), Integer.parseInt(tr.exporteInfo("longitude")), Double.parseDouble(tr.exporteInfo("echelleLatitude")), Double.parseDouble(tr.exporteInfo("echelleLongitude")));
                } else if (type.equals("image")) {
                    this.docs.chargerImage(chemin, ech, unit, regActif, zoomActif, this.modeEdition);
                }
            }
        } else {
            System.out.println("Erreur lors du chargement de la donnee !");
        }
        this.docsCB.setSelected(true);
        this.majAffichage();
    }

    public void afficheParametres() {
        if (this.modeEdition) {
            if (this.carteEnEdition && !this.fpec.isVisible()) {
                boolean regActif = this.traceurCarteEdition.exporteInfo("reglet").equals("actif");
                boolean zoomActif = this.traceurCarteEdition.exporteInfo("zoom").equals("actif");
                String nivo = this.traceurCarteEdition.exporteInfo("niveau");
                String motscles = this.traceurCarteEdition.exporteInfo("motscles");
                String typeVue = this.traceurCarteEdition.exporteTypeVuePrincipale();
                String fichVue = this.traceurCarteEdition.exporteFichierVuePrincipale();
                this.fpec = new FenetreParametresEditionCarte(this, fichVue);
                this.fpec.chargerParam(typeVue, regActif, zoomActif, nivo, motscles);
            } else if (this.texteEnEdition && !this.fpet.isVisible()) {
                String nivo = this.traceurDonneeEdition.exporteInfo("niveau");
                String motscles = this.traceurDonneeEdition.exporteInfo("motscles");
                String commentaire = this.traceurDonneeEdition.exporteInfo("commentaire");
                String typGeol = this.traceurDonneeEdition.exporteInfo("typeGeologique");
                this.fpet = new FenetreParametresEditionTexte(this);
                this.fpet.chargerParam(typGeol, nivo, commentaire, motscles);
            } else if (this.imageEnEdition && !this.fpei.isVisible()) {
                boolean regActif = this.traceurDonneeEdition.exporteInfo("reglet").equals("actif");
                boolean zoomActif = this.traceurDonneeEdition.exporteInfo("zoom").equals("actif");
                String nivo = this.traceurDonneeEdition.exporteInfo("niveau");
                String motscles = this.traceurDonneeEdition.exporteInfo("motscles");
                String commentaire = this.traceurDonneeEdition.exporteInfo("commentaire");
                String typGeol = this.traceurDonneeEdition.exporteInfo("typeGeologique");
                this.fpei = new FenetreParametresEditionImage(this);
                this.fpei.chargerParam(typGeol, regActif, zoomActif, nivo, commentaire, motscles);
            }
        }
    }

    public void afficheVisu(String donnee, String ndPere) {
        String cheminImage = "";
        String extension = "";
        String cheminXML = "";
        TraceurCarte tr = new TraceurCarte();
        if (ndPere.equals("carte")) {
            cheminImage = String.valueOf(this.espaceCartes) + this.traceurSession.exporteCarte();
            extension = donnee.substring(donnee.lastIndexOf("."));
            cheminXML = cheminImage.replace(extension, ".xml");
        } else if (ndPere.equals("arret")) {
            cheminImage = String.valueOf(this.espaceGeorefs) + donnee;
            extension = donnee.substring(donnee.lastIndexOf("."));
            cheminXML = cheminImage.replace(extension, ".xml");
        }
        boolean result = tr.charger(cheminXML);
        if (result) {
            String type = tr.exporteType();
            if (type.equals("texte")) {
                this.docs.chargerTexte(cheminImage);
            } else {
                boolean regActif = tr.exporteInfo("reglet").equals("actif");
                boolean zoomActif = tr.exporteInfo("zoom").equals("actif");
                String unit = "";
                double ech = 1.0;
                if (regActif) {
                    unit = tr.exporteInfo("unite");
                    ech = Double.parseDouble(tr.exporteInfo("echelle"));
                }
                if (type.equals("carte")) {
                    this.visualisation.chargerCarte(cheminImage, ech, unit, regActif, zoomActif, this.modeEdition, tr.construitArrets(), Integer.parseInt(tr.exporteInfo("latitude")), Integer.parseInt(tr.exporteInfo("longitude")), Double.parseDouble(tr.exporteInfo("echelleLatitude")), Double.parseDouble(tr.exporteInfo("echelleLongitude")), tr.exporteVues());
                    if (!donnee.equals(this.traceurSession.exporteCarte())) {
                        this.visualisation.chargerVue(String.valueOf(this.espaceCartes) + donnee);
                    }
                } else if (type.equals("image")) {
                    this.visualisation.chargerImage(cheminImage, ech, unit, regActif, zoomActif, this.modeEdition);
                }
            }
            this.visualisationCB.setSelected(true);
            this.majAffichage();
            this.coordCB.setEnabled(type.equals("carte"));
            if (!this.coordCB.isEnabled()) {
                this.coordCB.setSelected(false);
            }
        } else {
            System.out.println("Erreur lors du chargement de la donnee !");
        }
    }

    public void ajoutArretHisto(int idArret, String donnee) {
        this.sauv\u00e9 = false;
        Date date = new Date();
        String[] dateTab = this.traduireDate(date).split(" ");
        String[] heureTab = dateTab[3].split(":");
        this.historique.ajoutArret(idArret, String.valueOf(donnee) + " (le " + dateTab[2] + "/" + dateTab[1] + "/" + dateTab[5] + " \u00e0 " + heureTab[0] + ":" + heureTab[1] + ":" + heureTab[2] + ")");
        this.traceurSession.ajouteDonneeArret(Integer.toString(idArret), donnee, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
    }

    public void ajouteArretCarte(int id, int latitude, int longitude) {
        this.traceurCarteEdition.ajouteArret(id, latitude, longitude);
        this.carteModifi\u00e9e = true;
    }

    public void ajouteCoordonnees(int latOrigine, int longOrigine, double echLat, double echLong) {
        this.traceurCarteEdition.ajouteCoord(Integer.toString(latOrigine), Integer.toString(longOrigine), Double.toString(echLat), Double.toString(echLong));
        this.carteModifi\u00e9e = true;
        this.fpec.setExtendedState(0);
        this.fpec.setDefCoordEffectuee(true);
    }

    public ArrayList ajouteDonneeCarte(int id) {
        ArrayList<String> resultat = new ArrayList<String>();
        JFileChooser chooser = new JFileChooser(this.espaceDocs);
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 lier");
        FiltreExtensible filtre = new FiltreExtensible("Donn\u00e9es");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".png");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            String fichDest = String.valueOf(this.espaceGeorefs) + chooser.getSelectedFile().getName();
            String ext = fich.substring(fich.lastIndexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            String fichXMLDest = fichDest.replace(ext, ".xml");
            Traceur tr = new Traceur();
            boolean result = tr.charger(fichXML);
            if (result) {
                String typ = tr.exporteInfo("typeGeologique");
                String nom = chooser.getSelectedFile().getName();
                resultat.add(nom);
                resultat.add(typ);
                this.traceurCarteEdition.ajouteDonneeArret(nom, id, typ);
                if (!fich.contains(fichDest)) {
                    this.copier(chooser.getSelectedFile(), new File(fichDest));
                }
                if (!fichXML.contains(fichXMLDest)) {
                    this.copier(new File(fichXML), new File(fichXMLDest));
                }
                this.carteModifi\u00e9e = true;
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu charger ne dispose pas de fichier d'informations !", "ERREUR !", 2, null);
            }
        }
        return resultat;
    }

    public void ajouteEchelle(double mesure, String cible) {
        FenetreCalibrageReglet fcr = new FenetreCalibrageReglet(this, mesure, cible);
    }

    public void enregEchelle(String cible, String unit, double dist, double mesure) {
        if (cible.equals("carte")) {
            this.traceurCarteEdition.ajouterElt("unite", unit);
        }
        if (cible.equals("image")) {
            this.traceurDonneeEdition.ajouterElt("unite", unit);
        }
        this.visualisation.setUnite(unit);
        double rapport = dist / mesure;
        if (cible.equals("carte")) {
            this.traceurCarteEdition.ajouteEchelle(rapport);
        }
        if (cible.equals("image")) {
            this.traceurDonneeEdition.ajouteEchelle(rapport);
        }
        this.visualisation.setEchelle(rapport);
        if (this.fpec != null) {
            this.fpec.setExtendedState(0);
            this.fpec.setMesureEffectuee(true);
        } else if (this.fpei != null) {
            this.fpei.setExtendedState(0);
            this.fpei.setMesureEffectuee(true);
        }
        this.carteModifi\u00e9e = true;
        this.docsModifi\u00e9 = true;
    }

    public void ajouteVue(String fich) {
        if (!this.modeEdition) {
            Date date = new Date();
            String[] dateTab = this.traduireDate(date).split(" ");
            String[] heureTab = dateTab[3].split(":");
            this.historique.ajouterVue(String.valueOf(fich) + " (le " + dateTab[2] + "/" + dateTab[1] + "/" + dateTab[5] + " \u00e0 " + heureTab[0] + ":" + heureTab[1] + ":" + heureTab[2] + ")");
            this.traceurSession.ajouteVue(fich, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
            this.modifEffectuee(true);
        }
    }

    public void annoter(String elt, String pere, String texte) {
        this.traceurSession.ajouterAnnotation(elt, pere, texte);
        this.sauv\u00e9 = false;
        this.majAffichage();
    }

    private void aPropos() {
        this.rapportTrace("menu", "a propos");
        Object[] ok = new String[]{"OK"};
        ImageIcon icon = new ImageIcon(String.valueOf(this.espaceDeTravail) + "logo.jpg");
        String texte = "G\u00e9onote (version 0.10a)\nInstitut National de Recherche Pedagogique\nSc\u00e9nario : Eric Sanchez\nR\u00e9alisation : Olivier Lefevre\nRemerciements : P. Federici, Y. Fesselier, A. Mille, M. Prieur";
        JOptionPane.showOptionDialog(this, texte, "A PROPOS", 0, 1, icon, ok, ok[0]);
    }

    private boolean authentification() {
        JPasswordField mdp = new JPasswordField(10);
        Object[] o = new Object[]{mdp, "Valider", "Annuler"};
        int retour = JOptionPane.showOptionDialog(null, "Saisissez le mot de passe.", "Contr\u00f4le d'acc\u00e8s", 1, 2, null, o, null);
        if (retour == 1) {
            char[] mot = mdp.getPassword();
            if (this.motDePasseEditionCorrect(mot)) {
                JOptionPane.showMessageDialog(new JFrame(), "Mot de passe correct !", "Information", 1);
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "Mot de passe incorrect !", "Information", 2);
            }
            return this.motDePasseEditionCorrect(mot);
        }
        return false;
    }

    private void chargerDocs() {
        this.rapportTrace("menu", "ouverture document");
        JFileChooser chooser = new JFileChooser(this.espaceDocs);
        chooser.setDialogTitle("Ouverture d'une donn\u00e9e du docs (donn\u00e9e non-g\u00e9or\u00e9f\u00e9renc\u00e9e)");
        FiltreExtensible filtre = new FiltreExtensible("Docs");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".rtf");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getName();
            String extension = fich.substring(fich.lastIndexOf("."));
            if (this.extensionsDocs.contains(extension)) {
                Traceur tr = new Traceur();
                String fichXml = chooser.getSelectedFile().getPath().replace(extension, ".xml");
                boolean result = tr.charger(fichXml);
                if (result) {
                    String type = tr.exporteType();
                    if (type.equals("image")) {
                        boolean regActif = tr.exporteInfo("reglet").equals("actif");
                        boolean zoomActif = tr.exporteInfo("zoom").equals("actif");
                        String unit = "";
                        double ech = 1.0;
                        if (regActif) {
                            unit = tr.exporteInfo("unite");
                            ech = Double.parseDouble(tr.exporteInfo("echelle"));
                        }
                        this.docs.chargerImage(chooser.getSelectedFile().getPath(), ech, unit, regActif, zoomActif, this.modeEdition);
                        Date date = new Date();
                        String[] dateTab = this.traduireDate(date).split(" ");
                        String[] heureTab = dateTab[3].split(":");
                        this.historique.ajouterDocs(String.valueOf(fich) + " (le " + dateTab[2] + "/" + dateTab[1] + "/" + dateTab[5] + " \u00e0 " + heureTab[0] + ":" + heureTab[1] + ":" + heureTab[2] + ")");
                        this.traceurSession.ajouteDonneeDocs(fich, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                        this.docsCB.setSelected(true);
                        this.modifEffectuee(true);
                    } else if (type.equals("texte")) {
                        this.docs.chargerTexte(chooser.getSelectedFile().getPath());
                        Date date = new Date();
                        String[] dateTab = this.traduireDate(date).split(" ");
                        String[] heureTab = dateTab[3].split(":");
                        this.historique.ajouterDocs(String.valueOf(fich) + " (le " + dateTab[2] + "/" + dateTab[1] + "/" + dateTab[5] + " \u00e0 " + heureTab[0] + ":" + heureTab[1] + ":" + heureTab[2] + ")");
                        this.traceurSession.ajouteDonneeDocs(fich, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                        this.docsCB.setSelected(true);
                        this.modifEffectuee(true);
                    } else {
                        JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu charger n'est pas une image !", "ERREUR !", 2, null);
                    }
                } else {
                    JOptionPane.showMessageDialog(new JFrame(), "Impossible d'ouvrir cette donn\u00e9e !", "ERREUR !", 2, null);
                }
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "Le type de fichier que vous voulez charger n'est pas support\u00e9 !", "ERREUR !", 2, null);
            }
        } else {
            this.rapportTrace("menu", "ouverture document", "annulation");
        }
        this.majAffichage();
    }

    private void chargerSession() {
        this.confirmation();
        JFileChooser chooser = new JFileChooser(this.espaceSessions);
        chooser.setDialogTitle("Chargement d'une session");
        FiltreExtensible filtre = new FiltreExtensible("Fichiers");
        filtre.addExtension(".xml");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "chargement session", path);
            this.traceurSession = new TraceurSession();
            boolean result = this.traceurSession.charger(path);
            if (result) {
                String nomFichierRTF = chooser.getSelectedFile().getName().replace(".xml", ".rtf");
                this.carnet.charger(String.valueOf(this.espaceCarnet) + nomFichierRTF);
                TraceurCarte traceurCarte = new TraceurCarte();
                String cheminCarte = String.valueOf(this.espaceCartes) + this.traceurSession.exporteCarte();
                String extension = cheminCarte.substring(cheminCarte.lastIndexOf("."));
                boolean res = traceurCarte.charger(cheminCarte.replace(extension, ".xml"));
                if (res) {
                    this.docs.desactiver();
                    this.historique.creerArbre(this.traceurSession.exporteInfo("nom"));
                    this.historique.ajouterDateSession(this.traceurSession.exporteInfo("jour"), this.traceurSession.exporteInfo("mois"), this.traceurSession.exporteInfo("annee"), this.traceurSession.exporteInfo("heures"), this.traceurSession.exporteInfo("minutes"), this.traceurSession.exporteInfo("secondes"));
                    this.historique.ajouterVue(this.traceurSession.exporteCarteDat\u00e9e());
                    this.historique.chargeArrets(this.traceurSession.exporteArretsHisto());
                    this.historique.ajouterDocs(this.traceurSession.exporteDocsHisto());
                    ArrayList liste = this.traceurSession.exporteAnnotations();
                    int i = 0;
                    while (i < liste.size()) {
                        ArrayList caps = (ArrayList)liste.get(i);
                        String chemin = caps.get(0).toString();
                        String annotation = caps.get(1).toString();
                        this.historique.ajouteAnnotation(chemin, annotation);
                        ++i;
                    }
                    boolean regActif = traceurCarte.exporteInfo("reglet").equals("actif");
                    boolean zoomActif = traceurCarte.exporteInfo("zoom").equals("actif");
                    String unit = "";
                    double ech = 1.0;
                    if (regActif) {
                        unit = traceurCarte.exporteInfo("unite");
                        ech = Double.parseDouble(traceurCarte.exporteInfo("echelle"));
                    }
                    this.visualisation.chargerCarte(cheminCarte, ech, unit, regActif, zoomActif, this.modeEdition, traceurCarte.construitArrets(), Integer.parseInt(traceurCarte.exporteInfo("latitude")), Integer.parseInt(traceurCarte.exporteInfo("longitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLatitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLongitude")), traceurCarte.exporteVues());
                    this.activation(true);
                    this.majAffichage();
                    this.traceurTraces.ajouterTraces("menu", "chargerSession");
                } else {
                    JOptionPane.showMessageDialog(new JFrame(), "Lors du chargement de la carte !", "ERREUR !", 2, null);
                }
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "Impossible d'ouvrir cette donn\u00e9e !", "ERREUR !", 2, null);
            }
        } else {
            this.rapportTrace("menu", "chargement session", "annulation");
        }
    }

    private void confirmation() {
        int saveOrNot;
        if (!this.sauv\u00e9) {
            int saveOrNot2 = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre session?", "Confirmation", 0, 2, null);
            if (saveOrNot2 == 0) {
                this.enregistrerSession();
            }
        } else if (this.carteModifi\u00e9e) {
            int saveOrNot3 = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre carte ?", "Confirmation", 0, 2, null);
            if (saveOrNot3 == 0) {
                this.enregistrerEditionCarte();
            }
        } else if (this.docsModifi\u00e9 && (saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre donn\u00e9e ?", "Confirmation", 0, 2, null)) == 0) {
            this.enregistrerEditionDonnee();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copier(File source, File destination) {
        block15: {
            resultat = false;
            sourceFile = null;
            destinationFile = null;
            try {
                try {
                    destination.createNewFile();
                    sourceFile = new FileInputStream(source);
                    destinationFile = new FileOutputStream(destination);
                    buffer = new byte[524288];
                    while (true) {
                        if ((nbLecture = sourceFile.read(buffer)) == -1) {
                            resultat = true;
                        }
                        destinationFile.write(buffer, 0, nbLecture);
                    }
                }
                catch (FileNotFoundException var6_7) {
                }
                catch (IOException var6_8) {}
            }
            catch (Throwable var9_10) {
                var8_11 = null;
                try {
                    sourceFile.close();
                }
                catch (Exception var10_13) {
                    // empty catch block
                }
                try {
                    destinationFile.close();
                    throw var9_10;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw var9_10;
            }
            {
                var8_12 = null;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 92->100)] { 
lbl38:
            // 1 sources

            sourceFile.close();
            break block15;
lbl40:
            // 1 sources

            catch (Exception var10_14) {
                // empty catch block
            }
        }
        try {}
        catch (Exception e) {
            return resultat;
        }
        destinationFile.close();
        return resultat;
    }

    public void enConstruction() {
        String[] tab = new String[10];
        tab[0] = "Section en cours de developpement.";
        tab[1] = "Same player shoot again ! 8|";
        tab[2] = "Ca va pas \u00eatre possible l\u00e0 ... j'ai piscine :)";
        tab[3] = "Nan, j'veux p\u00f4 ! :(";
        tab[4] = "Section \u00e0 p\u00e9age :)";
        int j = 5;
        while (j < 10) {
            tab[j] = tab[0];
            ++j;
        }
        int i = (int)(Math.random() * 10.0);
        JOptionPane.showMessageDialog(new JFrame(), tab[i], "ATTENTION !", 2);
    }

    private void enregistrerEdition() {
        if (this.carteModifi\u00e9e) {
            this.rapportTrace("menu", "enregistrer edition", "carte");
            this.enregistrerEditionCarte();
        } else if (this.docsModifi\u00e9) {
            if (this.texteEnEdition) {
                this.rapportTrace("menu", "enregistrer edition", "texte");
                this.enregistrerEditionTexte();
            } else {
                this.rapportTrace("menu", "enregistrer edition", "donnee");
                this.enregistrerEditionDonnee();
            }
        }
    }

    private void enregistrerEditionTexte() {
        boolean res1 = this.traceurDonneeEdition.enregistrer();
        boolean res2 = this.carnet.enregistrer();
        if (res1 && res2) {
            this.docsModifi\u00e9 = false;
            JOptionPane.showMessageDialog(new JFrame(), "Le texte a \u00e9t\u00e9 enregistr\u00e9 avec succ\u00e8s !", "Information", 1);
            this.majAffichage();
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Echec lors de l'enregistrement !", "Erreur", 2);
        }
    }

    public void enregistrerEditionCarte() {
        boolean res = this.traceurCarteEdition.enregistrer();
        if (res) {
            this.carteModifi\u00e9e = false;
            JOptionPane.showMessageDialog(new JFrame(), "La carte a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", "Information", 1);
            this.majAffichage();
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Echec lors de l'enregistrement !", "Erreur", 2);
        }
    }

    public void enregistrerEditionDonnee() {
        boolean res = this.traceurDonneeEdition.enregistrer();
        if (res) {
            this.docsModifi\u00e9 = false;
            JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", "Information", 1);
            this.majAffichage();
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Echec lors de l'enregistrement !", "Erreur", 2);
        }
    }

    private void enregistrerSession() {
        this.rapportTrace("menu", "enregistrer session");
        boolean res1 = this.carnet.enregistrer();
        boolean res2 = this.traceurSession.enregistrer();
        this.traceurTraces.ajouterTraces("menu", "enregistrer");
        if (res1 && res2) {
            this.sauv\u00e9 = true;
            JOptionPane.showMessageDialog(new JFrame(), "La session a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", "Information", 1);
            this.majAffichage();
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Echec lors de l'enregistrement !", "Erreur", 2);
        }
    }

    public boolean getAAA() {
        return this.affichageArretsActif;
    }

    public boolean getACA() {
        return this.affichageCoordActif;
    }

    public void insertDepuis(String provenance) {
        ImageIcon im = null;
        ImageIcon carte = null;
        Texte texte = null;
        if (provenance.equals("docs")) {
            im = this.docs.exporteImage();
            carte = this.docs.exporteCarte();
            texte = this.docs.exporteTexte();
        } else if (provenance.equals("visualisation")) {
            im = this.visualisation.exporteImage();
            carte = this.visualisation.exporteCarte();
            texte = this.visualisation.exporteTexte();
        }
        if (im != null) {
            JOptionPane.showMessageDialog(new JFrame(), "Ne fonctionne pas encore avec les images.", "ATTENTION !", 2);
        } else if (carte != null) {
            JOptionPane.showMessageDialog(new JFrame(), "Ne fonctionne pas encore avec les cartes.", "ATTENTION !", 2);
        } else if (texte != null) {
            texte.selectAll();
            texte.copy();
            this.carnet.coller();
        }
        this.modifEffectuee(true);
    }

    public boolean isModeSuppArret() {
        return this.modeSuppArret;
    }

    public boolean isModeSuppLien() {
        return this.modeSuppLien;
    }

    public boolean isModeSuppVue() {
        return this.modeSuppVue;
    }

    private void lancementCalendrier() {
        this.rapportTrace("menu", "calendrier");
        this.enConstruction();
    }

    private void majAffichage() {
        if (this.modeEdition) {
            this.docs.desactiver();
        }
        boolean tempDocs = this.docs.isVisible();
        boolean tempVisu = this.visualisation.isVisible();
        boolean tempHisto = this.historique.isVisible();
        boolean tempCarnet = this.carnet.isVisible();
        this.historique.setVisible(this.historiqueCB.isSelected() && !this.modeEdition);
        this.visualisation.setVisible(this.visualisationCB.isSelected());
        this.docs.setVisible(this.docs.rapportActivit\u00e9() && this.docsCB.isSelected() && !this.modeEdition);
        this.carnet.setVisible(this.carnetCB.isSelected() && !this.modeEdition);
        if (!(this.docs.isVisible() || this.historique.isVisible() || this.visualisation.isVisible() || this.carnet.isVisible())) {
            this.docs.setVisible(tempDocs);
            this.docsCB.setSelected(tempDocs);
            this.historique.setVisible(tempHisto);
            this.historiqueCB.setSelected(tempHisto);
            this.carnet.setVisible(tempCarnet);
            this.carnetCB.setSelected(tempCarnet);
            this.visualisation.setVisible(tempVisu);
            this.visualisationCB.setSelected(tempVisu);
        }
        if (!tempDocs && this.docs.isVisible()) {
            this.splitPane2.setDividerLocation(this.getWidth() * 3 / 8);
        }
        this.splitPane2.setVisible(this.visualisation.isVisible() || this.docs.isVisible());
        this.splitPane1.setVisible(this.historique.isVisible() || this.splitPane2.isVisible());
        if (this.visualisation.isVisible()) {
            this.affichageArretsActif = this.arretsCB.isSelected();
            this.affichageCoordActif = this.coordCB.isSelected();
        }
        this.arretsCB.setEnabled(this.visualisation.isVisible());
        if (!this.arretsCB.isEnabled()) {
            this.arretsCB.setSelected(false);
        }
        this.coordCB.setEnabled(this.visualisation.isVisible());
        if (!this.coordCB.isEnabled()) {
            this.coordCB.setSelected(false);
        }
        this.nouvSessionM.setEnabled(!this.modeEdition);
        this.chargSessionM.setEnabled(!this.modeEdition);
        this.enregM.setEnabled(!this.sauv\u00e9 && !this.modeEdition && this.fenetreActive);
        this.docsCB.setEnabled(this.docs.rapportActivit\u00e9());
        if (!this.docs.rapportActivit\u00e9()) {
            this.docsCB.setSelected(false);
        }
        this.affichageM.setEnabled(!this.modeEdition && this.fenetreActive);
        this.docsM.setEnabled(!this.modeEdition && this.fenetreActive);
        this.rechercheM.setEnabled(this.fenetreActive);
        this.edActiverM.setEnabled(!this.modeEdition);
        this.edDesactiverM.setEnabled(this.modeEdition);
        this.nouvM.setEnabled(this.modeEdition);
        this.nouvVueM.setEnabled(this.carteEnEdition);
        this.modifM.setEnabled(this.modeEdition);
        this.suppM.setEnabled(this.modeEdition);
        this.parametresEditM.setEnabled(this.modeEdition && (this.carteEnEdition || this.texteEnEdition || this.imageEnEdition));
        this.suppArretM.setEnabled(this.carteEnEdition);
        this.suppLienM.setEnabled(this.carteEnEdition);
        this.suppVueM.setEnabled(this.carteEnEdition);
        this.enregEditM.setEnabled(this.carteModifi\u00e9e || this.docsModifi\u00e9);
        if (this.modeEdition) {
            this.setTitle(" G\u00e9onote 0.10a  ~  MODE EDITION  /!\\");
            if (this.texteEnEdition) {
                this.carnet.setVisible(true);
                this.splitPane1.setVisible(false);
            } else {
                this.affichageCoordActif = true;
                String typeActif = this.visualisation.exporteTypeActif();
                this.affichageArretsActif = typeActif.equals("carte");
            }
        } else {
            this.setTitle(" G\u00e9onote 0.10a");
        }
        this.repaintSplit();
        this.validate();
        this.repaint();
    }

    public void modifAnnotation(String elt, String texte) {
        this.traceurSession.modifierAnnotation(elt, texte);
        this.sauv\u00e9 = false;
        this.majAffichage();
    }

    public void activerModeDefCoord() {
        this.visualisation.activerModeDefCoord();
    }

    public void suppAnnotation(String elt) {
        this.traceurSession.supprimerAnnotation(elt);
        this.sauv\u00e9 = false;
        this.majAffichage();
    }

    private void modifCarte() {
        JFileChooser chooser = new JFileChooser(this.espaceCartes);
        chooser.setDialogTitle("Choix de la carte \u00e0 modifier");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "modification (edition)", "carte", fich);
            String ext = fich.substring(fich.lastIndexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            this.traceurCarteEdition = new TraceurCarte();
            boolean res = this.traceurCarteEdition.charger(fichXML);
            if (!res) {
                JOptionPane.showMessageDialog(new JFrame(), "La carte que vous avez voulu ouvrir ne poss\u00e8de pas de m\u00e9tadonn\u00e9es !", "ERREUR !", 2);
            } else {
                this.visualisation.chargerCarte(fich, 1.0, "", true, true, this.modeEdition, this.traceurCarteEdition.construitArrets(), Integer.parseInt(this.traceurCarteEdition.exporteInfo("latitude")), Integer.parseInt(this.traceurCarteEdition.exporteInfo("longitude")), Double.parseDouble(this.traceurCarteEdition.exporteInfo("echelleLatitude")), Double.parseDouble(this.traceurCarteEdition.exporteInfo("echelleLongitude")), this.traceurCarteEdition.exporteVues());
                boolean regActif = this.traceurCarteEdition.exporteInfo("reglet").equals("actif");
                boolean zoomActif = this.traceurCarteEdition.exporteInfo("zoom").equals("actif");
                String nivo = this.traceurCarteEdition.exporteInfo("niveau");
                String motscles = this.traceurCarteEdition.exporteInfo("motscles");
                String typeVue = this.traceurCarteEdition.exporteTypeVuePrincipale();
                this.fpec = new FenetreParametresEditionCarte(this, chooser.getSelectedFile().getName());
                this.fpec.chargerParam(typeVue, regActif, zoomActif, nivo, motscles);
                this.fpei = null;
                this.fpet = null;
                this.carteModifi\u00e9e = true;
                this.carteEnEdition = true;
                this.texteEnEdition = false;
                this.imageEnEdition = false;
                this.docsModifi\u00e9 = false;
                this.majAffichage();
            }
        }
    }

    private void modifDonnee() {
        JFileChooser chooser = new JFileChooser(this.espaceDonnees);
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 modifier");
        FiltreExtensible filtre = new FiltreExtensible("Donnees");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".rtf");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "modification (edition)", "donnee", fich);
            String ext = fich.substring(fich.lastIndexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            this.traceurDonneeEdition = new TraceurDonnee();
            boolean res = this.traceurDonneeEdition.charger(fichXML);
            if (!res) {
                JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu ouvrir ne poss\u00e8de pas de m\u00e9tadonn\u00e9es !", "ERREUR !", 2);
            } else {
                String type = this.traceurDonneeEdition.exporteType();
                if (type.equals("texte")) {
                    this.visualisation.chargerTexte(fich);
                    String nivo = this.traceurDonneeEdition.exporteInfo("niveau");
                    String motscles = this.traceurDonneeEdition.exporteInfo("motscles");
                    String commentaire = this.traceurDonneeEdition.exporteInfo("commentaire");
                    String typGeol = this.traceurDonneeEdition.exporteInfo("typeGeologique");
                    this.fpet = new FenetreParametresEditionTexte(this);
                    this.fpet.chargerParam(typGeol, nivo, commentaire, motscles);
                    this.fpei = null;
                    this.fpec = null;
                    this.texteEnEdition = true;
                    this.imageEnEdition = false;
                } else if (type.equals("image")) {
                    this.visualisation.chargerImage(fich, 1.0, "", true, true, this.modeEdition);
                    boolean regActif = this.traceurDonneeEdition.exporteInfo("reglet").equals("actif");
                    boolean zoomActif = this.traceurDonneeEdition.exporteInfo("zoom").equals("actif");
                    String nivo = this.traceurDonneeEdition.exporteInfo("niveau");
                    String motscles = this.traceurDonneeEdition.exporteInfo("motscles");
                    String commentaire = this.traceurDonneeEdition.exporteInfo("commentaire");
                    String typGeol = this.traceurDonneeEdition.exporteInfo("typeGeologique");
                    this.fpei = new FenetreParametresEditionImage(this);
                    this.fpei.chargerParam(typGeol, regActif, zoomActif, nivo, commentaire, motscles);
                    this.fpec = null;
                    this.fpet = null;
                    this.texteEnEdition = false;
                    this.imageEnEdition = true;
                }
                this.docsModifi\u00e9 = true;
                this.carteEnEdition = false;
                this.carteModifi\u00e9e = false;
                this.majAffichage();
            }
        }
    }

    private void modifEffectuee(boolean b) {
        boolean temp = this.sauv\u00e9;
        boolean bl = this.sauv\u00e9 = !b;
        if (temp != this.sauv\u00e9) {
            this.majAffichage();
        }
    }

    public void modifTexteEffectuee(boolean b) {
        if (this.texteEnEdition) {
            boolean temp = this.docsModifi\u00e9;
            this.docsModifi\u00e9 = b;
            if (temp != this.docsModifi\u00e9) {
                this.majAffichage();
            }
        } else {
            boolean temp = this.sauv\u00e9;
            boolean bl = this.sauv\u00e9 = !b;
            if (temp != this.sauv\u00e9) {
                this.majAffichage();
            }
        }
    }

    private boolean motDePasseEditionCorrect(char[] saisie) {
        String mot = "geonote";
        char[] mdp = new char[mot.length()];
        mdp = mot.toCharArray();
        boolean retour = true;
        int i = 0;
        while (i < mdp.length && i < saisie.length && retour) {
            retour = saisie[i] == mdp[i];
            ++i;
        }
        if (saisie.length == 0) {
            retour = false;
        }
        return retour;
    }

    private boolean motDePasseParamCorrect(char[] saisie) {
        String mot = "titi";
        char[] mdp = new char[mot.length()];
        mdp = mot.toCharArray();
        boolean retour = true;
        int i = 0;
        while (i < mdp.length && i < saisie.length && retour) {
            retour = saisie[i] == mdp[i];
            ++i;
        }
        return retour;
    }

    private void nouvCarte() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la carte principale \u00e0 editer");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "creation (edition)", "carte", fich);
            String fichDest = String.valueOf(this.espaceCartes) + chooser.getSelectedFile().getName();
            if (!fich.contains(fichDest)) {
                this.copier(chooser.getSelectedFile(), new File(fichDest));
            }
            String ext = fichDest.substring(fichDest.lastIndexOf("."));
            String fichXML = fichDest.replace(ext, ".xml");
            this.traceurCarteEdition = new TraceurCarte(fichXML, "carte");
            this.visualisation.chargerCarte(fichDest, 1.0, "", true, true, this.modeEdition, null, 0, 0, 1.0, 1.0, new ArrayList());
            this.fpec = new FenetreParametresEditionCarte(this, chooser.getSelectedFile().getName());
            this.fpei = null;
            this.fpet = null;
            this.carteModifi\u00e9e = true;
            this.carteEnEdition = true;
            this.texteEnEdition = false;
            this.imageEnEdition = false;
            this.docsModifi\u00e9 = false;
            this.majAffichage();
        }
    }

    public void enregParamCarteEditee(String fichier, String typeVue, boolean reglet, boolean zoom, String nivo, String motsCl\u00e9s) {
        this.traceurCarteEdition.ajouteVue(typeVue, fichier);
        this.visualisation.rechargeTypBarre(this.traceurCarteEdition.exporteVues(), this.espaceCartes);
        if (reglet) {
            this.traceurCarteEdition.ajouterElt("reglet", "actif");
            this.visualisation.activeReglet(true);
        } else {
            this.traceurCarteEdition.ajouterElt("reglet", "inactif");
            this.visualisation.activeReglet(false);
        }
        if (zoom) {
            this.traceurCarteEdition.ajouterElt("zoom", "actif");
        } else {
            this.traceurCarteEdition.ajouterElt("zoom", "inactif");
        }
        this.traceurCarteEdition.ajouterElt("niveau", nivo);
        this.traceurCarteEdition.ajouterElt("motscles", motsCl\u00e9s);
    }

    private void nouvDonnee() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 \u00e9diter");
        FiltreExtensible filtre = new FiltreExtensible("Donnees");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".rtf");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "creation (edition)", "donnee", fich);
            String fichDest = String.valueOf(this.espaceDocs) + chooser.getSelectedFile().getName();
            if (!fich.contains(fichDest)) {
                this.copier(chooser.getSelectedFile(), new File(fichDest));
            }
            String ext = fichDest.substring(fichDest.lastIndexOf("."));
            String fichXML = fichDest.replace(ext, ".xml");
            if (ext.equals(".rtf")) {
                this.traceurDonneeEdition = new TraceurDonnee(fichXML, "texte");
                this.carnet.charger(fichDest);
                this.texteEnEdition = true;
                this.imageEnEdition = false;
                this.fpet = new FenetreParametresEditionTexte(this);
                this.fpei = null;
                this.fpec = null;
            } else {
                this.traceurDonneeEdition = new TraceurDonnee(fichXML, "image");
                this.visualisation.chargerImage(fichDest, 1.0, "", true, true, this.modeEdition);
                this.texteEnEdition = false;
                this.imageEnEdition = true;
                this.fpei = new FenetreParametresEditionImage(this);
                this.fpec = null;
                this.fpet = null;
            }
            this.docsModifi\u00e9 = true;
            this.carteEnEdition = false;
            this.carteModifi\u00e9e = false;
            this.majAffichage();
        }
    }

    public void enregParamTexteEditee(String typeGeol, String nivo, String commentaire, String motsCl\u00e9s) {
        this.traceurDonneeEdition.ajouterElt("typeGeologique", typeGeol);
        this.traceurDonneeEdition.ajouterElt("niveau", nivo);
        this.traceurDonneeEdition.ajouterElt("commentaire", commentaire);
        this.traceurDonneeEdition.ajouterElt("motscles", motsCl\u00e9s);
        this.traceurDonneeEdition.ajouterElt("etat", "");
    }

    public void enregParamDonneeEditee(String typeGeol, boolean reglet, boolean zoom, String nivo, String commentaire, String motsCl\u00e9s) {
        this.traceurDonneeEdition.ajouterElt("typeGeologique", typeGeol);
        if (reglet) {
            this.traceurDonneeEdition.ajouterElt("reglet", "actif");
            this.visualisation.activeReglet(true);
        } else {
            this.traceurDonneeEdition.ajouterElt("reglet", "inactif");
            this.visualisation.activeReglet(false);
        }
        if (zoom) {
            this.traceurDonneeEdition.ajouterElt("zoom", "actif");
        } else {
            this.traceurDonneeEdition.ajouterElt("zoom", "inactif");
        }
        this.traceurDonneeEdition.ajouterElt("niveau", nivo);
        this.traceurDonneeEdition.ajouterElt("commentaire", commentaire);
        this.traceurDonneeEdition.ajouterElt("motscles", motsCl\u00e9s);
        this.traceurDonneeEdition.ajouterElt("etat", "");
    }

    private void nouvelleSession() {
        this.confirmation();
        this.userName = JOptionPane.showInputDialog(this, "Nom d'utilisateur :", "Nouvelle session", 1);
        if (this.userName != null && !this.userName.matches("") && !this.userName.contains(" ")) {
            this.rapportTrace("menu", "nouvelle session", "utilisateur : " + this.userName);
            JFileChooser chooser = new JFileChooser(this.espaceCartes);
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle("Choix de la carte principale de la nouvelle session");
            FiltreExtensible filtre = new FiltreExtensible("Cartes");
            filtre.addExtension(".jpg");
            filtre.addExtension(".gif");
            filtre.addExtension(".png");
            chooser.addChoosableFileFilter(filtre);
            chooser.setAccessory(new ImagePreview(chooser));
            int returnVal = chooser.showOpenDialog(chooser.getParent());
            if (returnVal == 0) {
                this.docs.desactiver();
                String fich = chooser.getSelectedFile().getName();
                String extension = fich.substring(chooser.getSelectedFile().getName().lastIndexOf("."));
                if (this.extensionsCartes.contains(extension)) {
                    TraceurCarte tr = new TraceurCarte();
                    String fichXml = chooser.getSelectedFile().getPath().replace(extension, ".xml");
                    boolean result = tr.charger(fichXml);
                    if (result) {
                        String type = tr.exporteType();
                        if (type.matches("carte")) {
                            String ech = tr.exporteInfo("echelle");
                            boolean regActif = tr.exporteInfo("reglet").matches("actif");
                            boolean zoomActif = tr.exporteInfo("zoom").matches("actif");
                            String unit = "";
                            if (regActif) {
                                unit = tr.exporteInfo("unite");
                            }
                            this.visualisation.chargerCarte(chooser.getSelectedFile().getPath(), Double.parseDouble(ech), unit, regActif, zoomActif, this.modeEdition, tr.construitArrets(), Integer.parseInt(tr.exporteInfo("latitude")), Integer.parseInt(tr.exporteInfo("longitude")), Double.parseDouble(tr.exporteInfo("echelleLatitude")), Double.parseDouble(tr.exporteInfo("echelleLongitude")), tr.exporteVues());
                            Date date = new Date();
                            String[] dateTab = this.traduireDate(date).split(" ");
                            String[] heureTab = dateTab[3].split(":");
                            String heure = dateTab[3].replaceFirst(":", "h");
                            heure = heure.replaceFirst(":", "m");
                            String nomCarte = fich.replace(extension, "");
                            this.nomFichierSession = String.valueOf(this.userName) + "_" + dateTab[2] + "-" + dateTab[1] + "-" + dateTab[5] + "_" + heure + "_" + nomCarte + ".xml";
                            String nomFichierRTF = this.nomFichierSession.replace(".xml", ".rtf");
                            this.carnet.creer(String.valueOf(this.espaceCarnet) + nomFichierRTF);
                            this.historique.creerArbre(this.userName);
                            this.historique.ajouterDateSession(dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                            this.historique.ajouterVue(String.valueOf(fich) + " (le " + dateTab[2] + "/" + dateTab[1] + "/" + dateTab[5] + " \u00e0 " + heureTab[0] + ":" + heureTab[1] + ":" + heureTab[2] + ")");
                            this.traceurSession = new TraceurSession(String.valueOf(this.espaceSessions) + "\\" + this.nomFichierSession, "session");
                            this.traceurSession.ajouterElt("nom", this.userName);
                            this.traceurSession.ajouteVue(fich, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                            this.traceurSession.ajouterDate(dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                            this.traceurSession.ajouteCarnet(nomFichierRTF);
                            this.activation(true);
                            this.modifEffectuee(true);
                            this.traceurTraces.ajouterTraces("menu", "nouvelleSession");
                            this.traceurTraces.ajouterNomSession("nouvelleSession", this.userName);
                        } else {
                            System.out.println("PAS carte !");
                            JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e que vous avez voulu charger n'est pas une carte !", "ERREUR !", 2, null);
                        }
                    } else {
                        JOptionPane.showMessageDialog(new JFrame(), "Impossible d'ouvrir cette donn\u00e9e !", "ERREUR !", 2, null);
                    }
                } else {
                    JOptionPane.showMessageDialog(new JFrame(), "Le type de fichier que vous voulez charger n'est pas support\u00e9 !", "ERREUR !", 2, null);
                }
            }
        } else {
            this.rapportTrace("menu", "nouvelle session", "annulation");
        }
    }

    private void nouvVue() {
        JFileChooser chooser = new JFileChooser(this.espaceDonnees);
        chooser.setDialogTitle("Choix de la vue \u00e0 ajouter");
        FiltreExtensible filtre = new FiltreExtensible("Donn\u00e9es");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".png");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "creation (edition)", "vue", fich);
            String fichDest = String.valueOf(this.espaceCartes) + chooser.getSelectedFile().getName();
            String type = JOptionPane.showInputDialog(new JFrame(), "Quel est le type de cette vue (satellite, topographique, ...) ?\n(\u00e9vitez les accents)", "Parametrage (1/1)", 3);
            if (type != null && !type.matches("")) {
                this.traceurCarteEdition.ajouteVue(type, chooser.getSelectedFile().getName());
                this.visualisation.rechargeTypBarre(this.traceurCarteEdition.exporteVues(), this.espaceCartes);
                if (!fich.contains(fichDest)) {
                    this.copier(chooser.getSelectedFile(), new File(fichDest));
                }
                this.carteModifi\u00e9e = true;
            }
        }
    }

    private void quitter() {
        this.confirmation();
        this.rapportTrace("menu", "quitter");
        if (this.tracesActives) {
            this.traceurTraces.enregistrer();
        }
        this.dispose();
        System.exit(0);
    }

    public void rapportTrace(String entit\u00e9, String action) {
        this.traceurTraces.ajouterTraces(entit\u00e9, action);
    }

    public void rapportTrace(String entit\u00e9, String action, String param1) {
        this.traceurTraces.ajouterTraces(entit\u00e9, action, param1);
    }

    public void rapportTrace(String entit\u00e9, String action, String param1, String param2) {
        this.traceurTraces.ajouterTraces(entit\u00e9, action, param1, param2);
    }

    private void repaintSplit() {
        if (this.splitPane1.getDividerLocation() <= this.splitPane1.getMinimumDividerLocation() || this.splitPane1.getDividerLocation() >= this.splitPane1.getMaximumDividerLocation()) {
            this.splitPane1.setDividerLocation(this.getWidth() / 4);
        }
        if (this.splitPane2.getDividerLocation() <= this.splitPane2.getMinimumDividerLocation() || this.splitPane2.getDividerLocation() >= this.splitPane2.getMaximumDividerLocation()) {
            this.splitPane2.setDividerLocation(this.getWidth() * 3 / 8);
        }
        if (this.splitPanePrincipal.getDividerLocation() <= this.splitPanePrincipal.getMinimumDividerLocation() || this.splitPanePrincipal.getDividerLocation() >= this.splitPanePrincipal.getMaximumDividerLocation()) {
            this.splitPanePrincipal.setDividerLocation(this.getHeight() * 3 / 4);
        }
    }

    private ArrayList listeRepertoire(File repertoire) {
        ArrayList<String> liste = new ArrayList<String>();
        if (repertoire.isDirectory()) {
            File[] list = repertoire.listFiles();
            int i = 0;
            while (i < list.length) {
                liste.addAll(this.listeRepertoire(list[i]));
                ++i;
            }
        } else if (repertoire.getAbsolutePath().contains(".") && !repertoire.getAbsolutePath().contains(".xml")) {
            liste.add(repertoire.getAbsolutePath());
        }
        return liste;
    }

    private void recherche() {
        String mot = JOptionPane.showInputDialog(new JFrame(), "Mot cl\u00e9 :", "Recherche", 3);
        if (mot != null && !mot.equals("")) {
            JFrame fenetre = new JFrame("R\u00e9sultats");
            fenetre.setLayout(new FlowLayout());
            Traceur traceur = new Traceur();
            ArrayList listeFichiers = this.listeRepertoire(new File(this.espaceDonnees));
            Iterator i = listeFichiers.iterator();
            while (i.hasNext()) {
                String extension;
                final String chemin = (String)i.next();
                final String cheminXML = chemin.replace(extension = chemin.substring(chemin.lastIndexOf(".")), ".xml");
                boolean retour = traceur.charger(cheminXML);
                if (!retour) continue;
                String mots = traceur.exporteInfo("motscles");
                final String type = traceur.exporteType();
                if (mots == null || !mots.contains(mot)) continue;
                String nomFichier = chemin.substring(chemin.lastIndexOf("\\") + 1, chemin.length());
                JButton bouton = new JButton(nomFichier);
                bouton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        System.out.println(type);
                        if (type.equals("carte")) {
                            TraceurCarte traceurCarte = new TraceurCarte();
                            traceurCarte.charger(cheminXML);
                            boolean regActif = traceurCarte.exporteInfo("reglet").equals("actif");
                            boolean zoomActif = traceurCarte.exporteInfo("zoom").equals("actif");
                            String unit = "";
                            double ech = 1.0;
                            if (regActif) {
                                unit = traceurCarte.exporteInfo("unite");
                                ech = Double.parseDouble(traceurCarte.exporteInfo("echelle"));
                            }
                            Interface.this.docs.chargerCarte(chemin, ech, unit, regActif, zoomActif, Interface.this.modeEdition, traceurCarte.construitArrets(), Integer.parseInt(traceurCarte.exporteInfo("latitude")), Integer.parseInt(traceurCarte.exporteInfo("longitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLatitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLongitude")), traceurCarte.exporteVues());
                        } else if (type.equals("image")) {
                            TraceurDonnee tr = new TraceurDonnee();
                            tr.charger(cheminXML);
                            boolean regActif = tr.exporteInfo("reglet").equals("actif");
                            boolean zoomActif = tr.exporteInfo("zoom").equals("actif");
                            String unit = "";
                            double ech = 1.0;
                            if (regActif) {
                                unit = tr.exporteInfo("unite");
                                ech = Double.parseDouble(tr.exporteInfo("echelle"));
                            }
                            Interface.this.docs.chargerImage(chemin, ech, unit, regActif, zoomActif, Interface.this.modeEdition);
                        } else {
                            Interface.this.docs.chargerTexte(chemin);
                        }
                        Interface.this.docsCB.setSelected(true);
                        Interface.this.majAffichage();
                    }
                });
                fenetre.add(bouton);
            }
            if (fenetre.getContentPane().getComponentCount() > 0) {
                int haut = fenetre.getContentPane().getComponent((int)0).getPreferredSize().height;
                int nbBoutons = fenetre.getContentPane().getComponentCount();
                fenetre.setSize(new Dimension(100, (haut + 5) * nbBoutons + 25));
                fenetre.setVisible(true);
                fenetre.setLocationRelativeTo(null);
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "Aucune donn\u00e9e ne correspond \u00e0 votre recherche.", "R\u00e9sultats", 1);
            }
        }
    }

    private void suppArret() {
        JOptionPane.showMessageDialog(new JFrame(), "Selectionnez l'arr\u00eat \u00e0 supprimer.", "Suppression", 1);
        this.modeSuppArret = true;
    }

    public void suppArretEffectue(int i) {
        this.traceurCarteEdition.suppArret(i);
        this.modeSuppArret = false;
    }

    private void suppCarte() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la carte \u00e0 supprimer");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "suppression (edition)", "carte", fich);
            String ext = fich.substring(fich.lastIndexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            boolean b1 = chooser.getSelectedFile().delete();
            File xml = new File(fichXML);
            boolean b2 = xml.delete();
            if (b1) {
                JOptionPane.showMessageDialog(new JFrame(), "La carte a \u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s !", "Information", 1);
            }
            if (b2) {
                JOptionPane.showMessageDialog(new JFrame(), "Les m\u00e9tadonn\u00e9es de la carte ont \u00e9t\u00e9 supprim\u00e9es avec succ\u00e8s !", "Information", 1);
            }
        }
        this.repaint();
    }

    private void suppDonnee() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 supprimer");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "suppression (edition)", "donnee", fich);
            String ext = fich.substring(fich.lastIndexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            boolean b1 = chooser.getSelectedFile().delete();
            File xml = new File(fichXML);
            boolean b2 = xml.delete();
            if (b1) {
                JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e a \u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s !", "Information", 1);
            }
            if (b2) {
                JOptionPane.showMessageDialog(new JFrame(), "Les m\u00e9tadonn\u00e9es de la donn\u00e9e ont \u00e9t\u00e9 supprim\u00e9es avec succ\u00e8s !", "Information", 1);
            }
        }
        this.repaint();
    }

    private void suppLien() {
        JOptionPane.showMessageDialog(new JFrame(), "Selectionnez le lien \u00e0 supprimer.", "Suppression", 1);
        this.modeSuppLien = true;
    }

    public void suppLienEffectue(int i, String lien) {
        this.traceurCarteEdition.suppLien(i, lien);
        this.modeSuppLien = false;
    }

    private void suppVue() {
        ArrayList list = this.traceurCarteEdition.exporteVues();
        if (list.size() > 1) {
            JOptionPane.showMessageDialog(new JFrame(), "Selectionnez la vue \u00e0 supprimer.", "Suppression", 1);
            this.modeSuppVue = true;
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Impossible de supprimer la seule vue restante !", "Suppression", 2);
        }
    }

    public void suppVueEffectue(String vue, String fich) {
        this.modeSuppVue = false;
        this.traceurCarteEdition.suppVue(vue, fich);
        this.visualisation.rechargeTypBarre(this.traceurCarteEdition.exporteVues(), this.espaceCartes);
    }

    private String traduireDate(Date date) {
        String temp = date.toString().replace("Jan", "01");
        temp = temp.replace("Feb", "02");
        temp = temp.replace("Mar", "03");
        temp = temp.replace("Apr", "04");
        temp = temp.replace("May", "05");
        temp = temp.replace("Jun", "06");
        temp = temp.replace("Jul", "07");
        temp = temp.replace("Aug", "08");
        temp = temp.replace("Sep", "09");
        temp = temp.replace("Oct", "10");
        temp = temp.replace("Nov", "11");
        temp = temp.replace("Dec", "12");
        return temp;
    }

    public static void main(String[] args) {
        new Interface();
    }
}

