/*
 * Decompiled with CFR 0.152.
 */
package geonoteTypesDonnees;

import geonoteInterface.Interface;
import geonoteOutils.Reglet;
import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class Images
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected String chemin = null;
    protected MonImageIcon image = null;
    protected double zoom = 1.0;
    protected double echelle = 1.0;
    protected Reglet reglet = null;
    protected boolean regletDispo = true;
    protected boolean zoomActif = true;
    protected Interface diplomate = null;
    protected String unit\u00e9 = "m";
    protected Cursor curseurDefaut = Cursor.getDefaultCursor();
    protected boolean regletActif = false;
    protected boolean modeEdition = false;
    protected boolean deplacement = false;
    private int ancienX;
    private int ancienY;
    private int ancienVX;
    private int ancienVY;

    public Images(String path, double ech, String unit, boolean regletDisp, boolean zoomDisp, boolean modeEd, Interface i) {
        this.image = new MonImageIcon(path);
        this.chemin = path;
        this.echelle = ech;
        this.unit\u00e9 = unit;
        this.regletDispo = regletDisp;
        this.zoomActif = zoomDisp;
        this.modeEdition = modeEd;
        this.diplomate = i;
        this.reglet = new Reglet(this.modeEdition);
        this.zoom = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        if (this.modeEdition) {
            this.curseurDefaut = Cursor.getPredefinedCursor(1);
        }
    }

    public String getChemin() {
        return this.chemin;
    }

    public void setUnit\u00e9(String u) {
        this.unit\u00e9 = u;
    }

    public void setEchelle(double e) {
        this.echelle = e;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double rapportH = (double)this.getParent().getHeight() / this.image.getIconHeight();
        double rapportL = (double)this.getParent().getWidth() / this.image.getIconWidth();
        double min = Math.min(rapportH, rapportL);
        if (this.zoom == 1.0) {
            this.zoom = min;
        }
        g2.scale(this.zoom, this.zoom);
        int largImage = (int)(this.image.getIconWidth() * this.zoom);
        int hautImage = (int)(this.image.getIconHeight() * this.zoom);
        Dimension dimension = null;
        dimension = largImage > this.getParent().getWidth() && hautImage > this.getParent().getHeight() ? new Dimension(largImage, hautImage) : (largImage > this.getParent().getWidth() ? new Dimension(largImage, this.getParent().getHeight()) : (hautImage > this.getParent().getHeight() ? new Dimension(this.getParent().getWidth(), hautImage) : new Dimension(this.getParent().getSize())));
        if (this.getSize() != dimension) {
            this.setPreferredSize(dimension);
            this.setSize(dimension);
        }
        int decalHaut = 0;
        int decalLarg = 0;
        g2.drawImage(this.image.getImage(), decalLarg, decalHaut, this);
        if (this.regletDispo && this.regletActif) {
            this.reglet.draw(g2, this.zoom, this.echelle, this.unit\u00e9, decalLarg, decalHaut);
        }
        g2.dispose();
    }

    public ImageIcon getImage() {
        return this.image.getIi();
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
        if (this.regletDispo) {
            if (this.modeEdition && arg0.getButton() == 3 && this.reglet.getLongueur() > 0.0) {
                this.diplomate.ajouteEchelle(this.reglet.getLongueur(), "image");
            }
            this.regletActif = false;
            this.setCursor(this.curseurDefaut);
            this.diplomate.rapportTrace("reglet", "fin");
            this.repaint();
        }
        this.deplacement = false;
        this.diplomate.rapportTrace("image", "deplacement", "fin");
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
        if (arg0.getButton() == 3) {
            if (this.regletDispo) {
                if (this.modeEdition) {
                    this.regletActif = true;
                    this.reglet.setModeEcriture(true);
                    this.setCursor(Cursor.getPredefinedCursor(1));
                    this.reglet.setDepart((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
                    this.reglet.setArriv\u00e9e((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
                    this.diplomate.rapportTrace("reglet", "depart", "edition");
                } else {
                    JScrollPane scroll = (JScrollPane)((JViewport)this.getParent()).getParent();
                    this.ancienX = arg0.getX();
                    this.ancienY = arg0.getY();
                    this.ancienVX = scroll.getHorizontalScrollBar().getValue();
                    this.ancienVY = scroll.getVerticalScrollBar().getValue();
                    this.deplacement = true;
                    this.diplomate.rapportTrace("image", "deplacement");
                }
            }
        } else if (arg0.getButton() == 1 && this.regletDispo) {
            this.regletActif = true;
            this.reglet.setModeEcriture(false);
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.reglet.setDepart((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
            this.reglet.setArriv\u00e9e((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
            this.diplomate.rapportTrace("reglet", "depart");
        }
    }

    public void mouseDragged(MouseEvent arg0) {
        if (this.deplacement) {
            this.setCursor(Cursor.getPredefinedCursor(13));
            JScrollPane scroll = (JScrollPane)((JViewport)this.getParent()).getParent();
            int diffX = (int)((double)(arg0.getX() - this.ancienX) * 0.8);
            int diffY = (int)((double)(arg0.getY() - this.ancienY) * 0.8);
            scroll.getVerticalScrollBar().setValue(this.ancienVY + diffY);
            scroll.getHorizontalScrollBar().setValue(this.ancienVX + diffX);
            this.ancienX = arg0.getX();
            this.ancienY = arg0.getY();
            this.ancienVX = scroll.getHorizontalScrollBar().getValue();
            this.ancienVY = scroll.getVerticalScrollBar().getValue();
        }
        if (this.regletDispo) {
            this.reglet.setArriv\u00e9e((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent arg0) {
    }

    public void mouseWheelMoved(MouseWheelEvent arg0) {
        if (this.zoomActif) {
            JScrollPane scroll = (JScrollPane)((JViewport)this.getParent()).getParent();
            int larg = arg0.getX() - scroll.getHorizontalScrollBar().getValue();
            int haut = arg0.getY() - scroll.getVerticalScrollBar().getValue();
            int x = (int)((double)arg0.getX() / this.zoom);
            int y = (int)((double)arg0.getY() / this.zoom);
            double facteurTemp = this.zoom - (double)arg0.getWheelRotation() * 0.05;
            this.zoom = facteurTemp > 0.1 && facteurTemp < 4.0 ? facteurTemp : (arg0.getWheelRotation() > 0 ? 0.1 : 4.0);
            int absX = (int)((double)x * this.zoom);
            int absY = (int)((double)y * this.zoom);
            scroll.getHorizontalScrollBar().setValue(absX - larg);
            scroll.getVerticalScrollBar().setValue(absY - haut);
        }
        if (this.regletDispo) {
            this.reglet.setArriv\u00e9e((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
        }
        this.repaint();
    }

    public void setRegletDispo(boolean b) {
        this.regletDispo = b;
    }

    public String getUnit\u00e9() {
        return this.unit\u00e9;
    }

    protected class MonImageIcon
    extends JPanel {
        private float transparency = 1.0f;
        private ImageIcon ii = null;

        public MonImageIcon(String path) {
            this.ii = new ImageIcon(path);
        }

        public double getIconHeight() {
            return this.ii.getIconHeight();
        }

        public double getIconWidth() {
            return this.ii.getIconWidth();
        }

        public Image getImage() {
            return this.ii.getImage();
        }

        public ImageIcon getIi() {
            return this.ii;
        }

        public void setTransparency(float aTransparency) {
            this.transparency = aTransparency;
            if (this.transparency < 0.0f) {
                this.transparency = 0.0f;
            }
            if (this.transparency > 1.0f) {
                this.transparency = 1.0f;
            }
        }

        public float getTransparency() {
            return this.transparency;
        }

        public void paint(Graphics2D g) {
            g.setComposite(AlphaComposite.getInstance(3, this.transparency));
            g.drawImage(this.ii.getImage(), new AffineTransform(), null);
        }
    }
}

