/*
 * Decompiled with CFR 0.152.
 */
package geonoteZones;

import geonoteInterface.Interface;
import geonoteTypesDonnees.Texte;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.StyledEditorKit;

public class Carnet
extends JPanel
implements KeyListener {
    private JMenuBar barre = null;
    private JScrollPane conteneur = null;
    private Interface diplomate = null;
    private String newline = "\n";
    private Texte texte;

    public Carnet(Interface i) {
        this.diplomate = i;
        this.setLayout(new BorderLayout());
        JMenu editMenu = this.createEditMenu();
        JMenu styleMenu = this.createStyleMenu();
        this.barre = new JMenuBar();
        this.barre.add(editMenu);
        this.barre.add(styleMenu);
    }

    public boolean charger(String chemin) {
        this.nouveauTexte();
        boolean res = this.texte.charger(chemin);
        this.validate();
        this.repaint();
        return res;
    }

    protected JMenu createEditMenu() {
        JMenu menu = new JMenu("Edition");
        JMenuItem item = new JMenuItem("Copier");
        item.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Carnet.this.texte.copy();
            }
        });
        menu.add(item);
        item = new JMenuItem("Couper");
        item.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Carnet.this.texte.cut();
            }
        });
        menu.add(item);
        item = new JMenuItem("Coller");
        item.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Carnet.this.texte.paste();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Inserer depuis la zone de visualisation");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Carnet.this.diplomate.insertDepuis("visualisation");
            }
        });
        menu.add(item);
        item = new JMenuItem("Inserer depuis la zone de documents");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Carnet.this.diplomate.insertDepuis("docs");
            }
        });
        menu.add(item);
        return menu;
    }

    protected JMenu createStyleMenu() {
        JMenu menu = new JMenu("Style");
        StyledEditorKit.StyledTextAction action = new StyledEditorKit.BoldAction();
        action.putValue("Name", "Gras");
        menu.add(action);
        action = new StyledEditorKit.ItalicAction();
        action.putValue("Name", "Italique");
        menu.add(action);
        action = new StyledEditorKit.UnderlineAction();
        action.putValue("Name", "Soulign\u00e9");
        menu.add(action);
        menu.addSeparator();
        menu.add(new StyledEditorKit.FontSizeAction("12", 12));
        menu.add(new StyledEditorKit.FontSizeAction("14", 14));
        menu.add(new StyledEditorKit.FontSizeAction("18", 18));
        menu.addSeparator();
        menu.add(new StyledEditorKit.FontFamilyAction("Serif", "Serif"));
        menu.add(new StyledEditorKit.FontFamilyAction("SansSerif", "SansSerif"));
        menu.addSeparator();
        menu.add(new StyledEditorKit.ForegroundAction("Rouge", Color.red));
        menu.add(new StyledEditorKit.ForegroundAction("Vert", Color.green));
        menu.add(new StyledEditorKit.ForegroundAction("Bleu", Color.blue));
        menu.add(new StyledEditorKit.ForegroundAction("Noir", Color.black));
        return menu;
    }

    public void creer(String path) {
        this.nouveauTexte();
        this.texte.setPath(path);
        this.texte.enregistrer();
    }

    public boolean enregistrer() {
        return this.texte.enregistrer();
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
        this.diplomate.modifTexteEffectuee(true);
    }

    public void copierImage(ImageIcon im) {
        this.texte.insertIcon(im);
    }

    public void coller() {
        this.texte.paste();
    }

    private void nouveauTexte() {
        if (this.texte == null) {
            this.add((Component)this.barre, "North");
        }
        if (this.conteneur != null) {
            if (this.texte != null) {
                this.conteneur.remove(this.texte);
            }
            this.remove(this.conteneur);
        }
        this.texte = new Texte();
        this.texte.addKeyListener(this);
        this.conteneur = new JScrollPane(this.texte);
        this.conteneur.setPreferredSize(new Dimension(200, 200));
        this.conteneur.setBorder(null);
        this.add((Component)this.conteneur, "Center");
    }

    public void reset() {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        if (this.barre != null) {
            this.remove(this.barre);
        }
        this.texte = null;
    }
}

