/*
 * Decompiled with CFR 0.152.
 */
package geonoteInterface;

import geonoteTypesDonnees.Carte;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FenetreCalibrageCoord
extends JFrame {
    private JLabel latitudeLabel = new JLabel("Latitude (sous la forme xx\u00b0xx'xx\") :");
    private JTextField latitudeText = new JTextField(10);
    private JLabel longitudeLabel = new JLabel("Longitude (sous la forme xx\u00b0xx'xx\") :");
    private JTextField longitudeText = new JTextField(10);
    private Carte carte = null;
    private int latitude;
    private int longitude;

    public FenetreCalibrageCoord(Carte c, String titre, final int x, final int y) {
        super("Calibrage des coordonn\u00e9es");
        this.carte = c;
        this.setLayout(new BorderLayout());
        this.setSize(300, 140);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        Box hBox1 = Box.createHorizontalBox();
        hBox1.add(Box.createHorizontalStrut(5));
        hBox1.add(this.latitudeLabel);
        hBox1.add(Box.createHorizontalStrut(5));
        this.latitudeText.setMaximumSize(this.latitudeText.getPreferredSize());
        hBox1.add(this.latitudeText);
        hBox1.add(Box.createGlue());
        hBox1.add(Box.createHorizontalStrut(5));
        Box hBox3 = Box.createHorizontalBox();
        hBox3.add(Box.createHorizontalStrut(5));
        hBox3.add(this.longitudeLabel);
        hBox3.add(Box.createHorizontalStrut(5));
        this.longitudeText.setMaximumSize(this.latitudeText.getPreferredSize());
        hBox3.add(this.longitudeText);
        hBox3.add(Box.createGlue());
        hBox3.add(Box.createHorizontalStrut(5));
        Box vboxH = Box.createVerticalBox();
        vboxH.add(hBox1);
        vboxH.add(Box.createVerticalStrut(5));
        vboxH.add(hBox3);
        vboxH.setBorder(BorderFactory.createTitledBorder(titre));
        Box hBoxF = Box.createHorizontalBox();
        hBoxF.add(Box.createGlue());
        JButton okBouton = new JButton("OK");
        okBouton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                boolean ok = FenetreCalibrageCoord.this.verification();
                if (ok) {
                    FenetreCalibrageCoord.this.dispose();
                    FenetreCalibrageCoord.this.carte.ajouteCoord(x, y, FenetreCalibrageCoord.this.latitude, FenetreCalibrageCoord.this.longitude);
                }
            }
        });
        hBoxF.add(okBouton);
        hBoxF.add(Box.createHorizontalStrut(5));
        JButton annulerBouton = new JButton("Annuler");
        annulerBouton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FenetreCalibrageCoord.this.dispose();
            }
        });
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(vboxH);
        vBox.add(Box.createGlue());
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(hBoxF);
        vBox.add(Box.createVerticalStrut(5));
        this.add((Component)vBox, "Center");
        this.setVisible(true);
    }

    public void chargerParam(String unite, double distance) {
        this.latitudeText.setText(unite);
        this.longitudeText.setText(Double.toString(distance));
    }

    private boolean verifFormat(String saisie) {
        boolean retour = false;
        return saisie.contains("\u00b0") && saisie.contains("'") && saisie.contains("\"") && saisie.indexOf("\u00b0") < saisie.indexOf("'") && saisie.indexOf("'") < saisie.indexOf("\"");
    }

    private boolean verification() {
        String secondes;
        String minutes;
        String degres;
        boolean etat = true;
        if (this.latitudeText.getText() == null || this.latitudeText.getText().equals("") || !this.verifFormat(this.latitudeText.getText())) {
            etat = false;
            this.latitudeLabel.setForeground(Color.red);
        } else {
            degres = this.latitudeText.getText().substring(0, this.latitudeText.getText().indexOf("\u00b0"));
            minutes = this.latitudeText.getText().substring(this.latitudeText.getText().indexOf("\u00b0") + 1, this.latitudeText.getText().indexOf("'"));
            secondes = this.latitudeText.getText().substring(this.latitudeText.getText().indexOf("'") + 1, this.latitudeText.getText().indexOf("\""));
            this.latitude = Integer.parseInt(degres) * 3600 + Integer.parseInt(minutes) * 60 + Integer.parseInt(secondes);
            this.latitudeLabel.setForeground(Color.black);
        }
        if (this.longitudeText.getText() == null || this.longitudeText.getText().equals("") || !this.verifFormat(this.longitudeText.getText())) {
            etat = false;
            this.longitudeLabel.setForeground(Color.red);
        } else {
            degres = this.longitudeText.getText().substring(0, this.longitudeText.getText().indexOf("\u00b0"));
            minutes = this.longitudeText.getText().substring(this.longitudeText.getText().indexOf("\u00b0") + 1, this.longitudeText.getText().indexOf("'"));
            secondes = this.longitudeText.getText().substring(this.longitudeText.getText().indexOf("'") + 1, this.longitudeText.getText().indexOf("\""));
            this.longitude = Integer.parseInt(degres) * 3600 + Integer.parseInt(minutes) * 60 + Integer.parseInt(secondes);
            this.longitudeLabel.setForeground(Color.black);
        }
        return etat;
    }
}

