/*
 * Decompiled with CFR 0.152.
 */
package geonoteTypesDonnees;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;

public class Arret {
    private int id;
    private int x;
    private int y;
    private int diametre = 50;
    private ArrayList listeLiens = null;

    public Arret(int ident, int X, int Y) {
        this.id = ident;
        this.x = X;
        this.y = Y;
        this.listeLiens = new ArrayList();
    }

    public ArrayList exporteListeLiens() {
        return this.listeLiens;
    }

    public void ajouteLien(String lien, String type) {
        Iterator i = this.listeLiens.iterator();
        boolean trouv\u00e9 = false;
        while (i.hasNext() && !trouv\u00e9) {
            ArrayList listeCourante = (ArrayList)i.next();
            String typ = listeCourante.get(0).toString();
            if (!typ.contains(type)) continue;
            listeCourante.add(lien);
            trouv\u00e9 = true;
        }
        if (!trouv\u00e9) {
            ArrayList<String> nouvelListe = new ArrayList<String>();
            nouvelListe.add(type);
            nouvelListe.add(lien);
            this.listeLiens.add(nouvelListe);
        }
    }

    public void suppLien(String lien, String type) {
        Iterator i = this.listeLiens.iterator();
        boolean trouv\u00e9 = false;
        while (i.hasNext() && !trouv\u00e9) {
            ArrayList listeCourante = (ArrayList)i.next();
            String typ = listeCourante.get(0).toString();
            if (!typ.contains(type)) continue;
            listeCourante.remove(lien);
            if (listeCourante.size() == 1) {
                this.listeLiens.remove(listeCourante);
            }
            trouv\u00e9 = true;
        }
    }

    public void importeListeLiens(ArrayList l) {
        if (l != null) {
            this.listeLiens.addAll(l);
        }
    }

    public void draw(Graphics2D g2, double zoom, int decalHor, int decalVer) {
        int diamAff = (int)((double)this.diametre / zoom);
        int xAffichage = this.x + decalHor;
        int yAffichage = this.y + decalVer;
        g2.setColor(Color.white);
        g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g2.fillRect(xAffichage, yAffichage, (diamAff + 5) / 3, (diamAff + 5) / 3);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setStroke(new BasicStroke((float)(5.0 / zoom)));
        g2.drawOval(xAffichage - diamAff / 2, yAffichage - diamAff / 2, diamAff, diamAff);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke((float)(1.0 / zoom)));
        g2.drawOval(xAffichage - diamAff / 2, yAffichage - diamAff / 2, diamAff, diamAff);
        g2.drawLine(xAffichage, yAffichage - diamAff / 2, xAffichage, yAffichage + diamAff / 2);
        g2.drawLine(xAffichage - diamAff / 2, yAffichage, xAffichage + diamAff / 2, yAffichage);
        g2.setFont(new Font("Courrier", 0, (int)(15.0 / zoom)));
        g2.drawString(Integer.toString(this.id), (int)((double)xAffichage + 2.0 / zoom), (int)((double)yAffichage + 16.0 / zoom));
    }

    public int getId() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getDiametre() {
        return this.diametre;
    }
}

