/*
 * Decompiled with CFR 0.152.
 */
package geonoteOutils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.text.DecimalFormat;

public class Reglet {
    private int x1 = -1;
    private int y1 = -1;
    private int x2 = -1;
    private int y2 = -1;
    private double longueur = 0.0;
    private boolean modeEdition = false;
    private boolean modeEcriture = false;

    public Reglet(boolean edition) {
        this.modeEdition = edition;
    }

    public void setDepart(int x, int y) {
        this.x1 = x;
        this.y1 = y;
    }

    public void setArriv\u00e9e(int x, int y) {
        this.x2 = x;
        this.y2 = y;
    }

    public double getLongueur() {
        this.longueur = Math.sqrt(Math.pow(Math.abs(this.x1 - this.x2), 2.0) + Math.pow(Math.abs(this.y1 - this.y2), 2.0));
        return this.longueur;
    }

    public void setModeEcriture(boolean b) {
        this.modeEcriture = b;
    }

    public void draw(Graphics2D g, double zoom, double echelle, String unite, int decalHor, int decalVer) {
        String longueurAffiche;
        this.longueur = Math.sqrt(Math.pow(Math.abs(this.x1 - this.x2), 2.0) + Math.pow(Math.abs(this.y1 - this.y2), 2.0));
        int x1Affichage = this.x1 + decalHor;
        int y1Affichage = this.y1 + decalVer;
        g.setColor(Color.white);
        g.setStroke(new BasicStroke((float)(4.0 / zoom)));
        g.drawLine(x1Affichage, y1Affichage, this.x2, this.y2);
        g.setColor(Color.black);
        g.setStroke(new BasicStroke((float)(2.0 / zoom)));
        g.drawLine(x1Affichage, y1Affichage, this.x2, this.y2);
        g.setColor(Color.white);
        g.fillRect(this.x2, this.y2, (int)(110.0 / zoom), (int)(20.0 / zoom));
        g.setColor(Color.black);
        g.drawRect(this.x2, this.y2, (int)(110.0 / zoom), (int)(20.0 / zoom));
        double mesure = echelle * this.longueur;
        if (this.modeEdition && this.modeEcriture) {
            DecimalFormat df = new DecimalFormat("########");
            longueurAffiche = String.valueOf(df.format(this.longueur)) + " px.";
        } else {
            DecimalFormat df = new DecimalFormat("########.##");
            longueurAffiche = String.valueOf(df.format(mesure)) + unite;
        }
        g.setFont(new Font("Courrier", 0, (int)(20.0 / zoom)));
        g.drawString(longueurAffiche, (int)((double)this.x2 + 10.0 / zoom), (int)((double)this.y2 + 18.0 / zoom));
    }
}

