/*
 * Decompiled with CFR 0.152.
 */
package geonoteTypesDonnees;

import geonoteInterface.Interface;
import geonoteTypesDonnees.Arret;
import geonoteTypesDonnees.Images;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class Carte
extends Images {
    private double echelleLat = 1.0;
    private double echelleLong = 1.0;
    private int latitude1 = -1;
    private int latitude2 = -1;
    private int latitudeOrigine = 0;
    private ArrayList listeArrets = new ArrayList();
    private int longitude1 = -1;
    private int longitude2 = -1;
    private int longitudeOrigine = 0;
    private boolean pointeurIN = false;
    private int x1 = -1;
    private int x2 = -1;
    private int xCourant;
    private int y1 = -1;
    private int y2 = -1;
    private int yCourant;

    public Carte(String path, double ech, String unit, boolean regletDisp, boolean zoomDisp, boolean modeEd, Interface i, ArrayList list, int latO, int longO, double echLat, double echLong) {
        super(path, ech, unit, regletDisp, zoomDisp, modeEd, i);
        this.latitudeOrigine = latO;
        this.longitudeOrigine = longO;
        this.echelleLat = echLat;
        this.echelleLong = echLong;
        if (list != null) {
            this.listeArrets.addAll(list);
        }
        if (this.modeEdition) {
            this.curseurDefaut = Cursor.getPredefinedCursor(1);
        }
    }

    public void ajoutArret(int x, int y) {
        if (this.modeEdition) {
            Arret rech = this.recherche(x, y);
            if (rech == null) {
                Arret arretCourant = new Arret(this.listeArrets.size() + 1, x, y);
                this.diplomate.ajouteArretCarte(this.listeArrets.size() + 1, x, y);
                this.listeArrets.add(arretCourant);
            } else {
                ArrayList retour = this.diplomate.ajouteDonneeCarte(rech.getId());
                if (!retour.isEmpty()) {
                    rech.ajouteLien((String)retour.get(0), (String)retour.get(1));
                }
            }
        }
    }

    private void ajouteCoord(int x, int y) {
        int latitudeTemp = 0;
        int longitudeTemp = 0;
        String latitude = "";
        boolean latitudeOK = false;
        boolean longitudeOK = false;
        latitude = JOptionPane.showInputDialog(new JFrame(), "Quel est la latitude de ce point ? (sous la forme xx\u00b0xx'xx\") ", "Parametrage (1/2)", 3);
        while (latitude != null && !latitude.matches("") && !latitudeOK) {
            if (latitude.contains("\u00b0") && latitude.contains("'") && latitude.contains("\"") && latitude.indexOf("\u00b0") < latitude.indexOf("'") && latitude.indexOf("'") < latitude.indexOf("\"")) {
                String degres = latitude.substring(0, latitude.indexOf("\u00b0"));
                String minutes = latitude.substring(latitude.indexOf("\u00b0") + 1, latitude.indexOf("'"));
                String secondes = latitude.substring(latitude.indexOf("'") + 1, latitude.indexOf("\""));
                latitudeTemp = Integer.parseInt(degres) * 3600 + Integer.parseInt(minutes) * 60 + Integer.parseInt(secondes);
                latitudeOK = true;
                continue;
            }
            latitude = JOptionPane.showInputDialog(new JFrame(), "Erreur ! Respectez la syntaxe !\nQuel est la latitude de ce point ? (sous la forme xx\u00b0xx'xx\") ", "Parametrage (1/2)", 3);
        }
        if (latitudeOK) {
            String longitude = "";
            longitude = JOptionPane.showInputDialog(new JFrame(), "Quel est la longitude de ce point ? (sous la forme xx\u00b0xx'xx\") ", "Parametrage (2/2)", 3);
            while (longitude != null && !longitude.matches("") && !longitudeOK) {
                if (longitude.contains("\u00b0") && longitude.contains("'") && longitude.contains("\"") && longitude.indexOf("\u00b0") < longitude.indexOf("'") && longitude.indexOf("'") < longitude.indexOf("\"")) {
                    String degres = longitude.substring(0, longitude.indexOf("\u00b0"));
                    String minutes = longitude.substring(longitude.indexOf("\u00b0") + 1, longitude.indexOf("'"));
                    String secondes = longitude.substring(longitude.indexOf("'") + 1, longitude.indexOf("\""));
                    longitudeTemp = Integer.parseInt(degres) * 3600 + Integer.parseInt(minutes) * 60 + Integer.parseInt(secondes);
                    longitudeOK = true;
                    continue;
                }
                longitude = JOptionPane.showInputDialog(new JFrame(), "Erreur ! Respectez la syntaxe !\nQuel est la longitude de ce point ? (sous la forme xx\u00b0xx'xx\") ", "Parametrage (2/2)", 3);
            }
        }
        if (latitudeOK && longitudeOK) {
            if (this.x1 == -1 && this.y1 == -1) {
                this.x1 = x;
                this.y1 = y;
                this.latitude1 = latitudeTemp;
                this.longitude1 = longitudeTemp;
            } else if (this.x2 == -1 && this.y2 == -1) {
                this.x2 = x;
                this.y2 = y;
                this.latitude2 = latitudeTemp;
                this.longitude2 = longitudeTemp;
                this.echelleLat = (this.longitude2 - this.longitude1) / (this.x2 - this.x1);
                this.echelleLong = (this.latitude2 - this.latitude1) / (this.y2 - this.y1);
                this.longitudeOrigine = (int)((double)this.longitude1 - (double)this.x1 * this.echelleLong);
                this.latitudeOrigine = (int)((double)this.latitude1 - (double)this.x1 * this.echelleLat);
                this.diplomate.ajouteCoordonnees(this.latitudeOrigine, this.longitudeOrigine, this.echelleLat, this.echelleLong);
            }
        }
    }

    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getButton() == 1) {
            if (this.modeEdition && (this.x1 == -1 && this.y1 == -1 || this.x2 == -1 && this.y2 == -1)) {
                this.ajouteCoord(arg0.getX(), arg0.getY());
            } else {
                if (this.diplomate != null) {
                    this.diplomate.rapportTrace("carte", "clic");
                }
                if (this.diplomate.isModeSuppArret()) {
                    this.suppArret((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
                } else {
                    this.ajoutArret((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
                }
            }
            this.repaint();
        } else if (arg0.getButton() == 3) {
            this.ouvertureArret((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent arg0) {
        super.mouseDragged(arg0);
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
    }

    public void mouseEntered(MouseEvent arg0) {
        this.pointeurIN = true;
    }

    public void mouseExited(MouseEvent arg0) {
        this.pointeurIN = false;
        this.repaint();
    }

    public void mouseMoved(MouseEvent arg0) {
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
        Arret rech = this.recherche(this.xCourant, this.yCourant);
        if (rech != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.repaint();
        } else {
            this.setCursor(this.curseurDefaut);
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent arg0) {
        if (this.regletDispo) {
            if (this.modeEdition && arg0.getButton() == 3 && this.reglet.getLongueur() > 0.0) {
                this.diplomate.ajouteEchelle(this.reglet.getLongueur(), "carte");
            }
            this.regletActif = false;
            this.setCursor(this.curseurDefaut);
            if (this.diplomate != null) {
                this.diplomate.rapportTrace("reglet", "fin");
            }
            this.repaint();
        }
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
    }

    public void mouseWheelMoved(MouseWheelEvent arg0) {
        super.mouseWheelMoved(arg0);
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
    }

    private void ouvertureArret(int x, int y) {
        final Arret arret = this.recherche(x, y);
        if (arret != null) {
            final JPopupMenu menu = new JPopupMenu("Donn\u00e9es disponibles :");
            ArrayList liste = arret.exporteListeLiens();
            Iterator i = liste.iterator();
            while (i.hasNext()) {
                ArrayList listeDonneesPourUnType = (ArrayList)i.next();
                Iterator it = listeDonneesPourUnType.iterator();
                final String type = (String)it.next();
                JMenu item = new JMenu(type);
                while (it.hasNext()) {
                    final String fich = (String)it.next();
                    JMenuItem fichItem = new JMenuItem(fich);
                    fichItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent arg0) {
                            if (Carte.this.diplomate != null) {
                                if (!Carte.this.modeEdition) {
                                    Carte.this.diplomate.afficheVisu(fich, "arret");
                                    Carte.this.diplomate.ajoutArretHisto(arret.getId(), fich);
                                } else if (Carte.this.diplomate.isModeSuppLien()) {
                                    arret.suppLien(fich, type);
                                    Carte.this.diplomate.suppLienEffectue(arret.getId(), fich);
                                }
                            }
                            menu.setVisible(false);
                        }
                    });
                    item.add(fichItem);
                }
                menu.add(item);
            }
            menu.show(this, (int)((double)x * this.zoom), (int)((double)y * this.zoom));
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.zoom, this.zoom);
        int largImage = (int)((double)this.image.getIconWidth() * this.zoom);
        int hautImage = (int)((double)this.image.getIconHeight() * this.zoom);
        Dimension dimension = null;
        dimension = largImage > this.getParent().getWidth() && hautImage > this.getParent().getHeight() ? new Dimension(largImage, hautImage) : (largImage > this.getParent().getWidth() ? new Dimension(largImage, this.getParent().getHeight()) : (hautImage > this.getParent().getHeight() ? new Dimension(this.getParent().getWidth(), hautImage) : new Dimension(this.getParent().getSize())));
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        int decalHaut = (int)((double)(this.getHeight() - hautImage) / (2.0 * this.zoom));
        int decalLarg = (int)((double)(this.getWidth() - largImage) / (2.0 * this.zoom));
        g2.drawImage(this.image.getImage(), decalLarg, decalHaut, this);
        if (!this.listeArrets.isEmpty() && this.diplomate.getAAA()) {
            int i = 0;
            while (i < this.listeArrets.size()) {
                Arret temp = (Arret)this.listeArrets.get(i);
                temp.draw(g2, this.zoom, decalLarg, decalHaut);
                ++i;
            }
        }
        if (this.regletDispo && this.regletActif) {
            this.reglet.draw(g2, this.zoom, this.echelle, this.unit\u00e9, decalLarg, decalHaut);
        }
        if (!this.regletActif && this.diplomate.getACA() && this.pointeurIN) {
            int xAff = (int)((double)this.xCourant + 10.0 / this.zoom);
            int yAff = (int)((double)this.yCourant + 10.0 / this.zoom);
            g2.setColor(Color.white);
            g2.fillRect(xAff, yAff, (int)(110.0 / this.zoom), (int)(25.0 / this.zoom));
            g2.setColor(Color.black);
            g2.drawRect(xAff, yAff, (int)(110.0 / this.zoom), (int)(25.0 / this.zoom));
            if (this.modeEdition && (this.x1 == -1 && this.y1 == -1 || this.x2 == -1 && this.y2 == -1)) {
                g.setFont(new Font("Courrier", 0, (int)(15.0 / this.zoom)));
                String texte = "";
                if (this.x1 == -1 && this.y1 == -1) {
                    texte = "Premier point";
                } else if (this.x2 == -1 && this.y2 == -1) {
                    texte = "Deuxieme point";
                }
                g2.drawString(texte, (int)((double)xAff + 3.0 / this.zoom), (int)((double)yAff + 18.0 / this.zoom));
            } else {
                int longitude = (int)((double)this.longitudeOrigine + (double)this.xCourant * this.echelleLong);
                int latitude = (int)((double)this.latitudeOrigine + (double)this.yCourant * this.echelleLat);
                int degres = latitude / 3600;
                int minutes = (latitude - degres * 3600) / 60;
                int secondes = latitude - degres * 3600 - minutes * 60;
                g.setFont(new Font("Courrier", 0, (int)(10.0 / this.zoom)));
                g2.drawString("Latitude : " + Integer.toString(degres) + "\u00b0" + Integer.toString(minutes) + "'" + Integer.toString(secondes) + "\"", (int)((double)xAff + 3.0 / this.zoom), (int)((double)yAff + 23.0 / this.zoom));
                degres = longitude / 3600;
                minutes = (longitude - degres * 3600) / 60;
                secondes = longitude - degres * 3600 - minutes * 60;
                g2.drawString("Longitude : " + Integer.toString(degres) + "\u00b0" + Integer.toString(minutes) + "'" + Integer.toString(secondes) + "\"", (int)((double)xAff + 3.0 / this.zoom), (int)((double)yAff + 11.0 / this.zoom));
            }
        }
        g2.dispose();
    }

    private Arret recherche(int x, int y) {
        Arret cible = null;
        boolean trouve = false;
        int i = 0;
        while (i < this.listeArrets.size() && !trouve) {
            Arret temp = (Arret)this.listeArrets.get(i);
            if ((double)x >= (double)temp.getX() - (double)temp.getDiametre() / (2.0 * this.zoom) && (double)x <= (double)temp.getX() + (double)temp.getDiametre() / (2.0 * this.zoom) && (double)y >= (double)temp.getY() - (double)temp.getDiametre() / (2.0 * this.zoom) && (double)y <= (double)temp.getY() + (double)temp.getDiametre() / (2.0 * this.zoom)) {
                cible = temp;
                trouve = true;
            }
            ++i;
        }
        return cible;
    }

    private void suppArret(int x, int y) {
        Arret rech;
        if (this.modeEdition && (rech = this.recherche(x, y)) != null) {
            this.listeArrets.remove(rech);
            this.diplomate.suppArretEffectue(rech.getId());
        }
    }
}

