/*
 * Created on 7 juil. 2005
 */
package geonoteInterface;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

/**
 * @author lefevre
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class FenetreCalibrageReglet extends JFrame {
	private JLabel uniteLabel = new JLabel("Unit (mm, cm, m ou km) :"); 
	private JTextField uniteText = new JTextField(2);
	private JLabel distanceLabel = new JLabel("Distance quivalente (par ex. : 12.7) :"); 
	private JTextField distanceText = new JTextField(12);
	private Interface diplomate = null;
	private double distance;
	
	public FenetreCalibrageReglet(Interface i, final double mesure, final String typeDonnee) {
		super("Calibrage du reglet"); 
		diplomate = i;
		setLayout(new BorderLayout());
		setSize(310,150);
		setLocationRelativeTo(null);	//centrage de la fenetre
		setResizable(false);
		
		Box hBox1 = Box.createHorizontalBox();
		hBox1.add(Box.createHorizontalStrut(5));
		hBox1.add(uniteLabel);
		hBox1.add(Box.createHorizontalStrut(5));
		uniteText.setMaximumSize(uniteText.getPreferredSize());
		hBox1.add(uniteText);
		hBox1.add(Box.createGlue());
		hBox1.add(Box.createHorizontalStrut(5));
		
		Box hBox2 = Box.createHorizontalBox();
		hBox2.add(Box.createHorizontalStrut(5));
		DecimalFormat df = new DecimalFormat("#######"); //outil de formattage 
		String mesureAffiche = df.format(mesure)+" pixels."; //formattage 
		hBox2.add(new JLabel("Distance mesure : "+mesureAffiche)); 
		hBox2.add(Box.createGlue());
		hBox2.add(Box.createHorizontalStrut(5));
		
		Box hBox3 = Box.createHorizontalBox();
		hBox3.add(Box.createHorizontalStrut(5));
		hBox3.add(distanceLabel);
		hBox3.add(Box.createHorizontalStrut(5));
		distanceText.setMaximumSize(uniteText.getPreferredSize());
		hBox3.add(distanceText);
		hBox3.add(Box.createGlue());
		hBox3.add(Box.createHorizontalStrut(5));
		
		Box vboxH = Box.createVerticalBox();
		vboxH.add(hBox1);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox2);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox3);
		vboxH.setBorder(BorderFactory.createTitledBorder("")); 
		
		Box hBoxF = Box.createHorizontalBox();
		hBoxF.add(Box.createGlue());
		JButton okBouton = new JButton("OK"); 
		okBouton.grabFocus();
		okBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				boolean ok = verification();
				if (ok) {
					setVisible(false);
					diplomate.enregEchelle(typeDonnee, uniteText.getText(), distance, mesure);
				}
			}
		});
		hBoxF.add(okBouton);
		hBoxF.add(Box.createHorizontalStrut(5));
		JButton annulerBouton = new JButton("Annuler"); 
		annulerBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				setVisible(false);
			}
		});
		hBoxF.add(annulerBouton);
		hBoxF.add(Box.createHorizontalStrut(5));
		
		Box vBox = Box.createVerticalBox();
		vBox.add(Box.createVerticalStrut(5));
		vBox.add(vboxH);
		vBox.add(Box.createGlue());
		vBox.add(Box.createVerticalStrut(5));
		vBox.add(hBoxF);
		vBox.add(Box.createVerticalStrut(5));
		
		add(vBox,BorderLayout.CENTER);
		setVisible(true);
	}
	
	public void chargerParam(String unite, double distance) {
		uniteText.setText(unite);
		distanceText.setText(Double.toString(distance));
	}
	
	private boolean verification() {
		boolean etat = true;
		if ((uniteText.getText() == null) || uniteText.getText().equals("") || (!uniteText.getText().equals("mm") && !uniteText.getText().equals("cm") && !uniteText.getText().equals("m") && !uniteText.getText().equals("km"))) {     
			etat = false;
			uniteLabel.setForeground(Color.red);
		} else {
			uniteLabel.setForeground(Color.black);
		}
		if ((distanceText.getText() == null) || distanceText.getText().equals("")) { 
			etat = false;
			distanceLabel.setForeground(Color.red);
		} else {
			try {
				distance = Double.parseDouble(distanceText.getText());
				distanceLabel.setForeground(Color.black);
			} catch (Exception e ) {
				etat = false;
				distanceLabel.setForeground(Color.red);
//				e.printStackTrace();
			}
		}
		return etat;
	}
}
