/*
 * Created on 24 juin 2005
 *
 */
package geonoteTypesDonnees;

import geonoteInterface.BarreEtat;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.rtf.RTFEditorKit;

/**
 * @author lefevre
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Texte extends JTextPane implements Printable, MouseListener {//JEditorPane {
	private String path =""; 
	private RTFEditorKit rtf = new RTFEditorKit();
	private String commentaire = ""; 
	
	public Texte(String commentaire) {
		super();
		this.commentaire = commentaire;
		setEditorKit( rtf );
		setBackground(Color.white);
		addMouseListener(this);
		setBorder(BorderFactory.createLineBorder(Color.white, 5));
	}
	
	public boolean charger(String path) {
		boolean retour = false;
		try {
			FileInputStream fi = new FileInputStream( path );
			rtf.read( fi, this.getDocument(), 0 );
			this.path = path;
			retour = true;
		} catch (FileNotFoundException e ) {
			System.out.println( "Fichier introuvable ("+path+")");  
		} catch(IOException e ) {
			System.out.println( "I/O error" ); 
		} catch(BadLocationException e ){
			System.out.println("Chemin incorrect"); 
		}
		return retour;
	}
	
	public boolean enregistrer() {
		boolean retour = false;
		try {
			FileOutputStream fi = new FileOutputStream( path );
			rtf.write( fi, this.getDocument(), this.getDocument().getLength(), 0);
			retour = true;
		} catch (FileNotFoundException e ) {
			System.out.println("Fichier introuvable ("+path+")");  
		} catch(IOException e ) {
			System.out.println( "I/O error" ); 
		} catch(BadLocationException e ){
			System.out.println("Chemin incorrect"); 
		}
		return retour;
	}
	
	public void setPath(String path) {
		this.path = path;
	}
	
	public String getPath() {
		return path;
	}

	public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
    	if (pi >= 1) {
    		return Printable.NO_SUCH_PAGE;
    	}
    	g.translate(10, 10);
    	Font f = new Font("Monospaced",Font.PLAIN,12); 
    	g.setFont (f);
    	paint (g);
    	return Printable.PAGE_EXISTS;
    }
	
	public void mouseClicked(MouseEvent arg0) { }
	
	public void mousePressed(MouseEvent arg0) { }
	
	public void mouseReleased(MouseEvent arg0) { }
	
	public void mouseEntered(MouseEvent arg0) {
	    if (commentaire.length()>0) {
	        BarreEtat.afficheGauche("Commentaire : "+commentaire); 
	    }
	}
	
	public void mouseExited(MouseEvent arg0) {
	    BarreEtat.resetGauche();
	}
}
