/*
 * Created on 13 avr. 2005
 */
package geonoteZones;

import geonoteInterface.Interface;
import geonoteOutils.FiltreSimple;
import geonoteOutilsCarnet.ColorMenu;
import geonoteOutilsCarnet.FontDialog;
import geonoteOutilsCarnet.ParagraphDialog;
import geonoteOutilsCarnet.SmallButton;
import geonoteOutilsCarnet.SmallToggleButton;
import geonoteTypesDonnees.Texte;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Enumeration;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

/**
 * @author lefevre
 */
public class Carnet extends JPanel {
	private Texte texte;
	private JMenuBar menuBar;
	private JScrollPane conteneur;
	private JPanel barresConteneur = null;
	private StyleContext m_context;
	private DefaultStyledDocument m_doc;
	private RTFEditorKit m_kit; //inutile (voir texte)
	private JFileChooser m_chooser;
	private FiltreSimple m_rtfFilter;
	private JToolBar toolBar;
	private JComboBox m_cbFonts;
	private JComboBox m_cbSizes;
	private SmallToggleButton m_bBold;
	private SmallToggleButton m_bItalic;
	private FiltreSimple m_jpgFilter;
	private FiltreSimple m_gifFilter;
	private UndoManager m_undo = new UndoManager();
	private Action m_undoAction;
	private Action m_redoAction;
	private ColorMenu m_foreground;
	private ColorMenu m_background;
	private String m_fontName = "";
	private int m_fontSize = 0;
	private boolean m_skipUpdate;
	private String[] m_fontNames;
	private ParagraphDialog m_paragraphDialog;
	private String[] m_fontSizes;
	private FontDialog m_fontDialog;
	private int m_xStart = -1;
	private int m_xFinish = -1;
	private JComboBox m_cbStyles;
	private Interface diplomate = null;
	private String dossierSysteme = "";
	private String newline = "\n";
	public static final char[] WORD_SEPARATORS = {' ', '\t', '\n', '\r', '\f', '.', ',', ':', '-', '(', ')', '[', ']', '{', '}', '<', '>', '/', '|', '\\', '\'', '\"'};

	private class Undoer implements UndoableEditListener {
		public Undoer() {
			m_undo.die();
			updateUndo();
		}
		
		public void undoableEditHappened(UndoableEditEvent e) {
			UndoableEdit edit = e.getEdit();
			m_undo.addEdit(e.getEdit());
			updateUndo();
		}
	}
	
	public Carnet(Interface i, String sys) {
		super();
		diplomate = i;
		dossierSysteme = sys;
		setLayout(new BorderLayout());
	}
	
	public static boolean isSeparator(char ch) {
		for (int k=0; k<WORD_SEPARATORS.length; k++)
			if (ch == WORD_SEPARATORS[k])
				return true;
		return false;
	}
	
	private void masquer() {
		diplomate.masquerCarnet();
	}
	
	private JMenuBar createMenuBar() {
		JMenuBar menuBar = new JMenuBar();
		JMenuItem item;// = mFile.add(actionNew);
		
		toolBar = new JToolBar();
		toolBar.setFloatable(false);
		
		JMenu mEdit = new JMenu("Edition");
		mEdit.setMnemonic('e');
		
		Action action = new AbstractAction("Copier", new ImageIcon(dossierSysteme+"copier.gif")) {
			public void actionPerformed(ActionEvent e) {
				texte.copy();
				diplomate.modifTexteEffectuee(true);
			}
		};
		item = mEdit.add(action); 
		item.setMnemonic('c');
		item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, KeyEvent.CTRL_MASK));
		
		action = new AbstractAction("Couper", new ImageIcon(dossierSysteme+"couper.gif")) {
			public void actionPerformed(ActionEvent e) {
				texte.cut();
				diplomate.modifTexteEffectuee(true);
			}
			
		};
		item = mEdit.add(action); 
		item.setMnemonic('t');
		item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, KeyEvent.CTRL_MASK));
		
		action = new AbstractAction("Coller", new ImageIcon(dossierSysteme+"coller.gif")) {
			public void actionPerformed(ActionEvent e) {
				texte.paste();
				diplomate.modifTexteEffectuee(true);
			}
		};
		item = mEdit.add(action); 
		item.setMnemonic('p');
		item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, KeyEvent.CTRL_MASK));
		mEdit.addSeparator();
		
		m_undoAction = new AbstractAction("Annuler", new ImageIcon(dossierSysteme+"annuler.gif")) {
			public void actionPerformed(ActionEvent e) {
				try {
					m_undo.undo();
				}
				catch (CannotUndoException ex) {
					System.err.println("Unable to undo: " + ex);
				}
				updateUndo();
				diplomate.modifTexteEffectuee(true);
			}
		};
		item = mEdit.add(m_undoAction); 
		item.setMnemonic('a');
		item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Z, KeyEvent.CTRL_MASK));
		
		m_redoAction = new AbstractAction("Rtablir", new ImageIcon(dossierSysteme+"retablir.gif")) {
			public void actionPerformed(ActionEvent e) {
				try {
					m_undo.redo();
				} catch (CannotRedoException ex) {
					System.err.println("Unable to redo: " + ex);
				}
				updateUndo();
				diplomate.modifTexteEffectuee(true);
			}
		};
		item =  mEdit.add(m_redoAction); 
		item.setMnemonic('r');
		item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Y, KeyEvent.CTRL_MASK));
		
		GraphicsEnvironment ge = GraphicsEnvironment.
		getLocalGraphicsEnvironment();
		m_fontNames = ge.getAvailableFontFamilyNames();
		
		toolBar.addSeparator();
		m_cbFonts = new JComboBox(m_fontNames);
		m_cbFonts.setMaximumSize(m_cbFonts.getPreferredSize());
		m_cbFonts.setEditable(true);
		
		ActionListener lst = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				m_fontName = m_cbFonts.getSelectedItem().toString();
				MutableAttributeSet attr = new SimpleAttributeSet();
				StyleConstants.setFontFamily(attr, m_fontName);
				setAttributeSet(attr);
				texte.grabFocus();
				diplomate.modifTexteEffectuee(true);
			}
		};
		m_cbFonts.addActionListener(lst);
		toolBar.add(m_cbFonts);
		
		toolBar.addSeparator();
		m_fontSizes = new String[] {"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
		m_cbSizes = new JComboBox(m_fontSizes);
		m_cbSizes.setMaximumSize(m_cbSizes.getPreferredSize());
		m_cbSizes.setEditable(true);
		m_fontDialog = new FontDialog(diplomate, m_fontNames, m_fontSizes);
		lst = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int fontSize = 0;
				try {
					fontSize = Integer.parseInt(m_cbSizes.getSelectedItem().toString());
				} catch (NumberFormatException ex) { return; }
				
				m_fontSize = fontSize;
				MutableAttributeSet attr = new SimpleAttributeSet();
				StyleConstants.setFontSize(attr, fontSize);
				setAttributeSet(attr);
				texte.grabFocus();
				diplomate.modifTexteEffectuee(true);
			}
		};
		m_cbSizes.addActionListener(lst);
		toolBar.add(m_cbSizes);
		
		toolBar.addSeparator();
		ImageIcon img1 = new ImageIcon(dossierSysteme+"gras.gif");
		ImageIcon img2 = new ImageIcon(dossierSysteme+"gras2.gif");
		m_bBold = new SmallToggleButton(false, img1, img2, "Gras");
		lst = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MutableAttributeSet attr = new SimpleAttributeSet();
				StyleConstants.setBold(attr, m_bBold.isSelected());
				setAttributeSet(attr);
				texte.grabFocus();
				diplomate.modifTexteEffectuee(true);
			}
		};
		m_bBold.addActionListener(lst);
		toolBar.add(m_bBold);
		
		img1 = new ImageIcon(dossierSysteme+"italique.gif");
		img2 = new ImageIcon(dossierSysteme+"italique2.gif");
		m_bItalic = new SmallToggleButton(false, img1, img2, "Italique");
		lst = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MutableAttributeSet attr = new SimpleAttributeSet();
				StyleConstants.setItalic(attr, m_bItalic.isSelected());
				setAttributeSet(attr);
				texte.grabFocus();
				diplomate.modifTexteEffectuee(true);
			}
		};
		m_bItalic.addActionListener(lst);
		toolBar.add(m_bItalic);
		
		JMenu mFormat = new JMenu("Format");
		mFormat.setMnemonic('o');
		item = new JMenuItem("Police ...");
		item.setMnemonic('o');
		lst = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Carnet.this.repaint();
				AttributeSet a = m_doc.getCharacterElement(texte.getCaretPosition()).getAttributes();
				m_fontDialog.setAttributes(a);
				
				Dimension d1 = m_fontDialog.getSize();
				Dimension d2 = Carnet.this.getSize();
				int x = Math.max((d2.width-d1.width)/2, 0);
				int y = Math.max((d2.height-d1.height)/2, 0);
				m_fontDialog.setBounds(x + Carnet.this.getX(), y + Carnet.this.getY(), d1.width, d1.height);
				
				m_fontDialog.setVisible(true);
				if (m_fontDialog.getOption()==JOptionPane.OK_OPTION) {
					setAttributeSet(m_fontDialog.getAttributes());
					showAttributes(texte.getCaretPosition());
					diplomate.modifTexteEffectuee(true);
				}
			}
		};
		item.addActionListener(lst);
		mFormat.add(item);
		
		mFormat.addSeparator();
		JMenu mStyle = new JMenu("Style");
		mStyle.setMnemonic('s');
		mFormat.add(mStyle);
		
		item = new JMenuItem("Mise  jour");
		item.setMnemonic('m');
		lst = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String name = (String)m_cbStyles.getSelectedItem();
				Style style = m_doc.getStyle(name);
				int p = texte.getCaretPosition();
				AttributeSet a = m_doc.getCharacterElement(p).getAttributes();
				style.addAttributes(a);
				texte.repaint();
				diplomate.modifTexteEffectuee(true);
			}
		};
		item.addActionListener(lst);
		mStyle.add(item);
		
		item = new JMenuItem("Rtablir");
		item.setMnemonic('r');
		lst = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String name = (String)m_cbStyles.getSelectedItem();
				Style style = m_doc.getStyle(name);
				setAttributeSet(style);
				diplomate.modifTexteEffectuee(true);
			}
		};
		item.addActionListener(lst);
		mStyle.add(item);
		item = new JMenuItem("Paragraphe ...");
		item.setMnemonic('p');
		m_paragraphDialog = new ParagraphDialog(diplomate, dossierSysteme);
		lst = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Carnet.this.repaint();
				AttributeSet a = m_doc.getCharacterElement(texte.getCaretPosition()).getAttributes();
				m_paragraphDialog.setAttributes(a);
				
				Dimension d1 = m_paragraphDialog.getSize();
				Dimension d2 = Carnet.this.getSize();
				int x = Math.max((d2.width-d1.width)/2, 0);
				int y = Math.max((d2.height-d1.height)/2, 0);
				m_paragraphDialog.setBounds(x + Carnet.this.getX(),y + Carnet.this.getY(), d1.width, d1.height);
				
				m_paragraphDialog.setVisible(true);
				if (m_paragraphDialog.getOption()==JOptionPane.OK_OPTION) {
					setAttributeSet(/*TODO dlg*/m_paragraphDialog.getAttributes(), true);
					showAttributes(texte.getCaretPosition());
					diplomate.modifTexteEffectuee(true);
				}
			}
		};
		item.addActionListener(lst);
		mFormat.add(item);
		mFormat.addSeparator();
		m_foreground = new ColorMenu("Couleur de police");
		m_foreground.setColor(texte.getForeground());
		m_foreground.setMnemonic('f');
		lst = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MutableAttributeSet attr = new SimpleAttributeSet();
				StyleConstants.setForeground(attr, m_foreground.getColor());	//TODO
				setAttributeSet(attr);
				diplomate.modifTexteEffectuee(true);
			}
		};
		m_foreground.addActionListener(lst);
		mFormat.add(m_foreground);
		
		MenuListener ml = new MenuListener() {
			public void menuSelected(MenuEvent e) {
				int p = texte.getCaretPosition();
				AttributeSet a = m_doc.getCharacterElement(p).getAttributes();
				Color c = StyleConstants.getForeground(a);
				m_foreground.setColor(c);
			}
			
			public void menuDeselected(MenuEvent e) {}
			
			public void menuCanceled(MenuEvent e) {}
		};
		m_foreground.addMenuListener(ml);
		
		// Bug Alert! JEditorPane background color
		// doesn't work as of Java 2 FCS.
		m_background = new ColorMenu("Couleur de fond");
		m_background.setColor(texte.getBackground());
		m_background.setMnemonic('b');
		lst = new ActionListener()  {
			public void actionPerformed(ActionEvent e) {
				MutableAttributeSet attr = new SimpleAttributeSet();
				StyleConstants.setBackground(attr, m_background.getColor());
				setAttributeSet(attr);
				diplomate.modifTexteEffectuee(true);
			}
		};
		m_background.addActionListener(lst);
		mFormat.add(m_background);
		
		ml = new MenuListener() {
			public void menuSelected(MenuEvent e) {
				int p = texte.getCaretPosition();
				AttributeSet a = m_doc.getCharacterElement(p).getAttributes();
				Color c = StyleConstants.getBackground(a);
				m_background.setColor(c);
			}
			
			public void menuDeselected(MenuEvent e) {}
			public void menuCanceled(MenuEvent e) {}
		};
		m_background.addMenuListener(ml);
		// Bug Alert! Images do not get saved.
//		mFormat.addSeparator();
//		item = new JMenuItem("Inserer une  image"); 
//		item.setMnemonic('i');
//		lst = new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				m_chooser.addChoosableFileFilter(m_gifFilter);
//				m_chooser.addChoosableFileFilter(m_jpgFilter);
//				m_chooser.setFileFilter(m_gifFilter);
//				m_chooser.removeChoosableFileFilter(m_rtfFilter);
//				Thread runner = new Thread() {
//					public void run() {
//						if (m_chooser.showOpenDialog(Carnet.this) != JFileChooser.APPROVE_OPTION)
//							return;
//						Carnet.this.repaint();
//						File fChoosen = m_chooser.getSelectedFile();
//						ImageIcon icon = new ImageIcon(fChoosen.getPath());
//						int w = icon.getIconWidth();
//						int h = icon.getIconHeight();
//						if (w<=0 || h<=0) {
//							JOptionPane.showMessageDialog(Carnet.this, "Error reading image file\n"+fChoosen.getPath(), "Warning", JOptionPane.WARNING_MESSAGE);
//							return;
//						}
//						MutableAttributeSet attr = new SimpleAttributeSet();
//						StyleConstants.setIcon(attr, icon);
//						int p = texte.getCaretPosition();
//						try {
//							m_doc.insertString(p, " ", attr);
//						} catch (BadLocationException ex) {}
//						
//						// Its ok to do this outside of the event-dispatching
//						// thread because the chooser is not visible here.
//						m_chooser.addChoosableFileFilter(m_rtfFilter);
//						m_chooser.setFileFilter(m_rtfFilter);
//						m_chooser.removeChoosableFileFilter(m_gifFilter);
//						m_chooser.removeChoosableFileFilter(m_jpgFilter);
//					}
//				};
//				runner.start();
//			}
//		};
//		item.addActionListener(lst);
//		mFormat.add(item);
		
		action = new AbstractAction("coordonnes", new ImageIcon(dossierSysteme+"masquer.gif")) {
			public void actionPerformed(ActionEvent e) {
				masquer();
			}
		};
		SmallButton mask = new SmallButton(action, "Masquer le carnet");
		
		menuBar.add(mEdit);
		menuBar.add(mFormat);
		Box hBox = Box.createHorizontalBox();
		hBox.add(Box.createGlue());
		hBox.add(mask);
		menuBar.add(hBox);
		
		toolBar.addSeparator();
		m_cbStyles = new JComboBox();
		m_cbStyles.setMaximumSize(new Dimension(100,20));//m_cbStyles.getPreferredSize());
		m_cbStyles.setEditable(true);
		toolBar.add(m_cbStyles);
		
		lst = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (m_skipUpdate || m_cbStyles.getItemCount()==0)
					return;
				String name = (String)m_cbStyles.getSelectedItem();
				int index = m_cbStyles.getSelectedIndex();
				int p = texte.getCaretPosition();
				
				// New name entered
				if (index == -1) {
					m_cbStyles.addItem(name);
					Style style = m_doc.addStyle(name, null);
					AttributeSet a = m_doc.getCharacterElement(p).getAttributes();
					style.addAttributes(a);
					return;
				}
				
				// Apply the selected style
				Style currStyle = m_doc.getLogicalStyle(p);
				if (!currStyle.getName().equals(name)) {
					Style style = m_doc.getStyle(name);
					setAttributeSet(style);
					diplomate.modifTexteEffectuee(true);
				}
			}
		};
		m_cbStyles.addActionListener(lst);
		return menuBar;
	}
	
	protected void showAttributes(int p) {
		m_skipUpdate = true;
		AttributeSet a = m_doc.getCharacterElement(p).
		getAttributes();
		String name = StyleConstants.getFontFamily(a);
		if (!m_fontName.equals(name)) {
			m_fontName = name;
			m_cbFonts.setSelectedItem(name);
		}
		int size = StyleConstants.getFontSize(a);
		if (m_fontSize != size) {
			m_fontSize = size;
			m_cbSizes.setSelectedItem(Integer.toString(m_fontSize));
		}
		boolean bold = StyleConstants.isBold(a);
		if (bold != m_bBold.isSelected())
			m_bBold.setSelected(bold);
		boolean italic = StyleConstants.isItalic(a);
		if (italic != m_bItalic.isSelected())
			m_bItalic.setSelected(italic);
		Style style = m_doc.getLogicalStyle(p);
		name = style.getName();
		m_cbStyles.setSelectedItem(name);
		m_skipUpdate = false;
	}
	
	protected void setAttributeSet(AttributeSet attr) {
		setAttributeSet(attr, false);
	}
	
	protected void setAttributeSet(AttributeSet attr, boolean setParagraphAttributes) {
		if (m_skipUpdate)
			return;
		int xStart = texte.getSelectionStart();
		int xFinish = texte.getSelectionEnd();
		if (!texte.hasFocus()) {
			xStart = m_xStart;
			xFinish = m_xFinish;
		}
		if (setParagraphAttributes)
			m_doc.setParagraphAttributes(xStart,xFinish - xStart, attr, false);
		else if (xStart != xFinish)
			m_doc.setCharacterAttributes(xStart,xFinish - xStart, attr, false);
		else {
			MutableAttributeSet inputAttributes = m_kit.getInputAttributes();
			inputAttributes.addAttributes(attr);
		}
	}
	
	protected void showStyles() {
		m_skipUpdate = true;
		if (m_cbStyles.getItemCount() > 0)
			m_cbStyles.removeAllItems();
		Enumeration en = m_doc.getStyleNames();
		while (en.hasMoreElements()) {
			String str = en.nextElement().toString();
			m_cbStyles.addItem(str);
		}
		m_skipUpdate = false;
	}
	
	protected void updateUndo() {
		if(m_undo.canUndo()) {
			m_undoAction.setEnabled(true);
			m_undoAction.putValue(Action.NAME, m_undo.getUndoPresentationName().replace("Dfaire", "Annuler"));
		} else {
			m_undoAction.setEnabled(false);
			m_undoAction.putValue(Action.NAME, "Annuler");
		}
		if(m_undo.canRedo()) {
			m_redoAction.setEnabled(true);
			m_redoAction.putValue(Action.NAME, m_undo.getRedoPresentationName().replace("Refaire", "Rtablir"));
		} else {
			m_redoAction.setEnabled(false);
			m_redoAction.putValue(Action.NAME, "Rtablir");
		}
	}
	
	public Document getDocument() { return m_doc; }
	
	public JTextPane getTextPane() { return texte; }
	
	public void setSelection(int xStart, int xFinish, boolean moveUp) {
		if (moveUp) {
			texte.setCaretPosition(xFinish);
			texte.moveCaretPosition(xStart);
		}
		else
			texte.select(xStart, xFinish);
		m_xStart = texte.getSelectionStart();
		m_xFinish = texte.getSelectionEnd();
	}
	 
	public boolean charger(String chemin) {
		nouveauTexte();
		boolean res = texte.charger(chemin);
		this.validate();
		repaint();
		return res;
	}

	public void creer(String path) {
		nouveauTexte();
		texte.setPath(path);
		texte.enregistrer();
	}
	
	public boolean enregistrer() {
		return texte.enregistrer();
	}

	//	
//	public void copierImage(ImageIcon im) {
//		texte.insertIcon(im);
//	}
//	
	public void coller() {
		texte.paste();
	}
	
	private void nouveauTexte() {
		if (conteneur!=null) {
			if (texte != null) {
				conteneur.remove(texte);
			}
			remove(conteneur);
		}
		texte = new Texte("");	//pas de commentaire ds le carnet !
		texte.addKeyListener(diplomate); //permet la detection d'une modif au niveau du carnet pour permettre l'enregistrement
		m_kit = new RTFEditorKit();
		texte.setEditorKit(m_kit);
		m_context = new StyleContext();
		m_doc = new DefaultStyledDocument(m_context);
		texte.setDocument(m_doc);
		conteneur = new JScrollPane(texte);
		menuBar = createMenuBar();
		m_chooser = new JFileChooser();
		m_chooser.setCurrentDirectory(new File("."));
		m_rtfFilter = new FiltreSimple("RTF Documents", ".rtf");
		m_chooser.setFileFilter(m_rtfFilter);
		
		m_gifFilter = new FiltreSimple("GIF images", ".gif");
		m_jpgFilter = new FiltreSimple("JPG images", ".jpg");
		CaretListener lst = new CaretListener() {
			public void caretUpdate(CaretEvent e) {
				showAttributes(e.getDot());
			}
		};
		texte.addCaretListener(lst);
		
		FocusListener flst = new FocusListener() {
			public void focusGained(FocusEvent e) {
				if (m_xStart>=0 && m_xFinish>=0)
					if (texte.getCaretPosition()==m_xStart) {
						texte.setCaretPosition(m_xFinish);
						texte.moveCaretPosition(m_xStart);
					}
					else
						texte.select(m_xStart, m_xFinish);
			}
			
			public void focusLost(FocusEvent e) {
				m_xStart = texte.getSelectionStart();
				m_xFinish = texte.getSelectionEnd();
			}
		};
		texte.addFocusListener(flst);
		
		showAttributes(0);
		showStyles();
		m_doc.addUndoableEditListener(new Undoer());
		barresConteneur = new JPanel();
		barresConteneur.setLayout(new BorderLayout());
		barresConteneur.add(menuBar, BorderLayout.NORTH);
		barresConteneur.add(toolBar, BorderLayout.SOUTH);
		add(barresConteneur, BorderLayout.NORTH);
		conteneur.setPreferredSize(new Dimension(200, 200));
		this.add(conteneur, BorderLayout.CENTER);
	}

//    private void imprimer() {
//    	PrinterJob printJob = PrinterJob.getPrinterJob();
//    	printJob.setPrintable(texte);
//    	if (printJob.printDialog()) {
//    		try { printJob.print(); }
//    		catch(Exception PrinterExeception) { }
//    	}
//    } 
    
	/**
	 * efface ttes les donnees
	 */
	public void reset() {
		if (conteneur!= null) {
			remove(conteneur);
		}
		if (barresConteneur != null) {
		    barresConteneur.remove(menuBar);
		    barresConteneur.remove(toolBar);
		    remove(barresConteneur);
			barresConteneur = null;
		}
		texte = null;
	}

//	public JTextPane getTexte() {
//		return texte;
//	}
}
