/*
 * Decompiled with CFR 0.152.
 */
package geonoteTypesDonnees;

import geonoteInterface.BarreEtat;
import geonoteInterface.FenetreCalibrageCoord;
import geonoteInterface.Interface;
import geonoteOutils.TraceurCarte;
import geonoteTypesDonnees.Arret;
import geonoteTypesDonnees.Images;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class Carte
extends Images {
    private double echelleLat = 1.0;
    private double echelleLong = 1.0;
    private int latitude1 = -1;
    private int latitude2 = -1;
    private int latitudeOrigine = 0;
    private ArrayList listeArrets = null;
    private int longitude1 = -1;
    private int longitude2 = -1;
    private int longitudeOrigine = 0;
    private boolean pointeurIN = false;
    private boolean modeDefCoord = false;
    private int x1 = -1;
    private int x2 = -1;
    private int xCourant;
    private int y1 = -1;
    private int y2 = -1;
    private int yCourant;
    private FenetreCalibrageCoord fcc = null;
    private Images.MonImageIcon vue = null;
    private boolean reglageTransparence = false;
    private Color couleurArrets = Color.WHITE;
    private String cheminMeta = "";
    private boolean modeDeplacementArret = false;
    private Arret arretADeplacer = null;

    public Carte(String path, double ech, String unit, boolean regletDisp, boolean zoomDisp, boolean modeEd, Interface i, ArrayList list, int latO, int longO, double echLat, double echLong, String couleurArrets, String comment) {
        super(path, ech, unit, regletDisp, zoomDisp, modeEd, i, comment);
        this.cheminMeta = path;
        this.listeArrets = new ArrayList();
        this.latitudeOrigine = latO;
        this.longitudeOrigine = longO;
        this.echelleLat = echLat;
        this.echelleLong = echLong;
        String[] rvb = couleurArrets.split(" ");
        this.couleurArrets = new Color(Integer.parseInt(rvb[0]), Integer.parseInt(rvb[1]), Integer.parseInt(rvb[2]));
        if (list != null) {
            this.listeArrets.addAll(list);
        }
        if (this.modeEdition) {
            this.curseurDefaut = Cursor.getPredefinedCursor(1);
        }
    }

    private boolean present(int id) {
        boolean pr\u00e9sent = false;
        int i = 0;
        while (i < this.listeArrets.size() && !pr\u00e9sent) {
            Arret courant = (Arret)this.listeArrets.get(i);
            int idC = courant.getId();
            if (id == idC) {
                pr\u00e9sent = true;
            }
            ++i;
        }
        return pr\u00e9sent;
    }

    private int rechercheIdLibreMin() {
        int id = 1;
        boolean trouv\u00e9 = false;
        while (!trouv\u00e9) {
            if (!this.present(id)) {
                trouv\u00e9 = true;
                continue;
            }
            ++id;
        }
        return id;
    }

    public void ajoutArret(int x, int y) {
        if (this.modeEdition) {
            Arret rech = this.recherche(x, y);
            if (rech == null) {
                int id = this.rechercheIdLibreMin();
                Arret arretCourant = new Arret(id, x, y);
                this.diplomate.ajouteArretCarte(id, x, y);
                this.listeArrets.add(arretCourant);
            } else {
                ArrayList retour = this.diplomate.ajouteDonneeCarte(rech.getId());
                if (!retour.isEmpty()) {
                    rech.ajouteLien((String)retour.get(0), (String)retour.get(1));
                }
            }
        }
    }

    public void ajouteCoord(int x, int y, int latitudeTemp, int longitudeTemp) {
        if (this.x1 == -1 && this.y1 == -1) {
            this.x1 = x;
            this.y1 = y;
            this.latitude1 = latitudeTemp;
            this.longitude1 = longitudeTemp;
        } else if (this.x2 == -1 && this.y2 == -1) {
            this.x2 = x;
            this.y2 = y;
            this.latitude2 = latitudeTemp;
            this.longitude2 = longitudeTemp;
            this.echelleLong = this.x2 - this.x1 != 0 ? (double)Math.abs(this.longitude2 - this.longitude1) / (double)Math.abs(this.x2 - this.x1) * this.zoom : 0.0;
            this.echelleLat = this.y2 - this.y1 != 0 ? (double)Math.abs(this.latitude2 - this.latitude1) / (double)Math.abs(this.y2 - this.y1) * this.zoom : 0.0;
            this.longitudeOrigine = (int)((double)this.longitude1 - Math.abs((double)this.x1 / this.zoom * this.echelleLong));
            this.latitudeOrigine = (int)((double)this.latitude1 + Math.abs((double)this.y1 / this.zoom * this.echelleLat));
            this.diplomate.ajouteCoordonnees(this.latitudeOrigine, this.longitudeOrigine, this.echelleLat, this.echelleLong);
            this.diplomate.rapportTrace("carte", "ajout coordonnees");
            this.modeDefCoord = false;
        }
    }

    public void mouseClicked(MouseEvent arg0) {
        if (SwingUtilities.isLeftMouseButton(arg0)) {
            if (this.modeEdition && this.modeDefCoord) {
                if (this.fcc == null || !this.fcc.isVisible()) {
                    this.fcc = this.x1 == -1 && this.y1 == -1 ? new FenetreCalibrageCoord(this, "Premier point", arg0.getX(), arg0.getY()) : new FenetreCalibrageCoord(this, "Deuxi\u00e8me point", arg0.getX(), arg0.getY());
                }
            } else if (this.diplomate.isModeSuppArret()) {
                this.suppArret((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
                this.diplomate.rapportTrace("carte", "suppression arret");
            } else {
                this.ajoutArret((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
                this.diplomate.rapportTrace("carte", "ajout arret");
            }
            this.repaint();
        } else if (SwingUtilities.isRightMouseButton(arg0) && this.diplomate.getAAA()) {
            this.ouvertureArret((int)((double)arg0.getX() / this.zoom), (int)((double)arg0.getY() / this.zoom));
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent arg0) {
        super.mousePressed(arg0);
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
        if (SwingUtilities.isRightMouseButton(arg0)) {
            this.reglageTransparence = true;
            String temp = Float.toString(this.image.getTransparency() * 100.0f);
            String transparence = String.valueOf(temp.substring(0, temp.indexOf("."))) + "%";
            BarreEtat.afficheDroite("Transparence : " + transparence);
            this.repaint();
        }
        Arret rech = this.recherche(this.xCourant, this.yCourant);
        if (this.modeEdition && rech != null && this.diplomate.getAAA()) {
            this.modeDeplacementArret = true;
            this.arretADeplacer = rech;
        }
    }

    public void mouseDragged(MouseEvent arg0) {
        super.mouseDragged(arg0);
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
        if (this.modeDeplacementArret) {
            this.arretADeplacer.setX(this.xCourant);
            this.arretADeplacer.setY(this.yCourant);
            this.diplomate.ajouteArretCarte(this.arretADeplacer.getId(), this.xCourant, this.yCourant);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void mouseEntered(MouseEvent arg0) {
        this.pointeurIN = true;
    }

    public void mouseExited(MouseEvent arg0) {
        this.pointeurIN = false;
        this.repaint();
    }

    public void mouseMoved(MouseEvent arg0) {
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
        Arret rech = this.recherche(this.xCourant, this.yCourant);
        if (rech != null && this.diplomate.getAAA()) {
            if (this.diplomate.isModeSuppLien() || this.diplomate.isModeSuppArret()) {
                this.setCursor(this.diplomate.suppCurseur);
            } else {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
            this.repaint();
        } else {
            this.setCursor(this.curseurDefaut);
            this.repaint();
        }
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
    }

    public void mouseReleased(MouseEvent arg0) {
        if (this.regletDispo) {
            if (this.modeEdition && SwingUtilities.isRightMouseButton(arg0) && this.reglet.getLongueur() > 0.0) {
                this.diplomate.ajouteEchelle(this.reglet.getLongueur(), "carte");
                this.diplomate.rapportTrace("carte", "ajout echelle");
            }
            this.regletActif = false;
            BarreEtat.resetDroite();
            this.setCursor(this.curseurDefaut);
            this.diplomate.rapportTrace("reglet", "fin");
            this.repaint();
        }
        this.deplacement = false;
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
        if (this.reglageTransparence) {
            this.reglageTransparence = false;
            BarreEtat.resetDroite();
        }
        if (this.modeDeplacementArret) {
            this.modeDeplacementArret = false;
            this.arretADeplacer = null;
        }
    }

    public void masquerCarte() {
        this.image.setTransparency(0.0f);
    }

    public void mouseWheelMoved(MouseWheelEvent arg0) {
        if (this.reglageTransparence) {
            this.image.setTransparency((float)((double)this.image.getTransparency() - (double)arg0.getWheelRotation() * 0.05));
            String temp = Float.toString(this.image.getTransparency() * 100.0f);
            String transparence = String.valueOf(temp.substring(0, temp.indexOf("."))) + "%";
            BarreEtat.afficheDroite("Transparence : " + transparence);
            this.repaint();
        } else {
            super.mouseWheelMoved(arg0);
        }
        this.xCourant = (int)((double)arg0.getX() / this.zoom);
        this.yCourant = (int)((double)arg0.getY() / this.zoom);
    }

    /*
     * Unable to fully structure code
     */
    private void ouvertureArret(int x, int y) {
        block2: {
            block3: {
                arret = this.recherche(x, y);
                if (arret == null) break block2;
                tr = new TraceurCarte();
                extension = this.cheminMeta.substring(this.cheminMeta.lastIndexOf("."));
                cheminXML = this.cheminMeta.replace(extension, ".xml");
                tr.charger(cheminXML);
                menu = new JPopupMenu("Donn\u00e9es disponibles :");
                liste = arret.exporteListeLiens();
                i = liste.iterator();
                if (!liste.isEmpty()) ** GOTO lbl31
                menu.add(new JMenuItem("VIDE"));
                break block3;
lbl-1000:
                // 1 sources

                {
                    listeDonneesPourUnType = (ArrayList)i.next();
                    it = listeDonneesPourUnType.iterator();
                    type = (String)it.next();
                    item = new JMenu(type);
                    while (it.hasNext()) {
                        fich = (String)it.next();
                        fichItem = new JMenuItem(fich);
                        fichItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent arg0) {
                                if (Carte.this.diplomate != null) {
                                    if (!Carte.this.modeEdition) {
                                        Carte.this.diplomate.afficheNav(fich, "arret");
                                        Carte.this.diplomate.ajoutArretHisto(arret.getId(), fich);
                                        Carte.this.diplomate.rapportTrace("carte", "ouverture donnee georeferencee", fich);
                                    } else if (Carte.this.diplomate.isModeSuppLien()) {
                                        arret.suppLien(fich, type);
                                        Carte.this.diplomate.suppLienEffectue(arret.getId(), fich);
                                        Carte.this.diplomate.rapportTrace("carte", "suppression lien", "arret " + arret.getId(), "lien : " + fich);
                                    }
                                }
                                menu.setVisible(false);
                            }
                        });
                        item.add(fichItem);
                        System.out.println();
                        if (this.modeEdition) continue;
                        fichItem.setEnabled(tr.exporteEtat(fich).equals("accessible"));
                    }
                    menu.add(item);
lbl31:
                    // 2 sources

                    ** while (i.hasNext())
                }
            }
            menu.show(this, (int)((double)x * this.zoom), (int)((double)y * this.zoom));
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke((float)(1.0 / this.zoom)));
        double rapportH = (double)this.getParent().getHeight() / this.image.getIconHeight();
        double rapportL = (double)this.getParent().getWidth() / this.image.getIconWidth();
        double min = Math.min(rapportH, rapportL);
        if (this.zoom == 1.0) {
            this.zoom = min;
        }
        int largImage = (int)(this.image.getIconWidth() * this.zoom);
        int hautImage = (int)(this.image.getIconHeight() * this.zoom);
        Dimension dimension = null;
        if (largImage > this.getParent().getWidth() && hautImage > this.getParent().getHeight()) {
            dimension = new Dimension(largImage, hautImage);
        } else if (largImage > this.getParent().getWidth()) {
            dimension = new Dimension(largImage, this.getParent().getHeight());
        } else if (hautImage > this.getParent().getHeight()) {
            dimension = new Dimension(this.getParent().getWidth(), hautImage);
        } else {
            dimension = new Dimension(this.getParent().getSize());
            this.zoom = min;
        }
        g2.scale(this.zoom, this.zoom);
        if (this.vue != null) {
            this.vue.paint(g2);
        }
        this.image.paint(g2);
        if (this.getSize() != dimension) {
            this.setPreferredSize(dimension);
            this.setSize(dimension);
        }
        if (!this.listeArrets.isEmpty() && this.diplomate.getAAA()) {
            int i = 0;
            while (i < this.listeArrets.size()) {
                Arret temp = (Arret)this.listeArrets.get(i);
                temp.draw(g2, this.zoom, this.couleurArrets);
                ++i;
            }
        }
        int xAff = (int)((double)this.xCourant + 10.0 / this.zoom);
        int yAff = (int)((double)this.yCourant + 10.0 / this.zoom);
        if (this.regletDispo && this.regletActif) {
            this.reglet.draw(g2, this.zoom, this.echelle, this.unit\u00e9);
        }
        if (this.diplomate.getACA() && this.pointeurIN) {
            g2.setStroke(new BasicStroke((float)(1.0 / this.zoom)));
            g2.setColor(Color.white);
            g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
            g2.fillRect(xAff, yAff, (int)(110.0 / this.zoom), (int)(25.0 / this.zoom));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setColor(Color.black);
            g2.drawRect(xAff, yAff, (int)(110.0 / this.zoom), (int)(25.0 / this.zoom));
            if (this.modeEdition && this.modeDefCoord) {
                g.setFont(new Font("Courrier", 0, (int)(15.0 / this.zoom)));
                String texte = "";
                if (this.x1 == -1 && this.y1 == -1) {
                    texte = "Premier point";
                } else if (this.x2 == -1 && this.y2 == -1) {
                    texte = "Deuxieme point";
                }
                g2.drawString(texte, (int)((double)xAff + 3.0 / this.zoom), (int)((double)yAff + 18.0 / this.zoom));
            } else {
                int longitude = (int)((double)this.longitudeOrigine + (double)this.xCourant * this.echelleLong);
                int latitude = (int)((double)this.latitudeOrigine - (double)this.yCourant * this.echelleLat);
                int degres = latitude / 3600;
                int minutes = (latitude - degres * 3600) / 60;
                int secondes = latitude - degres * 3600 - minutes * 60;
                g.setFont(new Font("Courrier", 0, (int)(10.0 / this.zoom)));
                g2.drawString("Latitude : " + Integer.toString(degres) + "\u00b0" + Integer.toString(minutes) + "'" + Integer.toString(secondes) + "\"", (int)((double)xAff + 3.0 / this.zoom), (int)((double)yAff + 23.0 / this.zoom));
                degres = longitude / 3600;
                minutes = (longitude - degres * 3600) / 60;
                secondes = longitude - degres * 3600 - minutes * 60;
                g2.drawString("Longitude : " + Integer.toString(degres) + "\u00b0" + Integer.toString(minutes) + "'" + Integer.toString(secondes) + "\"", (int)((double)xAff + 3.0 / this.zoom), (int)((double)yAff + 11.0 / this.zoom));
            }
        }
        g2.dispose();
    }

    public void VueVersCarte() {
        if (this.vue != null) {
            this.image = this.vue;
            this.chemin = this.vue.getChemin();
        }
    }

    public void chargerCouleurArrets(String coul) {
        String[] rvb = coul.split(" ");
        this.couleurArrets = new Color(Integer.parseInt(rvb[0]), Integer.parseInt(rvb[1]), Integer.parseInt(rvb[2]));
    }

    public void chargerVue(String path) {
        this.vue = new Images.MonImageIcon(this, path);
        this.repaint();
    }

    private Arret recherche(int x, int y) {
        Arret cible = null;
        boolean trouve = false;
        int i = 0;
        while (i < this.listeArrets.size() && !trouve) {
            Arret temp = (Arret)this.listeArrets.get(i);
            if ((double)x >= (double)temp.getX() - (double)temp.getDiametre() / (2.0 * this.zoom) && (double)x <= (double)temp.getX() + (double)temp.getDiametre() / (2.0 * this.zoom) && (double)y >= (double)temp.getY() - (double)temp.getDiametre() / (2.0 * this.zoom) && (double)y <= (double)temp.getY() + (double)temp.getDiametre() / (2.0 * this.zoom)) {
                cible = temp;
                trouve = true;
            }
            ++i;
        }
        return cible;
    }

    private void suppArret(int x, int y) {
        Arret rech;
        if (this.modeEdition && (rech = this.recherche(x, y)) != null) {
            this.listeArrets.remove(rech);
            this.diplomate.suppArretEffectue(rech.getId());
            this.diplomate.rapportTrace("carte", "suppression arret", "arret " + rech.getId());
        }
    }

    public void activerModeDefCoord() {
        this.modeDefCoord = true;
    }

    public void desactiverModeDefCoord() {
        this.modeDefCoord = false;
    }

    public String exporteCheminCarte() {
        return this.chemin;
    }

    public String exporteCheminVue() {
        if (this.vue == null) {
            return null;
        }
        return this.vue.getChemin();
    }
}

