/*
 * Decompiled with CFR 0.152.
 */
package geonoteTypesDonnees;

import geonoteInterface.BarreEtat;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.rtf.RTFEditorKit;

public class Texte
extends JTextPane
implements Printable,
MouseListener {
    private String path = "";
    private RTFEditorKit rtf = new RTFEditorKit();
    private String commentaire = "";

    public Texte(String commentaire) {
        this.commentaire = commentaire;
        this.setEditorKit(this.rtf);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.setBorder(BorderFactory.createLineBorder(Color.white, 5));
    }

    public boolean charger(String path) {
        boolean retour = false;
        try {
            FileInputStream fi = new FileInputStream(path);
            this.rtf.read(fi, this.getDocument(), 0);
            this.path = path;
            retour = true;
        }
        catch (FileNotFoundException e) {
            System.out.println("Fichier introuvable (" + path + ")");
        }
        catch (IOException e) {
            System.out.println("I/O error");
        }
        catch (BadLocationException e) {
            System.out.println("Chemin incorrect");
        }
        return retour;
    }

    public boolean enregistrer() {
        boolean retour = false;
        try {
            FileOutputStream fi = new FileOutputStream(this.path);
            this.rtf.write(fi, this.getDocument(), this.getDocument().getLength(), 0);
            retour = true;
        }
        catch (FileNotFoundException e) {
            System.out.println("Fichier introuvable (" + this.path + ")");
        }
        catch (IOException e) {
            System.out.println("I/O error");
        }
        catch (BadLocationException e) {
            System.out.println("Chemin incorrect");
        }
        return retour;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        g.translate(10, 10);
        Font f = new Font("Monospaced", 0, 12);
        g.setFont(f);
        this.paint(g);
        return 0;
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
        if (this.commentaire.length() > 0) {
            BarreEtat.afficheGauche("Commentaire : " + this.commentaire);
        }
    }

    public void mouseExited(MouseEvent arg0) {
        BarreEtat.resetGauche();
    }
}

