/*
 * Decompiled with CFR 0.152.
 */
package geonoteInterface;

import geonoteInterface.Interface;
import geonoteOutils.FiltreExtensible;
import geonoteOutils.ImagePreview;
import geonoteOutils.Traceur;
import geonoteOutils.TraceurCarte;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FenetreParametrage
extends JFrame {
    private ArrayList listeDonneesCarte = null;
    private TraceurCarte traceurCarte = null;
    private Interface diplomate = null;

    public FenetreParametrage(Interface inter, final String dossierCarte, final String dossierDocs, final String dossierGeorefs, String dossierTravail) {
        super("Parametrage");
        this.setLayout(new BorderLayout());
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.diplomate = inter;
        final Box vBoxListeG = Box.createVerticalBox();
        Box vBoxG = Box.createVerticalBox();
        final Box hBoxRadioG = Box.createHorizontalBox();
        Box hBoxCarte = Box.createHorizontalBox();
        hBoxCarte.add(Box.createHorizontalStrut(5));
        hBoxCarte.add(new JLabel("Carte :"));
        hBoxCarte.add(Box.createHorizontalStrut(5));
        final JLabel jl = new JLabel("...");
        hBoxCarte.add(jl);
        hBoxCarte.add(Box.createGlue());
        hBoxCarte.add(Box.createHorizontalStrut(5));
        JButton parcours = new JButton("Parcourir ...");
        parcours.grabFocus();
        parcours.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser(dossierCarte);
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle("Choix de la carte \u00e0 parametrer");
                FiltreExtensible filtre = new FiltreExtensible("Cartes");
                filtre.addExtension(".jpg");
                filtre.addExtension(".gif");
                chooser.addChoosableFileFilter(filtre);
                chooser.setAccessory(new ImagePreview(chooser));
                int returnVal = chooser.showOpenDialog(chooser.getParent());
                if (returnVal == 0) {
                    String fich = chooser.getSelectedFile().getPath();
                    String ext = fich.substring(fich.lastIndexOf("."));
                    String fichXML = fich.replace(ext, ".xml");
                    FenetreParametrage.this.traceurCarte = new TraceurCarte();
                    boolean res = FenetreParametrage.this.traceurCarte.charger(fichXML);
                    if (!res) {
                        JOptionPane.showMessageDialog(new JFrame(), "La carte que vous avez voulu ouvrir ne poss\u00e8de pas de m\u00e9tadonn\u00e9es !", "ERREUR !", 2);
                    } else {
                        FenetreParametrage.this.activer(vBoxListeG, true);
                        FenetreParametrage.this.activer(hBoxRadioG, true);
                        jl.setText(chooser.getSelectedFile().getName());
                        FenetreParametrage.this.listeDonneesCarte = FenetreParametrage.this.traceurCarte.exporteFichiers();
                        Component[] listeG = vBoxListeG.getComponents();
                        int it = 0;
                        while (it < listeG.length) {
                            if (listeG[it].getClass().getName().contains("JCheckBox")) {
                                JCheckBox cb = (JCheckBox)listeG[it];
                                if (FenetreParametrage.this.listeDonneesCarte.contains(cb.getText())) {
                                    listeG[it].setEnabled(true);
                                    ((JCheckBox)listeG[it]).setSelected(FenetreParametrage.this.traceurCarte.exporteEtat(cb.getText()).equals("accessible"));
                                } else {
                                    listeG[it].setEnabled(false);
                                }
                            }
                            ++it;
                        }
                    }
                }
            }
        });
        hBoxCarte.add(parcours);
        hBoxCarte.add(Box.createHorizontalStrut(5));
        vBoxListeG.setBorder(BorderFactory.createTitledBorder("Donn\u00e9es"));
        ArrayList listeFichiersG = this.listeRepertoire(new File(dossierGeorefs));
        Iterator j = listeFichiersG.iterator();
        while (j.hasNext()) {
            String chemin = (String)j.next();
            final String nomFichier = chemin.substring(chemin.lastIndexOf("\\") + 1, chemin.length());
            Traceur traceur = new Traceur();
            String extension = chemin.substring(chemin.lastIndexOf("."));
            String cheminXML = chemin.replace(extension, ".xml");
            boolean retour = traceur.charger(cheminXML);
            if (!retour) continue;
            final JCheckBox jcb = new JCheckBox(nomFichier);
            jcb.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent arg0) {
                    if (FenetreParametrage.this.listeDonneesCarte != null && FenetreParametrage.this.listeDonneesCarte.contains(nomFichier)) {
                        if (jcb.isSelected()) {
                            if (!FenetreParametrage.this.traceurCarte.exporteEtat(nomFichier).equals("accessible")) {
                                FenetreParametrage.this.traceurCarte.ajouteEtat(nomFichier, "accessible");
                                FenetreParametrage.this.traceurCarte.enregistrer();
                            }
                        } else if (!FenetreParametrage.this.traceurCarte.exporteEtat(nomFichier).equals("inaccessible")) {
                            FenetreParametrage.this.traceurCarte.ajouteEtat(nomFichier, "inaccessible");
                            FenetreParametrage.this.traceurCarte.enregistrer();
                        }
                        jcb.setSelected(FenetreParametrage.this.traceurCarte.exporteEtat(nomFichier).equals("accessible"));
                    }
                }
            });
            vBoxListeG.add(jcb);
            vBoxListeG.add(Box.createVerticalStrut(5));
        }
        final Box hBoxNivoG = Box.createHorizontalBox();
        hBoxNivoG.setBorder(BorderFactory.createTitledBorder("Niveaux"));
        hBoxNivoG.add(Box.createHorizontalStrut(5));
        final JCheckBox jcbG1 = new JCheckBox("Coll\u00e8ge");
        jcbG1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                FenetreParametrage.this.selectionParNiveauEtCarte("college", dossierGeorefs, jcbG1.isSelected());
            }
        });
        hBoxNivoG.add(jcbG1);
        hBoxNivoG.add(Box.createHorizontalStrut(5));
        final JCheckBox jcbG2 = new JCheckBox("Lyc\u00e9e");
        jcbG2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                FenetreParametrage.this.selectionParNiveauEtCarte("lycee", dossierGeorefs, jcbG2.isSelected());
            }
        });
        hBoxNivoG.add(jcbG2);
        hBoxNivoG.add(Box.createHorizontalStrut(5));
        final JCheckBox jcbG3 = new JCheckBox("Universit\u00e9");
        jcbG3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                FenetreParametrage.this.selectionParNiveauEtCarte("universite", dossierGeorefs, jcbG3.isSelected());
            }
        });
        hBoxNivoG.add(jcbG3);
        hBoxNivoG.add(Box.createHorizontalStrut(5));
        hBoxRadioG.add(Box.createHorizontalStrut(5));
        hBoxRadioG.add(new JLabel("Gestion des droits d'acc\u00e8s :"));
        hBoxRadioG.add(Box.createHorizontalStrut(5));
        final JRadioButton jrbG1 = new JRadioButton("par niveau");
        JRadioButton jrbG2 = new JRadioButton("pour chaque donn\u00e9e");
        ButtonGroup groupG = new ButtonGroup();
        groupG.add(jrbG1);
        groupG.add(jrbG2);
        jrbG1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                Component[] listeComposants = vBoxListeG.getComponents();
                int i = 0;
                while (i < listeComposants.length) {
                    listeComposants[i].setEnabled(!jrbG1.isSelected());
                    ++i;
                }
                Component[] nivoComposants = hBoxNivoG.getComponents();
                int i2 = 0;
                while (i2 < nivoComposants.length) {
                    nivoComposants[i2].setEnabled(jrbG1.isSelected());
                    ++i2;
                }
            }
        });
        hBoxRadioG.add(jrbG1);
        jrbG2.setSelected(true);
        Component[] nivoComposantsG = hBoxNivoG.getComponents();
        int k = 0;
        while (k < nivoComposantsG.length) {
            nivoComposantsG[k].setEnabled(false);
            ++k;
        }
        hBoxRadioG.add(jrbG2);
        hBoxRadioG.add(Box.createHorizontalStrut(5));
        vBoxG.setBorder(BorderFactory.createTitledBorder("Donn\u00e9es g\u00e9or\u00e9f\u00e9renc\u00e9es"));
        vBoxG.add(hBoxCarte);
        vBoxG.add(Box.createVerticalStrut(5));
        vBoxG.add(hBoxRadioG);
        vBoxG.add(Box.createVerticalStrut(5));
        vBoxG.add(hBoxNivoG);
        vBoxG.add(Box.createVerticalStrut(5));
        Box htempG = Box.createHorizontalBox();
        htempG.add(Box.createGlue());
        htempG.add(vBoxListeG);
        htempG.add(Box.createGlue());
        vBoxG.add(htempG);
        vBoxG.add(Box.createGlue());
        vBoxG.add(Box.createVerticalStrut(5));
        this.activer(hBoxRadioG, false);
        this.activer(hBoxNivoG, false);
        this.activer(vBoxListeG, false);
        final Box vBoxListeD = Box.createVerticalBox();
        vBoxListeD.setBorder(BorderFactory.createTitledBorder("Donn\u00e9es"));
        vBoxListeD.add(Box.createVerticalStrut(5));
        ArrayList listeFichiersD = this.listeRepertoire(new File(dossierDocs));
        Iterator i = listeFichiersD.iterator();
        while (i.hasNext()) {
            String chemin = (String)i.next();
            String nomFichier = chemin.substring(chemin.lastIndexOf("\\") + 1, chemin.length());
            final Traceur traceur = new Traceur();
            String extension = chemin.substring(chemin.lastIndexOf("."));
            String cheminXML = chemin.replace(extension, ".xml");
            boolean retour = traceur.charger(cheminXML);
            if (!retour) continue;
            final JCheckBox jcb = new JCheckBox(nomFichier);
            if (traceur.exporteInfo("etat") != null) {
                jcb.setSelected(traceur.exporteInfo("etat").equals("accessible"));
            } else {
                jcb.setSelected(true);
            }
            jcb.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent arg0) {
                    if (jcb.isSelected()) {
                        if (!traceur.exporteInfo("etat").equals("accessible")) {
                            traceur.ajouterElt("etat", "accessible");
                            traceur.enregistrer();
                        }
                    } else if (!traceur.exporteInfo("etat").equals("inaccessible")) {
                        traceur.ajouterElt("etat", "inaccessible");
                        traceur.enregistrer();
                    }
                }
            });
            vBoxListeD.add(jcb);
            vBoxListeD.add(Box.createVerticalStrut(5));
        }
        final Box hBoxNivoD = Box.createHorizontalBox();
        hBoxNivoD.setBorder(BorderFactory.createTitledBorder("Niveaux"));
        hBoxNivoD.add(Box.createHorizontalStrut(5));
        final JCheckBox jcbD1 = new JCheckBox("Coll\u00e8ge");
        jcbD1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                if (jcbD1.isEnabled()) {
                    FenetreParametrage.this.selectionParNiveau("college", dossierDocs, jcbD1.isSelected());
                }
            }
        });
        hBoxNivoD.add(jcbD1);
        hBoxNivoD.add(Box.createHorizontalStrut(5));
        final JCheckBox jcbD2 = new JCheckBox("Lyc\u00e9e");
        jcbD2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                if (jcbD2.isEnabled()) {
                    FenetreParametrage.this.selectionParNiveau("lycee", dossierDocs, jcbD2.isSelected());
                }
            }
        });
        hBoxNivoD.add(jcbD2);
        hBoxNivoD.add(Box.createHorizontalStrut(5));
        final JCheckBox jcbD3 = new JCheckBox("Universit\u00e9");
        jcbD3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                if (jcbD3.isEnabled()) {
                    FenetreParametrage.this.selectionParNiveau("universite", dossierDocs, jcbD3.isSelected());
                }
            }
        });
        hBoxNivoD.add(jcbD3);
        hBoxNivoD.add(Box.createHorizontalStrut(5));
        Box hBoxRadioD = Box.createHorizontalBox();
        hBoxRadioD.add(Box.createHorizontalStrut(5));
        hBoxRadioD.add(new JLabel("Gestion des droits d'acc\u00e8s :"));
        hBoxRadioD.add(Box.createHorizontalStrut(5));
        final JRadioButton jrbD1 = new JRadioButton("par niveau");
        JRadioButton jrbD2 = new JRadioButton("pour chaque donn\u00e9e");
        ButtonGroup groupD = new ButtonGroup();
        groupD.add(jrbD1);
        groupD.add(jrbD2);
        jrbD1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                Component[] listeComposants = vBoxListeD.getComponents();
                int i = 0;
                while (i < listeComposants.length) {
                    listeComposants[i].setEnabled(!jrbD1.isSelected());
                    if (listeComposants[i].getClass().getName().contains("JCheckBox")) {
                        ((JCheckBox)listeComposants[i]).setSelected(!jrbD1.isSelected());
                    }
                    ++i;
                }
                Component[] nivoComposants = hBoxNivoD.getComponents();
                int i2 = 0;
                while (i2 < nivoComposants.length) {
                    nivoComposants[i2].setEnabled(jrbD1.isSelected());
                    if (nivoComposants[i2].getClass().getName().contains("JCheckBox")) {
                        ((JCheckBox)nivoComposants[i2]).setSelected(jrbD1.isSelected());
                    }
                    ++i2;
                }
            }
        });
        hBoxRadioD.add(jrbD1);
        jrbD2.setSelected(true);
        Component[] nivoComposantsD = hBoxNivoD.getComponents();
        int k2 = 0;
        while (k2 < nivoComposantsD.length) {
            nivoComposantsD[k2].setEnabled(false);
            ++k2;
        }
        hBoxRadioD.add(jrbD2);
        hBoxRadioD.add(Box.createHorizontalStrut(5));
        Box vBoxD = Box.createVerticalBox();
        vBoxD.setBorder(BorderFactory.createTitledBorder("Documentation"));
        vBoxD.add(hBoxRadioD);
        vBoxD.add(Box.createVerticalStrut(5));
        vBoxD.add(hBoxNivoD);
        vBoxD.add(Box.createVerticalStrut(5));
        Box htempD = Box.createHorizontalBox();
        htempD.add(Box.createGlue());
        htempD.add(vBoxListeD);
        htempD.add(Box.createGlue());
        vBoxD.add(htempD);
        vBoxD.add(Box.createGlue());
        Box hBoxH = Box.createHorizontalBox();
        hBoxH.add(Box.createHorizontalStrut(5));
        hBoxH.add(vBoxG);
        hBoxH.add(Box.createHorizontalStrut(5));
        hBoxH.add(vBoxD);
        hBoxH.add(Box.createHorizontalStrut(5));
        Box hBoxB = Box.createHorizontalBox();
        final JCheckBox cb = new JCheckBox("Tra\u00e7age actif");
        final Traceur tr = new Traceur();
        tr.charger(String.valueOf(dossierTravail) + ".conf");
        cb.setSelected(tr.exporteInfo("traces").equals("actives"));
        cb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                FenetreParametrage.this.diplomate.activerTraces(cb.isSelected());
                String mode = cb.isSelected() ? "actives" : "inactives";
                if (!mode.equals(tr.exporteInfo("traces"))) {
                    tr.ajouterElt("traces", mode);
                    tr.enregistrer();
                }
            }
        });
        hBoxB.add(Box.createGlue());
        JButton quitterBouton = new JButton("OK");
        quitterBouton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FenetreParametrage.this.dispose();
            }
        });
        hBoxB.add(quitterBouton);
        hBoxB.add(Box.createHorizontalStrut(5));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(5));
        JScrollPane jsp = new JScrollPane(hBoxH);
        vBox.add(jsp);
        vBox.add(Box.createGlue());
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(hBoxB);
        vBox.add(Box.createVerticalStrut(5));
        this.add((Component)vBox, "Center");
        this.setVisible(true);
    }

    private ArrayList listeRepertoire(File repertoire) {
        ArrayList<String> liste = new ArrayList<String>();
        if (repertoire.isDirectory()) {
            File[] list = repertoire.listFiles();
            int i = 0;
            while (i < list.length) {
                liste.addAll(this.listeRepertoire(list[i]));
                ++i;
            }
        } else if (repertoire.getAbsolutePath().contains(".") && !repertoire.getAbsolutePath().contains(".xml")) {
            liste.add(repertoire.getAbsolutePath());
        }
        return liste;
    }

    private void selectionParNiveau(String nivo, String dossier, boolean selection) {
        ArrayList listeFichiers = this.listeRepertoire(new File(dossier));
        Iterator i = listeFichiers.iterator();
        while (i.hasNext()) {
            String niveau;
            String chemin = (String)i.next();
            String nomFichier = chemin.substring(chemin.lastIndexOf("\\") + 1, chemin.length());
            Traceur traceurS = new Traceur();
            String extension = chemin.substring(chemin.lastIndexOf("."));
            String cheminXML = chemin.replace(extension, ".xml");
            boolean retour = traceurS.charger(cheminXML);
            if (!retour || !(niveau = traceurS.exporteInfo("niveau")).contains(nivo)) continue;
            if (selection) {
                if (traceurS.exporteInfo("etat").equals("accessible")) continue;
                traceurS.ajouterElt("etat", "accessible");
                traceurS.enregistrer();
                continue;
            }
            if (traceurS.exporteInfo("etat").equals("inaccessible")) continue;
            traceurS.ajouterElt("etat", "inaccessible");
            traceurS.enregistrer();
        }
    }

    private void selectionParNiveauEtCarte(String nivo, String dossier, boolean selection) {
        ArrayList listeFichiers = this.listeRepertoire(new File(dossier));
        Iterator i = listeFichiers.iterator();
        while (i.hasNext()) {
            String chemin = (String)i.next();
            String nomFichier = chemin.substring(chemin.lastIndexOf("\\") + 1, chemin.length());
            Traceur traceur = new Traceur();
            String extension = chemin.substring(chemin.lastIndexOf("."));
            String cheminXML = chemin.replace(extension, ".xml");
            boolean retour = traceur.charger(cheminXML);
            if (!retour) continue;
            String niveau = traceur.exporteInfo("niveau");
            if (this.listeDonneesCarte == null || !niveau.contains(nivo) || !this.listeDonneesCarte.contains(nomFichier)) continue;
            if (selection) {
                if (this.traceurCarte.exporteEtat(nomFichier).equals("accessible")) continue;
                this.traceurCarte.ajouteEtat(nomFichier, "accessible");
                this.traceurCarte.enregistrer();
                continue;
            }
            if (this.traceurCarte.exporteEtat(nomFichier).equals("inaccessible")) continue;
            this.traceurCarte.ajouteEtat(nomFichier, "inaccessible");
            this.traceurCarte.enregistrer();
        }
    }

    private void activer(Component boite, boolean b) {
        boite.setEnabled(b);
        Component[] contenu = ((Container)boite).getComponents();
        int i = 0;
        while (i < contenu.length) {
            this.activer(contenu[i], b);
            ++i;
        }
    }
}

