/*
 * Decompiled with CFR 0.152.
 */
package geonoteOutils;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.border.TitledBorder;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private ImageIcon thumbnail = null;
    private File file = null;
    private int largMax = 185;
    private int hautMax = 230;

    public ImagePreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(this.largMax + 15, this.hautMax + 20));
        this.setBorder(new TitledBorder("Aper\u00e7u"));
        fc.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.file == null) {
            this.thumbnail = null;
            return;
        }
        ImageIcon tmpIcon = new ImageIcon(this.file.getPath());
        if (tmpIcon != null) {
            int iconLarg = tmpIcon.getIconWidth();
            int iconHaut = tmpIcon.getIconHeight();
            this.thumbnail = iconLarg > this.largMax || iconHaut > this.hautMax ? (iconHaut - this.hautMax > iconLarg - this.largMax ? new ImageIcon(tmpIcon.getImage().getScaledInstance(-1, this.hautMax, 1)) : new ImageIcon(tmpIcon.getImage().getScaledInstance(this.largMax, -1, 1))) : tmpIcon;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2 + 6;
            if (y < 6) {
                y = 6;
            }
            if (x < 3) {
                x = 3;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

