/*
 * Decompiled with CFR 0.152.
 */
package geonoteOutilsCarnet;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class ColorMenu
extends JMenu {
    protected Border m_unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
    protected Border m_selectedBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
    protected Border m_activeBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
    protected Hashtable m_panes;
    protected ColorPane m_selected;

    public ColorMenu(String name) {
        super(name);
        JPanel p = new JPanel();
        p.setBorder(new EmptyBorder(5, 5, 5, 5));
        p.setLayout(new GridLayout(8, 8));
        this.m_panes = new Hashtable();
        int[] nArray = new int[4];
        nArray[1] = 128;
        nArray[2] = 192;
        nArray[3] = 255;
        int[] values = nArray;
        int r = 0;
        while (r < values.length) {
            int g = 0;
            while (g < values.length) {
                int b = 0;
                while (b < values.length) {
                    Color c = new Color(values[r], values[g], values[b]);
                    ColorPane pn = new ColorPane(c);
                    p.add(pn);
                    this.m_panes.put(c, pn);
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        this.add(p);
    }

    public void setColor(Color c) {
        Object obj = this.m_panes.get(c);
        if (obj == null) {
            return;
        }
        if (this.m_selected != null) {
            this.m_selected.setSelected(false);
        }
        this.m_selected = (ColorPane)obj;
        this.m_selected.setSelected(true);
    }

    public Color getColor() {
        if (this.m_selected == null) {
            return null;
        }
        return this.m_selected.getColor();
    }

    public void doSelection() {
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    public class ColorPane
    extends JPanel
    implements MouseListener {
        protected Color m_c;
        protected boolean m_selected;

        public ColorPane(Color c) {
            this.m_c = c;
            this.setBackground(c);
            this.setBorder(ColorMenu.this.m_unselectedBorder);
            String msg = "R " + c.getRed() + ", V " + c.getGreen() + ", B " + c.getBlue();
            this.setToolTipText(msg);
            this.addMouseListener(this);
        }

        public Color getColor() {
            return this.m_c;
        }

        public Dimension getPreferredSize() {
            return new Dimension(15, 15);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setSelected(boolean selected) {
            this.m_selected = selected;
            if (this.m_selected) {
                this.setBorder(ColorMenu.this.m_selectedBorder);
            } else {
                this.setBorder(ColorMenu.this.m_unselectedBorder);
            }
        }

        public boolean isSelected() {
            return this.m_selected;
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            ColorMenu.this.setColor(this.m_c);
            MenuSelectionManager.defaultManager().clearSelectedPath();
            ColorMenu.this.doSelection();
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.setBorder(ColorMenu.this.m_activeBorder);
        }

        public void mouseExited(MouseEvent e) {
            this.setBorder(this.m_selected ? ColorMenu.this.m_selectedBorder : ColorMenu.this.m_unselectedBorder);
        }
    }
}

