/*
 * Decompiled with CFR 0.152.
 */
package geonoteOutilsCarnet;

import geonoteOutilsCarnet.SmallToggleButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Random;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ParagraphDialog
extends JDialog {
    protected int m_option = -1;
    protected MutableAttributeSet m_attributes;
    protected JTextField m_lineSpacing;
    protected JTextField m_spaceAbove;
    protected JTextField m_spaceBelow;
    protected JTextField m_firstIndent;
    protected JTextField m_leftIndent;
    protected JTextField m_rightIndent;
    protected SmallToggleButton m_btLeft;
    protected SmallToggleButton m_btCenter;
    protected SmallToggleButton m_btRight;
    protected SmallToggleButton m_btJustified;
    protected ParagraphPreview m_preview;

    public ParagraphDialog(JFrame parent, String dossierSysteme) {
        super(parent, "Paragraph", true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p = new JPanel(new GridLayout(1, 2, 5, 2));
        JPanel ps = new JPanel(new GridLayout(3, 2, 10, 2));
        ps.setBorder(new TitledBorder(new EtchedBorder(), "Space"));
        ps.add(new JLabel("Line spacing:"));
        this.m_lineSpacing = new JTextField();
        ps.add(this.m_lineSpacing);
        ps.add(new JLabel("Space above:"));
        this.m_spaceAbove = new JTextField();
        ps.add(this.m_spaceAbove);
        ps.add(new JLabel("Space below:"));
        this.m_spaceBelow = new JTextField();
        ps.add(this.m_spaceBelow);
        p.add(ps);
        JPanel pi = new JPanel(new GridLayout(3, 2, 10, 2));
        pi.setBorder(new TitledBorder(new EtchedBorder(), "Indent"));
        pi.add(new JLabel("First indent:"));
        this.m_firstIndent = new JTextField();
        pi.add(this.m_firstIndent);
        pi.add(new JLabel("Left indent:"));
        this.m_leftIndent = new JTextField();
        pi.add(this.m_leftIndent);
        pi.add(new JLabel("Right indent:"));
        this.m_rightIndent = new JTextField();
        pi.add(this.m_rightIndent);
        p.add(pi);
        this.getContentPane().add(p);
        this.getContentPane().add(Box.createVerticalStrut(5));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalStrut(10));
        p.add(new JLabel("Alignment:"));
        p.add(Box.createHorizontalStrut(20));
        ButtonGroup bg = new ButtonGroup();
        ImageIcon img = new ImageIcon(String.valueOf(dossierSysteme) + "gauche.gif");
        this.m_btLeft = new SmallToggleButton(false, img, img, "Left");
        bg.add(this.m_btLeft);
        p.add(this.m_btLeft);
        img = new ImageIcon(String.valueOf(dossierSysteme) + "centre.gif");
        this.m_btCenter = new SmallToggleButton(false, img, img, "Center");
        bg.add(this.m_btCenter);
        p.add(this.m_btCenter);
        img = new ImageIcon(String.valueOf(dossierSysteme) + "droite.gif");
        this.m_btRight = new SmallToggleButton(false, img, img, "Right");
        bg.add(this.m_btRight);
        p.add(this.m_btRight);
        img = new ImageIcon(String.valueOf(dossierSysteme) + "justifie.gif");
        this.m_btJustified = new SmallToggleButton(false, img, img, "Justify");
        bg.add(this.m_btJustified);
        p.add(this.m_btJustified);
        this.getContentPane().add(p);
        p = new JPanel(new BorderLayout());
        p.setBorder(new TitledBorder(new EtchedBorder(), "Preview"));
        this.m_preview = new ParagraphPreview();
        p.add((Component)this.m_preview, "Center");
        this.getContentPane().add(p);
        p = new JPanel(new FlowLayout());
        JPanel p1 = new JPanel(new GridLayout(1, 2, 10, 2));
        JButton btOK = new JButton("OK");
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParagraphDialog.this.m_option = 0;
                ParagraphDialog.this.setVisible(false);
            }
        };
        btOK.addActionListener(lst);
        p1.add(btOK);
        JButton btCancel = new JButton("Cancel");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParagraphDialog.this.m_option = 2;
                ParagraphDialog.this.setVisible(false);
            }
        };
        btCancel.addActionListener(lst);
        p1.add(btCancel);
        p.add(p1);
        this.getContentPane().add(p);
        this.pack();
        this.setResizable(false);
        FocusListener flst = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ParagraphDialog.this.updatePreview();
            }
        };
        this.m_lineSpacing.addFocusListener(flst);
        this.m_spaceAbove.addFocusListener(flst);
        this.m_spaceBelow.addFocusListener(flst);
        this.m_firstIndent.addFocusListener(flst);
        this.m_leftIndent.addFocusListener(flst);
        this.m_rightIndent.addFocusListener(flst);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParagraphDialog.this.updatePreview();
            }
        };
        this.m_btLeft.addActionListener(lst);
        this.m_btCenter.addActionListener(lst);
        this.m_btRight.addActionListener(lst);
        this.m_btJustified.addActionListener(lst);
    }

    public void setAttributes(AttributeSet a) {
        this.m_attributes = new SimpleAttributeSet(a);
        this.m_lineSpacing.setText(Float.toString(StyleConstants.getLineSpacing(a)));
        this.m_spaceAbove.setText(Float.toString(StyleConstants.getSpaceAbove(a)));
        this.m_spaceBelow.setText(Float.toString(StyleConstants.getSpaceBelow(a)));
        this.m_firstIndent.setText(Float.toString(StyleConstants.getFirstLineIndent(a)));
        this.m_leftIndent.setText(Float.toString(StyleConstants.getLeftIndent(a)));
        this.m_rightIndent.setText(Float.toString(StyleConstants.getRightIndent(a)));
        int alignment = StyleConstants.getAlignment(a);
        if (alignment == 0) {
            this.m_btLeft.setSelected(true);
        } else if (alignment == 1) {
            this.m_btCenter.setSelected(true);
        } else if (alignment == 2) {
            this.m_btRight.setSelected(true);
        } else if (alignment == 3) {
            this.m_btJustified.setSelected(true);
        }
        this.updatePreview();
    }

    public AttributeSet getAttributes() {
        float value;
        if (this.m_attributes == null) {
            return null;
        }
        try {
            value = Float.parseFloat(this.m_lineSpacing.getText());
            StyleConstants.setLineSpacing(this.m_attributes, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            value = Float.parseFloat(this.m_spaceAbove.getText());
            StyleConstants.setSpaceAbove(this.m_attributes, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            value = Float.parseFloat(this.m_spaceBelow.getText());
            StyleConstants.setSpaceBelow(this.m_attributes, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            value = Float.parseFloat(this.m_firstIndent.getText());
            StyleConstants.setFirstLineIndent(this.m_attributes, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            value = Float.parseFloat(this.m_leftIndent.getText());
            StyleConstants.setLeftIndent(this.m_attributes, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            value = Float.parseFloat(this.m_rightIndent.getText());
            StyleConstants.setRightIndent(this.m_attributes, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        StyleConstants.setAlignment(this.m_attributes, this.getAlignment());
        return this.m_attributes;
    }

    public int getOption() {
        return this.m_option;
    }

    protected void updatePreview() {
        this.m_preview.repaint();
    }

    protected int getAlignment() {
        if (this.m_btLeft.isSelected()) {
            return 0;
        }
        if (this.m_btCenter.isSelected()) {
            return 1;
        }
        if (this.m_btRight.isSelected()) {
            return 2;
        }
        return 3;
    }

    class ParagraphPreview
    extends JPanel {
        protected Font m_fn = new Font("Monospace", 0, 6);
        protected String m_dummy = "abcdefghjklm";
        protected float m_scaleX = 0.25f;
        protected float m_scaleY = 0.25f;
        protected Random m_random = new Random();

        public ParagraphPreview() {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.setOpaque(true);
            this.setBorder(new LineBorder(Color.black));
            this.setPreferredSize(new Dimension(120, 56));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            float lineSpacing = 0.0f;
            float spaceAbove = 0.0f;
            float spaceBelow = 0.0f;
            float firstIndent = 0.0f;
            float leftIndent = 0.0f;
            float rightIndent = 0.0f;
            try {
                lineSpacing = Float.parseFloat(ParagraphDialog.this.m_lineSpacing.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                spaceAbove = Float.parseFloat(ParagraphDialog.this.m_spaceAbove.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                spaceBelow = Float.parseFloat(ParagraphDialog.this.m_spaceBelow.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                firstIndent = Float.parseFloat(ParagraphDialog.this.m_firstIndent.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                leftIndent = Float.parseFloat(ParagraphDialog.this.m_leftIndent.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                rightIndent = Float.parseFloat(ParagraphDialog.this.m_rightIndent.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.m_random.setSeed(1959L);
            g.setFont(this.m_fn);
            FontMetrics fm = g.getFontMetrics();
            int h = fm.getAscent();
            int s = Math.max((int)(lineSpacing * this.m_scaleY), 1);
            int s1 = Math.max((int)(spaceAbove * this.m_scaleY), 0) + s;
            int s2 = Math.max((int)(spaceBelow * this.m_scaleY), 0) + s;
            int y = 5 + h;
            int xMarg = 20;
            int x0 = Math.max((int)(firstIndent * this.m_scaleX) + xMarg, 3);
            int x1 = Math.max((int)(leftIndent * this.m_scaleX) + xMarg, 3);
            int x2 = Math.max((int)(rightIndent * this.m_scaleX) + xMarg, 3);
            int xm0 = this.getWidth() - xMarg;
            int xm1 = this.getWidth() - x2;
            int n = (this.getHeight() - (2 * h + s1 + s2 - s + 10)) / (h + s);
            n = Math.max(n, 1);
            g.setColor(Color.lightGray);
            int x = xMarg;
            this.drawLine(g, x, y, xm0, xm0, fm, 0);
            y += h + s1;
            g.setColor(Color.gray);
            int alignment = ParagraphDialog.this.getAlignment();
            int k = 0;
            while (k < n) {
                int xLen;
                x = k == 0 ? x0 : x1;
                int n2 = xLen = k == n - 1 ? xm1 / 2 : xm1;
                if (k == n - 1 && alignment == 3) {
                    alignment = 0;
                }
                this.drawLine(g, x, y, xm1, xLen, fm, alignment);
                y += h + s;
                ++k;
            }
            x = xMarg;
            g.setColor(Color.lightGray);
            this.drawLine(g, x, y += s2 - s, xm0, xm0, fm, 0);
        }

        protected void drawLine(Graphics g, int x, int y, int xMax, int xLen, FontMetrics fm, int alignment) {
            int m;
            String str1;
            int len;
            if (y > this.getHeight() - 3) {
                return;
            }
            StringBuffer s = new StringBuffer();
            int xx = x;
            while (xx + (len = fm.stringWidth(str1 = String.valueOf(this.m_dummy.substring(0, m = this.m_random.nextInt(10) + 1)) + " ")) < xLen) {
                xx += len;
                s.append(str1);
            }
            String str = s.toString();
            switch (alignment) {
                case 0: {
                    g.drawString(str, x, y);
                    break;
                }
                case 1: {
                    xx = (xMax + x - fm.stringWidth(str)) / 2;
                    g.drawString(str, xx, y);
                    break;
                }
                case 2: {
                    xx = xMax - fm.stringWidth(str);
                    g.drawString(str, xx, y);
                    break;
                }
                case 3: {
                    while (x + fm.stringWidth(str) < xMax) {
                        str = String.valueOf(str) + "a";
                    }
                    g.drawString(str, x, y);
                }
            }
        }
    }
}

