/*
 * Created on 11 juil. 2005
 */
package geonoteInterface;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * @author lefevre
 */
public class BarreEtat extends JPanel {
	private static JLabel labelG = null;
	private static JLabel labelD = null;
	private static ImageIcon icon = null;
	
	public BarreEtat(String dosSys) {
		labelG = new JLabel(" ");	//espace pour garantir la hauteur de la barre
		labelD = new JLabel(""); 
		setLayout(new BorderLayout());
		Box hBox = Box.createHorizontalBox();
		hBox.add(Box.createHorizontalStrut(5));
		hBox.add(labelG);
		hBox.add(Box.createGlue());
		hBox.add(labelD);
		hBox.add(Box.createHorizontalStrut(5));
		Box vBox = Box.createVerticalBox();
		vBox.add(Box.createVerticalStrut(4));
		vBox.add(hBox);
		vBox.add(Box.createVerticalStrut(2));
		add(vBox, BorderLayout.CENTER);
		icon = new ImageIcon(dosSys+"info.gif");
	}
	
	public static void afficheGauche(String texte) {
		labelG.setForeground(Color.black);
		labelG.setText(texte);
		labelG.setIcon(icon);
	}
	
	public static void afficheGauche(String texte, Color couleur) {
		labelG.setForeground(couleur);
		labelG.setText(texte);
		labelG.setIcon(icon);
	}
	
	public static void afficheDroite(String texte) {
		labelD.setForeground(Color.black);
		labelD.setBackground(Color.white); //inefficace
		labelD.setFont(new Font("Microsoft Sans Serif", 0, 9));
		labelD.setBorder(BorderFactory.createLineBorder(Color.black));
		labelD.setText(" "+texte+" ");
	}
	
	public static void resetGauche() {
		labelG.setText(" ");
		labelG.setIcon(null);
	}
	
	public static void resetDroite() {
		labelD.setText("");
		labelD.setBorder(null);
	}
	
	public static void reset() {
		resetGauche();
		resetDroite();
	}
}
