/*
 * Created on 8 juin 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package geonoteOutils;

import geonoteTypesDonnees.Arret;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.jdom.Element;

/**
 * @author lefevre
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TraceurCarte extends Traceur{

	public TraceurCarte() {
		super();
	}

	public TraceurCarte(String path, String rac) {
		super(path, rac);
	}
	
	public void ajouteArret(int id, int x, int y) {
		Element arret = rechercheArret(document.getRootElement(),Integer.toString(id));
		if (arret != null) {
			System.out.println("Erreur : arret deja present !");
		} else {
			arret = new Element("arret");
			Element eltId = new Element("id");
			eltId.setText(Integer.toString(id));
			Element abs = new Element("abscisse");
			abs.setText(Integer.toString(x));
			Element ord = new Element("ordonnee");
			ord.setText(Integer.toString(y));
			arret.addContent(eltId);
			arret.addContent(abs);
			arret.addContent(ord);
			document.getRootElement().addContent(arret);
		}
	}
	
	public void suppArret(int id) {
		Element cible = rechercheArret(document.getRootElement(), Integer.toString(id));
		if (cible != null) {
			Element pere = cible.getParentElement();
			pere.removeContent(cible);
		}
	}
	
	public void suppLien(int id, String lien) {
		Element cible = rechercheArret(document.getRootElement(), Integer.toString(id));
		if (cible != null) {
			Element lienASup = rechercheDonnee(cible, lien);
			if (lienASup != null) {
				cible.removeContent(lienASup);
			}
		}
	}
	
	public void suppVue(String vue, String fichier) {
		Element vues = rechercher(document.getRootElement(), "vues");
		if (vues!=null) {
			List listeVues = vues.getChildren();
			Iterator it = listeVues.iterator();
			boolean trouv = false;
			Element cible = null;
			while (it.hasNext() && !trouv) {
				Element courant = (Element)it.next();
				Element nom = rechercher(courant, "nom");
				Element fich = rechercher(courant, "fichier");
				if ((nom.getText().equals(vue)) && (fich.getText().equals(fichier))) {
					cible = courant;
					trouv = true;
				}
			}
			if (cible != null) vues.removeContent(cible);
		}
	}
	
	public void ajouteVue(String nom, String fichier) {
		Element vues = rechercher(document.getRootElement(), "vues");
		if (vues == null) {
			vues = new Element("vues");
			document.getRootElement().addContent(vues);
		} //ici, l'elt vues existe obligatoirement
		List listeVues = vues.getChildren();
		Iterator i = listeVues.iterator();
		boolean fichierAbsent = true;
		Element courant = null;
		while(i.hasNext() && fichierAbsent) {
			courant = (Element) i.next();
			Element fichElt = rechercher(courant, "fichier");
			if (fichElt.getText().equals(fichier)) fichierAbsent = false;
		}
		if (fichierAbsent) {
			Element vue = new Element("vue");
			Element name = new Element("nom");
			name.setText(nom);
			Element file = new Element("fichier");
			file.setText(fichier);
			vue.addContent(name);
			vue.addContent(file);
			vues.addContent(vue);
		} else {
			Element nomElt = rechercher(courant, "nom");
			nomElt.setText(nom);
		}
	}
	
	public ArrayList exporteVues() {
		Element vues = rechercher(document.getRootElement(), "vues");
		ArrayList liste = new ArrayList();
		if (vues!=null) {
			List listeVues = vues.getChildren();
			Iterator i = listeVues.iterator();
			while (i.hasNext()) {
				Element courant = (Element)i.next();
				ArrayList capsule = new ArrayList();
				capsule.add(courant.getChild("nom").getText());
				capsule.add(courant.getChild("fichier").getText());
				liste.add(capsule);
			}
		}
		return liste;
	}
	
	public String exporteTypeVuePrincipale() {
		Element vues = rechercher(document.getRootElement(), "vues");
		//la premiere vue est la carte principale
		Element carte = rechercher(vues, "vue");
		Element nom = rechercher(carte, "nom");
		if (nom == null) return null;
		else return nom.getText();
	}
	
	public String exporteFichierVuePrincipale() {
		Element vues = rechercher(document.getRootElement(), "vues");
		//la premiere vue est la carte principale
		Element carte = rechercher(vues, "vue");
		Element fich = rechercher(carte, "fichier");
		if (fich == null) return null;
		else return fich.getText();
	}
	
	public ArrayList exporteFichiers() {
		return exporteFichiers(document.getRootElement());
	}
	
	private ArrayList exporteFichiers(Element elt) {
		ArrayList liste = new ArrayList();
		if (elt != null) {
			if (elt.getName().matches("donnee")) {
				liste.add(rechercher(elt, "fichier").getText());
			} else {
				List listElements = elt.getChildren(); //liste des fils de l'element ou se fait la recherche
				//	On cre un Iterator sur notre liste
				Iterator i = listElements.iterator();
				while (i.hasNext())	{
					Element courant = (Element)i.next();
					liste.addAll(exporteFichiers(courant));
				}
			}
		}
		return liste;
	}
	
	//inutile pour l'instant
	private ArrayList exporteFichiersTyps(Element elt) {
		ArrayList liste = new ArrayList();
		if (elt != null) {
			if (elt.getName().matches("donnee")) {
				ArrayList capsule = new ArrayList();
				Element pere = elt.getParentElement();
				capsule.add(rechercher(pere, "id").getText());
				capsule.add(rechercher(elt, "fichier").getText());
				capsule.add(rechercher(elt, "typeGeologique").getText());
				liste.add(capsule);
			} else {
				List listElements = elt.getChildren(); //liste des fils de l'element ou se fait la recherche
				//	On cre un Iterator sur notre liste
				Iterator i = listElements.iterator();
				while (i.hasNext())	{
					Element courant = (Element)i.next();
					liste.addAll(exporteFichiersTyps(courant));
				}
			}
		}
		return liste;
	}
	
	/**
	 * ajoute un lien vers une donnee  l'arret de bon identifiant
	 * @param path
	 * @param idArret
	 * @param type
	 */
	public void ajouteDonneeArret(String path, int idArret, String type) {
		Element arret = rechercheArret(document.getRootElement(), Integer.toString(idArret));
		if (arret == null) {
			System.out.println("Erreur : arret inexistant !"); //erreur normalement impossible :|
		} else {
			Element donnee = new Element("donnee");
			Element fichier = new Element("fichier");
			fichier.setText(path);
			Element typeG = new Element("typeGeologique");
			typeG.setText(type);
			Element etat = new Element("etat");
			etat.setText("accessible");	//par defaut
			donnee.addContent(fichier);
			donnee.addContent(typeG);
			donnee.addContent(etat);
			arret.addContent(donnee);
		}
	}
	
	/**
	 * ajoute ou modifie l'etat d'une donnee georef
	 * @param donneeCible
	 * @param etat
	 */
	public void ajouteEtat(String donneeCible, String etat) {
		Element cible = rechercheDonnee(document.getRootElement(), donneeCible);
		Element etatElt = rechercher(cible, "etat");
		if (etatElt == null) {
			etatElt = new Element("etat");
			cible.addContent(etatElt);
		}
		etatElt.setText(etat);
	}
	
	public String exporteEtat(String donneeCible) {
		Element cible = rechercheDonnee(document.getRootElement(), donneeCible);
		Element etat = rechercher(cible, "etat");
		if (etat == null) {
			etat = new Element("etat");
			cible.addContent(etat);
		}
		return etat.getText();
	}
	
	/**
	 * ajoute un elt echelle ou le modifie si deja present
	 * @param ech
	 */
	public void ajouteEchelle(double ech) {
		Element echelle = rechercher(document.getRootElement(),"echelle");
		if (echelle == null) {
			echelle = new Element("echelle");
			document.getRootElement().addContent(echelle);
		}
		echelle.setText(Double.toString(ech));
	}
	
	/**
	 * construit la liste des arrets presents sur la carte
	 */
	public ArrayList construitArrets() {
		ArrayList liste = new ArrayList();
		ArrayList listArrets = new ArrayList();
		listArrets = rechercheArrets(document.getRootElement()); //recup des arrets
		Iterator i = listArrets.iterator();
		while (i.hasNext()) {
			Element arret = (Element)i.next();
			int id = Integer.parseInt(rechercher(arret,"id").getText());
			int abs = Integer.parseInt(rechercher(arret,"abscisse").getText());
			int ord = Integer.parseInt(rechercher(arret,"ordonnee").getText());
			ArrayList listLiens = new ArrayList();
			listLiens.addAll(exporteLiens(arret)); //recup des liens contenus par l'arret
//System.out.println("arret "+Integer.parseInt(id.getText())+" - liste liens : "+listLiens);
			Arret nouvArret = new Arret(id, abs, ord);
			nouvArret.importeListeLiens(listLiens);
			liste.add(nouvArret);
		}
		return liste;
	}
	
	/**
	 * retourne la liste des liens d'un arret, classes par type !!!
	 */
	private ArrayList exporteLiens(Element elt) {
		ArrayList liste = new ArrayList();
		if (elt != null) {
			ArrayList listeTypes = rechercheTypes(elt);
			Iterator i = listeTypes.iterator();
			while (i.hasNext()) {
				String typeCourant = (String)i.next();
				ArrayList listeDonneesPourUnType = rechercheDonneesType(elt, typeCourant);
				liste.add(listeDonneesPourUnType);
			}
		}
		//System.out.println("liste path : "+liste);
		return liste;
	}
	
	/**
	 * retourne une liste contenant le type puis tous les liens vers les donnees de ce type
	 * @param elt
	 * @param type
	 * @return
	 */
	private ArrayList rechercheDonneesType(Element elt, String type) {
		ArrayList liste = new ArrayList();
		if (elt != null) {
			liste.add(type); //ajout du type en tete de liste
			List listFils = elt.getChildren();
			Iterator i = listFils.iterator();
			while (i.hasNext()) {
				Element courant = (Element)i.next();
				if (courant.getName().matches("donnee")) {
					String typeCourant = rechercher(courant,"typeGeologique").getText();
					if (typeCourant.matches(type)) {
						liste.add(rechercher(courant, "fichier").getText());	//ajout du nom de fichier de la donnee
					}
				}
			}
		}
		return liste;
	}
	
	/**
	 * retourne la liste des types de donnees contenu par l'elt (un arret)
	 * @param racine
	 * @return
	 */
	private ArrayList rechercheTypes(Element racine) {
		ArrayList liste = new ArrayList();
		if (racine != null) {
			List listFils = racine.getChildren();
			Iterator i = listFils.iterator();
			while (i.hasNext()) {
				Element courant = (Element)i.next();
				if (courant.getName().matches("donnee")) {
					String typeCourant = rechercher(courant,"typeGeologique").getText();
					if (!liste.contains(typeCourant)) {	//si pas deja present ds la liste des types
//System.out.println("ajout types");
						liste.add(typeCourant);	//ajout
					}
				}
			}
		}
		return liste;
	}
	
	/**
	 * ajoute les coordonnees de reference
	 *
	 */
	public void ajouteCoord(String latitudeOrigine, String longitudeOrigine, String echelleLat, String echelleLong) {
		Element coord = rechercher(document.getRootElement(), "coordonnees");
		Element lati = null;
		Element longi = null;
		Element echLat = null;
		Element echLong = null;
		if (coord == null) {
			coord = new Element("coordonnees");
			Element orig = new Element("origine");
			lati = new Element("latitude");
			longi = new Element("longitude");
			echLat = new Element("echelleLatitude");
			echLong = new Element("echelleLongitude");
			orig.addContent(lati);
			orig.addContent(longi);
			coord.addContent(orig);
			coord.addContent(echLat);
			coord.addContent(echLong);
			document.getRootElement().addContent(coord);
		} else {
			lati = rechercher(coord, "latitude");
			longi = rechercher(coord, "longitude");
			echLat = rechercher(coord, "echelleLatitude");
			echLong = rechercher(coord, "echelleLongitude");
		}
		lati.setText(latitudeOrigine);
		longi.setText(longitudeOrigine);
		echLat.setText(echelleLat);
		echLong.setText(echelleLong);
	}
}
