/*
 * Created on 18 juil. 2005
 */
package geonoteOutilsCarnet;

import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

/**
 * @author lefevre
 */
public class SmallToggleButton extends JToggleButton implements ItemListener {
	protected Border m_raised;
	protected Border m_lowered;
	
	public SmallToggleButton(boolean selected, ImageIcon imgUnselected, ImageIcon imgSelected, String tip) {
		super(imgUnselected, selected);
		setHorizontalAlignment(CENTER);
		setBorderPainted(true);
		m_raised = new BevelBorder(BevelBorder.RAISED);
		m_lowered = new BevelBorder(BevelBorder.LOWERED);
		setBorder(selected ? m_lowered : m_raised);
		setMargin(new Insets(1,1,1,1));
		setToolTipText(tip);
		setRequestFocusEnabled(false);
		setSelectedIcon(imgSelected);
		addItemListener(this);
	}
	
	public float getAlignmentY() { return 0.5f; }
	
	public void itemStateChanged(ItemEvent e) {
		setBorder(isSelected() ? m_lowered : m_raised);
	}
}
