/*
 * Created on 3 juin 2005
 */
package geonoteTypesDonnees;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * @author lefevre
 * 
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Arret {

	private int id;
	private int x;
	private int y;
	private int diametre = 50;
	private ArrayList listeLiens = null; //stocke les liens avec leurs types (liste de listes commencant par les types)
	
	/**
	 * Constructeur
	 * @param ident
	 * @param X
	 * @param Y
	 */
	public Arret(int ident, int X, int Y) {
		id=ident;
		x=X;
		y=Y;
		listeLiens = new ArrayList();
		
	}
	
	public ArrayList exporteListeLiens() {
		return listeLiens;
	}
	
	/**
	 * ajoute le lien ds la liste
	 * @param lien
	 */
	public void ajouteLien(String lien, String type) {
		Iterator i = listeLiens.iterator();
		boolean trouv = false;
		while (i.hasNext() && !trouv) {
			ArrayList listeCourante = (ArrayList) i.next();
			String typ = listeCourante.get(0).toString();
//System.out.println(typ);
			if (typ.contains(type)) {
				listeCourante.add(lien);
				trouv = true;
			}
		}
		if (!trouv) {	//si pas trouve alors nouveau type de donnee !
			ArrayList nouvelListe = new ArrayList();
			nouvelListe.add(type);
			nouvelListe.add(lien);
			listeLiens.add(nouvelListe);
		}
	}
	
	public void suppLien(String lien, String type) {
		Iterator i = listeLiens.iterator();
		boolean trouv = false;
		while (i.hasNext() && !trouv) {
			ArrayList listeCourante = (ArrayList) i.next();
			String typ = listeCourante.get(0).toString();
//System.out.println(typ);
			if (typ.contains(type)) {
				listeCourante.remove(lien);
				if (listeCourante.size() == 1) { //si il n'y plus que le type (sans lien)
					listeLiens.remove(listeCourante);
				}
				trouv = true;
			}
		}
	}
	
	public void importeListeLiens(ArrayList l) {
		if (l != null) listeLiens.addAll(l);
	}
	
	public void draw(Graphics2D g2, double zoom, Color couleur/*, int decalHor, int decalVer*/) {
		int diamAff = (int) (diametre/zoom);
		int xAffichage = x;//+decalHor;
		int yAffichage = y;//+decalVer;
		g2.setColor(couleur);
		g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.6f ));
		g2.fillRect(xAffichage,yAffichage,(diamAff+5)/3,(diamAff+5)/3);
		g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 1.0f ));
		g2.setStroke(new BasicStroke( (float) (5.0f/zoom) ));
		g2.drawOval( xAffichage-(diamAff/2), yAffichage-(diamAff/2), diamAff, diamAff);
		g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 1.0f ));
		g2.setColor(Color.black);
		g2.setStroke(new BasicStroke( (float) (1.0f/zoom) ));
		g2.drawOval(xAffichage-(diamAff/2),yAffichage-(diamAff/2),diamAff,diamAff);
		g2.drawLine(xAffichage,yAffichage-diamAff/2,xAffichage,yAffichage+diamAff/2);
		g2.drawLine(xAffichage-diamAff/2,yAffichage,xAffichage+diamAff/2,yAffichage);
		g2.setFont(new Font("Courrier", 0,(int) (15/zoom)));
		g2.drawString(Integer.toString(id), (int) (xAffichage+(2/zoom)), (int) (yAffichage+(16/zoom)));
	}

	/**
	 * @return Returns the id.
	 */
	public int getId() {
		return id;
	}

	/**
	 * @return Returns the x.
	 */
	public int getX() {
		return x;
	}

	/**
	 * @return Returns the y.
	 */
	public int getY() {
		return y;
	}

	/**
	 * @return Returns the diametre.
	 */
	public int getDiametre() {
		return diametre;
	}
    public void setX(int x) {
        this.x = x;
    }
    public void setY(int y) {
        this.y = y;
    }
}
