/*
 * Created on 8 juin 2005
 */
package geonoteOutils;

import geonoteTypesDonnees.Arret;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.jdom.Element;

/**
 * @author lefevre
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TraceurSession extends Traceur {

	public TraceurSession() {
		super();
	}

	public TraceurSession(String path, String rac) {
		super(path, rac);
	}
	
	/**
	 * Ajoute une annotation a l'elt (une donnee ou une vue, suivant le type) pass
	 */
	public void ajouterAnnotation(String nomFichier, String nomEltPere, String annotation) {
		String aChercher = nomFichier;
		if (nomFichier.indexOf(" ")>0) { 
			aChercher = nomFichier.substring(0, nomFichier.indexOf(" ")); //pour supprimer la date ! 
		}
		Element elt;
		if (nomEltPere.equals("Vue(s)")) { 
			elt = rechercheVue(document.getRootElement(),aChercher);
		} else {
			elt = rechercheDonnee(document.getRootElement(),aChercher);
		}
		if (elt != null) {
			Element annotationElt = rechercher(elt, "annotation");  
			if (annotationElt == null) {
				annotationElt = new Element("annotation"); 
				elt.addContent(annotationElt);
			}
			annotationElt.setText(annotation);
		} else {
			System.out.println("element inexistant : "+aChercher); 
		}
	}

	/**
	 * retourne l'elt correspondant a la vue
	 */
	private Element rechercheVue(Element elt, String cherch) {
		Element cible = null; //elt recherch
		if (elt != null) {
			if(elt.getName().matches("vues")){ 
				//recherche parmi les vues
				List listElements = elt.getChildren(); //liste des fils de l'element ou se fait la recherche
				boolean trouv = false;//pour arreter le parcours
				Iterator i = listElements.iterator();	//	On cre un Iterator sur notre liste
				while((i.hasNext()) && !trouv)	{
					Element courant = (Element)i.next();
					Element fich = rechercher(courant, "fichier"); 
					if (fich.getText().equals(cherch)) {
						cible = courant;
						trouv = true;
					}
				}
			} else {
				List listElements = elt.getChildren(); //liste des fils de l'element ou se fait la recherche
				boolean trouv = false;//pour arreter le parcours
				Iterator i = listElements.iterator();	//	On cre un Iterator sur notre liste
				while((i.hasNext()) && !trouv)	{
					//On recre l'Element courant  chaque tour de boucle afin de pouvoir utiliser les mthodes propres aux Element comme :
					//selectionner un noeud fils, modifier du texte, etc...
					Element courant = (Element)i.next();
					cible = rechercheVue(courant, cherch);
					if (cible != null) {
						trouv = true;
					}
				}
			}
		}
		return cible;
	}
	
	/**
	 * modifie l'annotation fournie
	 * @param annotationOrigine
	 * @param nouvoTexte
	 */
	public void modifierAnnotation(String annotationOrigine, String nouvoTexte) {
		Element elt =rechercheAnnotation(annotationOrigine);
		if (elt!= null) {
			elt.setText(nouvoTexte);
		}
	}
	
	public void supprimerAnnotation(String annotation) {
		Element elt =rechercheAnnotation(annotation);
		if (elt!= null) {
			Element pere = elt.getParentElement();
			boolean res = pere.removeContent(elt);
		}
	}
	
	private ArrayList rechercheAnnotation(Element elt) {
		ArrayList liste = new ArrayList();
		if (elt != null) {
			if (elt.getName().equals("annotation")) { 
				liste.add(elt);
			} else {
				List listElements = elt.getChildren(); //liste des fils de l'element ou se fait la recherche
				Iterator i = listElements.iterator();
				while (i.hasNext())	{
					//On recre l'Element courant  chaque tour de boucle afin de pouvoir utiliser les mthodes propres aux Element comme :
					//selectionner un noeud fils, modifier du texte, etc...
					Element courant = (Element)i.next();
					liste.addAll(rechercheAnnotation(courant));
				}
			}
		}
		return liste;
	}
	
	private Element rechercheAnnotation(String annotation) {
		ArrayList liste = new ArrayList();
		liste = rechercheAnnotation(document.getRootElement());
		Element retour = null;
		Iterator i = liste.iterator();
		boolean trouv = false;
		while (i.hasNext() && !trouv) {
			Element courant = (Element)i.next();
			if (courant != null) {
//				System.out.println(courant.getText());
//				System.out.println(annotation);
				if (annotation.contains(courant.getText())) {
					retour = courant;
					trouv = true;
				}
			}
		}
		return retour;
	}
	
	/**
	 * 
	 * @param elt
	 * @return liste de "capsules" contenant le chemin d'une donne ET son annotation
	 */
	private ArrayList exporteAnnotations(Element elt) {
		ArrayList liste = new ArrayList();
		if (elt != null) {
			if (elt.getName().matches("annotation")) { 
				Element pere = elt.getParentElement(); //on recup l'elt contenant le chemin et l'annotation
				Element papy = pere.getParentElement(); //le nd du type arret ou docs ou vue
				Element fichier = rechercher(pere, "fichier"); //recup du nom du fichier 
				ArrayList capsule = new ArrayList();
//				int[] date = exporteDate(pere);
				capsule.add(fichier.getText());//+" (le "+date[0]+"/"+date[1]+"/"+date[2]+"  "+date[3]+":"+date[4]+":"+date[5]+")"); //stocke le nom de fichier dat
				capsule.add(elt.getText()); //stocke l'annotation
				String type = papy.getName();
				String retour = ""; 
				if (type.equals("documentation")) retour = "Documentation";  
				if (type.equals("vue")) retour = "Vue(s)";  
				if (type.equals("arret")) retour = "Arrt "+rechercher(papy, "id").getText();   
				capsule.add(retour);
				liste.add(capsule); 
			} else {
				List listElements = elt.getChildren(); //liste des fils de l'element ou se fait la recherche
				//	On cre un Iterator sur notre liste
				Iterator i = listElements.iterator();
				while (i.hasNext())
				{
					Element courant = (Element)i.next();
					liste.addAll(exporteAnnotations(courant));
				}
			}
		}
		return liste;
	}
	
	/**
	 * retourne la liste des annotations liees  leur elt (une donne ds l'histo) 
	 */
	public ArrayList exporteAnnotations() {
		return exporteAnnotations(document.getRootElement());
	}
	
	public String exporteCarte() {
		Element vues = rechercher(document.getRootElement(), "vues"); 
		//la premiere vue est la carte principale
		Element carte = rechercher(vues, "vue"); 
		Element fichier = rechercher(carte, "fichier"); 
		return fichier.getText();
	}
	
//	public String exporteCarteDate() {
//		Element vues = rechercher(document.getRootElement(), "vues");
//		//la premiere vue est la carte principale
//		Element carte = rechercher(vues, "vue");
//		Element fichier = rechercher(carte, "fichier");
//		int[] date = exporteDate(carte);
//		return fichier.getText()+" (le "+date[0]+"/"+date[1]+"/"+date[2]+"  "+date[3]+":"+date[4]+":"+date[5]+")";
//	}
	
	/**
	 * Exporte la liste des donnees (leurs chemins) presentes ds la partie docs de l'histo
	 */
	public ArrayList exporteDocsHisto() {
		Element docs = rechercher(document.getRootElement(), "documentation"); 
		return exporteFichiersDates(docs);
	}
	
	public void ajouteCarnet(String t) {
		Element carnet = rechercher(document.getRootElement(),"carnet"); 
		if (carnet == null) {
			carnet = new Element("carnet"); 
			document.getRootElement().addContent(carnet);
		}
		carnet.setText(t);
	}
	
	/**
	 * ajoute un elt "donnee" a l'elt passe en parametre 
	 */
	private void ajouteDonnee(Element elt, String cheminDonnee, String j, String m, String a, String h, String min, String s) {
		Element donnee = new Element("donnee"); 
		Element fichier = new Element("fichier"); 
		fichier.setText(cheminDonnee);
		donnee.addContent(fichier);
		ajouterDate(donnee, j, m, a, h, min, s);
		elt.addContent(donnee);
	}
	
	/**
	 * Ajoute a la trace de l'historique une donnee accede depuis un arret
	 */
	public void ajouteDonneeArret(String idArret, String cheminDonnee, String j, String m, String a, String h, String min, String s) { 
		Element historique = rechercher(document.getRootElement(),"historique"); 
		if (historique == null) {
			historique = new Element("historique"); 
			document.getRootElement().addContent(historique);
		} //ici, l'elt historique existe obligatoirement
		Element arret = rechercheArret(historique, idArret);
		if (arret == null) {
			arret = new Element("arret"); 
			Element id = new Element("id"); 
			id.setText(idArret);
			arret.addContent(id);
			historique.addContent(arret);
		}//ici, l'arret d'id "idArret" existe comme sous elt de historique
		ajouteDonnee(arret, cheminDonnee, j, m, a, h, min, s);
	}
	
	/**
	 * ajoute une vue  l'elt vues de la session
	 * @param fich
	 */
	public void ajouteVue(String fich, String j, String m, String a, String h, String min, String s) {
		Element vues = rechercher(document.getRootElement(),"vues"); 
		if (vues == null) {
			vues = new Element("vues"); 
			document.getRootElement().addContent(vues);
		} //ici, l'elt vues existe obligatoirement
		ajouteVue(vues, fich, j, m, a, h, min, s);
	}
	
	/**
	 * ajoute un elt "vue" a l'elt passe en parametre 
	 */
	private void ajouteVue(Element elt, String nomFichier, String j, String m, String a, String h, String min, String s) {
		Element vue = rechercheVue(elt, nomFichier);
		if (vue == null) {
			vue = new Element("vue"); 
			Element fichier = new Element("fichier"); 
			fichier.setText(nomFichier);
			vue.addContent(fichier);
			ajouterDate(vue, j, m, a, h, min, s);
			elt.addContent(vue);
		}
	}
	
	/**
	 * Ajoute a la trace de l'historique une donnee du docs
	 */
	public void ajouteDonneeDocs(String cheminDonnee, String j, String m, String a, String h, String min, String s) {
		Element historique = rechercher(document.getRootElement(),"historique"); 
		if (historique == null) {
			historique = new Element("historique"); 
			document.getRootElement().addContent(historique);
		} //ici, l'elt historique existe obligatoirement
		Element docs = rechercher(historique,"documentation"); 
		if (docs == null) {
			docs = new Element("documentation"); 
			historique .addContent(docs);
		} //ici, l'elt docs existe obligatoirement
		ajouteDonnee(docs, cheminDonnee, j, m, a, h, min, s);
	}
	
	/**
	 * construit la liste des arrets presents dans l'historique pour le chargement d'une session uniquement (absence des types de chaque lien)
	 */
	public ArrayList exporteArretsHisto() {
		ArrayList liste = new ArrayList();
		ArrayList listArrets = new ArrayList();
		Element histo = rechercher(document.getRootElement(),"historique"); //recherhce de l'elt histo 
		listArrets = rechercheArrets(histo); //recup des arrets de l'histo
		Iterator i = listArrets.iterator();
		while (i.hasNext()) {
			Element arret = (Element)i.next();
			int id = Integer.parseInt(rechercher(arret,"id").getText()); 
			ArrayList listLiens = new ArrayList();
			listLiens.addAll(exporteFichiersDates(arret)); //recup des liens (sans les types) contenus par l'arret
//System.out.println("arret "+Integer.parseInt(id.getText())+" - liste liens : "+listLiens);
			Arret nouvArret = new Arret(id, 0, 0);
			nouvArret.importeListeLiens(listLiens);
			liste.add(nouvArret);
		}
//		System.out.println("liste arrets : "+liste);
		return liste;
	}
}
