/*
 * Created on 18 juil. 2005
 */
package geonoteOutilsCarnet;

import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

/**
 * @author lefevre
 */
public class SmallButton extends JButton implements MouseListener {
	protected Border m_raised;
	protected Border m_lowered;
	protected Border m_inactive;
	
	public SmallButton(Action act, String tip) {
		super((Icon)act.getValue(Action.SMALL_ICON));
		m_raised = new BevelBorder(BevelBorder.RAISED);
		m_lowered = new BevelBorder(BevelBorder.LOWERED);
		m_inactive = new EmptyBorder(2, 2, 2, 2);
		setBorder(m_inactive);
		setMargin(new Insets(1,1,1,1));
		setToolTipText(tip);
		addActionListener(act);
		addMouseListener(this);
		setRequestFocusEnabled(false);
	}
	
	public float getAlignmentY() { return 0.5f; }
	
	public void mousePressed(MouseEvent e) {
		setBorder(m_lowered);
	}
	
	public void mouseReleased(MouseEvent e) {
		setBorder(m_inactive);
	}
	
	public void mouseClicked(MouseEvent e) {}
	
	public void mouseEntered(MouseEvent e) {
		setBorder(m_raised);
	}
	
	public void mouseExited(MouseEvent e) {
		setBorder(m_inactive);
	}
}
