/*
 * Decompiled with CFR 0.152.
 */
package geonoteInterface;

import geonoteInterface.BarreEtat;
import geonoteInterface.FenetreCalibrageReglet;
import geonoteInterface.FenetreParametrage;
import geonoteInterface.FenetreParametresEditionCarte;
import geonoteInterface.FenetreParametresEditionImage;
import geonoteInterface.FenetreParametresEditionTexte;
import geonoteOutils.FiltreExtensible;
import geonoteOutils.ImagePreview;
import geonoteOutils.Traceur;
import geonoteOutils.TraceurCarte;
import geonoteOutils.TraceurDonnee;
import geonoteOutils.TraceurSession;
import geonoteOutils.TraceurTraces;
import geonoteOutilsCarnet.SmallButton;
import geonoteTypesDonnees.Texte;
import geonoteZones.Carnet;
import geonoteZones.Documentations;
import geonoteZones.Historique;
import geonoteZones.Navigation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class Interface
extends JFrame
implements KeyListener {
    private Historique historique = null;
    private Carnet carnet = null;
    private Navigation navigation = null;
    private Documentations documentations = null;
    private JSplitPane splitPane1 = null;
    private JSplitPane splitPane2 = null;
    private JSplitPane splitPanePrincipal = null;
    private int hauteurMin = 480;
    private int largeurMin = 640;
    private FenetreParametresEditionCarte fpec = null;
    private FenetreParametresEditionImage fpei = null;
    private FenetreParametresEditionTexte fpet = null;
    private TraceurCarte traceurCarteEdition = null;
    private TraceurDonnee traceurDonneeEdition = null;
    private TraceurSession traceurSession = null;
    private TraceurTraces traceurTraces = null;
    private boolean carteEnEdition = false;
    private boolean texteEnEdition = false;
    private boolean imageEnEdition = false;
    private boolean carteModifi\u00e9e = false;
    private boolean docsModifi\u00e9 = false;
    private boolean fenetreActive = false;
    private boolean modeEdition = false;
    private boolean modeSuppArret = false;
    private boolean modeSuppLien = false;
    private boolean modeSuppVue = false;
    private boolean tracesActives = true;
    private boolean sauv\u00e9 = true;
    private boolean sortie = false;
    private boolean enregEditPossible = false;
    private String userName = "";
    private String espaceCartes = "";
    private String espaceDeTravail = "";
    private String espaceSysteme = "";
    private String espaceDocs = "";
    private String espaceDonnees = "";
    private String espaceGeorefs = "";
    private String espaceSessions = "";
    private String espaceTraces = "";
    private String espaceCarnet = "";
    private String espaceCalendrier = "";
    private String espaceLexique = "";
    private String espaceAide = "";
    private String extensionsCartes = "";
    private String extensionsDocs = "";
    private String nomFichierSession = "";
    private String nomFichierTraces = "";
    private String pswd = "";
    private JMenuBar barreM = null;
    private JMenu sessionM = null;
    private JMenuItem nouvSessionM = null;
    private JMenuItem chargSessionM = null;
    private JMenuItem quitterM = null;
    private JMenuItem enregM = null;
    private JMenu affichageM = null;
    private JCheckBoxMenuItem coordCB = null;
    private JCheckBoxMenuItem carnetCB = null;
    private JCheckBoxMenuItem arretsCB = null;
    private JCheckBoxMenuItem documentationsCB = null;
    private JCheckBoxMenuItem historiqueCB = null;
    private JCheckBoxMenuItem navigationCB = null;
    private JMenu aideM = null;
    private JMenuItem helpM = null;
    private JMenuItem aproposM = null;
    private JMenu editionM = null;
    private JMenuItem edActiverM = null;
    private JMenuItem edDesactiverM = null;
    private JMenuItem parametrageM = null;
    private JMenuItem enregEditM = null;
    private JMenuItem parametresEditM = null;
    private JMenuItem modifCarteM = null;
    private JMenuItem modifDocsM = null;
    private JMenu modifM = null;
    private JMenuItem nouvCarteM = null;
    private JMenuItem nouvDocsM = null;
    private JMenuItem nouvVueM = null;
    private JMenu nouvM = null;
    private JMenuItem suppArretM = null;
    private JMenuItem suppCarteM = null;
    private JMenuItem suppVueM = null;
    private JMenuItem suppDocsM = null;
    private JMenuItem suppLienM = null;
    private JMenu suppM = null;
    private JMenu outilsM = null;
    private JMenuItem calendrierM = null;
    private JMenuItem documentationsM = null;
    private JMenuItem lexiqueM = null;
    private JMenuItem rechercheM = null;
    private JToolBar toolBar = null;
    private SmallButton coordSB = null;
    private SmallButton arretSB = null;
    private SmallButton quatreSB = null;
    private SmallButton docSB = null;
    private SmallButton calendrierSB = null;
    private SmallButton lexiqueSB = null;
    private SmallButton rechercheSB = null;
    private SmallButton suivSB = null;
    private SmallButton precSB = null;
    private SmallButton info = null;
    private String com = "";
    private String aut = "";
    private String tit = "";
    public Cursor suppCurseur = null;
    private String dossierNouvoLien = "";
    private String dossierNouvelleDonnee = "";
    private String dossierNouvelleVue = "";

    public Interface() {
        super(" G\u00e9onote 1.09b");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        System.out.println(" G\u00e9onote 1.09b");
        this.espaceDeTravail = String.valueOf(System.getProperty("user.dir")) + "\\";
        Traceur config = new Traceur();
        boolean result = config.charger(String.valueOf(this.espaceDeTravail) + ".conf");
        if (result) {
            this.espaceSysteme = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceSysteme");
            this.espaceTraces = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceTraces");
            this.espaceDonnees = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceDonnees");
            this.espaceSessions = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceSessions");
            this.espaceCartes = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceCartes");
            this.espaceDocs = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceDocs");
            this.espaceGeorefs = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceGeorefs");
            this.espaceCarnet = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceCarnet");
            this.espaceCalendrier = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceCalendrier");
            this.espaceLexique = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceLexique");
            this.espaceAide = String.valueOf(this.espaceDeTravail) + config.exporteInfo("espaceAide");
            this.extensionsCartes = config.exporteInfo("extensionsCartes");
            this.extensionsDocs = config.exporteInfo("extensionsDocs");
            String largeur = config.exporteInfo("largeur");
            this.largeurMin = Integer.parseInt(largeur);
            String hauteur = config.exporteInfo("hauteur");
            this.hauteurMin = Integer.parseInt(hauteur);
            this.tracesActives = config.exporteInfo("traces").equals("actives");
            this.pswd = config.exporteInfo("mdp");
            this.setSize(new Dimension(this.largeurMin, this.hauteurMin));
            this.setMinimumSize(new Dimension(640, 480));
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "ECHEC de chargement du fichier de configuration !!!", "ERREUR", 2);
            System.exit(0);
        }
        this.dossierNouvoLien = this.espaceDocs;
        this.dossierNouvelleDonnee = ".";
        this.dossierNouvelleVue = this.espaceDonnees;
        this.setLocationRelativeTo(null);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        Image icone = Toolkit.getDefaultToolkit().getImage(String.valueOf(this.espaceSysteme) + "icon1.gif");
        this.setIconImage(icone);
        Image im = Toolkit.getDefaultToolkit().getImage(String.valueOf(this.espaceSysteme) + "suppCurseur.gif");
        Point pt = new Point(0, 0);
        this.suppCurseur = Toolkit.getDefaultToolkit().createCustomCursor(im, pt, "suppression");
        this.historique = new Historique(this);
        this.navigation = new Navigation(this, this.espaceSysteme);
        this.carnet = new Carnet(this, this.espaceSysteme);
        this.documentations = new Documentations(this, this.espaceSysteme);
        this.splitPanePrincipal = new JSplitPane(0);
        this.splitPanePrincipal.setDividerLocation(this.getHeight() * 3 / 4);
        this.splitPanePrincipal.setPreferredSize(new Dimension(this.largeurMin, this.hauteurMin));
        this.splitPane1 = new JSplitPane(1);
        this.splitPane1.setDividerLocation(this.getWidth() / 4);
        this.splitPane2 = new JSplitPane(1);
        this.splitPane2.setDividerLocation(this.getWidth() * 3 / 8);
        this.splitPane1.setBorder(null);
        this.splitPane2.setBorder(null);
        this.splitPanePrincipal.setDividerSize(4);
        this.splitPane1.setDividerSize(4);
        this.splitPane2.setDividerSize(4);
        this.splitPane2.setLeftComponent(this.navigation);
        this.splitPane2.setRightComponent(this.documentations);
        this.splitPane1.setLeftComponent(this.historique);
        this.splitPane1.setRightComponent(this.splitPane2);
        this.splitPanePrincipal.setTopComponent(this.splitPane1);
        this.splitPanePrincipal.setBottomComponent(this.carnet);
        this.add((Component)this.splitPanePrincipal, "Center");
        this.add((Component)new BarreEtat(this.espaceSysteme), "South");
        this.barreM = new JMenuBar();
        this.setJMenuBar(this.barreM);
        this.sessionM = new JMenu("Session");
        this.sessionM.setMnemonic(83);
        this.barreM.add(this.sessionM);
        this.nouvSessionM = new JMenuItem("Nouvelle session ...", new ImageIcon(String.valueOf(this.espaceSysteme) + "nouveau.gif"));
        this.nouvSessionM.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.nouvSessionM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvelleSession();
            }
        });
        this.sessionM.add(this.nouvSessionM);
        this.chargSessionM = new JMenuItem("Charger une session ...", new ImageIcon(String.valueOf(this.espaceSysteme) + "ouvrir.gif"));
        this.chargSessionM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.chargerSession();
            }
        });
        this.sessionM.add(this.chargSessionM);
        this.enregM = new JMenuItem("Enregistrer la session", new ImageIcon(String.valueOf(this.espaceSysteme) + "enregistrer.gif"));
        this.enregM.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.enregM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enregistrerSession();
            }
        });
        this.sessionM.add(this.enregM);
        this.sessionM.addSeparator();
        this.quitterM = new JMenuItem("Quitter", new ImageIcon(String.valueOf(this.espaceSysteme) + "quitter.gif"));
        this.quitterM.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.quitterM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.quitter();
            }
        });
        this.sessionM.add(this.quitterM);
        this.affichageM = new JMenu("Affichage");
        this.affichageM.setMnemonic(65);
        this.barreM.add(this.affichageM);
        this.coordCB = new JCheckBoxMenuItem("Coordonn\u00e9es g\u00e9ographiques", new ImageIcon(String.valueOf(this.espaceSysteme) + "coordonnees.gif"));
        this.coordCB.setSelected(false);
        this.coordCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.coordCB);
        this.arretsCB = new JCheckBoxMenuItem("Arr\u00eats", new ImageIcon(String.valueOf(this.espaceSysteme) + "arrets.gif"));
        this.arretsCB.setSelected(true);
        this.arretsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.arretsCB);
        this.affichageM.addSeparator();
        this.historiqueCB = new JCheckBoxMenuItem("Historique", new ImageIcon(String.valueOf(this.espaceSysteme) + "historique.gif"));
        this.historiqueCB.setSelected(true);
        this.historiqueCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.historiqueCB);
        this.navigationCB = new JCheckBoxMenuItem("Navigation", new ImageIcon(String.valueOf(this.espaceSysteme) + "navigation.gif"));
        this.navigationCB.setSelected(true);
        this.navigationCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.navigationCB);
        this.documentationsCB = new JCheckBoxMenuItem("Documentation", new ImageIcon(String.valueOf(this.espaceSysteme) + "doc.gif"));
        this.documentationsCB.setSelected(false);
        this.documentationsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.documentationsCB);
        this.carnetCB = new JCheckBoxMenuItem("Carnet", new ImageIcon(String.valueOf(this.espaceSysteme) + "carnet.gif"));
        this.carnetCB.setSelected(true);
        this.carnetCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.majAffichage();
            }
        });
        this.affichageM.add(this.carnetCB);
        this.outilsM = new JMenu("Outils");
        this.outilsM.setMnemonic(79);
        this.barreM.add(this.outilsM);
        this.documentationsM = new JMenuItem("Documentation", new ImageIcon(String.valueOf(this.espaceSysteme) + "documentation.gif"));
        this.documentationsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.chargerDocs();
            }
        });
        this.outilsM.add(this.documentationsM);
        this.calendrierM = new JMenuItem("Calendrier", new ImageIcon(String.valueOf(this.espaceSysteme) + "calendrier.gif"));
        this.calendrierM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.lancementCalendrier();
            }
        });
        this.outilsM.add(this.calendrierM);
        this.lexiqueM = new JMenuItem("Lexique", new ImageIcon(String.valueOf(this.espaceSysteme) + "lexique.gif"));
        this.lexiqueM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.lancementLexique();
            }
        });
        this.outilsM.add(this.lexiqueM);
        this.rechercheM = new JMenuItem("Recherche", new ImageIcon(String.valueOf(this.espaceSysteme) + "recherche.gif"));
        this.rechercheM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.recherche(Interface.this.espaceDonnees);
            }
        });
        this.outilsM.add(this.rechercheM);
        this.editionM = new JMenu("Edition");
        this.editionM.setMnemonic(69);
        this.barreM.add(this.editionM);
        this.parametrageM = new JMenuItem("Parametrage", new ImageIcon(String.valueOf(this.espaceSysteme) + "parametrage.gif"));
        this.parametrageM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.parametrage();
            }
        });
        this.editionM.add(this.parametrageM);
        this.editionM.addSeparator();
        this.edActiverM = new JMenuItem("Activer", new ImageIcon(String.valueOf(this.espaceSysteme) + "activer.gif"));
        this.edActiverM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.activerEdition(true);
            }
        });
        this.editionM.add(this.edActiverM);
        this.edDesactiverM = new JMenuItem("Desactiver", new ImageIcon(String.valueOf(this.espaceSysteme) + "desactiver.gif"));
        this.edDesactiverM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.activerEdition(false);
            }
        });
        this.editionM.add(this.edDesactiverM);
        this.editionM.addSeparator();
        this.nouvM = new JMenu("Nouveau");
        this.editionM.add(this.nouvM);
        this.nouvCarteM = new JMenuItem("Carte ...");
        this.nouvCarteM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvCarte();
            }
        });
        this.nouvM.add(this.nouvCarteM);
        this.nouvVueM = new JMenuItem("Vue ...");
        this.nouvVueM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvVue();
            }
        });
        this.nouvVueM.setEnabled(false);
        this.nouvM.add(this.nouvVueM);
        this.nouvDocsM = new JMenuItem("Donn\u00e9e ...");
        this.nouvDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.nouvDonnee();
            }
        });
        this.nouvM.add(this.nouvDocsM);
        this.modifM = new JMenu("Modifier");
        this.editionM.add(this.modifM);
        this.modifCarteM = new JMenuItem("Carte ...");
        this.modifCarteM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.modifCarte();
            }
        });
        this.modifM.add(this.modifCarteM);
        this.modifDocsM = new JMenuItem("Donn\u00e9e ...");
        this.modifDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.modifDonnee();
            }
        });
        this.modifM.add(this.modifDocsM);
        this.suppM = new JMenu("Supprimer");
        this.editionM.add(this.suppM);
        this.suppCarteM = new JMenuItem("Carte ...");
        this.suppCarteM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppCarte();
            }
        });
        this.suppM.add(this.suppCarteM);
        this.suppVueM = new JMenuItem("Vue ...");
        this.suppVueM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppVue();
            }
        });
        this.suppM.add(this.suppVueM);
        this.suppArretM = new JMenuItem("Arret ...");
        this.suppArretM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppArret();
            }
        });
        this.suppM.add(this.suppArretM);
        this.suppLienM = new JMenuItem("Lien ...");
        this.suppLienM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppLien();
            }
        });
        this.suppM.add(this.suppLienM);
        this.suppDocsM = new JMenuItem("Donn\u00e9e ...");
        this.suppDocsM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.suppDonnee();
            }
        });
        this.suppM.add(this.suppDocsM);
        this.enregEditM = new JMenuItem("Enregistrer");
        this.enregEditM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.enregistrerEdition();
            }
        });
        this.editionM.add(this.enregEditM);
        this.parametresEditM = new JMenuItem("Param\u00e8tres ...");
        this.parametresEditM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.afficheParametres();
            }
        });
        this.editionM.add(this.parametresEditM);
        this.aideM = new JMenu("?");
        this.barreM.add(this.aideM);
        this.helpM = new JMenuItem("Aide");
        this.helpM.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.lancementAide();
            }
        });
        this.aideM.add(this.helpM);
        this.aproposM = new JMenuItem("A propos de G\u00e9onote ...");
        this.aproposM.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.aproposM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Interface.this.aPropos();
            }
        });
        this.aideM.add(this.aproposM);
        this.toolBar = new JToolBar();
        AbstractAction action = new AbstractAction("coordonn\u00e9es", new ImageIcon(String.valueOf(this.espaceSysteme) + "coordonnees.gif")){

            public void actionPerformed(ActionEvent e) {
                if (Interface.this.coordCB.isEnabled()) {
                    Interface.this.coordCB.setSelected(!Interface.this.coordCB.isSelected());
                    Interface.this.majAffichage();
                }
            }
        };
        this.coordSB = new SmallButton(action, "Affichage des coordonn\u00e9es");
        this.toolBar.add(this.coordSB);
        action = new AbstractAction("arrets", new ImageIcon(String.valueOf(this.espaceSysteme) + "arrets.gif")){

            public void actionPerformed(ActionEvent e) {
                if (Interface.this.arretsCB.isEnabled()) {
                    Interface.this.arretsCB.setSelected(!Interface.this.arretsCB.isSelected());
                    Interface.this.majAffichage();
                }
            }
        };
        this.arretSB = new SmallButton(action, "Affichage des arr\u00eats");
        this.toolBar.add(this.arretSB);
        action = new AbstractAction("quatres", new ImageIcon(String.valueOf(this.espaceSysteme) + "quatres.gif")){

            public void actionPerformed(ActionEvent e) {
                Interface.this.historiqueCB.setSelected(true);
                Interface.this.navigationCB.setSelected(true);
                Interface.this.carnetCB.setSelected(true);
                if (Interface.this.documentationsCB.isEnabled()) {
                    Interface.this.documentationsCB.setSelected(true);
                }
                Interface.this.majAffichage();
            }
        };
        this.quatreSB = new SmallButton(action, "Affichage de toutes les zones");
        this.toolBar.add(this.quatreSB);
        this.toolBar.addSeparator();
        action = new AbstractAction("docs", new ImageIcon(String.valueOf(this.espaceSysteme) + "documentation.gif")){

            public void actionPerformed(ActionEvent e) {
                Interface.this.chargerDocs();
            }
        };
        this.docSB = new SmallButton(action, "Documentation");
        this.toolBar.add(this.docSB);
        action = new AbstractAction("calendrier", new ImageIcon(String.valueOf(this.espaceSysteme) + "calendrier.gif")){

            public void actionPerformed(ActionEvent e) {
                Interface.this.lancementCalendrier();
            }
        };
        this.calendrierSB = new SmallButton(action, "Calendrier");
        this.toolBar.add(this.calendrierSB);
        action = new AbstractAction("lexique", new ImageIcon(String.valueOf(this.espaceSysteme) + "lexique.gif")){

            public void actionPerformed(ActionEvent e) {
                Interface.this.lancementLexique();
            }
        };
        this.lexiqueSB = new SmallButton(action, "Lexique");
        this.toolBar.add(this.lexiqueSB);
        action = new AbstractAction("recherche", new ImageIcon(String.valueOf(this.espaceSysteme) + "recherche.gif")){

            public void actionPerformed(ActionEvent e) {
                Interface.this.recherche(Interface.this.espaceDonnees);
            }
        };
        this.rechercheSB = new SmallButton(action, "Recherche");
        this.toolBar.add(this.rechercheSB);
        this.toolBar.addSeparator();
        action = new AbstractAction("precedent", new ImageIcon(String.valueOf(this.espaceSysteme) + "precedent.gif")){

            public void actionPerformed(ActionEvent e) {
                Interface.this.navigation.precedent();
                Interface.this.majAffichage();
            }
        };
        this.precSB = new SmallButton(action, "Donn\u00e9e pr\u00e9c\u00e9dente");
        this.toolBar.add(this.precSB);
        action = new AbstractAction("suivant", new ImageIcon(String.valueOf(this.espaceSysteme) + "suivant.gif")){

            public void actionPerformed(ActionEvent e) {
                Interface.this.navigation.suivant();
                Interface.this.majAffichage();
            }
        };
        this.suivSB = new SmallButton(action, "Donn\u00e9e suivante");
        this.toolBar.add(this.suivSB);
        this.toolBar.addSeparator();
        action = new AbstractAction("info", new ImageIcon(String.valueOf(this.espaceSysteme) + "information.gif")){

            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Informations");
                f.setSize(new Dimension(400, 120));
                JTextPane t = new JTextPane();
                t.setText("Titre : " + Interface.this.tit + "\n\r" + "Auteur : " + Interface.this.aut + "\n\r" + "Commentaire : " + Interface.this.com);
                t.setEditable(false);
                t.setBackground(Color.white);
                t.setBorder(BorderFactory.createLineBorder(Color.white, 5));
                f.add(new JScrollPane(t));
                f.setVisible(true);
            }
        };
        this.info = new SmallButton(action, "Informations sur la donn\u00e9e");
        this.info.setEnabled(false);
        this.toolBar.add(this.info);
        this.add((Component)this.toolBar, "North");
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent arg0) {
            }

            public void componentMoved(ComponentEvent arg0) {
            }

            public void componentResized(ComponentEvent arg0) {
                Interface.this.repaintSplit();
            }

            public void componentShown(ComponentEvent arg0) {
            }
        });
        this.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent arg0) {
            }

            public void windowClosed(WindowEvent arg0) {
            }

            public void windowClosing(WindowEvent evt) {
                Interface.this.quitter();
            }

            public void windowDeactivated(WindowEvent arg0) {
            }

            public void windowDeiconified(WindowEvent arg0) {
            }

            public void windowIconified(WindowEvent arg0) {
            }

            public void windowOpened(WindowEvent arg0) {
            }
        });
        this.addKeyListener(this);
        this.activation(false);
        this.pack();
        this.setVisible(true);
        Date date = new Date();
        String[] dateTab = date.toString().split(" ");
        String heure = dateTab[3].replaceFirst(":", "h");
        heure = heure.replaceFirst(":", "m");
        String loginWin = System.getProperty("user.name");
        this.nomFichierTraces = "traces_" + loginWin + "_" + dateTab[2] + "-" + dateTab[1] + "-" + dateTab[5] + "_" + heure + ".xml";
        this.traceurTraces = new TraceurTraces(String.valueOf(this.espaceTraces) + "\\" + this.nomFichierTraces, "traces");
    }

    private void activeInfos(String a, String t, String c) {
        this.info.setEnabled(true);
        this.com = c;
        this.aut = a;
        this.tit = t;
    }

    private void desactiveInfos() {
        this.info.setEnabled(false);
    }

    public void activation(boolean b) {
        this.fenetreActive = b;
        this.historique.setEnabled(b);
        this.navigation.setEnabled(b);
        this.carnet.setEnabled(b);
        this.documentations.setEnabled(b);
        this.splitPanePrincipal.setEnabled(b);
        this.splitPane1.setEnabled(b);
        this.splitPane2.setEnabled(b);
        this.enregM.setEnabled(b);
        this.affichageM.setEnabled(b);
        this.quatreSB.setEnabled(b);
        this.arretSB.setEnabled(b);
        this.coordSB.setEnabled(b);
        this.rechercheM.setEnabled(b);
        this.rechercheSB.setEnabled(b);
        this.documentationsM.setEnabled(b);
        this.docSB.setEnabled(b);
        this.precSB.setEnabled(false);
        this.suivSB.setEnabled(false);
        this.edDesactiverM.setEnabled(this.modeEdition);
        this.nouvM.setEnabled(this.modeEdition);
        this.modifM.setEnabled(this.modeEdition);
        this.suppM.setEnabled(this.modeEdition);
        this.enregEditM.setEnabled(this.modeEdition);
        this.parametresEditM.setEnabled(this.modeEdition && (this.carteEnEdition || this.texteEnEdition || this.imageEnEdition));
        this.documentations.setVisible(this.documentations.rapportActivit\u00e9());
    }

    private void activerEdition(boolean b) {
        this.confirmation();
        if (!this.fenetreActive) {
            this.activation(true);
        }
        this.sauv\u00e9 = true;
        if (b) {
            this.rapportTrace("menu", "activation edition");
            boolean verif = this.authentification();
            if (verif) {
                this.modeEdition = b;
                this.majAffichage();
                this.navigation.reset();
                this.historique.reset();
                this.documentations.reset();
                this.carnet.reset();
            } else {
                this.rapportTrace("menu", "activation edition", "echec authentification");
            }
        } else {
            this.rapportTrace("menu", "desactivation edition");
            this.modeEdition = b;
            this.majAffichage();
            this.navigation.reset();
            this.historique.reset();
            this.documentations.reset();
            this.carnet.reset();
            this.docsModifi\u00e9 = false;
            this.carteModifi\u00e9e = false;
            this.nouvVueM.setEnabled(false);
            this.carteEnEdition = false;
            this.texteEnEdition = false;
            BarreEtat.reset();
            this.activation(false);
        }
    }

    public void activerEnregEdition() {
        this.enregEditPossible = true;
        this.majAffichage();
    }

    public void afficheArrets() {
        this.arretsCB.setSelected(true);
    }

    public void afficheDocs(String donnee) {
        String extension;
        TraceurCarte tr = new TraceurCarte();
        String chemin = String.valueOf(this.espaceDocs) + donnee;
        String cheminXML = chemin.replace(extension = chemin.substring(chemin.lastIndexOf(".")), ".xml");
        boolean result = tr.charger(cheminXML);
        if (result) {
            BarreEtat.resetGauche();
            String type = tr.exporteType();
            if (type.equals("texte")) {
                String auteur = tr.exporteInfo("auteur");
                String titre = tr.exporteInfo("titre");
                String commentaires = tr.exporteInfo("commentaire");
                this.documentations.chargerTexte(chemin, titre);
                this.activeInfos(auteur, titre, commentaires);
            } else {
                boolean regActif = tr.exporteInfo("reglet").equals("actif");
                boolean zoomActif = tr.exporteInfo("zoom").equals("actif");
                String unit = "";
                double ech = 1.0;
                if (regActif) {
                    unit = tr.exporteInfo("unite");
                    ech = Double.parseDouble(tr.exporteInfo("echelle"));
                }
                String auteur = tr.exporteInfo("auteur");
                String titre = tr.exporteInfo("titre");
                String commentaires = tr.exporteInfo("commentaire");
                if (type.equals("carte")) {
                    BarreEtat.afficheGauche("Les cartes ne peuvent \u00eatre affich\u00e9es dans la documentation.", Color.red);
                } else if (type.equals("image")) {
                    this.documentations.chargerImage(chemin, ech, unit, regActif, zoomActif, this.modeEdition, titre);
                    this.activeInfos(auteur, titre, commentaires);
                }
            }
        } else {
            BarreEtat.afficheGauche("ERREUR : Impossible de charger cette donn\u00e9e ! (probablement d\u00e9plac\u00e9e)", Color.red);
        }
        this.documentationsCB.setSelected(true);
        this.majAffichage();
    }

    public void afficheParametres() {
        if (this.modeEdition) {
            if (this.carteEnEdition && !this.fpec.isVisible()) {
                String typeVue;
                String reg = this.traceurCarteEdition.exporteInfo("reglet");
                boolean regActif = false;
                if (reg != null) {
                    reg.equals("actif");
                }
                String zoom = this.traceurCarteEdition.exporteInfo("zoom");
                boolean zoomActif = false;
                if (zoom != null) {
                    zoom.equals("actif");
                }
                if ((typeVue = this.traceurCarteEdition.exporteTypeVuePrincipale()) == null) {
                    typeVue = "";
                }
                String fichVue = this.traceurCarteEdition.exporteFichierVuePrincipale();
                String couleur = this.traceurCarteEdition.exporteInfo("couleurArrets");
                if (couleur == null) {
                    couleur = "255 255 255";
                }
                this.fpec = new FenetreParametresEditionCarte(this, fichVue);
                this.fpec.chargerParam(typeVue, regActif, zoomActif, couleur);
                this.fpec.setExtendedState(0);
            } else if (this.texteEnEdition && !this.fpet.isVisible()) {
                String typGeol;
                String commentaire;
                String titre;
                String auteur;
                String motscles;
                String nivo = this.traceurDonneeEdition.exporteInfo("niveau");
                if (nivo == null) {
                    nivo = "";
                }
                if ((motscles = this.traceurDonneeEdition.exporteInfo("motscles")) == null) {
                    motscles = "";
                }
                if ((auteur = this.traceurDonneeEdition.exporteInfo("auteur")) == null) {
                    auteur = "";
                }
                if ((titre = this.traceurDonneeEdition.exporteInfo("titre")) == null) {
                    titre = "";
                }
                if ((commentaire = this.traceurDonneeEdition.exporteInfo("commentaire")) == null) {
                    commentaire = "";
                }
                if ((typGeol = this.traceurDonneeEdition.exporteInfo("typeGeologique")) == null) {
                    typGeol = "";
                }
                this.fpet = new FenetreParametresEditionTexte(this);
                this.fpet.chargerParam(typGeol, nivo, auteur, titre, titre, motscles);
                this.fpet.setExtendedState(0);
            } else if (this.imageEnEdition && !this.fpei.isVisible()) {
                String typGeol;
                String commentaire;
                String titre;
                String auteur;
                String motscles;
                String nivo;
                String reg = this.traceurDonneeEdition.exporteInfo("reglet");
                boolean regActif = false;
                if (reg != null) {
                    reg.equals("actif");
                }
                String zoom = this.traceurDonneeEdition.exporteInfo("zoom");
                boolean zoomActif = false;
                if (zoom != null) {
                    zoom.equals("actif");
                }
                if ((nivo = this.traceurDonneeEdition.exporteInfo("niveau")) == null) {
                    nivo = "";
                }
                if ((motscles = this.traceurDonneeEdition.exporteInfo("motscles")) == null) {
                    motscles = "";
                }
                if ((auteur = this.traceurDonneeEdition.exporteInfo("auteur")) == null) {
                    auteur = "";
                }
                if ((titre = this.traceurDonneeEdition.exporteInfo("titre")) == null) {
                    titre = "";
                }
                if ((commentaire = this.traceurDonneeEdition.exporteInfo("commentaire")) == null) {
                    commentaire = "";
                }
                if ((typGeol = this.traceurDonneeEdition.exporteInfo("typeGeologique")) == null) {
                    typGeol = "";
                }
                this.fpei = new FenetreParametresEditionImage(this);
                this.fpei.chargerParam(typGeol, regActif, zoomActif, nivo, auteur, titre, titre, motscles);
                this.fpei.setExtendedState(0);
            }
        }
    }

    public void afficheNav(String donnee, String ndPere) {
        String cheminImage = "";
        String extension = "";
        String cheminXML = "";
        TraceurCarte tr = new TraceurCarte();
        if (ndPere.equals("carte")) {
            cheminImage = String.valueOf(this.espaceCartes) + this.traceurSession.exporteCarte();
            extension = donnee.substring(donnee.lastIndexOf("."));
            cheminXML = cheminImage.replace(extension, ".xml");
        } else if (ndPere.equals("arret")) {
            cheminImage = String.valueOf(this.espaceGeorefs) + donnee;
            extension = donnee.substring(donnee.lastIndexOf("."));
            cheminXML = cheminImage.replace(extension, ".xml");
        }
        boolean result = tr.charger(cheminXML);
        if (result) {
            BarreEtat.resetGauche();
            String type = tr.exporteType();
            if (type.equals("texte")) {
                String auteur = tr.exporteInfo("auteur");
                String titre = tr.exporteInfo("titre");
                String comment = tr.exporteInfo("commentaire");
                this.navigation.chargerTexte(cheminImage, titre);
                this.activeInfos(auteur, titre, comment);
            } else {
                boolean regActif = tr.exporteInfo("reglet").equals("actif");
                boolean zoomActif = tr.exporteInfo("zoom").equals("actif");
                String unit = "";
                double ech = 1.0;
                if (regActif) {
                    unit = tr.exporteInfo("unite");
                    ech = Double.parseDouble(tr.exporteInfo("echelle"));
                }
                String couleur = tr.exporteInfo("couleurArrets");
                String auteur = tr.exporteInfo("auteur");
                String titre = tr.exporteInfo("titre");
                String comment = tr.exporteInfo("commentaire");
                if (type.equals("carte")) {
                    this.navigation.chargerCarte(cheminImage, ech, unit, regActif, zoomActif, this.modeEdition, tr.construitArrets(), Integer.parseInt(tr.exporteInfo("latitude")), Integer.parseInt(tr.exporteInfo("longitude")), Double.parseDouble(tr.exporteInfo("echelleLatitude")), Double.parseDouble(tr.exporteInfo("echelleLongitude")), tr.exporteVues(), couleur, titre);
                    if (!donnee.equals(this.traceurSession.exporteCarte())) {
                        this.navigation.chargerVue(String.valueOf(this.espaceCartes) + donnee);
                        this.navigation.masquerVuePrincipale();
                    }
                } else if (type.equals("image")) {
                    this.navigation.chargerImage(cheminImage, ech, unit, regActif, zoomActif, this.modeEdition, titre);
                    this.activeInfos(auteur, titre, comment);
                }
            }
            this.navigationCB.setSelected(true);
            this.majAffichage();
            this.coordCB.setEnabled(type.equals("carte"));
            if (!this.coordCB.isEnabled()) {
                this.coordCB.setSelected(false);
            }
        } else {
            BarreEtat.afficheGauche("ERREUR : Impossible de charger cette donn\u00e9e ! (probablement d\u00e9plac\u00e9e)", Color.red);
        }
    }

    public void ajoutArretHisto(int idArret, String donnee) {
        this.sauv\u00e9 = false;
        Date date = new Date();
        String[] dateTab = this.traduireDate(date).split(" ");
        String[] heureTab = dateTab[3].split(":");
        this.historique.ajoutArret(idArret, donnee);
        this.traceurSession.ajouteDonneeArret(Integer.toString(idArret), donnee, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
    }

    public void ajouteArretCarte(int id, int latitude, int longitude) {
        this.traceurCarteEdition.ajouteArret(id, latitude, longitude);
        this.carteModifi\u00e9e = true;
        this.majAffichage();
    }

    public void ajouteCoordonnees(int latOrigine, int longOrigine, double echLat, double echLong) {
        this.traceurCarteEdition.ajouteCoord(Integer.toString(latOrigine), Integer.toString(longOrigine), Double.toString(echLat), Double.toString(echLong));
        this.carteModifi\u00e9e = true;
        this.fpec.setExtendedState(0);
        this.fpec.setDefCoordEffectuee(true);
        BarreEtat.resetGauche();
        this.majAffichage();
    }

    public ArrayList ajouteDonneeCarte(int id) {
        ArrayList<String> resultat = new ArrayList<String>();
        JFileChooser chooser = new JFileChooser(this.dossierNouvoLien);
        chooser.setDialogTitle("Choix de la donn\u00e9e (DEJA EDITEE) \u00e0 lier");
        FiltreExtensible filtre = new FiltreExtensible("Donn\u00e9es");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".rtf");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            String fichDest = String.valueOf(this.espaceGeorefs) + chooser.getSelectedFile().getName();
            String ext = fich.substring(fich.lastIndexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            String fichXMLDest = fichDest.replace(ext, ".xml");
            Traceur tr = new Traceur();
            boolean result = tr.charger(fichXML);
            if (result) {
                String typ = tr.exporteInfo("typeGeologique");
                String nom = chooser.getSelectedFile().getName();
                resultat.add(nom);
                resultat.add(typ);
                this.traceurCarteEdition.ajouteDonneeArret(nom, id, typ);
                if (!fich.contains(fichDest)) {
                    this.copier(chooser.getSelectedFile(), new File(fichDest));
                }
                chooser.getSelectedFile().delete();
                File fileXml = new File(fichXML);
                if (!fichXML.contains(fichXMLDest)) {
                    this.copier(fileXml, new File(fichXMLDest));
                }
                fileXml.delete();
                this.carteModifi\u00e9e = true;
                this.majAffichage();
                this.dossierNouvoLien = String.valueOf(fich.substring(0, fich.lastIndexOf("\\"))) + "\\";
            } else {
                BarreEtat.afficheGauche("ERREUR : La donn\u00e9e que vous avez voulu charger ne dispose pas de fichier d'informations !", Color.red);
            }
        }
        return resultat;
    }

    public void ajouteEchelle(double mesure, String cible) {
        new FenetreCalibrageReglet(this, mesure, cible);
    }

    public void enregEchelle(String cible, String unit, double dist, double mesure) {
        if (cible.equals("carte")) {
            this.traceurCarteEdition.ajouterElt("unite", unit);
        }
        if (cible.equals("image")) {
            this.traceurDonneeEdition.ajouterElt("unite", unit);
        }
        this.navigation.setUnite(unit);
        double rapport = dist / mesure;
        if (cible.equals("carte")) {
            this.traceurCarteEdition.ajouteEchelle(rapport);
        }
        if (cible.equals("image")) {
            this.traceurDonneeEdition.ajouteEchelle(rapport);
        }
        this.navigation.setEchelle(rapport);
        if (this.fpec != null) {
            this.fpec.setExtendedState(0);
            this.fpec.setMesureEffectuee(true);
        } else if (this.fpei != null) {
            this.fpei.setExtendedState(0);
            this.fpei.setMesureEffectuee(true);
        }
        this.carteModifi\u00e9e = true;
        this.docsModifi\u00e9 = true;
    }

    public void ajouteVue(String fich) {
        if (!this.modeEdition) {
            Date date = new Date();
            String[] dateTab = this.traduireDate(date).split(" ");
            String[] heureTab = dateTab[3].split(":");
            this.historique.ajouterVue(fich);
            this.traceurSession.ajouteVue(fich, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
            this.modifEffectuee(true);
        }
    }

    public void annoter(String elt, String pere, String texte) {
        this.traceurSession.ajouterAnnotation(elt, pere, texte);
        this.sauv\u00e9 = false;
        this.majAffichage();
    }

    private void aPropos() {
        this.rapportTrace("menu", "a propos");
        Object[] ok = new String[]{"OK"};
        ImageIcon icon = new ImageIcon(String.valueOf(this.espaceSysteme) + "logo.jpg");
        String texte = "G\u00e9onote (version 1.09b)\nInstitut National de Recherche P\u00e9dagogique\nSc\u00e9nario : Eric Sanchez\nR\u00e9alisation : Olivier Lefevre\nRemerciements \u00e0 : P. Federici, Y. Fesselier, A. Mille, M. Prieur";
        JOptionPane.showOptionDialog(this, texte, "A PROPOS", 0, 1, icon, ok, ok[0]);
    }

    private boolean authentification() {
        JPasswordField mdp = new JPasswordField(10);
        Object[] o = new Object[]{mdp, "Valider", "Annuler"};
        int retour = JOptionPane.showOptionDialog(null, "Saisissez le mot de passe.", "Contr\u00f4le d'acc\u00e8s", 1, 2, null, o, null);
        if (retour == 1) {
            char[] mot = mdp.getPassword();
            if (this.motDePasseCorrect(mot)) {
                BarreEtat.afficheGauche("MOT DE PASSE CORRECT !");
            } else {
                BarreEtat.afficheGauche("MOT DE PASSE INCORRECT !", Color.red);
            }
            return this.motDePasseCorrect(mot);
        }
        return false;
    }

    private void chargerDocs() {
        this.rapportTrace("menu", "ouverture document");
        JFrame fenetre = new JFrame("R\u00e9sultats");
        fenetre.setLayout(new BorderLayout());
        Box vBox = Box.createVerticalBox();
        int compteur = 0;
        Traceur traceur = new Traceur();
        ArrayList listeFichiers = this.listeRepertoire(new File(this.espaceDocs));
        Iterator i = listeFichiers.iterator();
        while (i.hasNext()) {
            final String chemin = (String)i.next();
            String extension = chemin.substring(chemin.lastIndexOf("."));
            final String cheminXML = chemin.replace(extension, ".xml");
            ImageIcon apercu = null;
            int largMax = 100;
            int hautMax = 100;
            boolean retour = traceur.charger(cheminXML);
            if (!retour) continue;
            final String type = traceur.exporteType();
            final String nomFichier = chemin.substring(chemin.lastIndexOf("\\") + 1, chemin.length());
            ImageIcon tmpIcon = new ImageIcon(chemin);
            if (tmpIcon != null) {
                int iconLarg = tmpIcon.getIconWidth();
                int iconHaut = tmpIcon.getIconHeight();
                apercu = iconLarg > largMax || iconHaut > hautMax ? (iconHaut - hautMax > iconLarg - largMax ? new ImageIcon(tmpIcon.getImage().getScaledInstance(-1, hautMax, 1)) : new ImageIcon(tmpIcon.getImage().getScaledInstance(largMax, -1, 1))) : tmpIcon;
            }
            JButton bouton = null;
            if (type.equals("carte") || type.equals("image")) {
                bouton = new JButton(apercu);
                bouton.setToolTipText(nomFichier);
            } else {
                bouton = new JButton(nomFichier);
            }
            bouton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    if (type.equals("image")) {
                        TraceurDonnee tr = new TraceurDonnee();
                        tr.charger(cheminXML);
                        boolean regActif = tr.exporteInfo("reglet").equals("actif");
                        boolean zoomActif = tr.exporteInfo("zoom").equals("actif");
                        String unit = "";
                        double ech = 1.0;
                        if (regActif) {
                            unit = tr.exporteInfo("unite");
                            ech = Double.parseDouble(tr.exporteInfo("echelle"));
                        }
                        String auteur = tr.exporteInfo("auteur");
                        String titre = tr.exporteInfo("titre");
                        String commentaire = tr.exporteInfo("commentaire");
                        Interface.this.documentations.chargerImage(chemin, ech, unit, regActif, zoomActif, Interface.this.modeEdition, titre);
                        Interface.this.activeInfos(auteur, titre, commentaire);
                    } else {
                        TraceurDonnee tr = new TraceurDonnee();
                        tr.charger(cheminXML);
                        String auteur = tr.exporteInfo("auteur");
                        String titre = tr.exporteInfo("titre");
                        String commentaire = tr.exporteInfo("commentaire");
                        Interface.this.documentations.chargerTexte(chemin, titre);
                        Interface.this.activeInfos(auteur, titre, commentaire);
                    }
                    Interface.this.documentationsCB.setSelected(true);
                    Interface.this.historique.ajouterDocs(nomFichier);
                    Interface.this.sauv\u00e9 = false;
                    Interface.this.majAffichage();
                }
            });
            JTextPane jtp = new JTextPane();
            jtp.setText(traceur.exporteInfo("commentaire"));
            jtp.setPreferredSize(new Dimension(50, 50));
            jtp.setEditable(false);
            jtp.setBackground(Color.white);
            jtp.setBorder(null);
            Box vBox2 = Box.createVerticalBox();
            vBox2.add(bouton);
            vBox2.add(Box.createVerticalStrut(5));
            JScrollPane jsp = new JScrollPane(jtp);
            jsp.setBorder(null);
            vBox2.add(jsp);
            vBox2.setBorder(BorderFactory.createTitledBorder(""));
            vBox.add(vBox2);
            vBox.add(Box.createVerticalStrut(5));
            ++compteur;
        }
        if (compteur > 0) {
            fenetre.setSize(new Dimension(200, 600));
            fenetre.setResizable(false);
            Box vBoxTotale = Box.createVerticalBox();
            vBoxTotale.add(new JScrollPane(vBox));
            fenetre.add((Component)vBoxTotale, "Center");
            fenetre.setVisible(true);
        } else {
            BarreEtat.afficheGauche("Aucune documentation disponible.", Color.red);
        }
        this.majAffichage();
    }

    private void chargerSession() {
        this.confirmation();
        JFileChooser chooser = new JFileChooser(this.espaceSessions);
        chooser.setDialogTitle("Chargement d'une session");
        FiltreExtensible filtre = new FiltreExtensible("Sessions");
        filtre.addExtension(".xml");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "chargement session", path);
            this.traceurSession = new TraceurSession();
            boolean result = this.traceurSession.charger(path);
            if (result) {
                String nomFichierRTF = chooser.getSelectedFile().getName().replace(".xml", ".rtf");
                this.carnet.charger(String.valueOf(this.espaceCarnet) + nomFichierRTF);
                TraceurCarte traceurCarte = new TraceurCarte();
                String cheminCarte = String.valueOf(this.espaceCartes) + this.traceurSession.exporteCarte();
                String extension = cheminCarte.substring(cheminCarte.lastIndexOf("."));
                boolean res = traceurCarte.charger(cheminCarte.replace(extension, ".xml"));
                if (res) {
                    this.documentations.desactiver();
                    this.historique.creerArbre(this.traceurSession.exporteInfo("nom"));
                    this.historique.ajouterDateSession(this.traceurSession.exporteInfo("jour"), this.traceurSession.exporteInfo("mois"), this.traceurSession.exporteInfo("annee"), this.traceurSession.exporteInfo("heures"), this.traceurSession.exporteInfo("minutes"), this.traceurSession.exporteInfo("secondes"));
                    this.historique.ajouterVue(this.traceurSession.exporteCarte());
                    this.historique.chargeArrets(this.traceurSession.exporteArretsHisto());
                    this.historique.ajouterDocs(this.traceurSession.exporteDocsHisto());
                    ArrayList liste = this.traceurSession.exporteAnnotations();
                    int i = 0;
                    while (i < liste.size()) {
                        ArrayList caps = (ArrayList)liste.get(i);
                        String chemin = caps.get(0).toString();
                        String annotation = caps.get(1).toString();
                        String pere = caps.get(2).toString();
                        this.historique.ajouteAnnotation(pere, chemin, annotation);
                        ++i;
                    }
                    boolean regActif = traceurCarte.exporteInfo("reglet").equals("actif");
                    boolean zoomActif = traceurCarte.exporteInfo("zoom").equals("actif");
                    String unit = "";
                    double ech = 1.0;
                    if (regActif) {
                        unit = traceurCarte.exporteInfo("unite");
                        ech = Double.parseDouble(traceurCarte.exporteInfo("echelle"));
                    }
                    String couleur = traceurCarte.exporteInfo("couleurArrets");
                    String auteur = traceurCarte.exporteInfo("auteur");
                    String titre = traceurCarte.exporteInfo("titre");
                    String comment = traceurCarte.exporteInfo("commentaire");
                    this.navigation.resetHisto();
                    this.navigation.chargerCarte(cheminCarte, ech, unit, regActif, zoomActif, this.modeEdition, traceurCarte.construitArrets(), Integer.parseInt(traceurCarte.exporteInfo("latitude")), Integer.parseInt(traceurCarte.exporteInfo("longitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLatitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLongitude")), traceurCarte.exporteVues(), couleur, titre);
                    this.activation(true);
                    this.majAffichage();
                    this.traceurTraces.ajouterTraces("menu", "chargerSession");
                    this.userName = this.traceurSession.exporteInfo("nom");
                    BarreEtat.afficheGauche("BIENVENUE " + this.userName + " !", new Color(0, 0, 192));
                } else {
                    BarreEtat.afficheGauche("ERREUR lors du chargement de la carte !", Color.red);
                }
            } else {
                BarreEtat.afficheGauche("ERREUR : Impossible d'ouvrir cette donn\u00e9e !", Color.red);
            }
        } else {
            this.rapportTrace("menu", "chargement session", "annulation");
        }
    }

    private void confirmation() {
        if (!this.sauv\u00e9) {
            int saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre session?", "Confirmation", 0, 3, null);
            while (saveOrNot != 0 && saveOrNot != 1) {
                saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre session?", "Confirmation", 0, 3, null);
            }
            if (saveOrNot == 0) {
                this.enregistrerSession();
            }
        } else if (this.enregEditPossible) {
            if (this.carteModifi\u00e9e) {
                int saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre carte ?", "Confirmation", 0, 3, null);
                while (saveOrNot != 0 && saveOrNot != 1) {
                    saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre carte ?", "Confirmation", 0, 3, null);
                }
                if (saveOrNot == 0) {
                    this.enregistrerEditionCarte();
                }
            } else if (this.docsModifi\u00e9) {
                int saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre donn\u00e9e ?", "Confirmation", 0, 3, null);
                while (saveOrNot != 0 && saveOrNot != 1) {
                    saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre donn\u00e9e ?", "Confirmation", 0, 3, null);
                }
                if (saveOrNot == 0) {
                    this.enregistrerEditionDonnee();
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copier(File source, File destination) {
        block15: {
            resultat = false;
            sourceFile = null;
            destinationFile = null;
            try {
                try {
                    destination.createNewFile();
                    sourceFile = new FileInputStream(source);
                    destinationFile = new FileOutputStream(destination);
                    buffer = new byte[524288];
                    while (true) {
                        if ((nbLecture = sourceFile.read(buffer)) == -1) {
                            resultat = true;
                        }
                        destinationFile.write(buffer, 0, nbLecture);
                    }
                }
                catch (FileNotFoundException var6_7) {
                }
                catch (IOException var6_8) {}
            }
            catch (Throwable var9_10) {
                var8_11 = null;
                try {
                    sourceFile.close();
                }
                catch (Exception var10_13) {
                    // empty catch block
                }
                try {
                    destinationFile.close();
                    throw var9_10;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw var9_10;
            }
            {
                var8_12 = null;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 92->100)] { 
lbl38:
            // 1 sources

            sourceFile.close();
            break block15;
lbl40:
            // 1 sources

            catch (Exception var10_14) {
                // empty catch block
            }
        }
        try {}
        catch (Exception e) {
            return resultat;
        }
        destinationFile.close();
        return resultat;
    }

    public void enConstruction() {
        BarreEtat.reset();
        String[] tab = new String[100];
        tab[0] = "Section en cours de developpement.";
        tab[1] = "Same player shoot again ! 8|";
        tab[2] = "Ca va pas \u00eatre possible l\u00e0 ... j'ai piscine :)";
        tab[3] = "Nan, j'veux p\u00f4 ! :(";
        int j = 4;
        while (j < 100) {
            tab[j] = tab[0];
            ++j;
        }
        int i = (int)(Math.random() * 100.0);
        BarreEtat.afficheGauche(tab[i], Color.red);
    }

    private void enregistrerEdition() {
        if (this.carteModifi\u00e9e) {
            this.rapportTrace("menu", "enregistrer edition", "carte");
            this.enregistrerEditionCarte();
        } else if (this.docsModifi\u00e9) {
            if (this.texteEnEdition) {
                this.rapportTrace("menu", "enregistrer edition", "texte");
                this.enregistrerEditionTexte();
            } else {
                this.rapportTrace("menu", "enregistrer edition", "donnee");
                this.enregistrerEditionDonnee();
            }
        }
    }

    private void enregistrerEditionTexte() {
        boolean res1 = this.traceurDonneeEdition.enregistrer();
        boolean res2 = this.carnet.enregistrer();
        if (res1 && res2) {
            this.docsModifi\u00e9 = false;
            if (this.sortie) {
                JOptionPane.showMessageDialog(new JFrame(), "Le texte a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", "Information", 1);
            } else {
                BarreEtat.afficheGauche("INFORMATION : Le texte a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", Color.BLUE);
            }
            this.majAffichage();
        } else if (this.sortie) {
            JOptionPane.showMessageDialog(new JFrame(), "Echec lors de l'enregistrement !", "Erreur", 2);
        } else {
            BarreEtat.afficheGauche("ERREUR : Echec lors de l'enregistrement !", Color.red);
        }
    }

    public void enregistrerEditionCarte() {
        boolean res = this.traceurCarteEdition.enregistrer();
        if (res) {
            this.carteModifi\u00e9e = false;
            if (this.sortie) {
                JOptionPane.showMessageDialog(new JFrame(), "La carte a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", "Information", 1);
            } else {
                BarreEtat.afficheGauche("INFORMATION : La carte a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", Color.BLUE);
            }
            this.majAffichage();
        } else if (this.sortie) {
            JOptionPane.showMessageDialog(new JFrame(), "Echec lors de l'enregistrement !", "Erreur", 2);
        } else {
            BarreEtat.afficheGauche("ERREUR : Echec lors de l'enregistrement !", Color.red);
        }
    }

    public void enregistrerEditionDonnee() {
        boolean res = this.traceurDonneeEdition.enregistrer();
        if (res) {
            this.docsModifi\u00e9 = false;
            if (this.sortie) {
                JOptionPane.showMessageDialog(new JFrame(), "La donn\u00e9e a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", "Information", 1);
            } else {
                BarreEtat.afficheGauche("INFORMATION : La donn\u00e9e a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", Color.BLUE);
            }
            this.majAffichage();
        } else if (this.sortie) {
            JOptionPane.showMessageDialog(new JFrame(), "Echec lors de l'enregistrement !", "Erreur", 2);
        } else {
            BarreEtat.afficheGauche("ERREUR : Echec lors de l'enregistrement !", Color.red);
        }
    }

    private void enregistrerSession() {
        this.rapportTrace("menu", "enregistrer session");
        boolean res1 = this.carnet.enregistrer();
        boolean res2 = this.traceurSession.enregistrer();
        if (res2) {
            if (res1) {
                this.sauv\u00e9 = true;
                if (this.sortie) {
                    JOptionPane.showMessageDialog(new JFrame(), "La session a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", "Information", 1);
                } else {
                    BarreEtat.afficheGauche("INFORMATION : La session a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s !", Color.BLUE);
                }
            } else if (this.sortie) {
                JOptionPane.showMessageDialog(new JFrame(), "Echec lors de l'enregistrement du carnet !", "Erreur", 2);
            } else {
                BarreEtat.afficheGauche("ERREUR : Echec lors de l'enregistrement du carnet !", Color.red);
            }
        } else if (this.sortie) {
            JOptionPane.showMessageDialog(new JFrame(), "Echec lors de l'enregistrement de la session !", "Erreur", 2);
        } else {
            BarreEtat.afficheGauche("ERREUR : Echec lors de l'enregistrement de la session !", Color.red);
        }
        this.majAffichage();
    }

    public boolean getAAA() {
        return this.arretsCB.isSelected();
    }

    public boolean getACA() {
        return this.coordCB.isSelected();
    }

    public void insertDepuis(String provenance) {
        ImageIcon im = null;
        ImageIcon carte = null;
        Texte texte = null;
        if (provenance.equals("docs")) {
            im = this.documentations.exporteImage();
            carte = this.documentations.exporteCarte();
            texte = this.documentations.exporteTexte();
        } else if (provenance.equals("navigation")) {
            im = this.navigation.exporteImage();
            carte = this.navigation.exporteCarte();
            texte = this.navigation.exporteTexte();
        }
        if (im != null) {
            JOptionPane.showMessageDialog(new JFrame(), "Ne fonctionne pas encore avec les images.", "ATTENTION !", 2);
        } else if (carte != null) {
            JOptionPane.showMessageDialog(new JFrame(), "Ne fonctionne pas encore avec les cartes.", "ATTENTION !", 2);
        } else if (texte != null) {
            texte.selectAll();
            texte.copy();
            this.carnet.coller();
        }
        this.modifEffectuee(true);
    }

    public boolean isModeSuppArret() {
        return this.modeSuppArret;
    }

    public boolean isModeSuppLien() {
        return this.modeSuppLien;
    }

    public boolean isModeSuppVue() {
        return this.modeSuppVue;
    }

    private void lancementAide() {
        this.rapportTrace("menu", "aide");
        try {
            Runtime.getRuntime().exec(String.valueOf(this.espaceAide) + "aide.bat");
        }
        catch (IOException e) {
            System.out.println("Erreur lancement");
            e.printStackTrace();
        }
    }

    private void lancementCalendrier() {
        this.rapportTrace("menu", "calendrier");
        try {
            Process proc = Runtime.getRuntime().exec(String.valueOf(this.espaceCalendrier) + "Calendrier.exe");
        }
        catch (IOException e) {
            System.out.println("Erreur lancement");
            e.printStackTrace();
        }
    }

    private void lancementLexique() {
        this.rapportTrace("menu", "lexique");
        try {
            Runtime.getRuntime().exec(String.valueOf(this.espaceLexique) + "lexique.bat");
        }
        catch (IOException e) {
            System.out.println("Erreur lancement");
            e.printStackTrace();
        }
        this.enConstruction();
    }

    public void masquerCarnet() {
        this.carnetCB.setSelected(false);
        this.majAffichage();
    }

    private void majAffichage() {
        if (this.modeEdition) {
            this.documentations.desactiver();
        }
        boolean tempDocs = this.documentations.isVisible();
        boolean tempVisu = this.navigation.isVisible();
        boolean tempHisto = this.historique.isVisible();
        boolean tempCarnet = this.carnet.isVisible();
        this.historique.setVisible(this.historiqueCB.isSelected() && !this.modeEdition);
        this.navigation.setVisible(this.navigationCB.isSelected());
        this.documentations.setVisible(this.documentations.rapportActivit\u00e9() && this.documentationsCB.isSelected() && !this.modeEdition);
        this.carnet.setVisible(this.carnetCB.isSelected() && !this.modeEdition);
        if (!(this.documentations.isVisible() || this.historique.isVisible() || this.navigation.isVisible() || this.carnet.isVisible())) {
            this.documentations.setVisible(tempDocs);
            this.documentationsCB.setSelected(tempDocs);
            this.historique.setVisible(tempHisto);
            this.historiqueCB.setSelected(tempHisto);
            this.carnet.setVisible(tempCarnet);
            this.carnetCB.setSelected(tempCarnet);
            this.navigation.setVisible(tempVisu);
            this.navigationCB.setSelected(tempVisu);
        }
        if (!tempDocs && this.documentations.isVisible()) {
            this.splitPane2.setDividerLocation(this.getWidth() * 3 / 8);
        }
        this.splitPane2.setVisible(this.navigation.isVisible() || this.documentations.isVisible());
        this.splitPane1.setVisible(this.historique.isVisible() || this.splitPane2.isVisible());
        this.arretsCB.setEnabled(this.navigation.isVisible() && this.navigation.exporteTypeActif().equals("carte"));
        this.arretSB.setEnabled(!this.modeEdition && this.navigation.isVisible() && this.navigation.exporteTypeActif().equals("carte"));
        if (!this.arretsCB.isEnabled()) {
            this.arretsCB.setSelected(false);
        }
        this.coordCB.setEnabled(this.navigation.isVisible() && this.navigation.exporteTypeActif().equals("carte"));
        this.coordSB.setEnabled(!this.modeEdition && this.navigation.isVisible() && this.navigation.exporteTypeActif().equals("carte"));
        if (!this.coordCB.isEnabled()) {
            this.coordCB.setSelected(false);
        }
        this.nouvSessionM.setEnabled(!this.modeEdition);
        this.chargSessionM.setEnabled(!this.modeEdition);
        this.enregM.setEnabled(!this.sauv\u00e9 && !this.modeEdition && this.fenetreActive);
        this.documentationsCB.setEnabled(this.documentations.rapportActivit\u00e9());
        if (!this.documentations.rapportActivit\u00e9()) {
            this.documentationsCB.setSelected(false);
        }
        this.affichageM.setEnabled(!this.modeEdition && this.fenetreActive);
        this.quatreSB.setEnabled(!this.modeEdition && this.fenetreActive);
        this.documentationsM.setEnabled(!this.modeEdition && this.fenetreActive);
        this.docSB.setEnabled(!this.modeEdition && this.fenetreActive);
        this.rechercheM.setEnabled(this.fenetreActive && !this.modeEdition);
        this.rechercheSB.setEnabled(this.fenetreActive && !this.modeEdition);
        this.precSB.setEnabled(!this.modeEdition && !this.navigation.premier() && this.navigationCB.isSelected());
        this.suivSB.setEnabled(!this.modeEdition && !this.navigation.dernier() && this.navigationCB.isSelected());
        this.edActiverM.setEnabled(!this.modeEdition);
        this.edDesactiverM.setEnabled(this.modeEdition);
        this.nouvM.setEnabled(this.modeEdition);
        this.nouvVueM.setEnabled(this.carteEnEdition);
        this.modifM.setEnabled(this.modeEdition);
        this.suppM.setEnabled(this.modeEdition);
        this.parametresEditM.setEnabled(this.modeEdition && (this.carteEnEdition || this.texteEnEdition || this.imageEnEdition));
        this.suppArretM.setEnabled(this.carteEnEdition);
        this.suppLienM.setEnabled(this.carteEnEdition);
        this.suppVueM.setEnabled(this.carteEnEdition);
        this.enregEditM.setEnabled(this.enregEditPossible && (this.carteModifi\u00e9e || this.docsModifi\u00e9 && this.modeEdition));
        if (this.modeEdition) {
            this.setTitle(" G\u00e9onote 1.09b  ~  MODE EDITION  /!\\");
            if (this.texteEnEdition) {
                this.carnet.setVisible(true);
                this.splitPane1.setVisible(false);
            } else {
                this.coordCB.setSelected(true);
                String typeActif = this.navigation.exporteTypeActif();
                if (typeActif.equals("carte")) {
                    this.arretsCB.setSelected(true);
                } else {
                    this.arretsCB.setSelected(false);
                }
            }
        } else {
            this.setTitle(" G\u00e9onote 1.09b");
        }
        this.repaintSplit();
        this.validate();
        this.repaint();
    }

    public void modifAnnotation(String elt, String texte) {
        this.traceurSession.modifierAnnotation(elt, texte);
        this.sauv\u00e9 = false;
        this.majAffichage();
    }

    public void activerModeDefCoord() {
        this.navigation.activerModeDefCoord();
        BarreEtat.afficheGauche("DEFINITION DES COORDONNEES GEOGRAPHIQUES (CLIC GAUCHE pour d\u00e9finir un point, ECHAP pour annuler)");
    }

    public void activerTraces(boolean b) {
        this.tracesActives = b;
    }

    public void suppAnnotation(String elt) {
        this.traceurSession.supprimerAnnotation(elt);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.sauv\u00e9 = false;
        this.majAffichage();
    }

    private void modifCarte() {
        JFileChooser chooser = new JFileChooser(this.espaceCartes);
        chooser.setDialogTitle("Choix de la carte \u00e0 modifier");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "modification (edition)", "carte", fich);
            String ext = fich.substring(fich.lastIndexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            this.traceurCarteEdition = new TraceurCarte();
            boolean res = this.traceurCarteEdition.charger(fichXML);
            if (!res) {
                BarreEtat.afficheGauche("ERREUR : La carte que vous avez voulu ouvrir ne poss\u00e8de pas de m\u00e9tadonn\u00e9es !", Color.red);
            } else {
                this.enregEditPossible = true;
                boolean regActif = this.traceurCarteEdition.exporteInfo("reglet").equals("actif");
                boolean zoomActif = this.traceurCarteEdition.exporteInfo("zoom").equals("actif");
                String typeVue = this.traceurCarteEdition.exporteTypeVuePrincipale();
                String couleur = this.traceurCarteEdition.exporteInfo("couleurArrets");
                String unit = "";
                double ech = 1.0;
                if (regActif) {
                    unit = this.traceurCarteEdition.exporteInfo("unite");
                    ech = Double.parseDouble(this.traceurCarteEdition.exporteInfo("echelle"));
                }
                String titre = this.traceurCarteEdition.exporteInfo("titre");
                this.navigation.chargerCarte(fich, ech, unit, regActif, zoomActif, this.modeEdition, this.traceurCarteEdition.construitArrets(), Integer.parseInt(this.traceurCarteEdition.exporteInfo("latitude")), Integer.parseInt(this.traceurCarteEdition.exporteInfo("longitude")), Double.parseDouble(this.traceurCarteEdition.exporteInfo("echelleLatitude")), Double.parseDouble(this.traceurCarteEdition.exporteInfo("echelleLongitude")), this.traceurCarteEdition.exporteVues(), couleur, titre);
                this.fpec = new FenetreParametresEditionCarte(this, chooser.getSelectedFile().getName());
                this.fpec.chargerParam(typeVue, regActif, zoomActif, couleur);
                this.fpei = null;
                this.fpet = null;
                this.carteModifi\u00e9e = true;
                this.carteEnEdition = true;
                this.texteEnEdition = false;
                this.imageEnEdition = false;
                this.docsModifi\u00e9 = false;
                this.majAffichage();
            }
        }
    }

    private void modifDonnee() {
        JFileChooser chooser = new JFileChooser(this.espaceDonnees);
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 modifier");
        FiltreExtensible filtre = new FiltreExtensible("Donnees");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".rtf");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "modification (edition)", "donnee", fich);
            String ext = fich.substring(fich.lastIndexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            this.traceurDonneeEdition = new TraceurDonnee();
            boolean res = this.traceurDonneeEdition.charger(fichXML);
            if (!res) {
                BarreEtat.afficheGauche("ERREUR : La donn\u00e9e que vous avez voulu ouvrir ne poss\u00e8de pas de m\u00e9tadonn\u00e9es !", Color.red);
            } else {
                this.enregEditPossible = true;
                String type = this.traceurDonneeEdition.exporteType();
                if (type.equals("texte")) {
                    String titre;
                    String nivo = this.traceurDonneeEdition.exporteInfo("niveau");
                    String motscles = this.traceurDonneeEdition.exporteInfo("motscles");
                    String auteur = this.traceurDonneeEdition.exporteInfo("auteur");
                    if (auteur == null) {
                        auteur = "";
                    }
                    if ((titre = this.traceurDonneeEdition.exporteInfo("titre")) == null) {
                        titre = "";
                    }
                    String commentaire = this.traceurDonneeEdition.exporteInfo("commentaire");
                    String typGeol = this.traceurDonneeEdition.exporteInfo("typeGeologique");
                    this.navigation.chargerTexte(fich, titre);
                    this.fpet = new FenetreParametresEditionTexte(this);
                    this.fpet.chargerParam(typGeol, nivo, auteur, titre, titre, motscles);
                    this.fpei = null;
                    this.fpec = null;
                    this.texteEnEdition = true;
                    this.imageEnEdition = false;
                } else if (type.equals("image")) {
                    String titre;
                    boolean regActif = this.traceurDonneeEdition.exporteInfo("reglet").equals("actif");
                    boolean zoomActif = this.traceurDonneeEdition.exporteInfo("zoom").equals("actif");
                    String nivo = this.traceurDonneeEdition.exporteInfo("niveau");
                    String motscles = this.traceurDonneeEdition.exporteInfo("motscles");
                    String auteur = this.traceurDonneeEdition.exporteInfo("auteur");
                    if (auteur == null) {
                        auteur = "";
                    }
                    if ((titre = this.traceurDonneeEdition.exporteInfo("titre")) == null) {
                        titre = "";
                    }
                    String commentaire = this.traceurDonneeEdition.exporteInfo("commentaire");
                    String typGeol = this.traceurDonneeEdition.exporteInfo("typeGeologique");
                    this.navigation.chargerImage(fich, 1.0, "", regActif, zoomActif, this.modeEdition, titre);
                    this.fpei = new FenetreParametresEditionImage(this);
                    this.fpei.chargerParam(typGeol, regActif, zoomActif, nivo, auteur, titre, titre, motscles);
                    this.fpec = null;
                    this.fpet = null;
                    this.texteEnEdition = false;
                    this.imageEnEdition = true;
                }
                this.docsModifi\u00e9 = true;
                this.carteEnEdition = false;
                this.carteModifi\u00e9e = false;
                this.majAffichage();
            }
        }
    }

    private void modifEffectuee(boolean b) {
        boolean temp = this.sauv\u00e9;
        boolean bl = this.sauv\u00e9 = !b;
        if (temp != this.sauv\u00e9) {
            this.majAffichage();
        }
    }

    public void modifTexteEffectuee(boolean b) {
        if (this.texteEnEdition) {
            boolean temp = this.docsModifi\u00e9;
            this.docsModifi\u00e9 = b;
            if (temp != this.docsModifi\u00e9) {
                this.majAffichage();
            }
        } else {
            boolean temp = this.sauv\u00e9;
            boolean bl = this.sauv\u00e9 = !b;
            if (temp != this.sauv\u00e9) {
                this.majAffichage();
            }
        }
    }

    private boolean motDePasseCorrect(char[] saisie) {
        String mot = this.pswd;
        char[] mdp = new char[mot.length()];
        mdp = mot.toCharArray();
        boolean retour = true;
        int i = 0;
        while (i < mdp.length && i < saisie.length && retour) {
            retour = saisie[i] == mdp[i];
            ++i;
        }
        if (saisie.length == 0) {
            retour = false;
        }
        return retour;
    }

    private void nouvCarte() {
        this.confirmation();
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la carte principale \u00e0 editer");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            this.enregEditPossible = false;
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "creation (edition)", "carte", fich);
            String fichDest = String.valueOf(this.espaceCartes) + chooser.getSelectedFile().getName();
            if (!fich.contains(fichDest)) {
                this.copier(chooser.getSelectedFile(), new File(fichDest));
            }
            String ext = fichDest.substring(fichDest.lastIndexOf("."));
            String fichXML = fichDest.replace(ext, ".xml");
            this.traceurCarteEdition = new TraceurCarte(fichXML, "carte");
            this.navigation.chargerCarte(fichDest, 1.0, "", true, true, this.modeEdition, null, 0, 0, 1.0, 1.0, new ArrayList(), "255 255 255", "");
            this.fpec = new FenetreParametresEditionCarte(this, chooser.getSelectedFile().getName());
            this.fpei = null;
            this.fpet = null;
            this.carteModifi\u00e9e = true;
            this.carteEnEdition = true;
            this.texteEnEdition = false;
            this.imageEnEdition = false;
            this.docsModifi\u00e9 = false;
            this.majAffichage();
        }
    }

    public void enregParamCarteEditee(String fichier, String typeVue, boolean reglet, boolean zoom, String coulArrets) {
        this.traceurCarteEdition.ajouteVue(typeVue, fichier);
        this.navigation.rechargeTypBarre(this.traceurCarteEdition.exporteVues(), this.espaceCartes);
        if (reglet) {
            this.traceurCarteEdition.ajouterElt("reglet", "actif");
            this.navigation.activeReglet(true);
        } else {
            this.traceurCarteEdition.ajouterElt("reglet", "inactif");
            this.navigation.activeReglet(false);
        }
        if (zoom) {
            this.traceurCarteEdition.ajouterElt("zoom", "actif");
        } else {
            this.traceurCarteEdition.ajouterElt("zoom", "inactif");
        }
        this.traceurCarteEdition.ajouterElt("couleurArrets", coulArrets);
        this.navigation.chargerCouleurArrets(coulArrets);
        this.carteModifi\u00e9e = true;
        this.majAffichage();
    }

    private void nouvDonnee() {
        this.confirmation();
        JFileChooser chooser = new JFileChooser(this.dossierNouvelleDonnee);
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 \u00e9diter");
        FiltreExtensible filtre = new FiltreExtensible("Donnees");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".rtf");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            this.enregEditPossible = false;
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "creation (edition)", "donnee", fich);
            String fichDest = String.valueOf(this.espaceDocs) + chooser.getSelectedFile().getName();
            if (!fich.contains(fichDest)) {
                this.copier(chooser.getSelectedFile(), new File(fichDest));
            }
            String ext = fichDest.substring(fichDest.lastIndexOf("."));
            String fichXML = fichDest.replace(ext, ".xml");
            if (ext.equals(".rtf")) {
                this.traceurDonneeEdition = new TraceurDonnee(fichXML, "texte");
                this.carnet.charger(fichDest);
                this.texteEnEdition = true;
                this.imageEnEdition = false;
                this.fpet = new FenetreParametresEditionTexte(this);
                this.fpei = null;
                this.fpec = null;
            } else {
                this.traceurDonneeEdition = new TraceurDonnee(fichXML, "image");
                this.navigation.chargerImage(fichDest, 1.0, "", true, true, this.modeEdition, "");
                this.texteEnEdition = false;
                this.imageEnEdition = true;
                this.fpei = new FenetreParametresEditionImage(this);
                this.fpec = null;
                this.fpet = null;
            }
            this.docsModifi\u00e9 = true;
            this.carteEnEdition = false;
            this.carteModifi\u00e9e = false;
            this.majAffichage();
            this.dossierNouvelleDonnee = String.valueOf(fich.substring(0, fich.lastIndexOf("\\"))) + "\\";
        }
    }

    public void enregParamTexteEditee(String typeGeol, String nivo, String auteur, String titre, String commentaire, String motsCl\u00e9s) {
        this.traceurDonneeEdition.ajouterElt("typeGeologique", typeGeol);
        this.traceurDonneeEdition.ajouterElt("niveau", nivo);
        this.traceurDonneeEdition.ajouterElt("auteur", auteur);
        this.traceurDonneeEdition.ajouterElt("titre", titre);
        this.traceurDonneeEdition.ajouterElt("commentaire", commentaire);
        this.traceurDonneeEdition.ajouterElt("motscles", motsCl\u00e9s);
        this.traceurDonneeEdition.ajouterElt("etat", "accessible");
        this.docsModifi\u00e9 = true;
        this.majAffichage();
    }

    public void enregParamDonneeEditee(String typeGeol, boolean reglet, boolean zoom, String nivo, String auteur, String titre, String commentaire, String motsCl\u00e9s) {
        this.traceurDonneeEdition.ajouterElt("typeGeologique", typeGeol);
        if (reglet) {
            this.traceurDonneeEdition.ajouterElt("reglet", "actif");
            this.navigation.activeReglet(true);
        } else {
            this.traceurDonneeEdition.ajouterElt("reglet", "inactif");
            this.navigation.activeReglet(false);
        }
        if (zoom) {
            this.traceurDonneeEdition.ajouterElt("zoom", "actif");
        } else {
            this.traceurDonneeEdition.ajouterElt("zoom", "inactif");
        }
        this.traceurDonneeEdition.ajouterElt("niveau", nivo);
        this.traceurDonneeEdition.ajouterElt("auteur", auteur);
        this.traceurDonneeEdition.ajouterElt("titre", titre);
        this.traceurDonneeEdition.ajouterElt("commentaire", commentaire);
        this.traceurDonneeEdition.ajouterElt("motscles", motsCl\u00e9s);
        this.traceurDonneeEdition.ajouterElt("etat", "");
        this.docsModifi\u00e9 = true;
        this.majAffichage();
    }

    private void nouvelleSession() {
        this.confirmation();
        this.userName = JOptionPane.showInputDialog(this, "Nom d'utilisateur :", "Nouvelle session", 1);
        if (this.userName != null && !this.userName.matches("") && !this.userName.contains(" ")) {
            this.rapportTrace("menu", "nouvelle session", "utilisateur : " + this.userName);
            final JFrame fenetre = new JFrame("Cartes");
            fenetre.setLayout(new BorderLayout());
            Box vBox = Box.createVerticalBox();
            int compteur = 0;
            Traceur traceur = new Traceur();
            ArrayList listeFichiers = this.listeRepertoire(new File(this.espaceCartes));
            Iterator i = listeFichiers.iterator();
            while (i.hasNext()) {
                final String chemin = (String)i.next();
                final String extension = chemin.substring(chemin.lastIndexOf("."));
                final String cheminXML = chemin.replace(extension, ".xml");
                ImageIcon apercu = null;
                int largMax = 100;
                int hautMax = 100;
                boolean retour = traceur.charger(cheminXML);
                if (!retour) continue;
                String type = traceur.exporteType();
                final String nomFichier = chemin.substring(chemin.lastIndexOf("\\") + 1, chemin.length());
                ImageIcon tmpIcon = new ImageIcon(chemin);
                if (tmpIcon != null) {
                    int iconLarg = tmpIcon.getIconWidth();
                    int iconHaut = tmpIcon.getIconHeight();
                    apercu = iconLarg > largMax || iconHaut > hautMax ? (iconHaut - hautMax > iconLarg - largMax ? new ImageIcon(tmpIcon.getImage().getScaledInstance(-1, hautMax, 1)) : new ImageIcon(tmpIcon.getImage().getScaledInstance(largMax, -1, 1))) : tmpIcon;
                }
                JButton bouton = null;
                if (!type.equals("carte")) continue;
                bouton = new JButton(apercu);
                bouton.setToolTipText(nomFichier);
                bouton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        Interface.this.documentations.desactiver();
                        TraceurCarte traceurCarte = new TraceurCarte();
                        traceurCarte.charger(cheminXML);
                        boolean regActif = traceurCarte.exporteInfo("reglet").matches("actif");
                        boolean zoomActif = traceurCarte.exporteInfo("zoom").matches("actif");
                        String unit = "";
                        String ech = "";
                        if (regActif) {
                            unit = traceurCarte.exporteInfo("unite");
                            ech = traceurCarte.exporteInfo("echelle");
                        }
                        String couleur = traceurCarte.exporteInfo("couleurArrets");
                        String titre = traceurCarte.exporteInfo("titre");
                        Interface.this.navigation.resetHisto();
                        Interface.this.navigation.chargerCarte(chemin, Double.parseDouble(ech), unit, regActif, zoomActif, Interface.this.modeEdition, traceurCarte.construitArrets(), Integer.parseInt(traceurCarte.exporteInfo("latitude")), Integer.parseInt(traceurCarte.exporteInfo("longitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLatitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLongitude")), traceurCarte.exporteVues(), couleur, titre);
                        Date date = new Date();
                        String[] dateTab = Interface.this.traduireDate(date).split(" ");
                        String[] heureTab = dateTab[3].split(":");
                        String heure = dateTab[3].replaceFirst(":", "h");
                        heure = heure.replaceFirst(":", "m");
                        String nomCarte = nomFichier.replace(extension, "");
                        Interface.this.nomFichierSession = String.valueOf(Interface.this.userName) + "_" + dateTab[2] + "-" + dateTab[1] + "-" + dateTab[5] + "_" + heure + "_" + nomCarte + ".xml";
                        String nomFichierRTF = Interface.this.nomFichierSession.replace(".xml", ".rtf");
                        Interface.this.carnet.creer(String.valueOf(Interface.this.espaceCarnet) + nomFichierRTF);
                        Interface.this.historique.creerArbre(Interface.this.userName);
                        Interface.this.historique.ajouterDateSession(dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                        Interface.this.historique.ajouterVue(nomFichier);
                        Interface.this.traceurSession = new TraceurSession(String.valueOf(Interface.this.espaceSessions) + "\\" + Interface.this.nomFichierSession, "session");
                        Interface.this.traceurSession.ajouterElt("nom", Interface.this.userName);
                        Interface.this.traceurSession.ajouteVue(nomFichier, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                        Interface.this.traceurSession.ajouterDate(dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
                        Interface.this.traceurSession.ajouteCarnet(nomFichierRTF);
                        Interface.this.activation(true);
                        Interface.this.modifEffectuee(true);
                        Interface.this.rapportTrace("nouvelleSession", Interface.this.userName);
                        BarreEtat.afficheGauche("BIENVENUE " + Interface.this.userName + " !", new Color(0, 0, 192));
                        fenetre.dispose();
                    }
                });
                JLabel lab = new JLabel(nomFichier.replace(extension, ""));
                Box vBox2 = Box.createVerticalBox();
                vBox2.add(bouton);
                vBox2.add(Box.createVerticalStrut(5));
                vBox2.add(lab);
                vBox2.setBorder(BorderFactory.createTitledBorder(""));
                vBox.add(vBox2);
                vBox.add(Box.createVerticalStrut(5));
                ++compteur;
            }
            if (compteur > 0) {
                fenetre.setSize(new Dimension(200, 600));
                fenetre.setResizable(false);
                Box vBoxTotale = Box.createVerticalBox();
                vBoxTotale.add(new JScrollPane(vBox));
                fenetre.add((Component)vBoxTotale, "Center");
                fenetre.setVisible(true);
            } else {
                BarreEtat.afficheGauche("Aucune documentation disponible.", Color.red);
            }
        } else {
            this.rapportTrace("menu", "nouvelle session", "annulation");
        }
    }

    private void nouvVue() {
        JFileChooser chooser = new JFileChooser(this.dossierNouvelleVue);
        chooser.setDialogTitle("Choix de la vue \u00e0 ajouter");
        FiltreExtensible filtre = new FiltreExtensible("Donn\u00e9es");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        filtre.addExtension(".png");
        chooser.addChoosableFileFilter(filtre);
        chooser.setAccessory(new ImagePreview(chooser));
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "creation (edition)", "vue", fich);
            String fichDest = String.valueOf(this.espaceCartes) + chooser.getSelectedFile().getName();
            String type = JOptionPane.showInputDialog(new JFrame(), "Quel est le nom/type de cette vue (satellite, topographique, ...) ?\n(\u00e9vitez les accents)", "Parametrage", 3);
            if (type != null && !type.matches("")) {
                this.traceurCarteEdition.ajouteVue(type, chooser.getSelectedFile().getName());
                this.navigation.rechargeTypBarre(this.traceurCarteEdition.exporteVues(), this.espaceCartes);
                if (!fich.contains(fichDest)) {
                    this.copier(chooser.getSelectedFile(), new File(fichDest));
                }
                this.carteModifi\u00e9e = true;
                this.dossierNouvelleDonnee = String.valueOf(fich.substring(0, fich.lastIndexOf("\\"))) + "\\";
            }
        }
    }

    private void parametrage() {
        boolean verif = this.authentification();
        if (verif) {
            new FenetreParametrage(this, this.espaceCartes, this.espaceDocs, this.espaceGeorefs, this.espaceDeTravail);
        }
    }

    private void quitter() {
        int quit = JOptionPane.showConfirmDialog(new JFrame(), "Etes-vous s\u00fbr(e) de vouloir quitter ?", "Confirmation", 0, 2, null);
        if (quit == 0) {
            this.sortie = true;
            this.confirmation();
            this.rapportTrace("menu", "quitter");
            if (this.tracesActives) {
                this.traceurTraces.enregistrer();
            }
            this.dispose();
            System.exit(0);
        }
    }

    public void rapportTrace(String entit\u00e9, String action) {
        if (this.tracesActives) {
            this.traceurTraces.ajouterTraces(entit\u00e9, action);
        }
    }

    public void rapportTrace(String entit\u00e9, String action, String param1) {
        if (this.tracesActives) {
            this.traceurTraces.ajouterTraces(entit\u00e9, action, param1);
        }
    }

    public void rapportTrace(String entit\u00e9, String action, String param1, String param2) {
        if (this.tracesActives) {
            this.traceurTraces.ajouterTraces(entit\u00e9, action, param1, param2);
        }
    }

    private void repaintSplit() {
        if (this.splitPane1.getDividerLocation() <= this.splitPane1.getMinimumDividerLocation() || this.splitPane1.getDividerLocation() >= this.splitPane1.getMaximumDividerLocation()) {
            this.splitPane1.setDividerLocation(this.getWidth() / 4);
        }
        if (this.splitPane2.getDividerLocation() <= this.splitPane2.getMinimumDividerLocation() || this.splitPane2.getDividerLocation() >= this.splitPane2.getMaximumDividerLocation()) {
            this.splitPane2.setDividerLocation(this.getWidth() * 3 / 8);
        }
        if (this.splitPanePrincipal.getDividerLocation() <= this.splitPanePrincipal.getMinimumDividerLocation() || this.splitPanePrincipal.getDividerLocation() >= this.splitPanePrincipal.getMaximumDividerLocation()) {
            this.splitPanePrincipal.setDividerLocation(this.getHeight() * 3 / 4);
        }
    }

    private ArrayList listeRepertoire(File repertoire) {
        ArrayList<String> liste = new ArrayList<String>();
        if (repertoire.isDirectory()) {
            File[] list = repertoire.listFiles();
            int i = 0;
            while (i < list.length) {
                liste.addAll(this.listeRepertoire(list[i]));
                ++i;
            }
        } else if (repertoire.getAbsolutePath().contains(".") && !repertoire.getAbsolutePath().contains(".xml")) {
            liste.add(repertoire.getAbsolutePath());
        }
        return liste;
    }

    private boolean correspondance(String a, String b) {
        boolean resultat = false;
        String[] tabA = a.split(" ");
        String[] tabB = b.split(" ");
        int i = 0;
        while (i < tabA.length && !resultat) {
            int j = 0;
            while (j < tabB.length && !resultat) {
                if (tabA[i].equals(tabB[j])) {
                    resultat = true;
                }
                ++j;
            }
            ++i;
        }
        return resultat;
    }

    private void recherche(String dossier) {
        String mot = JOptionPane.showInputDialog(new JFrame(), "Mot(s) cl\u00e9(s) :", "Recherche", 3);
        TraceurCarte trc = new TraceurCarte();
        String nomCarte = this.traceurSession.exporteCarte();
        String extens = nomCarte.substring(nomCarte.lastIndexOf("."));
        trc.charger(String.valueOf(this.espaceCartes) + nomCarte.replace(extens, ".xml"));
        ArrayList listeGeorefs = trc.exporteFichiers();
        if (mot != null && !mot.equals("")) {
            JFrame fenetre = new JFrame("R\u00e9sultats de la recherche");
            fenetre.setLayout(new BorderLayout());
            Box vBox = Box.createVerticalBox();
            int compteur = 0;
            Traceur traceur = new Traceur();
            ArrayList listeFichiers = this.listeRepertoire(new File(dossier));
            Iterator i = listeFichiers.iterator();
            while (i.hasNext()) {
                String nomFichier;
                final String chemin = (String)i.next();
                String extension = chemin.substring(chemin.lastIndexOf("."));
                final String cheminXML = chemin.replace(extension, ".xml");
                ImageIcon apercu = null;
                int largMax = 100;
                int hautMax = 100;
                boolean retour = traceur.charger(cheminXML);
                if (!retour) continue;
                String mots = traceur.exporteInfo("motscles");
                final String type = traceur.exporteType();
                if (mots == null || !this.correspondance(mots, mot) || !listeGeorefs.contains(nomFichier = chemin.substring(chemin.lastIndexOf("\\") + 1, chemin.length()))) continue;
                ImageIcon tmpIcon = new ImageIcon(chemin);
                if (tmpIcon != null) {
                    int iconLarg = tmpIcon.getIconWidth();
                    int iconHaut = tmpIcon.getIconHeight();
                    apercu = iconLarg > largMax || iconHaut > hautMax ? (iconHaut - hautMax > iconLarg - largMax ? new ImageIcon(tmpIcon.getImage().getScaledInstance(-1, hautMax, 1)) : new ImageIcon(tmpIcon.getImage().getScaledInstance(largMax, -1, 1))) : tmpIcon;
                }
                JButton bouton = null;
                boolean ok = false;
                if (type.equals("image")) {
                    bouton = new JButton(apercu);
                    bouton.setToolTipText(String.valueOf(nomFichier) + " (arr\u00eat n\u00b0" + Integer.toString(trc.exporteIdArret(nomFichier)) + ")");
                    ok = true;
                } else if (type.equals("texte")) {
                    bouton = new JButton(nomFichier);
                    bouton.setToolTipText("arr\u00eat n\u00b0" + Integer.toString(trc.exporteIdArret(nomFichier)));
                    ok = true;
                }
                if (!ok) continue;
                bouton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        if (type.equals("image")) {
                            TraceurDonnee tr = new TraceurDonnee();
                            tr.charger(cheminXML);
                            boolean regActif = tr.exporteInfo("reglet").equals("actif");
                            boolean zoomActif = tr.exporteInfo("zoom").equals("actif");
                            String unit = "";
                            double ech = 1.0;
                            if (regActif) {
                                unit = tr.exporteInfo("unite");
                                ech = Double.parseDouble(tr.exporteInfo("echelle"));
                            }
                            String auteur = tr.exporteInfo("auteur");
                            String titre = tr.exporteInfo("titre");
                            String commentaire = tr.exporteInfo("commentaire");
                            Interface.this.documentations.chargerImage(chemin, ech, unit, regActif, zoomActif, Interface.this.modeEdition, titre);
                            Interface.this.activeInfos(auteur, titre, commentaire);
                        } else {
                            TraceurDonnee tr = new TraceurDonnee();
                            tr.charger(cheminXML);
                            String auteur = tr.exporteInfo("auteur");
                            String titre = tr.exporteInfo("titre");
                            String commentaire = tr.exporteInfo("commentaire");
                            Interface.this.documentations.chargerTexte(chemin, titre);
                            Interface.this.activeInfos(auteur, titre, commentaire);
                        }
                        Interface.this.documentationsCB.setSelected(true);
                        Interface.this.historique.ajoutRecherche(nomFichier);
                        Interface.this.sauv\u00e9 = false;
                        Interface.this.majAffichage();
                    }
                });
                JTextPane jtp = new JTextPane();
                jtp.setText(traceur.exporteInfo("commentaire"));
                jtp.setPreferredSize(new Dimension(50, 50));
                jtp.setEditable(false);
                jtp.setBackground(Color.white);
                jtp.setBorder(null);
                Box vBox2 = Box.createVerticalBox();
                vBox2.add(bouton);
                vBox2.add(Box.createVerticalStrut(5));
                JScrollPane jsp = new JScrollPane(jtp);
                jsp.setBorder(null);
                vBox2.add(jsp);
                vBox2.setBorder(BorderFactory.createTitledBorder(""));
                vBox.add(vBox2);
                vBox.add(Box.createVerticalStrut(5));
                ++compteur;
            }
            if (compteur > 0) {
                fenetre.setSize(new Dimension(200, 600));
                fenetre.setResizable(false);
                Box vBoxTotale = Box.createVerticalBox();
                vBoxTotale.add(new JScrollPane(vBox));
                fenetre.add((Component)vBoxTotale, "Center");
                fenetre.add((Component)new JLabel("carte : " + nomCarte), "South");
                fenetre.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "Aucune donn\u00e9e ne correspond \u00e0 votre recherche.", "R\u00e9sultats", 1);
            }
        }
    }

    private void suppArret() {
        this.modeSuppArret = true;
        BarreEtat.afficheGauche("SUPPRESSION D'UN ARRET (CLIC GAUCHE pour supprimer un arr\u00eat, ECHAP pour annuler)", Color.MAGENTA);
    }

    public void suppArretEffectue(int i) {
        this.traceurCarteEdition.suppArret(i);
        this.modeSuppArret = false;
        BarreEtat.resetGauche();
        this.setCursor(Cursor.getDefaultCursor());
        this.carteModifi\u00e9e = true;
        this.majAffichage();
    }

    private void suppCarte() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la carte \u00e0 supprimer");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "suppression (edition)", "carte", fich);
            String ext = fich.substring(fich.lastIndexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            boolean b1 = chooser.getSelectedFile().delete();
            File xml = new File(fichXML);
            boolean b2 = xml.delete();
            if (b1) {
                BarreEtat.afficheGauche("INFORMATION : La carte a \u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s !", Color.BLUE);
            }
            if (b2) {
                BarreEtat.afficheGauche("INFORMATION : Les m\u00e9tadonn\u00e9es de la carte ont \u00e9t\u00e9 supprim\u00e9es avec succ\u00e8s !", Color.BLUE);
            }
        }
        this.repaint();
    }

    private void suppDonnee() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle("Choix de la donn\u00e9e \u00e0 supprimer");
        FiltreExtensible filtre = new FiltreExtensible("Images");
        filtre.addExtension(".jpg");
        filtre.addExtension(".gif");
        chooser.addChoosableFileFilter(filtre);
        chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
        int returnVal = chooser.showOpenDialog(chooser.getParent());
        if (returnVal == 0) {
            String fich = chooser.getSelectedFile().getPath();
            this.rapportTrace("menu", "suppression (edition)", "donnee", fich);
            String ext = fich.substring(fich.lastIndexOf("."));
            String fichXML = fich.replace(ext, ".xml");
            boolean b1 = chooser.getSelectedFile().delete();
            File xml = new File(fichXML);
            boolean b2 = xml.delete();
            if (b1) {
                BarreEtat.afficheGauche("INFORMATION : La donn\u00e9e a \u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s !", Color.blue);
            }
            if (b2) {
                BarreEtat.afficheGauche("INFORMATION : Les m\u00e9tadonn\u00e9es de la donn\u00e9e ont \u00e9t\u00e9 supprim\u00e9es avec succ\u00e8s !", Color.blue);
            }
        }
        this.repaint();
    }

    private void suppLien() {
        this.modeSuppLien = true;
        BarreEtat.afficheGauche("SUPPRESSION D'UN LIEN (CLIC GAUCHE pour supprimer un lien, ECHAP pour annuler)", Color.red);
    }

    public void suppLienEffectue(int i, String lien) {
        this.traceurCarteEdition.suppLien(i, lien);
        this.modeSuppLien = false;
        BarreEtat.resetGauche();
        this.setCursor(Cursor.getDefaultCursor());
        this.carteModifi\u00e9e = true;
        this.majAffichage();
    }

    private void suppVue() {
        ArrayList list = this.traceurCarteEdition.exporteVues();
        if (list.size() > 1) {
            this.modeSuppVue = true;
            this.setCursor(this.suppCurseur);
            BarreEtat.afficheGauche("SUPPRESSION D'UNE VUE (CLIC GAUCHE pour supprimer une vue, ECHAP pour annuler)", Color.red);
        } else {
            BarreEtat.afficheGauche("ERREUR : Impossible de supprimer la seule vue restante !", Color.red);
        }
    }

    public void suppVueEffectue(String vue, String fich) {
        this.modeSuppVue = false;
        this.traceurCarteEdition.suppVue(vue, fich);
        this.navigation.rechargeTypBarre(this.traceurCarteEdition.exporteVues(), this.espaceCartes);
        BarreEtat.resetGauche();
        this.setCursor(Cursor.getDefaultCursor());
        this.carteModifi\u00e9e = true;
        this.majAffichage();
    }

    private String traduireDate(Date date) {
        String temp = date.toString().replace("Jan", "01");
        temp = temp.replace("Feb", "02");
        temp = temp.replace("Mar", "03");
        temp = temp.replace("Apr", "04");
        temp = temp.replace("May", "05");
        temp = temp.replace("Jun", "06");
        temp = temp.replace("Jul", "07");
        temp = temp.replace("Aug", "08");
        temp = temp.replace("Sep", "09");
        temp = temp.replace("Oct", "10");
        temp = temp.replace("Nov", "11");
        temp = temp.replace("Dec", "12");
        return temp;
    }

    public boolean verifDefCoord() {
        if (this.traceurCarteEdition != null) {
            String lat = this.traceurCarteEdition.exporteInfo("latitude");
            return lat != null;
        }
        return false;
    }

    public static void main(String[] args) {
        new Interface();
    }

    public void keyTyped(KeyEvent arg0) {
        this.modifTexteEffectuee(true);
        System.out.println("tape");
    }

    public void keyPressed(KeyEvent arg0) {
        int i = arg0.getKeyCode();
        System.out.println(arg0.getKeyCode());
        if (i == 27) {
            this.modeSuppArret = false;
            this.modeSuppLien = false;
            this.modeSuppVue = false;
            this.navigation.desactiverModeDefCoord();
            BarreEtat.resetGauche();
            this.setCursor(Cursor.getDefaultCursor());
            this.majAffichage();
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void componentResized(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentShown(ComponentEvent arg0) {
    }

    public void componentHidden(ComponentEvent arg0) {
    }
}

