/*
 * Decompiled with CFR 0.152.
 */
package geonoteZones;

import geonoteInterface.BarreEtat;
import geonoteInterface.Interface;
import geonoteTypesDonnees.Carte;
import geonoteTypesDonnees.Images;
import geonoteTypesDonnees.Texte;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class Navigation
extends JPanel {
    public Carte carte = null;
    private JScrollPane conteneur = null;
    private Interface diplomate = null;
    private Images image = null;
    private Texte texte = null;
    private JMenuBar vuesBarre = null;
    private String dossierSysteme = "";
    private ArrayList hN = null;
    private int iCourant;

    public Navigation(Interface i, String dosSys) {
        this.setLayout(new BorderLayout());
        this.diplomate = i;
        this.dossierSysteme = dosSys;
        this.hN = new ArrayList();
        this.iCourant = 0;
    }

    public void activeReglet(boolean b) {
        if (this.carte != null) {
            this.carte.setRegletDispo(b);
        } else if (this.image != null) {
            this.image.setRegletDispo(b);
        }
    }

    public void chargerCarte(String path, double ech, String unit\u00e9, boolean reg, boolean zoom, boolean edition, ArrayList listArrets, int latitudeO, int longitudeO, double echLati, double echLongi, ArrayList listeVues, String coulArrets, String titre) {
        ArrayList temp;
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        this.carte = new Carte(path, ech, unit\u00e9, reg, zoom, edition, this.diplomate, listArrets, latitudeO, longitudeO, echLati, echLongi, coulArrets, titre);
        this.conteneur = new JScrollPane(this.carte);
        this.conteneur.setBorder(null);
        this.conteneur.revalidate();
        this.add((Component)this.conteneur, "Center");
        this.texte = null;
        this.image = null;
        if (listeVues != null) {
            String esp = path.substring(0, path.lastIndexOf("\\"));
            this.rechargeTypBarre(listeVues, String.valueOf(esp) + "\\");
        }
        this.diplomate.afficheArrets();
        this.validate();
        boolean doublon = false;
        if (this.hN != null && this.hN.size() > 0 && (temp = (ArrayList)this.hN.get(this.hN.size() - 1)).get(0).equals(path)) {
            doublon = true;
        }
        if (!doublon) {
            ArrayList<Object> boite = new ArrayList<Object>();
            boite.add(path);
            boite.add(Double.toString(ech));
            boite.add(unit\u00e9);
            boite.add(Boolean.toString(reg));
            boite.add(Boolean.toString(zoom));
            boite.add(Boolean.toString(edition));
            boite.add(listArrets);
            boite.add(Integer.toString(latitudeO));
            boite.add(Integer.toString(longitudeO));
            boite.add(Double.toString(echLati));
            boite.add(Double.toString(echLongi));
            boite.add(listeVues);
            boite.add(coulArrets);
            boite.add(titre);
            this.hN.add(boite);
            this.iCourant = this.hN.size() - 1;
            this.rafraichirBoutons();
        }
    }

    public void chargerImage(String path, double ech, String unit\u00e9, boolean reg, boolean zoom, boolean edition, String titre) {
        ArrayList temp;
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        if (this.vuesBarre != null) {
            this.remove(this.vuesBarre);
        }
        this.image = new Images(path, ech, unit\u00e9, reg, zoom, edition, this.diplomate, titre);
        this.conteneur = new JScrollPane(this.image);
        this.conteneur.setBorder(null);
        this.conteneur.revalidate();
        this.add(this.conteneur);
        this.texte = null;
        this.carte = null;
        this.validate();
        boolean doublon = false;
        if (this.hN != null && this.hN.size() > 0 && (temp = (ArrayList)this.hN.get(this.hN.size() - 1)).get(0).equals(path)) {
            doublon = true;
        }
        if (!doublon) {
            ArrayList<String> boite = new ArrayList<String>();
            boite.add(path);
            boite.add(Double.toString(ech));
            boite.add(unit\u00e9);
            boite.add(Boolean.toString(reg));
            boite.add(Boolean.toString(zoom));
            boite.add(Boolean.toString(edition));
            boite.add(titre);
            this.hN.add(boite);
            this.iCourant = this.hN.size() - 1;
        }
    }

    public void chargerTexte(String path, String titre) {
        ArrayList temp;
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        if (this.vuesBarre != null) {
            this.remove(this.vuesBarre);
        }
        this.texte = new Texte(titre);
        this.texte.setEditable(false);
        this.texte.charger(path);
        this.conteneur = new JScrollPane(this.texte);
        this.conteneur.setBorder(null);
        this.conteneur.revalidate();
        this.add(this.conteneur);
        this.image = null;
        this.carte = null;
        this.validate();
        boolean doublon = false;
        if (this.hN != null && this.hN.size() > 0 && (temp = (ArrayList)this.hN.get(this.hN.size() - 1)).get(0).equals(path)) {
            doublon = true;
        }
        if (!doublon) {
            ArrayList<String> boite = new ArrayList<String>();
            boite.add(path);
            boite.add(titre);
            this.hN.add(boite);
            this.iCourant = this.hN.size() - 1;
        }
    }

    private void chargementCarte(String path, double ech, String unit\u00e9, boolean reg, boolean zoom, boolean edition, ArrayList listArrets, int latitudeO, int longitudeO, double echLati, double echLongi, ArrayList listeVues, String couleur, String titre) {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        this.carte = new Carte(path, ech, unit\u00e9, reg, zoom, edition, this.diplomate, listArrets, latitudeO, longitudeO, echLati, echLongi, couleur, titre);
        this.conteneur = new JScrollPane(this.carte);
        this.conteneur.setBorder(null);
        this.conteneur.revalidate();
        this.add((Component)this.conteneur, "Center");
        this.texte = null;
        this.image = null;
        if (listeVues != null) {
            String esp = path.substring(0, path.lastIndexOf("\\"));
            this.rechargeTypBarre(listeVues, String.valueOf(esp) + "\\");
        }
        this.diplomate.afficheArrets();
        this.validate();
    }

    private void chargementImage(String path, double ech, String unit\u00e9, boolean reg, boolean zoom, boolean edition, String titre) {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        if (this.vuesBarre != null) {
            this.remove(this.vuesBarre);
        }
        this.image = new Images(path, ech, unit\u00e9, reg, zoom, edition, this.diplomate, titre);
        this.conteneur = new JScrollPane(this.image);
        this.conteneur.setBorder(null);
        this.conteneur.revalidate();
        this.add(this.conteneur);
        this.texte = null;
        this.carte = null;
        this.validate();
    }

    private void chargementTexte(String path, String titre) {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        if (this.vuesBarre != null) {
            this.remove(this.vuesBarre);
        }
        this.texte = new Texte(titre);
        this.texte.setEditable(false);
        this.texte.charger(path);
        this.conteneur = new JScrollPane(this.texte);
        this.conteneur.setBorder(null);
        this.conteneur.revalidate();
        this.add(this.conteneur);
        this.image = null;
        this.carte = null;
        this.validate();
    }

    private void chargement(int i) {
        if (this.hN.size() > i) {
            ArrayList boite = (ArrayList)this.hN.get(i);
            if (boite.size() == 2) {
                this.chargementTexte((String)boite.get(0), (String)boite.get(1));
            } else if (boite.size() == 7) {
                this.chargementImage((String)boite.get(0), Double.parseDouble((String)boite.get(1)), (String)boite.get(2), Boolean.parseBoolean((String)boite.get(3)), Boolean.parseBoolean((String)boite.get(4)), Boolean.parseBoolean((String)boite.get(5)), (String)boite.get(6));
            } else if (boite.size() == 14) {
                this.chargementCarte((String)boite.get(0), Double.parseDouble((String)boite.get(1)), (String)boite.get(2), Boolean.parseBoolean((String)boite.get(3)), Boolean.parseBoolean((String)boite.get(4)), Boolean.parseBoolean((String)boite.get(5)), (ArrayList)boite.get(6), Integer.parseInt((String)boite.get(7)), Integer.parseInt((String)boite.get(8)), Double.parseDouble((String)boite.get(9)), Double.parseDouble((String)boite.get(10)), (ArrayList)boite.get(11), (String)boite.get(12), (String)boite.get(13));
            }
        }
    }

    public void suivant() {
        if (this.iCourant < this.hN.size() - 1) {
            ++this.iCourant;
            this.chargement(this.iCourant);
        }
    }

    public void precedent() {
        if (this.iCourant > 0) {
            --this.iCourant;
            this.chargement(this.iCourant);
        }
    }

    public boolean premier() {
        return this.iCourant == 0;
    }

    public boolean dernier() {
        return this.iCourant == this.hN.size() - 1;
    }

    public void chargerVue(String path) {
        this.carte.chargerVue(path);
    }

    public void chargerCouleurArrets(String c) {
        this.carte.chargerCouleurArrets(c);
    }

    public void masquerVuePrincipale() {
        this.carte.masquerCarte();
    }

    public ImageIcon exporteCarte() {
        if (this.carte != null) {
            return this.carte.getImage();
        }
        return null;
    }

    public ImageIcon exporteImage() {
        if (this.image != null) {
            return this.image.getImage();
        }
        return null;
    }

    public Texte exporteTexte() {
        if (this.texte != null) {
            return this.texte;
        }
        return null;
    }

    public String exporteTypeActif() {
        if (this.image != null) {
            return "image";
        }
        if (this.carte != null) {
            return "carte";
        }
        return "texte";
    }

    public String exporteUnite() {
        String result = "";
        if (this.carte != null) {
            result = this.carte.getUnit\u00e9();
        } else if (this.image != null) {
            result = this.image.getUnit\u00e9();
        }
        return result;
    }

    public void rechargeTypBarre(ArrayList l, final String dossier) {
        Iterator i = l.iterator();
        if (this.vuesBarre != null) {
            this.remove(this.vuesBarre);
        }
        if (!l.isEmpty()) {
            this.vuesBarre = new JMenuBar();
            while (i.hasNext()) {
                final ArrayList courant = (ArrayList)i.next();
                JButton bouton = new JButton((String)courant.get(0));
                bouton.setName((String)courant.get(1));
                bouton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        BarreEtat.resetGauche();
                        if (Navigation.this.diplomate.isModeSuppVue()) {
                            Navigation.this.diplomate.suppVueEffectue((String)courant.get(0), (String)courant.get(1));
                        } else {
                            Navigation.this.carte.VueVersCarte();
                            Navigation.this.carte.chargerVue(String.valueOf(dossier) + (String)courant.get(1));
                            Navigation.this.rafraichirBoutons();
                            Navigation.this.carte.masquerCarte();
                            Navigation.this.diplomate.ajouteVue((String)courant.get(1));
                            Navigation.this.diplomate.rapportTrace("carte", "changement vue", (String)courant.get(1));
                        }
                    }
                });
                bouton.setFocusable(false);
                this.vuesBarre.add(bouton);
            }
            this.add((Component)this.vuesBarre, "North");
        }
        this.validate();
    }

    private void rafraichirBoutons() {
        if (this.vuesBarre != null) {
            Component[] l = this.vuesBarre.getComponents();
            int i = 0;
            while (i < l.length) {
                JButton b = (JButton)l[i];
                String nom = b.getName();
                if (this.carte.exporteCheminVue() != null && this.carte.exporteCheminVue().endsWith(nom) && this.carte.exporteCheminCarte().endsWith(nom)) {
                    ((AbstractButton)l[i]).setIcon(new ImageIcon(String.valueOf(this.dossierSysteme) + "partout.gif"));
                } else if (this.carte.exporteCheminVue() != null && this.carte.exporteCheminVue().endsWith(nom)) {
                    ((AbstractButton)l[i]).setIcon(new ImageIcon(String.valueOf(this.dossierSysteme) + "devant.gif"));
                } else if (this.carte.exporteCheminCarte().endsWith(nom)) {
                    ((AbstractButton)l[i]).setIcon(new ImageIcon(String.valueOf(this.dossierSysteme) + "derriere.gif"));
                } else {
                    ((AbstractButton)l[i]).setIcon(null);
                }
                ++i;
            }
        }
    }

    public void reset() {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        if (this.vuesBarre != null) {
            this.remove(this.vuesBarre);
        }
        this.texte = null;
        this.image = null;
        this.carte = null;
    }

    public void resetHisto() {
        this.hN = null;
        this.hN = new ArrayList();
    }

    public void setEchelle(double e) {
        if (this.carte != null) {
            this.carte.setEchelle(e);
        } else if (this.image != null) {
            this.image.setEchelle(e);
        }
    }

    public void activerModeDefCoord() {
        this.carte.activerModeDefCoord();
    }

    public void desactiverModeDefCoord() {
        this.carte.desactiverModeDefCoord();
    }

    public void setUnite(String u) {
        if (this.carte != null) {
            this.carte.setUnit\u00e9(u);
        } else if (this.image != null) {
            this.image.setUnit\u00e9(u);
        }
    }
}

