/*
 * Created on 7 juil. 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package geonoteInterface;

import geonoteTypesDonnees.Carte;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

/**
 * @author lefevre
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class FenetreCalibrageCoord extends JFrame{
	private JLabel latitudeLabel = new JLabel("Latitude (sous la forme xxxx'xx\") :"); 
	private JTextField latitudeText = new JTextField(10);
	private JLabel longitudeLabel = new JLabel("Longitude (sous la forme xxxx'xx\") :"); 
	private JTextField longitudeText = new JTextField(10);
	private Carte carte = null;
	private int latitude;
	private int longitude;
	
	public FenetreCalibrageCoord(Carte c, String titre, final int x, final int y) {
		super("Calibrage des coordonnes"); 
		carte = c;
		setLayout(new BorderLayout());
		setSize(300,140);
		setLocationRelativeTo(null);	//centrage de la fenetre
		setResizable(false);
		
		Box hBox1 = Box.createHorizontalBox();
		hBox1.add(Box.createHorizontalStrut(5));
		hBox1.add(latitudeLabel);
		hBox1.add(Box.createHorizontalStrut(5));
		latitudeText.setMaximumSize(latitudeText.getPreferredSize());
		hBox1.add(latitudeText);
		hBox1.add(Box.createGlue());
		hBox1.add(Box.createHorizontalStrut(5));
		
		Box hBox3 = Box.createHorizontalBox();
		hBox3.add(Box.createHorizontalStrut(5));
		hBox3.add(longitudeLabel);
		hBox3.add(Box.createHorizontalStrut(5));
		longitudeText.setMaximumSize(latitudeText.getPreferredSize());
		hBox3.add(longitudeText);
		hBox3.add(Box.createGlue());
		hBox3.add(Box.createHorizontalStrut(5));
		
		Box vboxH = Box.createVerticalBox();
		vboxH.add(hBox3);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox1);
		vboxH.setBorder(BorderFactory.createTitledBorder(titre));
		
		Box hBoxF = Box.createHorizontalBox();
		hBoxF.add(Box.createGlue());
		JButton okBouton = new JButton("OK"); 
		okBouton.grabFocus();
		okBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				boolean ok = verification();
				if (ok) {
					dispose();
					carte.ajouteCoord(x, y, latitude, longitude);
				}
			}
		});
		hBoxF.add(okBouton);
		hBoxF.add(Box.createHorizontalStrut(5));
		JButton annulerBouton = new JButton("Annuler"); 
		annulerBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		});
		hBoxF.add(annulerBouton);
		hBoxF.add(Box.createHorizontalStrut(5));
		
		Box vBox = Box.createVerticalBox();
		vBox.add(Box.createVerticalStrut(5));
		vBox.add(vboxH);
		vBox.add(Box.createGlue());
		vBox.add(Box.createVerticalStrut(5));
		vBox.add(hBoxF);
		vBox.add(Box.createVerticalStrut(5));
		
		add(vBox,BorderLayout.CENTER);
		setVisible(true);
	}
	
	public void chargerParam(String unite, double distance) {
		latitudeText.setText(unite);
		longitudeText.setText(Double.toString(distance));
	}
	
	private boolean verifFormat(String saisie) {
		boolean retour = false;
		return ( saisie.contains("") && 
				saisie.contains("'") && 
				saisie.contains("\"") && 
				saisie.indexOf("")<saisie.indexOf("'") &&  
				saisie.indexOf("'")<saisie.indexOf("\"")  
				);
	}
	
	private boolean verification() {
		boolean etat = true;
		if ((latitudeText.getText() == null) || latitudeText.getText().equals("") || !verifFormat(latitudeText.getText()) ) { 
			etat = false;
			latitudeLabel.setForeground(Color.red);
		} else {
			String degres = latitudeText.getText().substring(0,latitudeText.getText().indexOf("")); 
			String minutes = latitudeText.getText().substring(latitudeText.getText().indexOf("")+1,latitudeText.getText().indexOf("'"));  
			String secondes = latitudeText.getText().substring(latitudeText.getText().indexOf("'")+1, latitudeText.getText().indexOf("\""));  
			//stockage des coordonnees en secondes !
			latitude = Integer.parseInt(degres)*3600+Integer.parseInt(minutes)*60+Integer.parseInt(secondes);
			latitudeLabel.setForeground(Color.black);
		}
		if ((longitudeText.getText() == null) || longitudeText.getText().equals("") || !verifFormat(longitudeText.getText()) ) { 
			etat = false;
			longitudeLabel.setForeground(Color.red);
		} else {
			String degres = longitudeText.getText().substring(0,longitudeText.getText().indexOf("")); 
			String minutes = longitudeText.getText().substring(longitudeText.getText().indexOf("")+1,longitudeText.getText().indexOf("'"));  
			String secondes = longitudeText.getText().substring(longitudeText.getText().indexOf("'")+1, longitudeText.getText().indexOf("\""));  
			//stockage des coordonnees en secondes !
			longitude = Integer.parseInt(degres)*3600+Integer.parseInt(minutes)*60+Integer.parseInt(secondes);
			longitudeLabel.setForeground(Color.black);
		}
		return etat;
	}
}
