/*
 * Created on 7 juil. 2005
 */
package geonoteInterface;

import geonoteOutils.FiltreExtensible;
import geonoteOutils.ImagePreview;
import geonoteOutils.Traceur;
import geonoteOutils.TraceurCarte;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * @author lefevre
 */
public class FenetreParametrage extends JFrame {
	private ArrayList listeDonneesCarte = null;
	private TraceurCarte traceurCarte = null;
	private Interface diplomate = null;
	
	public FenetreParametrage(Interface inter, final String dossierCarte, final String dossierDocs, final String dossierGeorefs, final String dossierTravail) {
		super("Parametrage"); 
		setLayout(new BorderLayout());
		setSize(800,300);
		setLocationRelativeTo(null);	//centrage de la fenetre
//		setResizable(false);
		
		diplomate = inter;
		
		final Box vBoxListeG = Box.createVerticalBox();
		final Box vBoxG = Box.createVerticalBox();
		final Box hBoxRadioG = Box.createHorizontalBox();
		
		//partie gauche
		Box hBoxCarte = Box.createHorizontalBox();
		hBoxCarte.add(Box.createHorizontalStrut(5));
		hBoxCarte.add(new JLabel("Carte :")); 
		hBoxCarte.add(Box.createHorizontalStrut(5));
		final JLabel jl = new JLabel("..."); 
		hBoxCarte.add(jl);
		hBoxCarte.add(Box.createGlue());
		hBoxCarte.add(Box.createHorizontalStrut(5));
		JButton parcours = new JButton("Parcourir ..."); 
		parcours.grabFocus();
		parcours.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				JFileChooser chooser = new JFileChooser(dossierCarte);
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY); 
				chooser.setDialogTitle("Choix de la carte principale de la nouvelle session"); 
				FiltreExtensible filtre = new FiltreExtensible("Cartes"); 
				filtre.addExtension(".jpg"); 
				filtre.addExtension(".gif"); 
				filtre.addExtension(".png"); 
				chooser.addChoosableFileFilter(filtre);
				chooser.setAccessory(new ImagePreview(chooser)); //pour apercu de l'image
				int returnVal = chooser.showOpenDialog(chooser.getParent());
				if(returnVal == JFileChooser.APPROVE_OPTION) {
					//recup liste des donnees georefs (nom de fichier) de la carte
					String fich = chooser.getSelectedFile().getPath();
					String ext = fich.substring(fich.lastIndexOf(".")); 
					String fichXML = fich.replace(ext,".xml"); 
					traceurCarte = new TraceurCarte();
					boolean res = traceurCarte.charger(fichXML);
					if (!res) {
						JOptionPane.showMessageDialog(new JFrame(), "La carte que vous avez voulu ouvrir ne possde pas de mtadonnes !", "ERREUR !", JOptionPane.WARNING_MESSAGE);  
					} else {
						activer(vBoxListeG, true);
						activer(hBoxRadioG, true);
						jl.setText(chooser.getSelectedFile().getName());
						listeDonneesCarte = traceurCarte.exporteFichiers();
						Component[] listeG = vBoxListeG.getComponents();
						for (int it=0; it<listeG.length; it++) {
							if (listeG[it].getClass().getName().contains("JCheckBox")) { 
								JCheckBox cb = (JCheckBox) listeG[it];
								if (listeDonneesCarte.contains(cb.getText())) {
									listeG[it].setEnabled(true);
								} else {
									listeG[it].setEnabled(false);
								}	
							}
						}
					}
				}
			}
		});
		hBoxCarte.add(parcours);
		hBoxCarte.add(Box.createHorizontalStrut(5));
		

		vBoxListeG.setBorder(BorderFactory.createTitledBorder("Donnes")); 
		ArrayList listeFichiersG = listeRepertoire(new File(dossierGeorefs));
		Iterator j = listeFichiersG.iterator();
		while (j.hasNext()) {
			final String chemin = (String) j.next();
			final String nomFichier = chemin.substring(chemin.lastIndexOf("\\")+1, chemin.length()); 
			String extension = chemin.substring(chemin.lastIndexOf(".")); 
			final String cheminXML = chemin .replace(extension, ".xml"); 
			final Traceur traceur = new Traceur();
			boolean retour = traceur.charger(cheminXML);
			if (retour) {
				final JCheckBox jcb = new JCheckBox(nomFichier);
				jcb.addChangeListener(new ChangeListener() {
					public void stateChanged(ChangeEvent arg0) {
						if (listeDonneesCarte != null && listeDonneesCarte.contains(nomFichier)) {
							if (jcb.isSelected()) {
								if (!traceurCarte.exporteEtat(nomFichier).equals("accessible")) { 
								    traceurCarte.ajouteEtat(nomFichier, "accessible"); 
								    traceurCarte.enregistrer();
								}
							} else {
								if (!traceurCarte.exporteEtat(nomFichier).equals("inaccessible")) { 
								    traceurCarte.ajouteEtat(nomFichier, "inaccessible"); 
								    traceurCarte.enregistrer();
								}
							}
//							System.out.println(traceurCarte.exporteEtat(nomFichier).equals("accessible")+" "+nomFichier);
							jcb.setSelected(traceurCarte.exporteEtat(nomFichier).equals("accessible")); 
						}
					}
				});
				vBoxListeG.add(jcb);
				vBoxListeG.add(Box.createVerticalStrut(5));
			}
		}
		
		final Box hBoxNivoG = Box.createHorizontalBox();
		hBoxNivoG.setBorder(BorderFactory.createTitledBorder("Niveaux")); 
		hBoxNivoG.add(Box.createHorizontalStrut(5));
		final JCheckBox jcbG1 = new JCheckBox("Collge"); 
		jcbG1.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
//				selection des donnees presentes sur la carte et du bon nivo !
				selectionParNiveauEtCarte("college", dossierGeorefs, jcbG1.isSelected()); 
			}
		});
		hBoxNivoG.add(jcbG1);
		hBoxNivoG.add(Box.createHorizontalStrut(5));
		final JCheckBox jcbG2 = new JCheckBox("Lyce"); 
		jcbG2.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				selectionParNiveauEtCarte("lycee", dossierGeorefs, jcbG2.isSelected()); 
			}
		});
		hBoxNivoG.add(jcbG2);
		hBoxNivoG.add(Box.createHorizontalStrut(5));
		final JCheckBox jcbG3 = new JCheckBox("Universit"); 
		jcbG3.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				selectionParNiveauEtCarte("universite", dossierGeorefs, jcbG3.isSelected()); 
			}
		});
		hBoxNivoG.add(jcbG3);
//		hBoxNivoG.add(Box.createGlue());
		hBoxNivoG.add(Box.createHorizontalStrut(5));
		
		hBoxRadioG.add(Box.createHorizontalStrut(5));
		hBoxRadioG.add(new JLabel("Gestion des droits d'accs :")); 
		hBoxRadioG.add(Box.createHorizontalStrut(5));
		final JRadioButton jrbG1 = new JRadioButton("par niveau"); 
		final JRadioButton jrbG2 = new JRadioButton("pour chaque donne"); 
		ButtonGroup groupG = new ButtonGroup();
	    groupG.add(jrbG1);
	    groupG.add(jrbG2);
		jrbG1.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				Component[] listeComposants = vBoxListeG.getComponents();
				for (int i=0; i<listeComposants.length; i++) {
					listeComposants[i].setEnabled(!jrbG1.isSelected());
				}
				Component[] nivoComposants = hBoxNivoG.getComponents();
				for (int i=0; i<nivoComposants.length; i++) {
					nivoComposants[i].setEnabled(jrbG1.isSelected());
				}
			}
		});
		hBoxRadioG.add(jrbG1);
//		init
		jrbG2.setSelected(true);
		Component[] nivoComposantsG = hBoxNivoG.getComponents();
		for (int k=0; k<nivoComposantsG.length; k++) {
			nivoComposantsG[k].setEnabled(false);
		}
		hBoxRadioG.add(jrbG2);
//		hBoxRadioG.add(Box.createGlue());
		hBoxRadioG.add(Box.createHorizontalStrut(5));
		
		vBoxG.setBorder(BorderFactory.createTitledBorder("Donnes gorfrences")); 
		vBoxG.add(hBoxCarte);
		vBoxG.add(Box.createVerticalStrut(5));
		vBoxG.add(hBoxRadioG);
		vBoxG.add(Box.createVerticalStrut(5));
		vBoxG.add(hBoxNivoG);
		vBoxG.add(Box.createVerticalStrut(5));
		Box htempG = Box.createHorizontalBox();
		htempG.add(Box.createGlue());
		htempG.add(vBoxListeG);
		htempG.add(Box.createGlue());
		vBoxG.add(htempG);
		vBoxG.add(Box.createGlue());
		vBoxG.add(Box.createVerticalStrut(5));
		activer(hBoxRadioG, false);
		activer(hBoxNivoG, false);
		activer(vBoxListeG, false);
		
		//partie droite
		final Box vBoxListeD = Box.createVerticalBox();
		vBoxListeD.setBorder(BorderFactory.createTitledBorder("Donnes")); 
		vBoxListeD.add(Box.createVerticalStrut(5));
		ArrayList listeFichiersD = listeRepertoire(new File(dossierDocs));
		Iterator i = listeFichiersD.iterator();
		while (i.hasNext()) {
			final String chemin = (String) i.next();
			final String nomFichier = chemin.substring(chemin.lastIndexOf("\\")+1, chemin.length()); 
			String extension = chemin.substring(chemin.lastIndexOf(".")); 
			final String cheminXML = chemin .replace(extension, ".xml"); 
			final Traceur traceur = new Traceur();
			boolean retour = traceur.charger(cheminXML);
			if (retour) {
				//TODO pb de rechargement des etats : charge pas la 1ere (lancement) et la 3eme fois (sans quitter geonote, juste param)
				final JCheckBox jcb = new JCheckBox(nomFichier);
				if (traceur.exporteInfo("etat") != null) { 
//					System.out.println("init docs");	
//					System.out.println(traceur.exporteInfo("etat").equals("accessible"));
					jcb.setSelected(traceur.exporteInfo("etat").equals("accessible"));  
				} else {
					jcb.setSelected(true);
				}
				jcb.addChangeListener(new ChangeListener() {
					public void stateChanged(ChangeEvent arg0) {
						if (jcb.isSelected()) {
							if (!traceur.exporteInfo("etat").equals("accessible")) {  
							    traceur.ajouterElt("etat", "accessible");  
							    traceur.enregistrer();
							}
						} else {
							if (!traceur.exporteInfo("etat").equals("inaccessible")) {  
							    traceur.ajouterElt("etat", "inaccessible");  
							    traceur.enregistrer();
							}
						}
//						System.out.println(traceur.exporteInfo("etat").equals("accessible")+" "+nomFichier);
						jcb.setSelected(traceur.exporteInfo("etat").equals("accessible"));  
					}
				});
				
				vBoxListeD.add(jcb);
				vBoxListeD.add(Box.createVerticalStrut(5));
			}
		}
		
		final Box hBoxNivoD = Box.createHorizontalBox();
		hBoxNivoD.setBorder(BorderFactory.createTitledBorder("Niveaux")); 
		hBoxNivoD.add(Box.createHorizontalStrut(5));
		final JCheckBox jcbD1 = new JCheckBox("Collge"); 
		jcbD1.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				selectionParNiveau("college", dossierDocs, jcbD1.isSelected()); 
			}
		});
		hBoxNivoD.add(jcbD1);
		hBoxNivoD.add(Box.createHorizontalStrut(5));
		final JCheckBox jcbD2 = new JCheckBox("Lyce"); 
		jcbD2.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				selectionParNiveau("lycee", dossierDocs, jcbD2.isSelected()); 
			}
		});
		hBoxNivoD.add(jcbD2);
		hBoxNivoD.add(Box.createHorizontalStrut(5));
		final JCheckBox jcbD3 = new JCheckBox("Universit"); 
		jcbD3.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				selectionParNiveau("universite", dossierDocs, jcbD3.isSelected()); 
			}
		});
		hBoxNivoD.add(jcbD3);
//		hBoxNivoD.add(Box.createGlue());
		hBoxNivoD.add(Box.createHorizontalStrut(5));
		
		Box hBoxRadioD = Box.createHorizontalBox();
		hBoxRadioD.add(Box.createHorizontalStrut(5));
		hBoxRadioD.add(new JLabel("Gestion des droits d'accs :")); 
		hBoxRadioD.add(Box.createHorizontalStrut(5));
		final JRadioButton jrbD1 = new JRadioButton("par niveau"); 
		final JRadioButton jrbD2 = new JRadioButton("pour chaque donne"); 
		ButtonGroup groupD = new ButtonGroup();
	    groupD.add(jrbD1);
	    groupD.add(jrbD2);
		jrbD1.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				Component[] listeComposants = vBoxListeD.getComponents();
				for (int i=0; i<listeComposants.length; i++) {
					listeComposants[i].setEnabled(!jrbD1.isSelected());
				}
				Component[] nivoComposants = hBoxNivoD.getComponents();
				for (int i=0; i<nivoComposants.length; i++) {
					nivoComposants[i].setEnabled(jrbD1.isSelected());
				}
			}
		});
		hBoxRadioD.add(jrbD1);
		//init
		jrbD2.setSelected(true);
		Component[] nivoComposantsD = hBoxNivoD.getComponents();
		for (int k=0; k<nivoComposantsD.length; k++) {
			nivoComposantsD[k].setEnabled(false);
		}
		hBoxRadioD.add(jrbD2);
//		hBoxRadioD.add(Box.createGlue());
		hBoxRadioD.add(Box.createHorizontalStrut(5));
		
		Box vBoxD = Box.createVerticalBox();
		vBoxD.setBorder(BorderFactory.createTitledBorder("Documentation")); 
		vBoxD.add(hBoxRadioD);
		vBoxD.add(Box.createVerticalStrut(5));
		vBoxD.add(hBoxNivoD);
		vBoxD.add(Box.createVerticalStrut(5));
		Box htempD = Box.createHorizontalBox();
		htempD.add(Box.createGlue());
		htempD.add(vBoxListeD);
		htempD.add(Box.createGlue());
		vBoxD.add(htempD);
		vBoxD.add(Box.createGlue());
		vBoxD.add(Box.createVerticalStrut(5));
		
		//partie haute
		Box hBoxH = Box.createHorizontalBox();
		hBoxH.add(Box.createHorizontalStrut(5));
		hBoxH.add(vBoxG);
		hBoxH.add(Box.createHorizontalStrut(5));
		hBoxH.add(vBoxD);
		hBoxH.add(Box.createHorizontalStrut(5));
		
		//partie basse
		Box hBoxB = Box.createHorizontalBox();
		final JCheckBox cb = new JCheckBox("Traage actif"); 
		final Traceur tr = new Traceur();
		tr.charger(dossierTravail+".conf"); 
		cb.setSelected(tr.exporteInfo("traces").equals("actives"));  
//		System.out.println(tr.exporteInfo("traces"));
		cb.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				diplomate.activerTraces(cb.isSelected());
				String mode;
				if (cb.isSelected()) mode = "actives"; 
				else mode = "inactives"; 
				if (!mode.equals(tr.exporteInfo("traces"))) { 
				    tr.ajouterElt("traces", mode); 
				    tr.enregistrer();	//TODO enregistrement : echec !!!
				}
//				System.out.println(tr.exporteInfo("traces"));		
			} 
		});
//		hBoxB.add(cb);
		hBoxB.add(Box.createGlue());
		JButton quitterBouton = new JButton("Quitter"); 
		quitterBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		});
		hBoxB.add(quitterBouton);
		hBoxB.add(Box.createHorizontalStrut(5));
		
		Box vBox = Box.createVerticalBox();
		vBox.add(Box.createVerticalStrut(5));
		JScrollPane jsp = new JScrollPane(hBoxH);
//		jsp.setBorder(null);
		vBox.add(jsp);
		vBox.add(Box.createGlue());
		vBox.add(Box.createVerticalStrut(5));
		vBox.add(hBoxB);
		vBox.add(Box.createVerticalStrut(5));
		
		add(vBox,BorderLayout.CENTER);
		setVisible(true);
	}
	
	/**
	 * liste des fichiers donnees
	 * @param repertoire
	 */
	private ArrayList listeRepertoire ( File repertoire ) {
		ArrayList liste = new ArrayList();
//		System.out.println ( repertoire.getAbsolutePath());
		if ( repertoire.isDirectory ( ) ) {
			File[] list = repertoire.listFiles();
			for ( int i = 0; i < list.length; i++) {
				// Appel rcursif sur les sous-rpertoires
				liste.addAll(listeRepertoire( list[i]));
			} 
		} else {
			if (repertoire.getAbsolutePath().contains(".") && !repertoire.getAbsolutePath().contains(".xml")) {  
				liste.add(repertoire.getAbsolutePath());
			}
		}
		return liste;
	}
	
	private void selectionParNiveau(String nivo, String dossier, boolean selection) {
		ArrayList listeFichiers = listeRepertoire(new File(dossier));
		Iterator i = listeFichiers.iterator();
		while (i.hasNext()) {
			final String chemin = (String) i.next();
			String nomFichier = chemin.substring(chemin.lastIndexOf("\\")+1, chemin.length()); 
			String extension = chemin.substring(chemin.lastIndexOf(".")); 
			final String cheminXML = chemin .replace(extension, ".xml"); 
			final Traceur traceurS = new Traceur();
			boolean retour = traceurS.charger(cheminXML);
			if (retour) {
				String niveau = traceurS.exporteInfo("niveau"); 
				if (niveau.contains(nivo)) {
					if (selection) {
						if (!traceurS.exporteInfo("etat").equals("accessible")) {  
						    traceurS.ajouterElt("etat", "accessible");  
						    traceurS.enregistrer();
						}
					}
					else {
						if (!traceurS.exporteInfo("etat").equals("inaccessible")) {  
						    traceurS.ajouterElt("etat", "inaccessible");  
						    traceurS.enregistrer();
						}
					}
				}
			}
		}
	}
	
	private void selectionParNiveauEtCarte(String nivo, String dossier, boolean selection) {
		ArrayList listeFichiers = listeRepertoire(new File(dossier));
		Iterator i = listeFichiers.iterator();
		while (i.hasNext()) {
			final String chemin = (String) i.next();
			String nomFichier = chemin.substring(chemin.lastIndexOf("\\")+1, chemin.length()); 
			String extension = chemin.substring(chemin.lastIndexOf(".")); 
			final String cheminXML = chemin .replace(extension, ".xml"); 
			final Traceur traceur = new Traceur();
			boolean retour = traceur.charger(cheminXML);
			if (retour) {
				String niveau = traceur.exporteInfo("niveau"); 
				if (listeDonneesCarte != null) {
					if (niveau.contains(nivo) && listeDonneesCarte.contains(nomFichier)) {
						if (selection) {
							if (!traceurCarte.exporteEtat(nomFichier).equals("accessible")) { 
							    traceurCarte.ajouteEtat(nomFichier, "accessible"); 
							    traceurCarte.enregistrer();
							}
						}
						else {
							if (!traceurCarte.exporteEtat(nomFichier).equals("inaccessible")) { 
							    traceurCarte.ajouteEtat(nomFichier, "inaccessible"); 
							    traceurCarte.enregistrer();
							}
						}
					}
				}
			}
		}
	}
	
	private void activer(Component boite , boolean b) {
		boite.setEnabled(b);
		Component[] contenu = ((Container) boite).getComponents();
		for (int i=0; i<contenu.length; i++) {
			activer(contenu[i], b);
		}
	}
}
