/*
 * Created on 5 juil. 2005
 */
package geonoteInterface;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

/**
 * @author lefevre
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class FenetreParametresEditionCarte extends JFrame {
	private JLabel typeLabel = new JLabel("Type de vue principale :"); 
	private JTextField typeText = new JTextField(42);
	private JButton mesureBouton = new JButton("Mesure ..."); 
	private JCheckBox cbReglet = new JCheckBox("Reglet"); 
	private JCheckBox cbZoom = new JCheckBox("Zoom"); 
//	private JLabel niveauLabel = new JLabel("Niveau d'utilisation :");
//	private JCheckBox jcbCollege = new JCheckBox("Collge");
//	private JCheckBox jcbLycee = new JCheckBox("Lyce");
//	private JCheckBox jcbUniv = new JCheckBox("Universit");
	private JButton calibrageBouton = new JButton("Calibrage ..."); 
//	private JTextArea motsClsText = new JTextArea();
	private JLabel couleurLabel = new JLabel("Couleur des arrts :"); 
	private PanneauCouleurs couleurs = null;
	private Interface diplomate = null;
	private boolean mesureEffectuee = false;
	private boolean defCoordEffectuee = false;
	private String fichier = "";	//nom du fichier image --> utile lors de l'enregistrement des infos  
	
	public FenetreParametresEditionCarte(Interface i, String fich) {
		super("Paramtres de la carte"); 
		diplomate = i;
		fichier = fich;
		setLayout(new BorderLayout());
		setSize(487,300);
		setLocationRelativeTo(null);	//centrage de la fenetre
		setResizable(false);
		
		Box hBox1 = Box.createHorizontalBox();
		hBox1.add(Box.createHorizontalStrut(5));
		hBox1.add(typeLabel);
		hBox1.add(Box.createHorizontalStrut(5));
		typeText.setMaximumSize(typeText.getPreferredSize());
		hBox1.add(typeText);
		hBox1.add(Box.createGlue());
		hBox1.add(Box.createHorizontalStrut(5));
		
		Box hBox2 = Box.createHorizontalBox();
		hBox2.add(Box.createHorizontalStrut(5));
		hBox2.add(new JLabel("Fonctionnalits :")); 
		hBox2.add(Box.createHorizontalStrut(5));
		hBox2.add(cbReglet);
		cbReglet.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				mesureBouton.setEnabled(cbReglet.isSelected());
			}
		});
		hBox2.add(Box.createHorizontalStrut(5));
		mesureBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				setExtendedState(JFrame.ICONIFIED);
			}
		});
		mesureBouton.setEnabled(cbReglet.isSelected());
		hBox2.add(mesureBouton);
		hBox2.add(Box.createHorizontalStrut(5));
		hBox2.add(cbZoom);
		hBox2.add(Box.createGlue());
		hBox2.add(Box.createHorizontalStrut(5));

//		Box hBox3 = Box.createHorizontalBox();
//		hBox3.add(Box.createHorizontalStrut(5));
//		hBox3.add(niveauLabel);
//		hBox3.add(Box.createHorizontalStrut(5));
//		hBox3.add(jcbCollege);
//		hBox3.add(Box.createHorizontalStrut(5));
//		hBox3.add(jcbLycee);
//		hBox3.add(Box.createHorizontalStrut(5));
//		hBox3.add(jcbUniv);
//		hBox3.add(Box.createGlue());
//		hBox3.add(Box.createHorizontalStrut(5));
		
		Box hBox4 = Box.createHorizontalBox();
		hBox4.add(Box.createHorizontalStrut(5));
		hBox4.add(new JLabel("Dfinition des coordonnes gographiques :")); 
		hBox4.add(Box.createHorizontalStrut(5));
		calibrageBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				setExtendedState(JFrame.ICONIFIED);
				diplomate.activerModeDefCoord();
			}
		});
		hBox4.add(calibrageBouton);
		hBox4.add(Box.createGlue());
		hBox4.add(Box.createHorizontalStrut(5));
		
		Box hBox5 = Box.createHorizontalBox();
		hBox5.add(Box.createHorizontalStrut(5));
		hBox5.add(couleurLabel);
		hBox5.add(Box.createHorizontalStrut(5));
		couleurs = new PanneauCouleurs();
		hBox5.add(couleurs);
		hBox5.add(Box.createGlue());
		hBox5.add(Box.createHorizontalStrut(5));

//		Box hBox6 = Box.createHorizontalBox();
//		hBox6.add(Box.createHorizontalStrut(5));
//		couleurs = new PanneauCouleurs();
//		hBox6.add(couleurs);
//		hBox6.add(Box.createGlue());
//		hBox6.add(Box.createHorizontalStrut(5));
		
		Box vboxH = Box.createVerticalBox();
		vboxH.add(hBox1);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox2);
//		vboxH.add(Box.createVerticalStrut(5));
//		vboxH.add(hBox3);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox4);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox5);
//		vboxH.add(Box.createVerticalStrut(5));
//		vboxH.add(hBox6);
		vboxH.setBorder(BorderFactory.createTitledBorder("")); 
		
		Box hBoxF = Box.createHorizontalBox();
		hBoxF.add(Box.createGlue());
		JButton okBouton = new JButton("OK"); 
		okBouton.grabFocus();
		okBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				boolean ok = verification();
				if (ok) {
					setVisible(false);
//					String niveau = "";
//					if (jcbCollege.isSelected()) niveau = niveau+" college";
//					if (jcbLycee.isSelected()) niveau = niveau+" lycee";
//					if (jcbUniv.isSelected()) niveau = niveau+" universite";
					String coul = couleurs.getColor().getRed()+" "+couleurs.getColor().getGreen()+" "+couleurs.getColor().getBlue();  
					diplomate.enregParamCarteEditee(fichier, typeText.getText(), cbReglet.isSelected(), cbZoom.isSelected(), coul/*, niveau, motsClsText.getText()*/);
					diplomate.activerEnregEdition();
				}
			}
		});
		hBoxF.add(okBouton);
		hBoxF.add(Box.createHorizontalStrut(5));
		JButton quitterBouton = new JButton("Quitter"); 
		quitterBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
//				if (typeText.getText().length()>0) {
//				    //obligation d'enregistrer au moins le nom et le fichier de la vue principale pour la premiere fois
//				    String coul = "255 255 255"; 
//				    if (couleurs.getColor() != null) coul = couleurs.getColor().getRed()+" "+couleurs.getColor().getGreen()+" "+couleurs.getColor().getBlue();
//				    diplomate.enregParamCarteEditee(fichier, typeText.getText(), cbReglet.isSelected(), cbZoom.isSelected(), coul);
//				    setVisible(false);
				    dispose();
//				} else typeLabel.setForeground(Color.red);
			}
		});
		hBoxF.add(quitterBouton);
		hBoxF.add(Box.createHorizontalStrut(5));
		
		Box vBox = Box.createVerticalBox();
		vBox.add(Box.createVerticalStrut(5));
		vBox.add(vboxH);
		vBox.add(Box.createGlue());
		vBox.add(Box.createVerticalStrut(5));
		vBox.add(hBoxF);
		vBox.add(Box.createVerticalStrut(5));
		
		add(vBox,BorderLayout.CENTER);
		setVisible(true);
	}
	
	public void chargerParam(String typeVue, boolean reglet, boolean zoom,/* String niveau, String motscles,*/ String couleur) {
		typeText.setText(typeVue);
		cbReglet.setSelected(reglet);
		cbZoom.setSelected(zoom);
//		jcbCollege.setSelected(niveau.contains("college"));
//		jcbLycee.setSelected(niveau.contains("lycee"));
//		jcbUniv.setSelected(niveau.contains("universite"));
//		motsClsText.setText(motscles);
		String[] rvb = couleur.split(" "); 
		Color temp = new Color(Integer.parseInt(rvb[0]), Integer.parseInt(rvb[1]), Integer.parseInt(rvb[2]));
		couleurs.setColor(temp);
		mesureEffectuee = true;
		defCoordEffectuee = diplomate.verifDefCoord();
	}
	
	private boolean verification() {
		boolean etat = true;
		if ((typeText.getText() == null) || typeText.getText().equals("")) { 
			etat = false;
			typeLabel.setForeground(Color.red);
		} else {
			typeLabel.setForeground(Color.black);
		}
//		if (!jcbCollege.isSelected() && !jcbLycee.isSelected() && !jcbUniv.isSelected()) {
//			etat = false;
//			niveauLabel.setForeground(Color.red);
//		} else {
//			niveauLabel.setForeground(Color.black);
//		}
		if (couleurs.getColor()==null) {
		    etat = false;
		    couleurLabel.setForeground(Color.red);
		} else {
		    couleurLabel.setForeground(Color.black);
		}
		if (cbReglet.isSelected() && !mesureEffectuee) {
			etat = false;
			mesureBouton.setForeground(Color.red);
		} else {
			mesureBouton.setForeground(Color.black);
		}
		if (!defCoordEffectuee) {
			etat = false;
			if (calibrageBouton.isEnabled()) calibrageBouton.setForeground(Color.red);
		}
		return etat;
	}
	
	public void setDefCoordEffectuee(boolean defCoordEffectuee) {
		this.defCoordEffectuee = defCoordEffectuee;
	}
	public void setMesureEffectuee(boolean mesureEffectuee) {
		this.mesureEffectuee = mesureEffectuee;
	}
}
