/*
 * Created on 6 juil. 2005
 */
package geonoteInterface;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/**
 * @author lefevre
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class FenetreParametresEditionTexte extends JFrame {
	private JLabel typeLabel = new JLabel("Type gologique :"); 
	private JTextField typeText = new JTextField(45);
	private JLabel niveauLabel = new JLabel("Niveau d'utilisation :"); 
	private JCheckBox jcbCollege = new JCheckBox("Collge"); 
	private JCheckBox jcbLycee = new JCheckBox("Lyce"); 
	private JCheckBox jcbUniv = new JCheckBox("Universit"); 
	private JTextArea commentText = new JTextArea();
	private JTextArea motsClsText = new JTextArea();
	private Interface diplomate = null;
	
	public FenetreParametresEditionTexte(Interface i) {
		super("Paramtres du texte"); 
		diplomate = i;
		setLayout(new BorderLayout());
		setSize(487,300);
		setLocationRelativeTo(null);	//centrage de la fenetre
		setResizable(false);
		
		Box hBox1 = Box.createHorizontalBox();
		hBox1.add(Box.createHorizontalStrut(5));
		hBox1.add(typeLabel);
		hBox1.add(Box.createHorizontalStrut(5));
		typeText.setMaximumSize(typeText.getPreferredSize());
		hBox1.add(typeText);
		hBox1.add(Box.createGlue());
		hBox1.add(Box.createHorizontalStrut(5));
		
		Box hBox3 = Box.createHorizontalBox();
		hBox3.add(Box.createHorizontalStrut(5));
		hBox3.add(niveauLabel);
		hBox3.add(Box.createHorizontalStrut(5));
		hBox3.add(jcbCollege);
		hBox3.add(Box.createHorizontalStrut(5));
		hBox3.add(jcbLycee);
		hBox3.add(Box.createHorizontalStrut(5));
		hBox3.add(jcbUniv);
		hBox3.add(Box.createGlue());
		hBox3.add(Box.createHorizontalStrut(5));
		
		Box hBox4 = Box.createHorizontalBox();
		hBox4.add(Box.createHorizontalStrut(5));
		hBox4.add(new JLabel("Commentaire :")); 
		hBox4.add(Box.createGlue());
		hBox4.add(Box.createHorizontalStrut(5));
		
		Box hBox5 = Box.createHorizontalBox();
		hBox5.add(Box.createHorizontalStrut(5));
		commentText.setBorder(BorderFactory.createLoweredBevelBorder());
		hBox5.add(commentText);
		hBox5.add(Box.createGlue());
		hBox5.add(Box.createHorizontalStrut(5));
		
		Box hBox6 = Box.createHorizontalBox();
		hBox6.add(Box.createHorizontalStrut(5));
		hBox6.add(new JLabel("Mots cls (ncessaires pour la recherche, spars par un espace) :")); 
		hBox6.add(Box.createGlue());
		hBox6.add(Box.createHorizontalStrut(5));
		
		Box hBox7 = Box.createHorizontalBox();
		hBox7.add(Box.createHorizontalStrut(5));
		motsClsText.setBorder(BorderFactory.createLoweredBevelBorder());
		hBox7.add(motsClsText);
		hBox7.add(Box.createGlue());
		hBox7.add(Box.createHorizontalStrut(5));
		
		Box vboxH = Box.createVerticalBox();
		vboxH.add(hBox1);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox3);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox4);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox5);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox6);
		vboxH.add(Box.createVerticalStrut(5));
		vboxH.add(hBox7);
		vboxH.setBorder(BorderFactory.createTitledBorder("")); 
		
		Box hBoxF = Box.createHorizontalBox();
		hBoxF.add(Box.createGlue());
		JButton okBouton = new JButton("OK"); 
		okBouton.grabFocus();
		okBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				boolean ok = verification();
				if (ok) {
					setVisible(false);
					String niveau = ""; 
					if (jcbCollege.isSelected()) niveau = niveau+" college"; 
					if (jcbLycee.isSelected()) niveau = niveau+" lycee"; 
					if (jcbUniv.isSelected()) niveau = niveau+" universite"; 
					diplomate.enregParamTexteEditee(typeText.getText(), niveau, commentText.getText(), motsClsText.getText());
					diplomate.activerEnregEdition();
				}
			}
		});
		hBoxF.add(okBouton);
		hBoxF.add(Box.createHorizontalStrut(5));
		JButton quitterBouton = new JButton("Quitter"); 
		quitterBouton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
//			    if (typeText.getText().length()>0) {
//			        //obligation d'enregistrer au moins le nom et le fichier de la donnee pour la premiere fois
//			        String niveau = "";
//					if (jcbCollege.isSelected()) niveau = niveau+" college";
//					if (jcbLycee.isSelected()) niveau = niveau+" lycee";
//					if (jcbUniv.isSelected()) niveau = niveau+" universite";
//					diplomate.enregParamTexteEditee(typeText.getText(), niveau, commentText.getText(), motsClsText.getText());
//			        setVisible(false);
			    dispose();
//			    } else typeLabel.setForeground(Color.red);
			}
		});
		hBoxF.add(quitterBouton);
		hBoxF.add(Box.createHorizontalStrut(5));
		
		Box vBox = Box.createVerticalBox();
		vBox.add(Box.createVerticalStrut(5));
		vBox.add(vboxH);
		vBox.add(Box.createGlue());
		vBox.add(Box.createVerticalStrut(5));
		vBox.add(hBoxF);
		vBox.add(Box.createVerticalStrut(5));
		
		add(vBox,BorderLayout.CENTER);
		setVisible(true);
	}
	
	public void chargerParam(String typeGeol, String niveau, String commentaire, String motscles) {
		typeText.setText(typeGeol);
		jcbCollege.setSelected(niveau.contains("college")); 
		jcbLycee.setSelected(niveau.contains("lycee")); 
		jcbUniv.setSelected(niveau.contains("universite")); 
		commentText.setText(commentaire);
		motsClsText.setText(motscles);
	}
	
	private boolean verification() {
		boolean etat = true;
		if ((typeText.getText() == null) || typeText.getText().equals("")) { 
			etat = false;
			typeLabel.setForeground(Color.red);
		} else {
			typeLabel.setForeground(Color.black);
		}
		if (!jcbCollege.isSelected() && !jcbLycee.isSelected() && !jcbUniv.isSelected()) {
			etat = false;
			niveauLabel.setForeground(Color.red);
		} else {
			niveauLabel.setForeground(Color.black);
		}
		return etat;
	}
}
