/*
 * Created on 20 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package geonoteOutils;

import java.io.File;
import java.util.ArrayList;

import javax.swing.filechooser.FileFilter;

/**
 * @author lefevre
 * 
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class FiltreExtensible extends FileFilter{
	//Description et extensions acceptes par le filtre
	private String description;
	private ArrayList extensions;
	
	//Constructeur  partir de la description
	public FiltreExtensible(String description){
		if(description == null){
			throw new NullPointerException("La description ne peut tre null.");
		}
		this.description = description;
		this.extensions = new ArrayList();
	}
	
	//Implmentation de FileFilter
	public boolean accept(File file){
		if(file.isDirectory() || extensions.size()==0) { 
			return true; 
		} 
		String nomFichier = file.getName().toLowerCase(); 
		for(int i=0 ; i<extensions.size() ; i++) {
			if(nomFichier.endsWith((String) extensions.get(i))){
				return true;
			}
		}
		return false;
	}
	
	public String getDescription() {
		StringBuffer buffer = new StringBuffer(description);
		buffer.append(" (");
		for (int i = 0; i < extensions.size(); i++) {
			buffer.append(extensions.get(i)).append(" ");
		}
		return buffer.append(")").toString();
	}
	
	//Quelques mthodes utilitaires
	public void setDescription(String description) {
		if (description == null) {
			throw new NullPointerException("La description ne peut tre null.");
		}
		this.description = description;
	}
	
	public void addExtension(String extension){
		if(extension == null){
			throw new NullPointerException("Une extension ne peut tre null.");
		}
		extensions.add(extension);
	}
	
	public void removeExtension(String extension){
		extensions.remove(extension);
	}
	
	public void clearExtensions(){
		extensions.clear();
	}
	
	public ArrayList getExtensions() {
		return extensions;
	}
}