/*
 * Created on 17 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package geonoteOutils;

import geonoteInterface.BarreEtat;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.text.DecimalFormat;

/**
 * @author lefevre
 * 
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Reglet {
	
	private int x1;
	private int y1;
	private int x2;
	private int y2;
	private double longueur;
	private boolean modeEdition = false; //comportement different selon le mode TODO verif si inutile ?
	private boolean modeEcriture = false; // permet l'affichage des 2 types de reglet : prise de mesure et lecture
	
	public Reglet(boolean edition) {
		x1=-1;
		y1=-1;
		x2=-1;
		y2=-1;
		longueur = 0;
		modeEdition = edition;
	}
	
	public void setDepart(int x, int y) {
		x1 = x;
		y1 = y;
	}
	
	public void setArrive(int x, int y) {
		x2 = x;
		y2 = y;
	}

	public double getLongueur() {
		longueur = (double) Math.sqrt(Math.pow(Math.abs((x1-x2)),2) + Math.pow(Math.abs((y1-y2)),2)); //rafraichit la longueur
		return longueur;
	}

	public void setModeEcriture(boolean b) {
		modeEcriture = b;
	}

	
	public void draw(Graphics2D g, double zoom, double echelle, String unite/*, int decalHor, int decalVer*/) {
		longueur = (double) Math.sqrt(Math.pow(Math.abs((x1-x2)),2) + Math.pow(Math.abs((y1-y2)),2));
		g.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 1.0f ));
		int x1Affichage = x1;//+decalHor;
		int y1Affichage = y1;//+decalVer;
		
		//distances projetees sur les axes
		int dxa = x2 - x1Affichage;
		int dya = y2 - y1Affichage;
		int dxb = dxa;
		int dyb = dya;
		//pour simplifier les calculs :
		int absdx = Math.abs(dxa);
		int absdy = Math.abs(dya);
//		 calcul de l'angle entre les deux pts
		double theta = Math.atan2(absdy, absdx);
		//barre de gauche
		int absdxa = absdx - (int) (10/zoom*Math.cos(theta-Math.PI/2));
		int absdya = absdy - (int) (10/zoom*Math.sin(theta-Math.PI/2));
		//barre de droite
		int absdxb = absdx - (int) (10/zoom*Math.cos(theta+Math.PI/2));
		int absdyb = absdy - (int) (10/zoom*Math.sin(theta+Math.PI/2));
//		 on enleve les valeur absolue de dx et dy
		if (dxa < 0) {dxa = -absdxa;} else {dxa = absdxa;}
		if (dya < 0) {dya = -absdya;} else {dya = absdya;}
		if (dxb < 0) {dxb = -absdxb;} else {dxb = absdxb;}
		if (dyb < 0) {dyb = -absdyb;} else {dyb = absdyb;}
		//coord resultats :
		int xa = x2 - dxa;
		int ya = y2 - dya;
		int xb = x2 - dxb;
		int yb = y2 - dyb;
		
		g.setColor(Color.white);
		g.setStroke(new BasicStroke( (float) (4.0f/zoom) ));
		g.drawLine(x1Affichage,y1Affichage,x2,y2);
		g.drawLine(x1Affichage,y1Affichage,xa,ya);
		g.drawLine(x1Affichage,y1Affichage,xb,yb);
		g.setColor(Color.black);
		//"etalonnage" du reglet
		if (3/zoom>=(1/zoom)/(echelle/zoom)) {
			g.setStroke(new BasicStroke( (float) (2.0f/zoom) ));
		} else {
			float epaisseur=(float) (2/zoom); /* taille de la ligne */
			float[] style = {(float) (((1/zoom)/(echelle/zoom))-(3/zoom)),(float) (3/zoom)}; //un pointill + un blanc font exactement UNE unit
			g.setStroke( new BasicStroke(epaisseur, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER, 2.0f, style, 0));
		}
		g.drawLine(x1Affichage,y1Affichage,x2,y2);
		g.setStroke(new BasicStroke( (float) (2.0f/zoom) ));
		g.drawLine(x1Affichage,y1Affichage,xa,ya);
		g.drawLine(x1Affichage,y1Affichage,xb,yb);
//		g.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.6f ));
//		g.setColor(Color.white);
//		g.fillRect(x2,y2,(int) (110/zoom),(int) (20/zoom));
//		g.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 1.0f ));
//		g.setColor(Color.black);
//		g.setStroke(new BasicStroke( (float) (1.0f/zoom) ));
//		g.drawRect(x2,y2,(int) (110/zoom),(int) (20/zoom));
		double mesure = echelle * longueur;
		String longueurAffiche;
		DecimalFormat df;
		if ((modeEdition) && (modeEcriture)) {
			df = new DecimalFormat("########"); //outil de formattage 
			longueurAffiche = df.format(longueur)+" px."; //formattage 
		} else {
			df = new DecimalFormat("########.##"); //outil de formattage 
			longueurAffiche = df.format(mesure)+" "+unite; //formattage 
		}
//		g.setFont(new Font("Courrier", 0,(int) (20/zoom)));
//		g.drawString(longueurAffiche, (int) (x2+(10/zoom)), (int) (y2+(18/zoom)));
		BarreEtat.afficheDroite("MESURE : "+longueurAffiche); 
	}
}
