/*
 * Created on 13 avr. 2005
 */
package geonoteInterface;

import geonoteOutils.FiltreExtensible;
import geonoteOutils.ImagePreview;
import geonoteOutils.Traceur;
import geonoteOutils.TraceurCarte;
import geonoteOutils.TraceurDonnee;
import geonoteOutils.TraceurSession;
import geonoteOutils.TraceurTraces;
import geonoteOutilsCarnet.SmallButton;
import geonoteZones.Carnet;
import geonoteZones.Documentations;
import geonoteZones.Historique;
import geonoteZones.Navigation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

//TODO BLOC NOTE : 
//TODO
//TODO MAJ du systeme de traces
//TODO verifier le chargement de ts les param pour modif des cartes/donnees
//TODO CONSTANTES !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


/**
 * Fenetre pricipale de l'application
 */
public class Interface extends JFrame implements KeyListener, ComponentListener  {
	private Historique historique = null;
	private Carnet carnet = null;
	private Navigation navigation = null;
	private Documentations documentations = null;
	private JSplitPane splitPane1 = null;
	private JSplitPane splitPane2 = null;
	private JSplitPane splitPanePrincipal = null;
//	private double rapport1 = 1/4;
//    private double rapport2 = 3/8;
//    private double rapportP = 1/4;
	
	private int hauteurMin = 480;
	private int largeurMin = 640;
	
	private FenetreParametresEditionCarte fpec = null;
	private FenetreParametresEditionImage fpei = null;
	private FenetreParametresEditionTexte fpet = null;
	
	private TraceurCarte traceurCarteEdition = null; //pour creer/modifier le fichier xml correspondant  une carte cre/modifie en edition
	private TraceurDonnee traceurDonneeEdition = null;//pour creer/modifier le fichier xml correspondant  une donnee cre/modifie en edition
	private TraceurSession traceurSession = null; //fichier de sauvegarde de la session
	private TraceurTraces traceurTraces = null; //enregistre toutes les traces d'utilisation
	
//	private boolean affichageArretsActif = true;
//	private boolean affichageCoordActif = false;
	private boolean carteEnEdition = false;	//pour activer des methodes specifiques
	private boolean texteEnEdition = false;	//pour activer des methodes specifiques
	private boolean imageEnEdition = false;	//devines ;)
	private boolean carteModifie = false; //si true, on propose l'enregistrement de la carte en cours d'edition
	private boolean docsModifi = false; //si true, on propose l'enregistrement du docs en cours d'edition
	private boolean fenetreActive = false;
	private boolean modeEdition = false;
	private boolean modeSuppArret = false;
	private boolean modeSuppLien = false;
	private boolean modeSuppVue = false;
	private boolean tracesActives = true; //pour activer la fonction de tracage
	private boolean sauv = true; //pour savoir si session sauvegarde ou non
	private boolean sortie = false;	//pour limiter l'utilisation d'un popup d'info d'enregistrement  la sortie du prog 
	private boolean enregEditPossible = false;
	
	private String userName = ""; 
	private String espaceCartes = ""; //charg depuis fichier de CONFIG 
	private String espaceDeTravail = "";	//determin a partir d'une var d'environnement 
	private String espaceSysteme = ""; 
	private String espaceDocs = ""; //charg depuis fichier de CONFIG 
	private String espaceDonnees = ""; //charg depuis fichier de CONFIG 
	private String espaceGeorefs = ""; //charg depuis fichier de CONFIG 
	private String espaceSessions = ""; //charg depuis fichier de CONFIG 
	private String espaceTraces = ""; //charg depuis fichier de CONFIG 
	private String espaceCarnet = ""; //devines ;) 
	private String espaceCalendrier = ""; 
	private String espaceLexique = ""; 
	private String espaceAide = ""; 
	private String extensionsCartes = "";	//listes des extensions acceptees INUTILES : les filtres empechent les mauvaises extensions 
	private String extensionsDocs = ""; 
//	private String extensionsTextes = ""; 
	private String nomFichierSession = ""; 
	private String nomFichierTraces = ""; 
	private String pswd = ""; 
	
	private JMenuBar barreM = null;
//	private JToolBar toolBarre = null;
	private JMenu sessionM = null;
	private JMenuItem nouvSessionM = null;
	private JMenuItem chargSessionM = null;
	private JMenuItem quitterM = null;
	private JMenuItem enregM = null;
	private JMenu affichageM = null;
	private JCheckBoxMenuItem coordCB = null;
	private JCheckBoxMenuItem carnetCB = null;
	private JCheckBoxMenuItem arretsCB = null;
	private JCheckBoxMenuItem documentationsCB = null;
	private JCheckBoxMenuItem historiqueCB = null;
	private JCheckBoxMenuItem navigationCB = null;
	private JMenu aideM = null;
	private JMenuItem helpM = null;
	private JMenuItem aproposM = null;
	private JMenu editionM = null;
	private JMenuItem edActiverM = null;
	private JMenuItem edDesactiverM = null;
	private JMenuItem parametrageM = null;
	private JMenuItem enregEditM = null;//pour enregistrer les modifs effectuer en mode edition
	private JMenuItem parametresEditM = null;
	private JMenuItem modifCarteM = null;
	private JMenuItem modifDocsM = null;
	private JMenu modifM = null;
	private JMenuItem nouvCarteM = null;
	private JMenuItem nouvDocsM = null;
	private JMenuItem nouvVueM = null;
	private JMenu nouvM = null;
	private JMenuItem suppArretM = null;
	private JMenuItem suppCarteM = null;
	private JMenuItem suppVueM = null;
	private JMenuItem suppDocsM = null;
	private JMenuItem suppLienM = null;
	private JMenu suppM = null;
	private JMenu outilsM = null;
	private JMenuItem calendrierM = null;
	private JMenuItem documentationsM = null;
	private JMenuItem lexiqueM = null;
	private JMenuItem rechercheM = null;
	
	private JToolBar toolBar = null;
	private SmallButton coordSB = null;
	private SmallButton arretSB = null;
	private SmallButton quatreSB = null;
	private SmallButton docSB = null;
	private SmallButton calendrierSB = null;
	private SmallButton lexiqueSB = null;
	private SmallButton rechercheSB = null;
	private SmallButton suivSB = null;
	private SmallButton precSB = null;
	
	public Cursor suppCurseur = null;
	
	//pour memoriser les dossiers o les choix se sont faits
	private String dossierNouvoLien = ""; 
	private String dossierNouvelleDonnee = ""; 
	private String dossierNouvelleVue = ""; 
	
	/**
	 * Constructeur
	 */
	public Interface() {
		super(Constantes.GEONOTE+Constantes.VERSION); 
		//	pour conserver l'aspect du systeme d'exploitation :
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {}
		this.setLayout(new BorderLayout());
		//Recuperation du chemin absolu !!
//		System.out.println("JRE "+System.getProperty("java.version"));
		System.out.println(Constantes.GEONOTE+Constantes.VERSION); 
		espaceDeTravail = System.getProperty("user.dir")+"\\";	//chemin relatif MARCHE  
		
		//Chargement du fichier de config
		Traceur config = new Traceur();
		boolean result = config.charger(espaceDeTravail+Constantes.FICHIER_CONFIG); 
		if (result) {
			espaceSysteme = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_SYSTEME); 
			espaceTraces = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_TRACES); 
			espaceDonnees = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_DONNEES); 
			espaceSessions = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_SESSIONS); 
			espaceCartes = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_CARTES); 
			espaceDocs = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_DOCS); 
			espaceGeorefs = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_GEOREFS); 
			espaceCarnet = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_CARNET); 
			espaceCalendrier = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_CALENDRIER); 
			espaceLexique = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_LEXIQUE); 
			espaceAide = espaceDeTravail+config.exporteInfo(Constantes.DOSSIER_AIDE); 
//			extensionsCartes = config.exporteInfo("extensionsCartes"); 
//			extensionsDocs = config.exporteInfo("extensionsDocs"); 
//			extensionsTextes = config.exporteInfo("extensionsTextes"); 
			String largeur = config.exporteInfo(Constantes.LARGEUR); 
			largeurMin = Integer.parseInt(largeur);
			String hauteur = config.exporteInfo(Constantes.HAUTEUR); 
			hauteurMin = Integer.parseInt(hauteur);
			tracesActives = config.exporteInfo(Constantes.TRACES).equals(Constantes.ACTIVES);  
			pswd = config.exporteInfo(Constantes.MDP); 
			//fin du chargement
			setSize(new Dimension(largeurMin,hauteurMin));
			setMinimumSize(new Dimension(640,480)); //INEFFICACE
		} else {
			JOptionPane.showMessageDialog(new JFrame(), Constantes.ECHEC_CHRGT_CONFIG, Constantes.ERREUR ,JOptionPane.WARNING_MESSAGE);  
			System.exit(0);
		}
		dossierNouvoLien = espaceDocs;
		dossierNouvelleDonnee = "."; 
		dossierNouvelleVue = espaceDonnees;
		
		setLocationRelativeTo(null);	//centrage de la fenetre
		setResizable(true);
//		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		
		//chargement de l'icone
		Image icone = Toolkit.getDefaultToolkit().getImage(espaceSysteme+Constantes.FICHIER_ICON); 
		setIconImage(icone);
		//chargement du curseur de suppression
		Image im = java.awt.Toolkit.getDefaultToolkit().getImage(espaceSysteme+Constantes.FICHIER_CURSEUR_SUPP); 
		Point pt = new Point(0, 0);
		suppCurseur = java.awt.Toolkit.getDefaultToolkit().createCustomCursor(im, pt, "suppression"); 
		
		//ZONES D'AFFICHAGE
		historique = new Historique(this);
		navigation = new Navigation(this, espaceSysteme);
		carnet = new Carnet(this, espaceSysteme);
		documentations = new Documentations(this, espaceSysteme);
		
		//creation des 2 splitpanes
		splitPanePrincipal = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		//splitPanePrincipal.setOneTouchExpandable(true);
		splitPanePrincipal.setDividerLocation(getHeight()*3/4);
		splitPanePrincipal.setPreferredSize(new Dimension(largeurMin,hauteurMin));	//EFFICACE !
		splitPane1 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		//splitPane1.setOneTouchExpandable(true);
		splitPane1.setDividerLocation(getWidth()/4);
		splitPane2 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		//splitPane2.setOneTouchExpandable(true);
		splitPane2.setDividerLocation(getWidth()*3/8);
		splitPane1.setBorder(null);
		splitPane2.setBorder(null);
		//taille des diviseurs
		splitPanePrincipal.setDividerSize(4);
		splitPane1.setDividerSize(4);
		splitPane2.setDividerSize(4);
		//ajout des elements
		splitPane2.setLeftComponent(navigation);
		splitPane2.setRightComponent(documentations);
		splitPane1.setLeftComponent(historique);
		splitPane1.setRightComponent(splitPane2);
		splitPanePrincipal.setTopComponent(splitPane1);
		splitPanePrincipal.setBottomComponent(carnet);
		
		this.add(splitPanePrincipal, BorderLayout.CENTER);
		add(new BarreEtat(espaceSysteme), BorderLayout.SOUTH);
				
		//MENU :
		barreM = new JMenuBar();
		setJMenuBar(barreM);
		
		sessionM = new JMenu(Constantes.MENU_SESSION);
		sessionM.setMnemonic(KeyEvent.VK_S);
		barreM.add(sessionM);
		nouvSessionM = new JMenuItem(Constantes.MENU_NOUVELLE_SESSION, new ImageIcon(espaceSysteme+Constantes.IMAGE_NOUVEAU));  
		nouvSessionM.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));
		nouvSessionM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				nouvelleSession();
			}
		});
		sessionM.add(nouvSessionM);
		chargSessionM = new JMenuItem(Constantes.MENU_CHARGER_SESSION, new ImageIcon(espaceSysteme+Constantes.IMAGE_OUVRIR));  
		chargSessionM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				chargerSession();
			}
		});
		sessionM.add(chargSessionM);
		enregM = new JMenuItem(Constantes.MENU_ENREG_SESSION, new ImageIcon(espaceSysteme+Constantes.IMAGE_ENREGISTRER));  
		enregM.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
		enregM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				enregistrerSession();
			}
		});
		sessionM.add(enregM);
		sessionM.addSeparator();
		quitterM = new JMenuItem(Constantes.MENU_QUITTER, new ImageIcon(espaceSysteme+Constantes.IMAGE_QUITTER));  
		quitterM.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, ActionEvent.CTRL_MASK));
		quitterM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				quitter();
			}
		});
		sessionM.add(quitterM);
		
		affichageM = new JMenu(Constantes.MENU_AFFICHAGE); 
		affichageM.setMnemonic(KeyEvent.VK_A);
		barreM.add(affichageM);
		coordCB= new JCheckBoxMenuItem(Constantes.MENU_COORDS, new ImageIcon(espaceSysteme+Constantes.IMAGE_COORDS));  
		coordCB.setSelected(false);	
		coordCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				majAffichage();
			}
		});
		affichageM.add(coordCB);
		arretsCB = new JCheckBoxMenuItem(Constantes.MENU_ARRETS, new ImageIcon(espaceSysteme+Constantes.IMAGE_ARRETS));  
		arretsCB.setSelected(true);
		arretsCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				majAffichage();
			}
		});
		affichageM.add(arretsCB);
		affichageM.addSeparator();
		historiqueCB = new JCheckBoxMenuItem(Constantes.MENU_HISTO, new ImageIcon(espaceSysteme+Constantes.IMAGE_HISTO));  
		historiqueCB.setSelected(true);
		historiqueCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				majAffichage();
			}
		});
		affichageM.add(historiqueCB);
		navigationCB = new JCheckBoxMenuItem(Constantes.MENU_NAVIG, new ImageIcon(espaceSysteme+Constantes.IMAGE_NAVIG));  
		navigationCB.setSelected(true);
		navigationCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				majAffichage();
			}
		});
		affichageM.add(navigationCB);
		documentationsCB = new JCheckBoxMenuItem(Constantes.MENU_DOCU, new ImageIcon(espaceSysteme+Constantes.IMAGE_DOC));  
		documentationsCB.setSelected(false);
		documentationsCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				majAffichage();
			}
		});
		affichageM.add(documentationsCB);
		carnetCB = new JCheckBoxMenuItem(Constantes.MENU_CARNET, new ImageIcon(espaceSysteme+Constantes.IMAGE_CARNET));  
		carnetCB.setSelected(true);
		carnetCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				majAffichage();
			}
		});
		affichageM.add(carnetCB);
		
		outilsM = new JMenu("Outils"); 
		outilsM.setMnemonic(KeyEvent.VK_O);
		barreM.add(outilsM);
		documentationsM = new JMenuItem(Constantes.MENU_DOCU, new ImageIcon(espaceSysteme+Constantes.IMAGE_DOCUMENTATION));  
		documentationsM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				chargerDocs();
			}
		});
		outilsM.add(documentationsM);
		calendrierM = new JMenuItem(Constantes.MENU_CALENDRIER, new ImageIcon(espaceSysteme+Constantes.IMAGE_CALENDRIER));  
		calendrierM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				lancementCalendrier();
			}
		});
		outilsM.add(calendrierM);
		lexiqueM = new JMenuItem(Constantes.MENU_LEXIQUE, new ImageIcon(espaceSysteme+Constantes.IMAGE_LEXIQUE));  
		lexiqueM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				lancementLexique();
			}
		});
		outilsM.add(lexiqueM);
		rechercheM = new JMenuItem(Constantes.MENU_RECHERCHE, new ImageIcon(espaceSysteme+Constantes.IMAGE_RECHERCHE));  
		rechercheM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				recherche();
			}
		});
		outilsM.add(rechercheM);
		
		editionM = new JMenu(Constantes.MENU_EDITION); 
		editionM.setMnemonic(KeyEvent.VK_E);
		barreM.add(editionM);
		parametrageM = new JMenuItem(Constantes.MENU_PARAMETRAGE, new ImageIcon(espaceSysteme+Constantes.IMAGE_PARAM));  
		parametrageM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				parametrage();
			}
		});
		editionM.add(parametrageM);
		editionM.addSeparator();
		edActiverM = new JMenuItem(Constantes.MENU_ACTIVER, new ImageIcon(espaceSysteme+Constantes.IMAGE_ACTIVER));  
		edActiverM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				activerEdition(true);
			}
		});
		editionM.add(edActiverM);
		edDesactiverM = new JMenuItem(Constantes.MENU_DESACTIVER, new ImageIcon(espaceSysteme+Constantes.IMAGE_DESACTIVER));  
		edDesactiverM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				activerEdition(false);
			}
		});
		editionM.add(edDesactiverM);
		editionM.addSeparator();
		nouvM = new JMenu(Constantes.MENU_NOUVO); 
		editionM.add(nouvM);
		nouvCarteM = new JMenuItem(Constantes.MENU_EDIT_CARTE); 
		nouvCarteM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				nouvCarte();
			}
		});
		nouvM.add(nouvCarteM);
		nouvVueM = new JMenuItem(Constantes.MENU_EDIT_VUE); 
		nouvVueM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				nouvVue();
			}
		});
		nouvVueM.setEnabled(false);
		nouvM.add(nouvVueM);
		nouvDocsM = new JMenuItem(Constantes.MENU_EDIT_DONNEE); 
		nouvDocsM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				nouvDonnee();
			}
		});
		nouvM.add(nouvDocsM);
		modifM = new JMenu(Constantes.MENU_MODIFIER); 
		editionM.add(modifM);
		modifCarteM = new JMenuItem(Constantes.MENU_EDIT_CARTE); 
		modifCarteM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				modifCarte();
			}
		});
		modifM.add(modifCarteM);
		modifDocsM = new JMenuItem(Constantes.MENU_EDIT_DONNEE); 
		modifDocsM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				modifDonnee();
			}
		});
		modifM.add(modifDocsM);
		suppM = new JMenu(Constantes.MENU_SUPPRIMER); 
		editionM.add(suppM);
		suppCarteM = new JMenuItem(Constantes.MENU_EDIT_CARTE); 
		suppCarteM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				suppCarte();
			}
		});
		suppM.add(suppCarteM);
		suppVueM = new JMenuItem(Constantes.MENU_EDIT_VUE); 
		suppVueM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				suppVue();
			}
		});
		suppM.add(suppVueM);
		suppArretM = new JMenuItem(Constantes.MENU_EDIT_ARRET); 
		suppArretM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				suppArret();
			}
		});
		suppM.add(suppArretM);
		suppLienM = new JMenuItem(Constantes.MENU_EDIT_LIEN); 
		suppLienM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				suppLien();
			}
		});
		suppM.add(suppLienM);
		suppDocsM = new JMenuItem(Constantes.MENU_EDIT_DONNEE); 
		suppDocsM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				suppDonnee();
			}
		});
		suppM.add(suppDocsM);
		enregEditM = new JMenuItem(Constantes.MENU_ENREG); 
		enregEditM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				enregistrerEdition();
			}
		});
		editionM.add(enregEditM);
		parametresEditM = new JMenuItem(Constantes.MENU_PARAM); 
		parametresEditM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				afficheParametres();
			}
		});
		editionM.add(parametresEditM);
		
		
		aideM = new JMenu(Constantes.MENU_HELP); 
		barreM.add(aideM);
		helpM = new JMenuItem(Constantes.MENU_AIDE); 
		helpM.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0));
		helpM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				lancementAide();
			}
		});
		aideM.add(helpM);
		aproposM = new JMenuItem(Constantes.MENU_APROPOS); 
		aproposM.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));
		aproposM.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				aPropos();
			}
		});
		aideM.add(aproposM);
		
		toolBar = new JToolBar();
		Action action = new AbstractAction("coordonnes", new ImageIcon(espaceSysteme+Constantes.IMAGE_COORDS)) {  
			public void actionPerformed(ActionEvent e) {
				if (coordCB.isEnabled()) {
					coordCB.setSelected(!coordCB.isSelected());
					majAffichage();
				}
			}
		};
		coordSB = new SmallButton(action, Constantes.MENU_AFF_COORDS); 
		toolBar.add(coordSB);
		action = new AbstractAction("arrets", new ImageIcon(espaceSysteme+Constantes.IMAGE_ARRETS)) {  
			public void actionPerformed(ActionEvent e) {
				if (arretsCB.isEnabled()) {
					arretsCB.setSelected(!arretsCB.isSelected());
					majAffichage();
				}
			}
		};
		arretSB = new SmallButton(action, Constantes.MENU_AFF_ARRETS); 
		toolBar.add(arretSB);
		action = new AbstractAction("quatres", new ImageIcon(espaceSysteme+Constantes.IMAGE_QUATRES)) {  
			public void actionPerformed(ActionEvent e) {
				historiqueCB.setSelected(true);
				navigationCB.setSelected(true);
				carnetCB.setSelected(true);
				if (documentationsCB.isEnabled()) documentationsCB.setSelected(true);
				majAffichage();
			}
		};
		quatreSB = new SmallButton(action, Constantes.MENU_AFF_ZONES); 
		toolBar.add(quatreSB);
		toolBar.addSeparator();
		action = new AbstractAction("docs", new ImageIcon(espaceSysteme+Constantes.IMAGE_DOCUMENTATION)) {  
			public void actionPerformed(ActionEvent e) {
				chargerDocs();
			}
		};
		docSB = new SmallButton(action, Constantes.MENU_DOCU); 
		toolBar.add(docSB);
		action = new AbstractAction("calendrier", new ImageIcon(espaceSysteme+Constantes.IMAGE_CALENDRIER)) {  
			public void actionPerformed(ActionEvent e) {
				lancementCalendrier();
			}
		};
		calendrierSB = new SmallButton(action, Constantes.MENU_CALENDRIER); 
		toolBar.add(calendrierSB);
		action = new AbstractAction("lexique", new ImageIcon(espaceSysteme+Constantes.IMAGE_LEXIQUE)) {  
			public void actionPerformed(ActionEvent e) {
				lancementLexique();
			}
		};
		lexiqueSB = new SmallButton(action, Constantes.MENU_LEXIQUE); 
		toolBar.add(lexiqueSB);
		action = new AbstractAction("recherche", new ImageIcon(espaceSysteme+Constantes.IMAGE_RECHERCHE)) {  
			public void actionPerformed(ActionEvent e) {
				recherche();
			}
		};
		rechercheSB = new SmallButton(action, Constantes.MENU_RECHERCHE); 
		toolBar.add(rechercheSB);
		toolBar.addSeparator();
		action = new AbstractAction("precedent", new ImageIcon(espaceSysteme+Constantes.IMAGE_PRECEDENT)) {  
			public void actionPerformed(ActionEvent e) {
				navigation.precedent();
				majAffichage();
			}
		};
		precSB = new SmallButton(action, Constantes.MENU_DONNEE_PREC); 
		toolBar.add(precSB);
		action = new AbstractAction("suivant", new ImageIcon(espaceSysteme+Constantes.IMAGE_SUIVANT)) {  
            public void actionPerformed(ActionEvent e) {
				navigation.suivant();
				majAffichage();
			}
		};
		suivSB = new SmallButton(action, Constantes.MENU_DONNEE_SUIV); 
		toolBar.add(suivSB);
		add(toolBar, BorderLayout.NORTH);
		
		addComponentListener(new ComponentListener() {
			public void componentHidden(ComponentEvent arg0) {
			}
			public void componentMoved(ComponentEvent arg0) {
			}
			public void componentResized(ComponentEvent arg0) {
				repaintSplit(); //replacement des separateurs des splitpanes
			}
			public void componentShown(ComponentEvent arg0) {	
			}
		});
		
		//		 modif du listener de la fenetre
		addWindowListener(new WindowListener() {
			public void windowActivated(WindowEvent arg0) {
			}
			public void windowClosed(WindowEvent arg0) {
			}
			//procedure de fermeture de la fenetre principale (avec enregistrement des fichiers ...)
			public void windowClosing(java.awt.event.WindowEvent evt) {
				quitter();
			}
			public void windowDeactivated(WindowEvent arg0) {
			} 
			public void windowDeiconified(WindowEvent arg0) {
			}
			public void windowIconified(WindowEvent arg0) {
			}
			public void windowOpened(WindowEvent arg0) {
			}
		} );
		
		addKeyListener(this); //pour le ECHAP du mode suppression
		addComponentListener(this);
		
		activation(false); //pour griser la fenetre
		pack();
		setVisible(true);
		
		//Creation du fichier de traces
		Date date = new Date();
		String[] dateTab = date.toString().split(" "); 
		String heure = dateTab[3].replaceFirst(":","h");  
		heure = heure.replaceFirst(":","m");  
		String loginWin = System.getProperty("user.name"); 
		nomFichierTraces = "traces_"+loginWin+"_"+dateTab[2]+"-"+dateTab[1]+"-"+dateTab[5]+"_"+heure+".xml";      
		traceurTraces = new TraceurTraces(espaceTraces+"\\"+nomFichierTraces,"traces");  
		
//		rapport1 = 0.25;
//		rapport2 = 0.625;
//		rapportP = 0.75;
	}
	
	/**
	 * Active/desactive la fenetre principale suivant le parametre
	 */
	public void activation(boolean b) {
		fenetreActive = b;
		historique.setEnabled(b);
		navigation.setEnabled(b);
		carnet.setEnabled(b);
		documentations.setEnabled(b);
		splitPanePrincipal.setEnabled(b);
		splitPane1.setEnabled(b);
		splitPane2.setEnabled(b);
		enregM.setEnabled(b);
		affichageM.setEnabled(b);
		quatreSB.setEnabled(b);
		arretSB.setEnabled(b);
		coordSB.setEnabled(b);
		rechercheM.setEnabled(b);
		rechercheSB.setEnabled(b);
		documentationsM.setEnabled(b);
		docSB.setEnabled(b);
		precSB.setEnabled(false);
		suivSB.setEnabled(false);
		edDesactiverM.setEnabled(modeEdition);
		nouvM.setEnabled(modeEdition);
		modifM.setEnabled(modeEdition);
		suppM.setEnabled(modeEdition);
		enregEditM.setEnabled(modeEdition);
		parametresEditM.setEnabled(modeEdition && (carteEnEdition || texteEnEdition || imageEnEdition));
		documentations.setVisible(documentations.rapportActivit());
	}
	
	/**
	 * passe le prog en mode edition !
	 */
	private void activerEdition(boolean b) {
		confirmation();
		if (!fenetreActive) activation(true);
		sauv = true;
		if (b) {
			rapportTrace("menu", "activation edition");  
			boolean verif = authentification();
			if (verif) {
				modeEdition = b;
				majAffichage();
				navigation.reset();
				historique.reset();
				documentations.reset();
				carnet.reset();
			} else {
				rapportTrace("menu", "activation edition", "echec authentification");   
			}
		} else {
			rapportTrace("menu", "desactivation edition");  
			modeEdition = b;
			majAffichage();
			navigation.reset();
			historique.reset();
			documentations.reset();
			carnet.reset();
			docsModifi = false;
			carteModifie = false;
			nouvVueM.setEnabled(false);
			carteEnEdition = false;
			texteEnEdition = false;
			BarreEtat.reset();
			activation(false);
		}
	}
	
	public void activerEnregEdition() {
	    enregEditPossible = true;
	    majAffichage();
	}
	
	public void afficheArrets() {
	    arretsCB.setSelected(true);
	}
	
	/**
	 * Permet de faire afficher les donnees dans la zone de Docs
	 */
	public void afficheDocs(String donnee) {
		TraceurCarte tr = new TraceurCarte();
		String chemin = espaceDocs+donnee;
		String extension = chemin.substring(chemin.lastIndexOf(".")); 
		String cheminXML = chemin.replace(extension,".xml"); 
		boolean result = tr.charger(cheminXML);
		if (result) {
		    BarreEtat.resetGauche();
			String type = tr.exporteType();
			if (type.equals("texte")) { 
			    String commentaires = tr.exporteInfo("commentaire"); 
				documentations.chargerTexte(chemin, commentaires);
			} else {
				boolean regActif = tr.exporteInfo("reglet").equals("actif");  
				boolean zoomActif = tr.exporteInfo("zoom").equals("actif");  
				String unit = ""; 
				double ech = 1;
				if (regActif) {
					unit = tr.exporteInfo("unite"); 
					ech = Double.parseDouble(tr.exporteInfo("echelle")); 
				}
				String commentaires = tr.exporteInfo("commentaire"); 
				if (type.equals("carte")) { 
					BarreEtat.afficheGauche(Constantes.MSG_ERREUR_1, Color.red); 
				    //documentations.chargerCarte(chemin, ech, unit, regActif, zoomActif, modeEdition, tr.construitArrets(), Integer.parseInt(tr.exporteInfo("latitude")), Integer.parseInt(tr.exporteInfo("longitude")), Double.parseDouble(tr.exporteInfo("echelleLatitude")), Double.parseDouble(tr.exporteInfo("echelleLongitude")));
				} else {
					if (type.equals("image")) { 
						documentations.chargerImage(chemin, ech, unit, regActif, zoomActif, modeEdition, commentaires);
					}
				}
			}
		} else {
//			System.out.println("Erreur lors du chargement de la donnee !");
			BarreEtat.afficheGauche(Constantes.MSG_ERREUR_2, Color.red); 
		}
		documentationsCB.setSelected(true);
		majAffichage();
	}
	
	/**
	 * affiche la fenetre des parametres d'une donnee en cours d'edition
	 */
	public void afficheParametres() {
		if (modeEdition) {
			if (carteEnEdition && !fpec.isVisible()) {
			    String reg =  traceurCarteEdition.exporteInfo("reglet"); 
				boolean regActif = false;
				if (reg != null) reg.equals("actif"); 
				String zoom = traceurCarteEdition.exporteInfo("zoom"); 
				boolean zoomActif = false;
				if (zoom != null) zoom.equals("actif"); 
				String typeVue = traceurCarteEdition.exporteTypeVuePrincipale();
				if (typeVue == null) typeVue = ""; 
				String fichVue = traceurCarteEdition.exporteFichierVuePrincipale();
				String couleur = traceurCarteEdition.exporteInfo("couleurArrets"); 
				if (couleur == null) couleur = "255 255 255"; 
				fpec = new FenetreParametresEditionCarte(this, fichVue);
				fpec.chargerParam(typeVue, regActif, zoomActif,/* nivo, motscles,*/ couleur);
				fpec.setExtendedState(JFrame.NORMAL);
			} else {
				if (texteEnEdition && !fpet.isVisible()) {
					String nivo = traceurDonneeEdition.exporteInfo("niveau"); 
					if (nivo == null) nivo = ""; 
					String motscles = traceurDonneeEdition.exporteInfo("motscles"); 
					if (motscles == null) motscles = ""; 
					String commentaire = traceurDonneeEdition.exporteInfo("commentaire"); 
					if (commentaire == null) commentaire = ""; 
					String typGeol = traceurDonneeEdition.exporteInfo("typeGeologique"); 
					if (typGeol == null) typGeol = ""; 
					fpet = new FenetreParametresEditionTexte(this);
					fpet.chargerParam(typGeol, nivo, commentaire, motscles);
					fpet.setExtendedState(JFrame.NORMAL);
				} else {
					if (imageEnEdition && !fpei.isVisible()) {
					    String reg =  traceurDonneeEdition.exporteInfo("reglet"); 
						boolean regActif = false;
						if (reg != null) reg.equals("actif"); 
						String zoom = traceurDonneeEdition.exporteInfo("zoom"); 
						boolean zoomActif = false;
						if (zoom != null) zoom.equals("actif"); 
						String nivo = traceurDonneeEdition.exporteInfo("niveau"); 
						if (nivo == null) nivo = ""; 
						String motscles = traceurDonneeEdition.exporteInfo("motscles"); 
						if (motscles == null) motscles = ""; 
						String commentaire = traceurDonneeEdition.exporteInfo("commentaire"); 
						if (commentaire == null) commentaire = ""; 
						String typGeol = traceurDonneeEdition.exporteInfo("typeGeologique"); 
						if (typGeol == null) typGeol = ""; 
						fpei = new FenetreParametresEditionImage(this);
						fpei.chargerParam(typGeol, regActif, zoomActif, nivo, commentaire, motscles);
						fpei.setExtendedState(JFrame.NORMAL);
					}
				}
			}
		}
	}
	
	/**
	 * Permet de faire afficher les donnees dans la zone de Visualisation
	 */
	public void afficheNav(String donnee, String ndPere) {
		String cheminImage = ""; 
		String extension = ""; 
		String cheminXML = ""; 
		TraceurCarte tr = new TraceurCarte(); //ds le cas d'une carte, besoin de reconstruire les arrets; ds les autres, besoins communs
		//determination du chemin
		if (ndPere.equals("carte")) { 
			cheminImage = espaceCartes+traceurSession.exporteCarte();
			extension = donnee.substring(donnee.lastIndexOf(".")); 
			cheminXML = cheminImage.replace(extension,".xml"); 
		} else {
			if (ndPere.equals("arret")) { 
				cheminImage = espaceGeorefs+donnee;
				extension = donnee.substring(donnee.lastIndexOf(".")); 
				cheminXML = cheminImage.replace(extension,".xml"); 
			}
		}
		boolean result = tr.charger(cheminXML);
		if (result) {
		    BarreEtat.resetGauche();
			String type = tr.exporteType();
			if (type.equals("texte")) { 
			    String comment = tr.exporteInfo("commentaire"); 
			    navigation.chargerTexte(cheminImage, comment);
			} else {
				boolean regActif = tr.exporteInfo("reglet").equals("actif");  
				boolean zoomActif = tr.exporteInfo("zoom").equals("actif");  
				String unit = ""; 
				double ech = 1;
				if (regActif) {
					unit = tr.exporteInfo("unite"); 
					ech = Double.parseDouble(tr.exporteInfo("echelle")); 
				}
				String couleur = tr.exporteInfo("couleurArrets"); 
				String comment = tr.exporteInfo("commentaire"); 
				if (type.equals("carte")) { 
					navigation.chargerCarte(cheminImage, ech, unit, regActif, zoomActif, modeEdition, tr.construitArrets(), Integer.parseInt(tr.exporteInfo("latitude")), Integer.parseInt(tr.exporteInfo("longitude")), Double.parseDouble(tr.exporteInfo("echelleLatitude")), Double.parseDouble(tr.exporteInfo("echelleLongitude")), tr.exporteVues(), couleur, comment);    
					if (!donnee.equals(traceurSession.exporteCarte())) { //si la donnee est une vue alors on la charge en + de la carte
						navigation.chargerVue(espaceCartes+donnee);
						navigation.masquerVuePrincipale();
					}
				} else {
					if (type.equals("image")) { 
						navigation.chargerImage(cheminImage, ech, unit, regActif, zoomActif, modeEdition, comment);
					}
				}
			}
			navigationCB.setSelected(true);
			majAffichage();
			coordCB.setEnabled(type.equals("carte")); 
			if (!coordCB.isEnabled()) coordCB.setSelected(false);
		} else {
//			System.out.println("Erreur lors du chargement de la donnee !");
			BarreEtat.afficheGauche(Constantes.MSG_ERREUR_2, Color.red); 
		}
	}
	
	/**
	 * ajoute ds l'histo (ecran + fichier session) l'acces  une donne georef d'un arret
	 * @param idArret
	 * @param donnee
	 */
	public void ajoutArretHisto(int idArret, String donnee) {
		sauv = false;
		Date date = new Date();
		String[] dateTab = traduireDate(date).split(" "); 
		String[] heureTab = dateTab[3].split(":"); 
		historique.ajoutArret(idArret, donnee);//+" (le "+dateTab[2]+"/"+dateTab[1]+"/"+dateTab[5]+"  "+heureTab[0]+":"+heureTab[1]+":"+heureTab[2]+")");
		traceurSession.ajouteDonneeArret(Integer.toString(idArret), donnee, dateTab[2],dateTab[1],dateTab[5],heureTab[0],heureTab[1],heureTab[2]);
	}
	
	/**
	 * ajoute au fichier xml d'une carte un arret
	 *
	 */
	public void ajouteArretCarte(int id, int latitude, int longitude) {
		traceurCarteEdition.ajouteArret(id, latitude, longitude);
		carteModifie = true;
		majAffichage();
	}
	
	/**
	 * ajoute les coords a une carte
	 */
	public void ajouteCoordonnees(int latOrigine, int longOrigine, double echLat, double echLong) {
		traceurCarteEdition.ajouteCoord(Integer.toString(latOrigine), Integer.toString(longOrigine), Double.toString(echLat), Double.toString(echLong));
		carteModifie = true;
		fpec.setExtendedState(JFrame.NORMAL);
		fpec.setDefCoordEffectuee(true);
		BarreEtat.resetGauche();
		majAffichage();
	}
	
	/**
	 * ajoute une donnee (existante) a un arret ds le xml d'une carte
	 */
	public ArrayList ajouteDonneeCarte(int id) {
		//System.out.println("ajout donnee");
		ArrayList resultat = new ArrayList();
		JFileChooser chooser = new JFileChooser(dossierNouvoLien);
		chooser.setDialogTitle("Choix de la donne (DEJA EDITEE)  lier"); 
		FiltreExtensible filtre = new FiltreExtensible("Donnes"); 
		filtre.addExtension(".jpg"); 
		filtre.addExtension(".gif"); 
		filtre.addExtension(".png"); 
		chooser.addChoosableFileFilter(filtre);
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		int returnVal = chooser.showOpenDialog(chooser.getParent());
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			String fich = chooser.getSelectedFile().getPath();
			String fichDest = espaceGeorefs+chooser.getSelectedFile().getName();
			String ext = fich.substring(fich.lastIndexOf(".")); 
			String fichXML = fich.replace(ext,".xml"); 
			String fichXMLDest = fichDest.replace(ext,".xml"); 
			Traceur tr = new Traceur();
			boolean result = tr.charger(fichXML);
			if (result) {
				String typ = tr.exporteInfo("typeGeologique"); 
				String nom = chooser.getSelectedFile().getName();
				resultat.add(nom);
				resultat.add(typ);
				traceurCarteEdition.ajouteDonneeArret(nom, id, typ); //edition du lien entre l'arret de la carte et la donnee
				//comparaison pour eviter le deplacement si deja au bon endroit
				if (!fich.contains(fichDest)) copier(chooser.getSelectedFile(), new File(fichDest)); // COPIE si besoin
				chooser.getSelectedFile().delete();	//suppression du fichier source
				File fileXml = new File(fichXML);
				if (!fichXML.contains(fichXMLDest)) copier(fileXml, new File(fichXMLDest)); // COPIE si besoin
				fileXml.delete();
				//fin deplacement
				carteModifie = true;
				majAffichage();
				dossierNouvoLien = fich.substring(0, fich.lastIndexOf("\\"))+"\\";  
			} else {
//				JOptionPane.showMessageDialog(new JFrame(), "La donne que vous avez voulu charger ne dispose pas de fichier d'informations !", "ERREUR !", JOptionPane.WARNING_MESSAGE, null);
				BarreEtat.afficheGauche(Constantes.MSG_ERREUR_3, Color.red); 
			}
		}
		return resultat;
	}
	
	/**
	 * recupere la mesure de l'echelle en pixel et demande la distance equivalente
	 */
	public void ajouteEchelle(double mesure, String cible) {
		/*FenetreCalibrageReglet fcr = */new FenetreCalibrageReglet(this, mesure, cible);
	}
	
	/**
	 * enregistre l'echelle dans le fichier de la carte/image en cours d'edition
	 * @param cible
	 * @param unit
	 * @param dist
	 * @param mesure
	 */
	public void enregEchelle(String cible, String unit, double dist, double mesure) {
		if (cible.equals("carte")) traceurCarteEdition.ajouterElt("unite",unit);  
		if (cible.equals("image")) traceurDonneeEdition.ajouterElt("unite",unit);  
		navigation.setUnite(unit);
		double rapport = dist/mesure;
		if (cible.equals("carte")) traceurCarteEdition.ajouteEchelle(rapport); 
		if (cible.equals("image")) traceurDonneeEdition.ajouteEchelle(rapport); 
		navigation.setEchelle(rapport);
		if (fpec != null) {
			fpec.setExtendedState(JFrame.NORMAL);
			fpec.setMesureEffectuee(true);
		} else {
			if (fpei != null) {
				fpei.setExtendedState(JFrame.NORMAL);
				fpei.setMesureEffectuee(true);
			}
		}
		carteModifie = true;
		docsModifi = true;
	}
	
	/**
	 * ajoute l'acces a une vue ds l'histo (ecran+ xml de session)
	 * @param fich
	 */
	public void ajouteVue(String fich) {
		if (!modeEdition) { //ds le mode edition : pas de session ni d'historique
			Date date = new Date();
			String[] dateTab = traduireDate(date).split(" "); 
			String[] heureTab = dateTab[3].split(":"); 
			historique.ajouterVue(fich);//+" (le "+dateTab[2]+"/"+dateTab[1]+"/"+dateTab[5]+"  "+heureTab[0]+":"+heureTab[1]+":"+heureTab[2]+")");
			traceurSession.ajouteVue(fich, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
			modifEffectuee(true);
		}
	}
	
	/**
	 * enregistre l'annotation effectuee sur un elt de l'histo ds le fichier de session 
	 */
	public void annoter(String elt, String pere, String texte) {
		traceurSession.ajouterAnnotation(elt, pere, texte);
		sauv = false;
		majAffichage();
	}
	
	/**
	 * affiche une fenetre "A propos"
	 *
	 */
	private void aPropos() {
		rapportTrace("menu", "a propos");  
	//	JOptionPane.showMessageDialog(new JFrame(),"Gonote (version "+version+")\nInstitut National de Recherche Pedagogique\nAuteur : Olivier LEFEVRE","A PROPOS",JOptionPane.INFORMATION_MESSAGE);
		String ok[] = {"OK"}; 
		ImageIcon icon = new ImageIcon(espaceSysteme+"logo.jpg"); 
		String texte = "Gonote (version "+Constantes.VERSION+")\nInstitut National de Recherche Pdagogique\nScnario : Eric Sanchez\nRalisation : Olivier Lefevre\nRemerciements  : P. Federici, Y. Fesselier, A. Mille, M. Prieur";  
		JOptionPane.showOptionDialog(this, texte,"A PROPOS", JOptionPane.OK_OPTION, JOptionPane.INFORMATION_MESSAGE, icon, ok, ok[0]); 
	}
	
	/**
	 * demande de mot de passe
	 * @return
	 */
	private boolean authentification() {
		JPasswordField mdp = new JPasswordField (10);
		Object[] o={mdp,"Valider","Annuler"};   
		int retour = JOptionPane.showOptionDialog(null, "Saisissez le mot de passe.", "Contrle d'accs", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.WARNING_MESSAGE, null, o, null);   
//		System.out.println("res : "+retour);
		if (retour == 1) {
			char[] mot = mdp.getPassword();
			if (motDePasseCorrect(mot)) {
				BarreEtat.afficheGauche("MOT DE PASSE CORRECT !"); 
//				JOptionPane.showMessageDialog(new JFrame(),"Mot de passe correct !","Information",JOptionPane.INFORMATION_MESSAGE);
			} else {
				BarreEtat.afficheGauche("MOT DE PASSE INCORRECT !", Color.red); 
//				JOptionPane.showMessageDialog(new JFrame(),"Mot de passe incorrect !","Information",JOptionPane.WARNING_MESSAGE);
			}
			return motDePasseCorrect(mot);
		} else {
			return false;
		}
	}
	
	/**
	 * Charge un docs dans la zone Docs
	 */
	private void chargerDocs() {
		rapportTrace("menu", "ouverture document");  
		JFileChooser chooser = new JFileChooser(espaceDocs);
		chooser.setDialogTitle("Ouverture d'une documentation (donne non-gorfrence)");//Charger une carte"); 
		FiltreExtensible filtre = new FiltreExtensible("Docs"); 
		filtre.addExtension(".jpg"); 
		filtre.addExtension(".gif"); 
		filtre.addExtension(".rtf"); 
		chooser.addChoosableFileFilter(filtre);
		chooser.setAccessory(new ImagePreview(chooser)); //pour apercu de l'image
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		int returnVal = chooser.showOpenDialog(chooser.getParent());
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			String fich = chooser.getSelectedFile().getName();
			String extension = fich.substring(fich.lastIndexOf(".")); 
			if (extensionsDocs.contains(extension)) {
				String fichXml = chooser.getSelectedFile().getPath().replace(extension,".xml"); 
				Traceur tr = new Traceur();
				boolean result = tr.charger(fichXml);
				if (result) {
				    BarreEtat.resetGauche();
					String type = tr.exporteType();
					if (type.equals("image")) { 
						boolean regActif = tr.exporteInfo("reglet").equals("actif");  
						boolean zoomActif = tr.exporteInfo("zoom").equals("actif");  
						String unit = ""; 
						double ech = 1;
						if (regActif) {
							unit = tr.exporteInfo("unite"); 
							ech = Double.parseDouble(tr.exporteInfo("echelle")); 
						}
						String comment = tr.exporteInfo("commentaire"); 
						documentations.chargerImage(chooser.getSelectedFile().getPath(), ech, unit, regActif, zoomActif, modeEdition, comment);
						//jScrollCours.revalidate();
						Date date = new Date();
						String[] dateTab = traduireDate(date).split(" "); 
						String[] heureTab = dateTab[3].split(":"); 
						historique.ajouterDocs(fich);//+" (le "+dateTab[2]+"/"+dateTab[1]+"/"+dateTab[5]+"  "+heureTab[0]+":"+heureTab[1]+":"+heureTab[2]+")");
						traceurSession.ajouteDonneeDocs(fich,dateTab[2],dateTab[1],dateTab[5],heureTab[0],heureTab[1],heureTab[2]);
						documentationsCB.setSelected(true);
						modifEffectuee(true);
					} else {
						if (type.equals("texte")) { 
						    String comment = tr.exporteInfo("commentaire"); 
							documentations.chargerTexte(chooser.getSelectedFile().getPath(), comment);
							Date date = new Date();
							String[] dateTab = traduireDate(date).split(" "); 
							String[] heureTab = dateTab[3].split(":"); 
							historique.ajouterDocs(fich);//+" (le "+dateTab[2]+"/"+dateTab[1]+"/"+dateTab[5]+"  "+heureTab[0]+":"+heureTab[1]+":"+heureTab[2]+")");
							traceurSession.ajouteDonneeDocs(fich,dateTab[2],dateTab[1],dateTab[5],heureTab[0],heureTab[1],heureTab[2]);
							documentationsCB.setSelected(true);
							modifEffectuee(true);
						} else {
//							JOptionPane.showMessageDialog(new JFrame(), "La donne que vous avez voulu charger n'est pas une image !", "ERREUR !", JOptionPane.WARNING_MESSAGE, null);
							BarreEtat.afficheGauche(Constantes.MSG_ERREUR_4, Color.red); 
						}
					}
				} else {
//					JOptionPane.showMessageDialog(new JFrame(), "Impossible d'ouvrir cette donne !", "ERREUR !", JOptionPane.WARNING_MESSAGE, null);
					BarreEtat.afficheGauche(Constantes.MSG_ERREUR_5, Color.red); 
				}
			} else {
//				JOptionPane.showMessageDialog(new JFrame(), "Le type de fichier que vous voulez charger n'est pas support !", "ERREUR !", JOptionPane.WARNING_MESSAGE, null);
				BarreEtat.afficheGauche(Constantes.MSG_ERREUR_6, Color.red); 
			}
		} else {
			rapportTrace("menu", "ouverture document", "annulation");   
		}
		chooser = null;
		majAffichage();
	}
	
	/**
	 * Charge une session choisie par l'utilisateur
	 */
	private void chargerSession() {
		confirmation();
		JFileChooser chooser = new JFileChooser(espaceSessions);
		chooser.setDialogTitle("Chargement d'une session"); 
		FiltreExtensible filtre = new FiltreExtensible("Sessions"); 
		filtre.addExtension(".xml"); 
		chooser.addChoosableFileFilter(filtre);
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		int returnVal = chooser.showOpenDialog(chooser.getParent());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			String path = chooser.getSelectedFile().getPath();
			rapportTrace("menu", "chargement session", path);  
			traceurSession = new TraceurSession();
			boolean result = traceurSession.charger(path);
			if (result) {
				String nomFichierRTF = chooser.getSelectedFile().getName().replace(".xml",".rtf");  
				carnet.charger(espaceCarnet+nomFichierRTF);
				TraceurCarte traceurCarte = new TraceurCarte();
				String cheminCarte = espaceCartes+traceurSession.exporteCarte();
				String extension = cheminCarte.substring(cheminCarte.lastIndexOf(".")); 
				boolean res = traceurCarte.charger(cheminCarte.replace(extension,".xml")); 
				if (res) {
					documentations.desactiver(); //pour desactiver le docs qui est obsolete
					historique.creerArbre(traceurSession.exporteInfo("nom")); 
					historique.ajouterDateSession(traceurSession.exporteInfo("jour"),traceurSession.exporteInfo("mois"),traceurSession.exporteInfo("annee"),traceurSession.exporteInfo("heures"),traceurSession.exporteInfo("minutes"),traceurSession.exporteInfo("secondes"));      
					historique.ajouterVue(traceurSession.exporteCarte());//exporteCarteDate());
					historique.chargeArrets(traceurSession.exporteArretsHisto());
					historique.ajouterDocs(traceurSession.exporteDocsHisto());
					ArrayList liste = traceurSession.exporteAnnotations();
					for(int i=0 ; i<liste.size() ; i++) {
						ArrayList caps = (ArrayList) liste.get(i);
						String chemin = caps.get(0).toString();
						String annotation = caps.get(1).toString();
						String pere = caps.get(2).toString();
						historique.ajouteAnnotation(pere, chemin, annotation);
					}
					boolean regActif = traceurCarte.exporteInfo("reglet").equals("actif");  
					boolean zoomActif = traceurCarte.exporteInfo("zoom").equals("actif");  
					String unit = ""; 
					double ech = 1;
					if (regActif) {
						unit = traceurCarte.exporteInfo("unite"); 
						ech = Double.parseDouble(traceurCarte.exporteInfo("echelle")); 
					}
					String couleur = traceurCarte.exporteInfo("couleurArrets"); 
					String comment = traceurCarte.exporteInfo("commentaire"); 
					navigation.chargerCarte(cheminCarte, ech, unit, regActif, zoomActif, modeEdition, traceurCarte.construitArrets(), Integer.parseInt(traceurCarte.exporteInfo("latitude")), Integer.parseInt(traceurCarte.exporteInfo("longitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLatitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLongitude")), traceurCarte.exporteVues(), couleur, comment);    
					activation(true);
					//modifEffectuee(true);
					majAffichage();
					traceurTraces.ajouterTraces("menu","chargerSession");  
					userName = traceurSession.exporteInfo("nom"); 
					BarreEtat.afficheGauche("BIENVENUE "+userName+" !", new Color(0,0,192));  
				}  else {
//					JOptionPane.showMessageDialog(new JFrame(), "Lors du chargement de la carte !", "ERREUR !", JOptionPane.WARNING_MESSAGE, null);
					BarreEtat.afficheGauche(Constantes.MSG_ERREUR_7, Color.red); 
				}
			} else {
//				JOptionPane.showMessageDialog(new JFrame(), "Impossible d'ouvrir cette donne !", "ERREUR !", JOptionPane.WARNING_MESSAGE, null);
				BarreEtat.afficheGauche(Constantes.MSG_ERREUR_8, Color.red); 
			}
		} else {
			rapportTrace("menu", "chargement session", "annulation");   
		}
	}
	
	/**
	 * permet de proposer l'enregistrement avant de changer de contexte
	 */
	private void confirmation() {
		if (!sauv){ 
			int saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre session?", "Confirmation", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null);  
			while (!(saveOrNot == JOptionPane.YES_OPTION || saveOrNot == JOptionPane.NO_OPTION)) {
				saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre session?", "Confirmation", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null);  
			}
			if(saveOrNot == JOptionPane.YES_OPTION) {
				enregistrerSession();
			}
		} else {
			if (enregEditPossible) {
				if (carteModifie){ 
					int saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre carte ?", "Confirmation", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null);  
					while (!(saveOrNot == JOptionPane.YES_OPTION || saveOrNot == JOptionPane.NO_OPTION)) {
						saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre carte ?", "Confirmation", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null);  
					}
					if(saveOrNot == JOptionPane.YES_OPTION) {
						enregistrerEditionCarte();
					}
				} else {
					if (docsModifi){ 
						int saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre donne ?", "Confirmation", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null);  
						while (!(saveOrNot == JOptionPane.YES_OPTION || saveOrNot == JOptionPane.NO_OPTION)) {
							saveOrNot = JOptionPane.showConfirmDialog(new JFrame(), "Voulez-vous sauvegarder votre donne ?", "Confirmation", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null);  
						}
						if(saveOrNot == JOptionPane.YES_OPTION) {
							enregistrerEditionDonnee();
						}
					}
				}
			}
		}
	}
	
	/**
	 * copie de fichiers, permettant l'importation lors de l'edition
	 * @param source
	 * @param destination
	 * @return
	 */
	private boolean copier( File source, File destination ) {
		boolean resultat = false;
		// Declaration des flux
		java.io.FileInputStream sourceFile=null;
		java.io.FileOutputStream destinationFile=null;
		
		try {
			// Cration du fichier :
			destination.createNewFile();
			// Ouverture des flux
			sourceFile = new java.io.FileInputStream(source);
			destinationFile = new java.io.FileOutputStream(destination);
			// Lecture par segment de 0.5Mo 
			byte buffer[]=new byte[512*1024];
			int nbLecture;
			while( (nbLecture = sourceFile.read(buffer)) != -1 ) {
				destinationFile.write(buffer, 0, nbLecture);
			} 
			// Copie russie
			resultat = true;
		} catch( java.io.FileNotFoundException f ) {
		} catch( java.io.IOException e ) {
		} finally {
			// Quoi qu'il arrive, on ferme les flux
			try {
				sourceFile.close();
			} catch(Exception e) { }
			try {
				destinationFile.close();
			} catch(Exception e) { }
		} 
		return( resultat );
	}
	
	/**
	 * Precise a l'utilisateur l'etat incomplet du prog
	 *
	 */
	public void enConstruction() {
		BarreEtat.reset();
		String[] tab = new String[100];
		tab[0] = "Section en cours de developpement."; 
		tab[1] = "Same player shoot again ! 8|"; 
		tab[2] = "Ca va pas tre possible l ... j'ai piscine :)"; 
		tab[3] = "Nan, j'veux p ! :("; 
		for (int j=4; j<100; j++) tab[j] = tab[0];
		int i = (int) (Math.random()*100);
//		JOptionPane.showMessageDialog(new JFrame(),tab[i],"ATTENTION !",JOptionPane.WARNING_MESSAGE);
		BarreEtat.afficheGauche("/!\\ "+tab[i], Color.red); 
	}
	
	/**
	 * appel la bonne methode d'enregistrement suivant la donnee en cours d'edititon
	 *
	 */
	private void enregistrerEdition() {
		if (carteModifie) {
			rapportTrace("menu", "enregistrer edition", "carte");   
			enregistrerEditionCarte();
		} else {
			if (docsModifi) {
				if (texteEnEdition) {
					rapportTrace("menu", "enregistrer edition", "texte");   
					enregistrerEditionTexte();
				} else {	//image
					rapportTrace("menu", "enregistrer edition", "donnee");   
					enregistrerEditionDonnee();
				}
			}
		}
	}
	
	/**
	 * enregistre le xml et le fichier texte
	 */
	private void enregistrerEditionTexte() {
		boolean res1 =  traceurDonneeEdition.enregistrer();
		boolean res2 = carnet.enregistrer();
		if (res1 && res2) {
			docsModifi = false;
			if (sortie) JOptionPane.showMessageDialog(new JFrame(),"Le texte a t enregistre avec succs !","Information",JOptionPane.INFORMATION_MESSAGE);  
			else BarreEtat.afficheGauche("INFORMATION : Le texte a t enregistre avec succs !", Color.BLUE); 
//			enregEditPossible = true;
			majAffichage();
		} else {
			if (sortie) JOptionPane.showMessageDialog(new JFrame(),"Echec lors de l'enregistrement !","Erreur",JOptionPane.WARNING_MESSAGE);  
			else BarreEtat.afficheGauche("ERREUR : Echec lors de l'enregistrement !", Color.red); 
		}
	}
	
	/**
	 * enregistre le fichier xml nouvellement cree
	 */
	public void enregistrerEditionCarte() {
		boolean res = traceurCarteEdition.enregistrer();
		if (res) {
			carteModifie = false;
			if (sortie) JOptionPane.showMessageDialog(new JFrame(),"La carte a t enregistre avec succs !","Information",JOptionPane.INFORMATION_MESSAGE);  
			else BarreEtat.afficheGauche("INFORMATION : La carte a t enregistre avec succs !", Color.BLUE); 
//			enregEditPossible = true;
			majAffichage();
		} else {
			if (sortie) JOptionPane.showMessageDialog(new JFrame(),"Echec lors de l'enregistrement !","Erreur",JOptionPane.WARNING_MESSAGE);  
			else BarreEtat.afficheGauche("ERREUR : Echec lors de l'enregistrement !", Color.red); 
		}
	}
	
	/**
	 * enregistre le fichier xml nouvellement cree
	 *
	 */
	public void enregistrerEditionDonnee() {
		boolean res = traceurDonneeEdition.enregistrer();
		if (res) {
			docsModifi = false;
			if (sortie) JOptionPane.showMessageDialog(new JFrame(),"La donne a t enregistre avec succs !","Information",JOptionPane.INFORMATION_MESSAGE);  
			else BarreEtat.afficheGauche("INFORMATION : La donne a t enregistre avec succs !", Color.BLUE); 
//			enregEditPossible = true;
			majAffichage();
		} else {
			if (sortie) JOptionPane.showMessageDialog(new JFrame(),"Echec lors de l'enregistrement !","Erreur",JOptionPane.WARNING_MESSAGE);  
			else BarreEtat.afficheGauche("ERREUR : Echec lors de l'enregistrement !", Color.red); 
		}
	}
	
	/**
	 * Enregistre la session dans le repertoire de stockage des sessions
	 */
	private void enregistrerSession() {
		rapportTrace("menu", "enregistrer session");  
		boolean res1 = carnet.enregistrer();
		//System.out.println(carnet.exporteTexte());
		boolean res2 = traceurSession.enregistrer();
//		traceurTraces.ajouterTraces("menu","enregistrer");
		if (res2) {
		    if (res1) {
			sauv=true;
			if (sortie) JOptionPane.showMessageDialog(new JFrame(),"La session a t enregistre avec succs !","Information",JOptionPane.INFORMATION_MESSAGE);  
			else BarreEtat.afficheGauche("INFORMATION : La session a t enregistre avec succs !", Color.BLUE); 
		    } else {
		        if (sortie) JOptionPane.showMessageDialog(new JFrame(),"Echec lors de l'enregistrement du carnet !","Erreur",JOptionPane.WARNING_MESSAGE);  
				else BarreEtat.afficheGauche("ERREUR : Echec lors de l'enregistrement du carnet !", Color.red); 
		    }
		} else {
			if (sortie) JOptionPane.showMessageDialog(new JFrame(),"Echec lors de l'enregistrement de la session !","Erreur",JOptionPane.WARNING_MESSAGE);  
			else BarreEtat.afficheGauche("ERREUR : Echec lors de l'enregistrement de la session !", Color.red); 
		}
		majAffichage();
	}
	
	/**
	 * getters
	 * @return
	 */
	public boolean getAAA() {
		return arretsCB.isSelected();//affichageArretsActif;
	}
	
	public boolean getACA() {
		return coordCB.isSelected();//affichageCoordActif;
	}
	
	/**
	 * copie la donnee affichee ds la zone de donnee ds le carnet
	 *
	 */
	public void insertDepuis(String provenance) {

		ImageIcon im = null;
		ImageIcon carte = null;
		JTextPane texte = null;
		if (provenance.equals("docs")) { 
			im = documentations.exporteImage();
			carte = documentations.exporteCarte();
			texte = documentations.exporteTexte();
		} else {
			if (provenance.equals("navigation")) { 
				im = navigation.exporteImage();
				carte = navigation.exporteCarte();
				texte = navigation.exporteTexte();
			}
		}
		if (im!=null) {
			//carnet.copierImage(im);		//TODO a modifier : taille de l'image
			JOptionPane.showMessageDialog(new JFrame(),"Ne fonctionne pas encore avec les images.","ATTENTION !",JOptionPane.WARNING_MESSAGE);  
		} else {
			if (carte!=null) {
				//carnet.copierImage(carte);		//TODO a modifier : taille de l'image
				JOptionPane.showMessageDialog(new JFrame(),"Ne fonctionne pas encore avec les cartes.","ATTENTION !",JOptionPane.WARNING_MESSAGE);  
			} else {
				if (texte!=null) {
					texte.selectAll();
					texte.copy();
					carnet.coller();
				}
			}
		}
		modifEffectuee(true);
	}
	
	/**
	 * getters
	 */
	public boolean isModeSuppArret() {
		return modeSuppArret;
	}
	public boolean isModeSuppLien() {
		return modeSuppLien;
	}
	public boolean isModeSuppVue() {
		return modeSuppVue;
	}
	
	/**
	 * lance l'aide : un fichier .bat qui lance une page html
	 *
	 */
	private void lancementAide() {
		rapportTrace("menu", "aide");  
		try {
			//Process proc = Runtime.getRuntime().exec("net send rech054 "+espaceDeTravail);
			/*Process proc = */Runtime.getRuntime().exec(espaceAide+"aide.bat"); 
		} catch (IOException e) {
			System.out.println("Erreur lancement"); 
			e.printStackTrace();
		}
	}
	
	/**
	 * lance l'execution de l'application "Calendrier"
	 */
	private void lancementCalendrier() {
		rapportTrace("menu", "calendrier");  
//		try {
//			Process proc = Runtime.getRuntime().exec(espaceCalendrier+"putty.exe");
//		} catch (IOException e) {
//			System.out.println("Erreur lancement");
//			e.printStackTrace();
//		}
		enConstruction();
	}
	
	/**
	 * lance le lexique : page html
	 *
	 */
	private void lancementLexique() {
		rapportTrace("menu", "lexique");  
		try {
			//Process proc = Runtime.getRuntime().exec("net send rech054 "+espaceDeTravail);
			/*Process proc = */Runtime.getRuntime().exec(espaceLexique+"lexique.bat"); 
		} catch (IOException e) {
			System.out.println("Erreur lancement"); 
			e.printStackTrace();
		}
		enConstruction();
	}
	
	/**
	 * permet au carnet de se masquer lui meme
	 *
	 */
	public void masquerCarnet() {
		carnetCB.setSelected(false);
		majAffichage();
	}
	
	/**
	 * Rafraichissement de l'affichage en fonction des zones  afficher (dans menu affichage)
	 */
	private void majAffichage() {
		if (modeEdition) {
			documentations.desactiver();
		}
		boolean tempDocs = documentations.isVisible();
		boolean tempVisu = navigation.isVisible();
		boolean tempHisto = historique.isVisible();
		boolean tempCarnet = carnet.isVisible();
		historique.setVisible(historiqueCB.isSelected() && !modeEdition);//si histo selectionn ou pas
		navigation.setVisible(navigationCB.isSelected());// si navigation selectionn ou pas
		documentations.setVisible(documentations.rapportActivit() && documentationsCB.isSelected() && !modeEdition);//si docs selectionn et actif
		carnet.setVisible(carnetCB.isSelected() && !modeEdition);// si editeur selectionn ou pas
		// pour empecher de masquer ttes les zones !
		if (!documentations.isVisible() && !historique.isVisible() && ! navigation.isVisible() && !carnet.isVisible()) {
			documentations.setVisible(tempDocs);
			documentationsCB.setSelected(tempDocs);
			historique.setVisible(tempHisto);
			historiqueCB.setSelected(tempHisto);
			carnet.setVisible(tempCarnet);
			carnetCB.setSelected(tempCarnet);
			navigation.setVisible(tempVisu);
			navigationCB.setSelected(tempVisu);
		}
		if (!tempDocs && documentations.isVisible()) splitPane2.setDividerLocation((getWidth()*3)/8);
		splitPane2.setVisible( navigation.isVisible() || documentations.isVisible() );//si navi ou docs visibles
		splitPane1.setVisible( historique.isVisible() || splitPane2.isVisible() );
//		if (navigation.isVisible()) {
//			affichageArretsActif = arretsCB.isSelected();
//			affichageCoordActif = coordCB.isSelected();
//		}
		arretsCB.setEnabled(navigation.isVisible() && navigation.exporteTypeActif().equals("carte")); 
		arretSB.setEnabled(!modeEdition && navigation.isVisible() && navigation.exporteTypeActif().equals("carte")); 
		if (!arretsCB.isEnabled()) arretsCB.setSelected(false); //force la decoche si pas dispo
		coordCB.setEnabled(navigation.isVisible() && navigation.exporteTypeActif().equals("carte")); 
		coordSB.setEnabled(!modeEdition && navigation.isVisible() && navigation.exporteTypeActif().equals("carte")); 
		if (!coordCB.isEnabled()) coordCB.setSelected(false); //force la decoche si pas dispo
		
		nouvSessionM.setEnabled(!modeEdition);
		chargSessionM.setEnabled(!modeEdition);
		enregM.setEnabled(!sauv && !modeEdition && fenetreActive);
		documentationsCB.setEnabled(documentations.rapportActivit());
		if (!documentations.rapportActivit()) {
			documentationsCB.setSelected(false); //force la decoche du menu si le docs non dispo
		}
		affichageM.setEnabled(!modeEdition && fenetreActive);
		quatreSB.setEnabled(!modeEdition && fenetreActive);
		documentationsM.setEnabled(!modeEdition && fenetreActive);
		docSB.setEnabled(!modeEdition && fenetreActive);
		rechercheM.setEnabled(fenetreActive && !modeEdition);
		rechercheSB.setEnabled(fenetreActive && !modeEdition);
		precSB.setEnabled(!modeEdition && !navigation.premier() && navigationCB.isSelected());
		suivSB.setEnabled(!modeEdition && !navigation.dernier() && navigationCB.isSelected());
		
		edActiverM.setEnabled(!modeEdition);
		edDesactiverM.setEnabled(modeEdition);
		nouvM.setEnabled(modeEdition);
		nouvVueM.setEnabled(carteEnEdition);
		modifM.setEnabled(modeEdition);
		suppM.setEnabled(modeEdition);
		parametresEditM.setEnabled(modeEdition && (carteEnEdition || texteEnEdition || imageEnEdition));
		suppArretM.setEnabled(carteEnEdition);
		suppLienM.setEnabled(carteEnEdition);
		suppVueM.setEnabled(carteEnEdition);
		enregEditM.setEnabled(enregEditPossible && (carteModifie || docsModifi && modeEdition));	//des la premiere modif, la creation des vues est accessible
		if (modeEdition) {
			this.setTitle(" Gonote "+Constantes.VERSION+"  ~  MODE EDITION  /!\\");  
			if (texteEnEdition) {
				carnet.setVisible(true);
				splitPane1.setVisible(false);
			} else {
				coordCB.setSelected(true);//affichageCoordActif = true;
				String typeActif = navigation.exporteTypeActif();
				if (typeActif.equals("carte")) { 
					arretsCB.setSelected(true);//affichageArretsActif = true;
				} else {
				    arretsCB.setSelected(false);//affichageArretsActif = false;
				}
			}
		} else {
			this.setTitle(" Gonote "+Constantes.VERSION); 
		}
		repaintSplit();
		validate();
		repaint();
	}
	
	/**
	 * modifie l'annotation d'un elt ds le fichier de session
	 * @param elt
	 * @param texte
	 */
	public void modifAnnotation(String elt, String texte) {
		traceurSession.modifierAnnotation(elt, texte);
		sauv = false;
		majAffichage();
	}
	
	/**
	 * passage en mode de def des coord d'une carte en edition
	 *
	 */
	public void activerModeDefCoord() {
		navigation.activerModeDefCoord();
		BarreEtat.afficheGauche("DEFINITION DES COORDONNEES GEOGRAPHIQUES (CLIC GAUCHE pour dfinir un point, ECHAP pour annuler)"); 
	}
	
	/**
	 * permet a la fenetre de parametrage de modifier le tracage
	 * @param b
	 */
	public void activerTraces(boolean b) {
		tracesActives = b;
	}
	
	/**
	 * supprime l'annotation d'une elt ds le fichier de session
	 * @param elt
	 */
	public void suppAnnotation(String elt) {
		traceurSession.supprimerAnnotation(elt);
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		sauv = false;
		majAffichage();
	}
	
	/**
	 * charge une carte pour la modifier
	 *
	 */
	private void modifCarte() {
		JFileChooser chooser = new JFileChooser(espaceCartes);
		chooser.setDialogTitle("Choix de la carte  modifier"); 
		FiltreExtensible filtre = new FiltreExtensible("Images"); 
		filtre.addExtension(".jpg"); 
		filtre.addExtension(".gif"); 
		chooser.addChoosableFileFilter(filtre);
		chooser.setAccessory(new ImagePreview(chooser)); //pour apercu de l'image
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		int returnVal = chooser.showOpenDialog(chooser.getParent());
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			String fich = chooser.getSelectedFile().getPath();
			rapportTrace("menu", "modification (edition)", "carte", fich);   
			String ext = fich.substring(fich.lastIndexOf(".")); 
			String fichXML = fich.replace(ext,".xml"); 
			traceurCarteEdition = new TraceurCarte();
			boolean res = traceurCarteEdition.charger(fichXML);
			if (!res) {
//				JOptionPane.showMessageDialog(new JFrame(), "La carte que vous avez voulu ouvrir ne possde pas de mtadonnes !", "ERREUR !", JOptionPane.WARNING_MESSAGE);
				BarreEtat.afficheGauche("ERREUR : La carte que vous avez voulu ouvrir ne possde pas de mtadonnes !", Color.red); 
			} else {
				enregEditPossible = true;
				boolean regActif = traceurCarteEdition.exporteInfo("reglet").equals("actif");  
				boolean zoomActif = traceurCarteEdition.exporteInfo("zoom").equals("actif");  
//				String nivo = traceurCarteEdition.exporteInfo("niveau");
				String typeVue = traceurCarteEdition.exporteTypeVuePrincipale();
				String couleur = traceurCarteEdition.exporteInfo("couleurArrets"); 
				String unit = ""; 
				double ech = 1;
				if (regActif) {
					unit = traceurCarteEdition.exporteInfo("unite"); 
					ech = Double.parseDouble(traceurCarteEdition.exporteInfo("echelle")); 
				}
				String comment = traceurCarteEdition.exporteInfo("commentaire"); 
				navigation.chargerCarte(fich, ech, unit, regActif, zoomActif, modeEdition, traceurCarteEdition.construitArrets() , Integer.parseInt(traceurCarteEdition.exporteInfo("latitude")), Integer.parseInt(traceurCarteEdition.exporteInfo("longitude")), Double.parseDouble(traceurCarteEdition.exporteInfo("echelleLatitude")), Double.parseDouble(traceurCarteEdition.exporteInfo("echelleLongitude")), traceurCarteEdition.exporteVues(), couleur, comment);    
				fpec = new FenetreParametresEditionCarte(this, chooser.getSelectedFile().getName());
				fpec.chargerParam(typeVue, regActif, zoomActif, /*nivo, motscles,*/ couleur);
				fpei = null;
				fpet = null;
				carteModifie = true;
				carteEnEdition = true;
				texteEnEdition = false;
				imageEnEdition = false;
				docsModifi = false;
				majAffichage();
			}
		}
	}
	
	/**
	 * charge un donnee pour la modifier
	 *
	 */
	private void modifDonnee() {
		JFileChooser chooser = new JFileChooser(espaceDonnees);
		chooser.setDialogTitle("Choix de la donne  modifier"); 
		FiltreExtensible filtre = new FiltreExtensible("Donnees"); 
		filtre.addExtension(".jpg"); 
		filtre.addExtension(".gif"); 
		filtre.addExtension(".rtf"); 
		chooser.addChoosableFileFilter(filtre);
		chooser.setAccessory(new ImagePreview(chooser)); //pour apercu de l'image
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		int returnVal = chooser.showOpenDialog(chooser.getParent());
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			String fich = chooser.getSelectedFile().getPath();
			rapportTrace("menu", "modification (edition)", "donnee", fich);   
			String ext = fich.substring(fich.lastIndexOf(".")); 
			String fichXML = fich.replace(ext,".xml"); 
			traceurDonneeEdition = new TraceurDonnee();
			boolean res = traceurDonneeEdition.charger(fichXML);
			if (!res) {
//				JOptionPane.showMessageDialog(new JFrame(), "La donne que vous avez voulu ouvrir ne possde pas de mtadonnes !", "ERREUR !", JOptionPane.WARNING_MESSAGE);
				BarreEtat.afficheGauche("ERREUR : La donne que vous avez voulu ouvrir ne possde pas de mtadonnes !", Color.red); 
			} else {
				enregEditPossible = true;
				String type = traceurDonneeEdition.exporteType();
				if (type.equals("texte")) { 
					String nivo = traceurDonneeEdition.exporteInfo("niveau"); 
					String motscles = traceurDonneeEdition.exporteInfo("motscles"); 
					String commentaire = traceurDonneeEdition.exporteInfo("commentaire"); 
					String typGeol = traceurDonneeEdition.exporteInfo("typeGeologique"); 
					navigation.chargerTexte(fich, commentaire);
					fpet = new FenetreParametresEditionTexte(this);
					fpet.chargerParam(typGeol, nivo, commentaire, motscles);
					fpei = null;
					fpec = null;
					texteEnEdition = true;
					imageEnEdition = false;
				} else {
					if (type.equals("image")) { 
						boolean regActif = traceurDonneeEdition.exporteInfo("reglet").equals("actif");  
						boolean zoomActif = traceurDonneeEdition.exporteInfo("zoom").equals("actif");  
						String nivo = traceurDonneeEdition.exporteInfo("niveau"); 
						String motscles = traceurDonneeEdition.exporteInfo("motscles"); 
						String commentaire = traceurDonneeEdition.exporteInfo("commentaire"); 
						String typGeol = traceurDonneeEdition.exporteInfo("typeGeologique"); 
						navigation.chargerImage(fich, 1, "", regActif, zoomActif, modeEdition, commentaire); 
						fpei = new FenetreParametresEditionImage(this);
						fpei.chargerParam(typGeol, regActif, zoomActif, nivo, commentaire, motscles);
						fpec = null;
						fpet = null;
						texteEnEdition = false;
						imageEnEdition = true;
					}
				}
				docsModifi = true;
				carteEnEdition = false;
				carteModifie = false;
				majAffichage();
			}
		}
	}
	
	/**
	 * enregistre s'il y a eu une modif ds la session et rafraichit si besoin
	 * @param b
	 */
	private void modifEffectuee(boolean b) {
		boolean temp = sauv;
		sauv = !b;
		if (temp!=sauv) majAffichage(); //verif du chgt de statut --> evite de rafraichir  chaque fois !
	}
	
	/**
	 * repercute une modification d'un texte (en edition ou non) pour autoriser l'enregistrement
	 * @param b
	 */
	public void modifTexteEffectuee(boolean b) {
		if (texteEnEdition) {
			boolean temp = docsModifi;
			docsModifi = b;
			if (temp!=docsModifi) majAffichage();
		} else {
			boolean temp = sauv;
			sauv = !b;
			if (temp!=sauv) majAffichage();
		}
	}
	
	/**
	 * compare la saisie utilisateur au mot de passe
	 * @param saisie
	 * @return
	 */
	private boolean motDePasseCorrect(char[] saisie) {
		String mot = pswd;
		char[] mdp = new char[mot.length()];
		mdp = mot.toCharArray();
		boolean retour = true;
		int i = 0;
		while (i<mdp.length && i<saisie.length && retour) {
			retour = (saisie[i] == mdp[i]);
			i++;
		}
		if (saisie.length == 0) retour = false;
		return retour;
	}
	
//	private boolean motDePasseParamCorrect(char[] saisie) {
//		String mot = "titi";
//		char[] mdp = new char[mot.length()];
//		mdp = mot.toCharArray();
//		boolean retour = true;
//		int i = 0;
//		while (i<mdp.length && i<saisie.length && retour) {
//			retour = (saisie[i] == mdp[i]);
//			i++;
//		}
//		return retour;
//	}
	
	/**
	 * ouvre une image (une carte normalement) en mode Edition
	 */
	private void nouvCarte() {
	    confirmation();
		JFileChooser chooser = new JFileChooser("."); 
		chooser.setDialogTitle("Choix de la carte principale  editer"); 
		FiltreExtensible filtre = new FiltreExtensible("Images"); 
		filtre.addExtension(".jpg"); 
		filtre.addExtension(".gif"); 
		chooser.addChoosableFileFilter(filtre);
		chooser.setAccessory(new ImagePreview(chooser)); //pour apercu de l'image
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		int returnVal = chooser.showOpenDialog(chooser.getParent());
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			enregEditPossible = false;
			String fich = chooser.getSelectedFile().getPath();
			rapportTrace("menu", "creation (edition)", "carte", fich);   
			String fichDest = espaceCartes+chooser.getSelectedFile().getName(); //fichier destination de la copie
			//comparaison pour eviter le deplacement si deja au bon endroit
			if (!fich.contains(fichDest)) {
				copier(chooser.getSelectedFile(), new File(fichDest)); // COPIE si besoin
			}
			//fin deplacement de fichier
			String ext = fichDest.substring(fichDest.lastIndexOf(".")); 
			String fichXML = fichDest.replace(ext,".xml"); 
			traceurCarteEdition = new TraceurCarte(fichXML,"carte"); 
			//chargement minimal :
			navigation.chargerCarte(fichDest, 1, "", true, true, modeEdition, null, 0, 0, 1, 1, new ArrayList(), "255 255 255", "");   
			fpec = new FenetreParametresEditionCarte(this, chooser.getSelectedFile().getName());
			fpei = null;
			fpet = null;
			carteModifie = true;
			carteEnEdition = true;
			texteEnEdition = false;
			imageEnEdition = false;
			docsModifi = false;
			majAffichage();
		}
	}
	
	/**
	 * enregistre tous les parametres recoltes par la fenetres des param de la carte en edition
	 * @param fichier
	 * @param typeVue
	 * @param reglet
	 * @param zoom
	 * @param coulArrets
	 */
	public void enregParamCarteEditee(String fichier, String typeVue, boolean reglet, boolean zoom, String coulArrets/*, String nivo, String motsCls*/) {
		traceurCarteEdition.ajouteVue(typeVue, fichier);
		navigation.rechargeTypBarre(traceurCarteEdition.exporteVues(), espaceCartes);
		if (reglet) {
			traceurCarteEdition.ajouterElt("reglet","actif");  
			navigation.activeReglet(true);
		} else {
			traceurCarteEdition.ajouterElt("reglet","inactif");  
			navigation.activeReglet(false);
		}
		if (zoom) {
			traceurCarteEdition.ajouterElt("zoom","actif");  
		} else {
			traceurCarteEdition.ajouterElt("zoom","inactif");  
		}
		traceurCarteEdition.ajouterElt("couleurArrets",coulArrets); 
		navigation.chargerCouleurArrets(coulArrets);
		carteModifie = true;
		majAffichage();
//		traceurCarteEdition.ajouterElt("niveau",nivo);
//		traceurCarteEdition.ajouterElt("motscles",motsCls);
		
	}
	
	/**
	 * cree une donnee
	 *
	 */
	private void nouvDonnee() {
	    confirmation();
		JFileChooser chooser = new JFileChooser(dossierNouvelleDonnee);
		chooser.setDialogTitle("Choix de la donne  diter"); 
		FiltreExtensible filtre = new FiltreExtensible("Donnees"); 
		filtre.addExtension(".jpg"); 
		filtre.addExtension(".gif"); 
		filtre.addExtension(".rtf"); 
		chooser.addChoosableFileFilter(filtre);
		chooser.setAccessory(new ImagePreview(chooser)); //pour apercu de l'image
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		int returnVal = chooser.showOpenDialog(chooser.getParent());
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			enregEditPossible = false;
			String fich = chooser.getSelectedFile().getPath();
			rapportTrace("menu", "creation (edition)", "donnee", fich);   
			String fichDest = espaceDocs+chooser.getSelectedFile().getName(); //fichier destination de la copie
			//comparaison pour eviter le deplacement si deja au bon endroit
			if (!fich.contains(fichDest)) {
				copier(chooser.getSelectedFile(), new File(fichDest)); // COPIE si besoin
			}
			//fin deplacement
			String ext = fichDest.substring(fichDest.lastIndexOf(".")); 
			String fichXML = fichDest.replace(ext,".xml"); 
			if (ext.equals(".rtf")) { 
				traceurDonneeEdition = new TraceurDonnee(fichXML,"texte"); 
				carnet.charger(fichDest);
				texteEnEdition = true;
				imageEnEdition = false;
				fpet = new FenetreParametresEditionTexte(this);
				fpei = null;
				fpec = null;
			} else {
				traceurDonneeEdition = new TraceurDonnee(fichXML,"image"); 
				navigation.chargerImage(fichDest, 1, "", true, true, modeEdition, "");  
				texteEnEdition = false;
				imageEnEdition = true;
				fpei = new FenetreParametresEditionImage(this);
				fpec = null;
				fpet = null;
			}
			docsModifi = true;
			carteEnEdition = false;
			carteModifie =false;
			majAffichage();
			dossierNouvelleDonnee = fich.substring(0, fich.lastIndexOf("\\"))+"\\";  
		}
	}
	
	/**
	 * enregistre les param du texte en edition
	 * @param typeGeol
	 * @param nivo
	 * @param commentaire
	 * @param motsCls
	 */
	public void enregParamTexteEditee(String typeGeol, String nivo, String commentaire, String motsCls) {
		traceurDonneeEdition.ajouterElt("typeGeologique",typeGeol); 
		traceurDonneeEdition.ajouterElt("niveau",nivo); 
		traceurDonneeEdition.ajouterElt("commentaire",commentaire); 
		traceurDonneeEdition.ajouterElt("motscles",motsCls); 
		traceurDonneeEdition.ajouterElt("etat","accessible"); //etat accessible par defaut pour eviter bug en parametrage  
		docsModifi = true;
		majAffichage();
	}
	
	/**
	 * enregistre les param de l'image en cours d'edition
	 * @param typeGeol
	 * @param reglet
	 * @param zoom
	 * @param nivo
	 * @param commentaire
	 * @param motsCls
	 */
	public void enregParamDonneeEditee(String typeGeol, boolean reglet, boolean zoom, String nivo, String commentaire, String motsCls) {
		traceurDonneeEdition.ajouterElt("typeGeologique",typeGeol); 
		if (reglet) {
			traceurDonneeEdition.ajouterElt("reglet","actif");  
			navigation.activeReglet(true);
		} else {
			traceurDonneeEdition.ajouterElt("reglet","inactif");  
			navigation.activeReglet(false);
		}
		if (zoom) {
			traceurDonneeEdition.ajouterElt("zoom","actif");  
		} else {
			traceurDonneeEdition.ajouterElt("zoom","inactif");  
		}
		traceurDonneeEdition.ajouterElt("niveau",nivo); 
		traceurDonneeEdition.ajouterElt("commentaire",commentaire); 
		traceurDonneeEdition.ajouterElt("motscles",motsCls); 
		traceurDonneeEdition.ajouterElt("etat",""); //etat vide pour eviter bug en parametrage  
		docsModifi = true;
		majAffichage();
	}
	
	/**
	 * Cree un nouvelle session
	 */
	private void nouvelleSession() {
		confirmation();
		userName = JOptionPane.showInputDialog(this,"Nom d'utilisateur :","Nouvelle session", JOptionPane.INFORMATION_MESSAGE);  
		if ((userName != null)&&(!userName.matches(""))&&(!userName.contains(" "))) {  
			rapportTrace("menu", "nouvelle session", "utilisateur : "+userName);   
			JFileChooser chooser = new JFileChooser(espaceCartes);
			chooser.setFileSelectionMode(JFileChooser.FILES_ONLY); 
			chooser.setDialogTitle("Choix de la carte principale de la nouvelle session"); 
			FiltreExtensible filtre = new FiltreExtensible("Cartes"); 
			filtre.addExtension(".jpg"); 
			filtre.addExtension(".gif"); 
			filtre.addExtension(".png"); 
			chooser.addChoosableFileFilter(filtre);
			chooser.setAccessory(new ImagePreview(chooser)); //pour apercu de l'image
			int returnVal = chooser.showOpenDialog(chooser.getParent());
			if(returnVal == JFileChooser.APPROVE_OPTION) {
				documentations.desactiver(); //pour desactiver le docs qui est obsolete
				String fich = chooser.getSelectedFile().getName();
				String extension = fich.substring(chooser.getSelectedFile().getName().lastIndexOf(".")); 
				if (extensionsCartes.contains(extension)) {
					String fichXml = chooser.getSelectedFile().getPath().replace(extension,".xml"); 
					TraceurCarte tr = new TraceurCarte();
					boolean result = tr.charger(fichXml);
					if (result) {
						String type = tr.exporteType();
						if (type.matches("carte")) { 
							boolean regActif = tr.exporteInfo("reglet").matches("actif");  
							boolean zoomActif = tr.exporteInfo("zoom").matches("actif");  
							String unit = ""; 
							String ech = ""; 
							if (regActif) {
								unit = tr.exporteInfo("unite"); 
								ech = tr.exporteInfo("echelle"); 
							}
							String couleur = tr.exporteInfo("couleurArrets"); 
							String commentaire = tr.exporteInfo("commentaire"); 
							navigation.chargerCarte(chooser.getSelectedFile().getPath(), Double.parseDouble(ech), unit, regActif, zoomActif, modeEdition, tr.construitArrets(), Integer.parseInt(tr.exporteInfo("latitude")), Integer.parseInt(tr.exporteInfo("longitude")), Double.parseDouble(tr.exporteInfo("echelleLatitude")), Double.parseDouble(tr.exporteInfo("echelleLongitude")), tr.exporteVues(), couleur, commentaire);    
							//creation du nom du fichier de session
							Date date = new Date();
							String[] dateTab = traduireDate(date).split(" "); 
							String[] heureTab = dateTab[3].split(":"); 
							String heure = dateTab[3].replaceFirst(":","h");  
							heure = heure.replaceFirst(":","m");  
							String nomCarte = fich.replace(extension, ""); 
							nomFichierSession = userName+"_"+dateTab[2]+"-"+dateTab[1]+"-"+dateTab[5]+"_"+heure+"_"+nomCarte+".xml";      
							String nomFichierRTF = nomFichierSession.replace(".xml",".rtf");  
							carnet.creer(espaceCarnet+nomFichierRTF);
							//mise a jour de l'histo
							historique.creerArbre(userName);
							historique.ajouterDateSession(dateTab[2],dateTab[1],dateTab[5],heureTab[0],heureTab[1],heureTab[2]);
							historique.ajouterVue(fich);//+" (le "+dateTab[2]+"/"+dateTab[1]+"/"+dateTab[5]+"  "+heureTab[0]+":"+heureTab[1]+":"+heureTab[2]+")");
							//mise a jour du traceur
							traceurSession = new TraceurSession(espaceSessions+"\\"+nomFichierSession,"session");  
							traceurSession.ajouterElt("nom",userName); 
							traceurSession.ajouteVue(fich, dateTab[2], dateTab[1], dateTab[5], heureTab[0], heureTab[1], heureTab[2]);
							traceurSession.ajouterDate(dateTab[2],dateTab[1],dateTab[5],heureTab[0],heureTab[1],heureTab[2]);
							traceurSession.ajouteCarnet(nomFichierRTF);
							activation(true);
							modifEffectuee(true);
							//System.out.println("sauv (nouvelle session) : "+sauv);
							traceurTraces.ajouterTraces("menu","nouvelleSession");  
							traceurTraces.ajouterNomSession("nouvelleSession", userName); 
							BarreEtat.afficheGauche("BIENVENUE "+userName+" !", new Color(0,0,192));  
						} else {
//							JOptionPane.showMessageDialog(new JFrame(), "La donne que vous avez voulu charger n'est pas une carte !", "ERREUR !", JOptionPane.WARNING_MESSAGE, null);
							BarreEtat.afficheGauche("ERREUR : La donne que vous avez voulu charger n'est pas une carte !", Color.red); 
						}
					} else {
//						JOptionPane.showMessageDialog(new JFrame(), "Impossible d'ouvrir cette donne !", "ERREUR !", JOptionPane.WARNING_MESSAGE, null);
						BarreEtat.afficheGauche("ERREUR : Impossible d'ouvrir cette donne !", Color.red); 
					}
				} else {
					JOptionPane.showMessageDialog(new JFrame(), "Le type de fichier que vous voulez charger n'est pas support !", "ERREUR !", JOptionPane.WARNING_MESSAGE, null);  
					BarreEtat.afficheGauche("ERREUR : Le type de fichier que vous voulez charger n'est pas support !", Color.red); 
				}
			}
		} else {
			rapportTrace("menu", "nouvelle session", "annulation");   
		}
	}
	
	/**
	 * ajoute une vue a la carte en cours d'edition
	 */
	private void nouvVue() {
		JFileChooser chooser = new JFileChooser(dossierNouvelleVue);
		chooser.setDialogTitle("Choix de la vue  ajouter"); 
		FiltreExtensible filtre = new FiltreExtensible("Donnes"); 
		filtre.addExtension(".jpg"); 
		filtre.addExtension(".gif"); 
		filtre.addExtension(".png"); 
		chooser.addChoosableFileFilter(filtre);
		chooser.setAccessory(new ImagePreview(chooser)); //pour apercu de l'image
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		int returnVal = chooser.showOpenDialog(chooser.getParent());
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			String fich = chooser.getSelectedFile().getPath();
			rapportTrace("menu", "creation (edition)", "vue", fich);   
			String fichDest = espaceCartes+chooser.getSelectedFile().getName();
			String type = JOptionPane.showInputDialog(new JFrame(), "Quel est le nom/type de cette vue (satellite, topographique, ...) ?\n(vitez les accents)", "Parametrage", JOptionPane.QUESTION_MESSAGE);  
			if ((type != null) && !type.matches("")) { 
				traceurCarteEdition.ajouteVue(type, chooser.getSelectedFile().getName());
				navigation.rechargeTypBarre(traceurCarteEdition.exporteVues(), espaceCartes);
				//				comparaison pour eviter le deplacement si deja au bon endroit
				if (!fich.contains(fichDest)) copier(chooser.getSelectedFile(), new File(fichDest)); // COPIE si besoin
				//fin deplacement
				carteModifie = true;
				dossierNouvelleDonnee = fich.substring(0, fich.lastIndexOf("\\"))+"\\";  
			}
		}
	}
	
	/**
	 * ouvre la fenetre de parametrage apres authentification
	 *
	 */
	private void parametrage() {
		boolean verif = authentification();
		if (verif) {
			/*FenetreParametrage fp = */new FenetreParametrage(this, espaceCartes, espaceDocs, espaceGeorefs, espaceDeTravail);
		}
	}
	
	/**
	 * Termine l'application en proposant d'enregistrer
	 */
	private void quitter() {
	    int quit = JOptionPane.showConfirmDialog(new JFrame(), "Etes-vous sr(e) de vouloir quitter ?", "Confirmation", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE, null);  
	    if (quit == JOptionPane.YES_OPTION) {
	        sortie = true;
	        confirmation();
	        rapportTrace("menu","quitter");  
	        if (tracesActives) {
	            traceurTraces.enregistrer();
	        }
	        dispose();
	        System.exit(0);
	    }
	}
	
	/**
	 * Permet  toutes les zones de notifier une action de l'utilisateur
	 */
	public void rapportTrace(String entit, String action) {
		traceurTraces.ajouterTraces(entit, action);
	}
	public void rapportTrace(String entit, String action, String param1) {
		traceurTraces.ajouterTraces(entit, action, param1);
	}
	public void rapportTrace(String entit, String action, String param1, String param2) {
		traceurTraces.ajouterTraces(entit, action, param1, param2);
	}
	
	
	/**
	 * Replace les separateurs apres redimmensionnement (entre autre)
	 */
	private void repaintSplit() {
		if (splitPane1.getDividerLocation()<=splitPane1.getMinimumDividerLocation() || splitPane1.getDividerLocation()>=splitPane1.getMaximumDividerLocation()) splitPane1.setDividerLocation(getWidth()/4);
		if (splitPane2.getDividerLocation()<=splitPane2.getMinimumDividerLocation() || splitPane2.getDividerLocation()>=splitPane2.getMaximumDividerLocation()) splitPane2.setDividerLocation((getWidth()*3)/8);
		if (splitPanePrincipal.getDividerLocation()<=splitPanePrincipal.getMinimumDividerLocation() || splitPanePrincipal.getDividerLocation()>=splitPanePrincipal.getMaximumDividerLocation()) splitPanePrincipal.setDividerLocation((getHeight()*3)/4);
	}
	
	
	/**
	 * liste des fichiers donnees
	 * @param repertoire
	 */
	private ArrayList listeRepertoire ( File repertoire ) {
		ArrayList liste = new ArrayList();
//		System.out.println ( repertoire.getAbsolutePath());
		if ( repertoire.isDirectory ( ) ) {
			File[] list = repertoire.listFiles();
			for ( int i = 0; i < list.length; i++) {
				// Appel rcursif sur les sous-rpertoires
				liste.addAll(listeRepertoire( list[i]));
			} 
		} else {
			if (repertoire.getAbsolutePath().contains(".") && !repertoire.getAbsolutePath().contains(".xml")) {  
				liste.add(repertoire.getAbsolutePath());
			}
		}
		return liste;
	}
	
	/**
	 * si l'un des mots d'une chaine est contenu dans la seconde, alors TRUE
	 * @param a
	 * @param b
	 * @return
	 */
	private boolean correspondance(String a, String b) {
	    boolean resultat = false;
	    String[] tabA = a.split(" "); 
	    String[] tabB = b.split(" "); 
	    int i=0;
	    while (i<tabA.length && !resultat) {
	        int j=0;
	        while (j<tabB.length && !resultat) {
	            if (tabA[i].equals(tabB[j])) resultat = true;
	            j++;
	        }
	        i++;
	    }
	    return resultat;
	}
	
	/**
	 * recherche parmi les donnees (en demandant un mot cl)
	 */
	private void recherche() {
		//demande d'un mot cl
		String mot = JOptionPane.showInputDialog(new JFrame(), "Mot(s) cl(s) :", "Recherche", JOptionPane.QUESTION_MESSAGE);  
		//recherche parmi tous les fichiers ds les dossiers de donnees (les noms de fichiers et les mots cles)
		//TODO ne conserver que les fichiers en rapport avec la carte en cours
		if (mot != null && !mot.equals("")) { 
			JFrame fenetre = new JFrame("Rsultats"); 
			fenetre.setLayout(new BorderLayout());
			Box vBox = Box.createVerticalBox();
			int compteur = 0;
			Traceur traceur = new Traceur();
			ArrayList listeFichiers = listeRepertoire(new File(espaceDonnees));
			Iterator i = listeFichiers.iterator();
			while (i.hasNext()) {
				final String chemin = (String) i.next();
				String extension = chemin.substring(chemin.lastIndexOf(".")); 
				final String cheminXML = chemin .replace(extension, ".xml"); 
				ImageIcon apercu = null;
			    int largMax = 100;
			    int hautMax = 100;
				boolean retour = traceur.charger(cheminXML);
				if (retour) {
					String mots = traceur.exporteInfo("motscles"); 
					final String type = traceur.exporteType();
					if (mots != null && correspondance(mots, mot)) {
						final String nomFichier = chemin.substring(chemin.lastIndexOf("\\")+1, chemin.length()); 
						ImageIcon tmpIcon = new ImageIcon(chemin);
				        if (tmpIcon != null) {
				        	int iconLarg = tmpIcon.getIconWidth();
				        	int iconHaut = tmpIcon.getIconHeight();
				            if ((iconLarg > largMax) || (iconHaut >hautMax)) {
				            	if (iconHaut-hautMax > iconLarg-largMax) {
				            		apercu = new ImageIcon(tmpIcon.getImage().getScaledInstance(-1, hautMax, Image.SCALE_DEFAULT));
				            	} else {
				            		apercu = new ImageIcon(tmpIcon.getImage().getScaledInstance(largMax, -1, Image.SCALE_DEFAULT));
				            	}
				            } else { //no need to miniaturize
				                apercu = tmpIcon;
				            }
				        }
				        JButton bouton = null;
				        if (type.equals("carte") || type.equals("image")) {  
				        	bouton = new JButton(apercu);
				        	bouton.setToolTipText(nomFichier);
				        } else {
				        	bouton = new JButton(nomFichier);
				        }
						bouton.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent arg0) {
//								System.out.println(type);
								if (type.equals("carte")) { 
									TraceurCarte traceurCarte = new TraceurCarte();
									traceurCarte.charger(cheminXML);
									boolean regActif = traceurCarte.exporteInfo("reglet").equals("actif");  
									boolean zoomActif = traceurCarte.exporteInfo("zoom").equals("actif");  
									String unit = ""; 
									double ech = 1;
									if (regActif) {
										unit = traceurCarte.exporteInfo("unite"); 
										ech = Double.parseDouble(traceurCarte.exporteInfo("echelle")); 
									}
									String couleur = traceurCarte.exporteInfo("couleurArrets"); 
									String commentaire = traceurCarte.exporteInfo("commentaire"); 
									documentations.chargerCarte(chemin, ech, unit, regActif, zoomActif, modeEdition, traceurCarte.construitArrets(), Integer.parseInt(traceurCarte.exporteInfo("latitude")), Integer.parseInt(traceurCarte.exporteInfo("longitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLatitude")), Double.parseDouble(traceurCarte.exporteInfo("echelleLongitude")), traceurCarte.exporteVues(), couleur, commentaire);    
								} else {
									if (type.equals("image")) { 
										TraceurDonnee tr = new TraceurDonnee();
										tr.charger(cheminXML);
										boolean regActif = tr.exporteInfo("reglet").equals("actif");  
										boolean zoomActif = tr.exporteInfo("zoom").equals("actif");  
										String unit = ""; 
										double ech = 1;
										if (regActif) {
											unit = tr.exporteInfo("unite"); 
											ech = Double.parseDouble(tr.exporteInfo("echelle")); 
										}
										String commentaire = tr.exporteInfo("commentaire"); 
										documentations.chargerImage(chemin, ech, unit, regActif, zoomActif, modeEdition, commentaire);
									} else {
									    TraceurDonnee tr = new TraceurDonnee();
										tr.charger(cheminXML);
									    String commentaire = tr.exporteInfo("commentaire"); 
										documentations.chargerTexte(chemin, commentaire);
									}
								}
								documentationsCB.setSelected(true);
								historique.ajoutRecherche(nomFichier);
								sauv = false;
								majAffichage();
							}
						});
						JTextPane jtp = new JTextPane();
						jtp.setText(traceur.exporteInfo("commentaire")); 
						jtp.setPreferredSize(new Dimension(50,50));
						jtp.setEditable(false);
						jtp.setBackground(Color.white);
						jtp.setBorder(null);
						Box vBox2 = Box.createVerticalBox();
//						vBox.add(Box.createVerticalStrut(5));
						vBox2.add(bouton);
						vBox2.add(Box.createVerticalStrut(5));
						JScrollPane jsp = new JScrollPane(jtp);
						jsp.setBorder(null);//BorderFactory.createTitledBorder(nomFichier));
						vBox2.add(jsp);
//						vBox.add(Box.createVerticalStrut(5));
						vBox2.setBorder(BorderFactory.createTitledBorder("")); 
						vBox.add(vBox2);
						vBox.add(Box.createVerticalStrut(5));
						compteur++;
					}
				}
			}
			if (compteur>0) {
//				int haut = fenetre.getContentPane().getComponent(0).getPreferredSize().height;
//				int larg = fenetre.getContentPane().getComponent(0).getPreferredSize().width;
//				int nbBoutons = fenetre.getContentPane().getComponentCount();
//				Dimension tailleEcran = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
//				fenetre.setSize(new Dimension(Math.min(larg+70,tailleEcran.width), Math.min((haut+10)*nbBoutons,tailleEcran.height)));
				fenetre.setSize(new Dimension(200, 600));
				fenetre.setResizable(false);
				Box vBoxTotale = Box.createVerticalBox();
				vBoxTotale.add(new JScrollPane(vBox));
				fenetre.add(vBoxTotale,BorderLayout.CENTER);
				fenetre.setVisible(true);
//				fenetre.setLocationRelativeTo(null);
			} else {
				JOptionPane.showMessageDialog(new JFrame(),"Aucune donne ne correspond  votre recherche.","Rsultats",JOptionPane.INFORMATION_MESSAGE);  
			}
		}
	}
	
	/**
	 * active le mode suppression d'un arret
	 *
	 */
	private void suppArret() {
//		JOptionPane.showMessageDialog(new JFrame(),"Selectionnez l'arrt  supprimer.","Suppression",JOptionPane.INFORMATION_MESSAGE);
		modeSuppArret = true;
		BarreEtat.afficheGauche("SUPPRESSION D'UN ARRET (CLIC GAUCHE pour supprimer un arrt, ECHAP pour annuler)", Color.MAGENTA); 
	}
	
	/**
	 * repercurte la suppression d'un arret pour permettre l'enregistrement
	 * @param i
	 */
	public void suppArretEffectue(int i) {
		traceurCarteEdition.suppArret(i);
		modeSuppArret = false;
		BarreEtat.resetGauche();
		setCursor(Cursor.getDefaultCursor());
		carteModifie = true;
		majAffichage();
	}
	
	/**
	 * permet la suppression d'une carte
	 *
	 */
	private void suppCarte() {
		JFileChooser chooser = new JFileChooser("."); 
		chooser.setDialogTitle("Choix de la carte  supprimer"); 
		FiltreExtensible filtre = new FiltreExtensible("Images"); 
		filtre.addExtension(".jpg"); 
		filtre.addExtension(".gif"); 
		chooser.addChoosableFileFilter(filtre);
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		int returnVal = chooser.showOpenDialog(chooser.getParent());
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			String fich = chooser.getSelectedFile().getPath();
			rapportTrace("menu", "suppression (edition)", "carte", fich);   
			String ext = fich.substring(fich.lastIndexOf(".")); 
			String fichXML = fich.replace(ext,".xml"); 
			boolean b1 = chooser.getSelectedFile().delete();
			File xml = new File(fichXML);
			boolean b2 = xml.delete();
			if (b1) {
				//JOptionPane.showMessageDialog(new JFrame(),"La carte a t supprime avec succs !","Information",JOptionPane.INFORMATION_MESSAGE);
				BarreEtat.afficheGauche("INFORMATION : La carte a t supprime avec succs !", Color.BLUE); 
			}
			if (b2) {
				//JOptionPane.showMessageDialog(new JFrame(),"Les mtadonnes de la carte ont t supprimes avec succs !","Information",JOptionPane.INFORMATION_MESSAGE);
				BarreEtat.afficheGauche("INFORMATION : Les mtadonnes de la carte ont t supprimes avec succs !", Color.BLUE); 
			}
		}
		repaint();
	}
	
	/**
	 * supprime une donnee selectionnee par l'utilisateur
	 */
	private void suppDonnee() {
		JFileChooser chooser = new JFileChooser("."); 
		chooser.setDialogTitle("Choix de la donne  supprimer"); 
		FiltreExtensible filtre = new FiltreExtensible("Images"); 
		filtre.addExtension(".jpg"); 
		filtre.addExtension(".gif"); 
		chooser.addChoosableFileFilter(filtre);
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		int returnVal = chooser.showOpenDialog(chooser.getParent());
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			String fich = chooser.getSelectedFile().getPath();
			rapportTrace("menu", "suppression (edition)", "donnee", fich);   
			String ext = fich.substring(fich.lastIndexOf(".")); 
			String fichXML = fich.replace(ext,".xml"); 
			boolean b1 = chooser.getSelectedFile().delete();
			File xml = new File(fichXML);
			boolean b2 = xml.delete();
			if (b1) {
				//JOptionPane.showMessageDialog(new JFrame(),"La carte a t supprime avec succs !","Information",JOptionPane.INFORMATION_MESSAGE);
				BarreEtat.afficheGauche("INFORMATION : La donne a t supprime avec succs !", Color.blue); 
			}
			if (b2) {
				//JOptionPane.showMessageDialog(new JFrame(),"Les mtadonnes de la carte ont t supprimes avec succs !","Information",JOptionPane.INFORMATION_MESSAGE);
				BarreEtat.afficheGauche("INFORMATION : Les mtadonnes de la donne ont t supprimes avec succs !", Color.blue); 
			}
		}
		repaint();
	}
	
	/**
	 * active le mode suppression d'un lien
	 *
	 */
	private void suppLien() {
//		JOptionPane.showMessageDialog(new JFrame(),"Selectionnez le lien  supprimer.","Suppression",JOptionPane.INFORMATION_MESSAGE);
		modeSuppLien = true;
		BarreEtat.afficheGauche("SUPPRESSION D'UN LIEN (CLIC GAUCHE pour supprimer un lien, ECHAP pour annuler)", Color.red); 
	}
	
	/**
	 * valide la suppresssion d'un lien pour permettre l'enregistrement
	 * @param i
	 * @param lien
	 */
	public void suppLienEffectue(int i, String lien) {
		traceurCarteEdition.suppLien(i, lien);
		modeSuppLien = false;
		BarreEtat.resetGauche();
		setCursor(Cursor.getDefaultCursor());
		carteModifie = true;
		majAffichage();
	}
	
	/**
	 * active la suppresssion d'une vue
	 *
	 */
	private void suppVue() {
		ArrayList list = traceurCarteEdition.exporteVues();
		if (list.size()>1) {
//			JOptionPane.showMessageDialog(new JFrame(),"Selectionnez la vue  supprimer.","Suppression",JOptionPane.INFORMATION_MESSAGE);
			modeSuppVue = true;
			setCursor(suppCurseur); 
			BarreEtat.afficheGauche("SUPPRESSION D'UNE VUE (CLIC GAUCHE pour supprimer une vue, ECHAP pour annuler)", Color.red); 
		} else {
//			JOptionPane.showMessageDialog(new JFrame(),"Impossible de supprimer la seule vue restante !","Suppression",JOptionPane.WARNING_MESSAGE);
			BarreEtat.afficheGauche("ERREUR : Impossible de supprimer la seule vue restante !", Color.red); 
		}
	}
	
	/**
	 * valide la suppression d'une vue
	 * @param vue
	 * @param fich
	 */
	public void suppVueEffectue(String vue, String fich) {
		modeSuppVue = false;
		traceurCarteEdition.suppVue(vue, fich);
		navigation.rechargeTypBarre(traceurCarteEdition.exporteVues(), espaceCartes);
		BarreEtat.resetGauche();
		setCursor(Cursor.getDefaultCursor());
		carteModifie = true;
		majAffichage();
	}
	
	/**
	 * Traduit en nombres les mois ecris en lettres
	 */
	private String traduireDate(Date date) {
		String temp = date.toString().replace("Jan","01");  
		temp = temp.replace("Feb","02");  
		temp = temp.replace("Mar","03");  
		temp = temp.replace("Apr","04");  
		temp = temp.replace("May","05");  
		temp = temp.replace("Jun","06");  
		temp = temp.replace("Jul","07");  
		temp = temp.replace("Aug","08");  
		temp = temp.replace("Sep","09");  
		temp = temp.replace("Oct","10");  
		temp = temp.replace("Nov","11");  
		temp = temp.replace("Dec","12");  
		return temp;
	}
	
	/**
	 * verifie que les coord sont definies (lors de l'edition uniquement !)
	 */
	public boolean verifDefCoord() {
	    if (traceurCarteEdition != null) {
	        String lat = traceurCarteEdition.exporteInfo("latitude");	//la balise "latitude est definie que si les coord le sont ! 
	        return !(lat == null);
	    } else return false;
	}
	
	public static void main(String[] args) {
		new Interface();
	}

	/**
	 * une touche tape --> carnet modifi --> autoriser enregistrement
	 */
	public void keyTyped(KeyEvent arg0) {
		modifTexteEffectuee(true);
	}

	/**
	 * permet l'annulation des differents modes de suppression et de definition des coords 
	 */
	public void keyPressed(KeyEvent arg0) {
		int i = arg0.getKeyCode();
//		System.out.println(arg0.getKeyCode());
		if (i == 27) {
			modeSuppArret = false;
			modeSuppLien = false;
			modeSuppVue = false;
			navigation.desactiverModeDefCoord();
			BarreEtat.resetGauche();
			setCursor(Cursor.getDefaultCursor());
			majAffichage();
		}
	}

	public void keyReleased(KeyEvent arg0) { }
	
	public void componentResized(ComponentEvent arg0) {	//TODO
//	    
//	    splitPane1.setDividerLocation(rapport1);
//	    splitPane2.setDividerLocation(rapport2);
//	    splitPanePrincipal.setDividerLocation(rapportP);
//	    
//	    rapport1 = splitPane1.getDividerLocation()/ (double) splitPane1.getParent().getWidth();
//	    rapport2 = splitPane2.getDividerLocation()/ (double) splitPane2.getParent().getWidth();
//	    rapportP = splitPanePrincipal.getDividerLocation()/ (double) splitPanePrincipal.getParent().getHeight();
//	    if (rapport1 == 0) rapport1 = 0.25;
//	    if (rapport2 == 0) rapport2 = 0.625;
//	    if (rapportP == 0) rapportP = 0.75;
//	    System.out.println("rapport 1 : "+rapport1);
//	    System.out.println("rapport 2 : "+rapport2);
//	    System.out.println("rapport P : "+rapportP);
	}

    public void componentMoved(ComponentEvent arg0) { }

    public void componentShown(ComponentEvent arg0) { }

    public void componentHidden(ComponentEvent arg0) { }
	
} //fin de classe
