/*
 * Created on 13 avr. 2005
 */
package geonoteZones;

import geonoteInterface.BarreEtat;
import geonoteInterface.Interface;
import geonoteTypesDonnees.Carte;
import geonoteTypesDonnees.Images;
import geonoteTypesDonnees.Texte;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;


/**
 * gere la zone d'affichage principale
 */
public class Navigation extends JPanel {
	public Carte carte = null;
	private JScrollPane conteneur = null;
	private Interface diplomate = null; //pour communiquer avec l'interface

	private Images image = null;
	private Texte texte = null;
	private JMenuBar vuesBarre = null;
	private String dossierSysteme = "";
	
	private ArrayList hN = null; //historique de la navigation parmi les donnees georefs; enregistre ts les params necessaire au chargement de la donnee
	private int iCourant;

	/**
	 * Constructeur
	 * @param i
	 */
	public Navigation(Interface i, String dosSys) {
		super();
		this.setLayout(new BorderLayout());
		diplomate = i;
		dossierSysteme = dosSys;
		hN = new ArrayList();
		iCourant = 0;
	}
	
	public void activeReglet(boolean b) {
		if (carte != null) {
			carte.setRegletDispo(b);
		} else {
			if (image != null) {
				image.setRegletDispo(b);
			}
		}
	}
	
	public void chargerCarte(final String path, final double ech, final String unit, final boolean reg, final boolean zoom, final boolean edition, final ArrayList listArrets, final int latitudeO, final int longitudeO, final double echLati, final double echLongi, ArrayList listeVues, String coulArrets, String commentaire) {
		if (conteneur!= null) remove(conteneur);
		carte = new Carte(path, ech, unit, reg, zoom, edition, diplomate, listArrets, latitudeO, longitudeO, echLati, echLongi, coulArrets, commentaire);
		conteneur = new JScrollPane(carte);
		conteneur.setBorder(null);
		conteneur.revalidate();
		this.add(conteneur, BorderLayout.CENTER);
		texte = null;
		image = null;
		if (listeVues != null) {
			//recup du dossier des cartes a partir du path de la carte
			String esp = path.substring(0, path.lastIndexOf("\\"));
			rechargeTypBarre(listeVues,esp+"\\");
		}
		diplomate.afficheArrets();
		this.validate();
//		enregistrement ds HN
		ArrayList boite = new ArrayList();
		boite.add(path);
		boite.add(Double.toString(ech));
		boite.add(unit);
		boite.add(Boolean.toString(reg));
		boite.add(Boolean.toString(zoom));
		boite.add(Boolean.toString(edition));
		boite.add(listArrets);
		boite.add(Integer.toString(latitudeO));
		boite.add(Integer.toString(longitudeO));
		boite.add(Double.toString(echLati));
		boite.add(Double.toString(echLongi));
		boite.add(listeVues);
		boite.add(coulArrets);
		boite.add(commentaire);
		hN.add(boite);
		iCourant = hN.size()-1;
		rafraichirBoutons();
	}
	
	public void chargerImage(String path, double ech, String unit, boolean reg, boolean zoom, boolean edition, String commentaire) {
		if (conteneur!= null) remove(conteneur);
		if (vuesBarre != null) remove(vuesBarre);
		image = new Images(path, ech, unit, reg, zoom, edition, diplomate, commentaire);
		conteneur = new JScrollPane(image);
		conteneur.setBorder(null);
		conteneur.revalidate();
		this.add(conteneur);
		texte = null;
		carte = null;
		this.validate();
//		enregistrement ds HN
		ArrayList boite = new ArrayList();
		boite.add(path);
		boite.add(Double.toString(ech));
		boite.add(unit);
		boite.add(Boolean.toString(reg));
		boite.add(Boolean.toString(zoom));
		boite.add(Boolean.toString(edition));
		boite.add(commentaire);
		hN.add(boite);
		iCourant = hN.size()-1;
	}
	
	public void chargerTexte(String path, String commentaire) {
		if (conteneur!= null) remove(conteneur);
		if (vuesBarre != null) remove(vuesBarre);
		texte = new Texte(commentaire);
		texte.setEditable(false);
		texte.charger(path);
		conteneur = new JScrollPane(texte);
		conteneur.setBorder(null);
		conteneur.revalidate();
		this.add(conteneur);
		image = null;
		carte = null;
		this.validate();
		//enregistrement ds HN
		ArrayList boite = new ArrayList();
		boite.add(path);
		boite.add(commentaire);
		hN.add(boite);
		iCourant = hN.size()-1;
	}

	/**
	 * affiche une carte, depuis les boutons de navigation -> acces non enregistr ds l'histo de navigation
	 */
	private void chargementCarte(final String path, final double ech, final String unit, final boolean reg, final boolean zoom, final boolean edition, final ArrayList listArrets, final int latitudeO, final int longitudeO, final double echLati, final double echLongi, ArrayList listeVues, String couleur, String commentaire) {
		if (conteneur!= null) remove(conteneur);
		carte = new Carte(path, ech, unit, reg, zoom, edition, diplomate, listArrets, latitudeO, longitudeO, echLati, echLongi, couleur, commentaire);
		conteneur = new JScrollPane(carte);
		conteneur.setBorder(null);
		conteneur.revalidate();
		this.add(conteneur, BorderLayout.CENTER);
		texte = null;
		image = null;
		if (listeVues != null) {
			//recup du dossier des cartes a partir du path de la carte
			String esp = path.substring(0, path.lastIndexOf("\\"));
			rechargeTypBarre(listeVues,esp+"\\");
		}
		diplomate.afficheArrets();
		this.validate();
	}
	
	/**
	 * affiche une image, depuis les boutons de navigation -> acces non enregistr ds l'histo de navigation
	 */
	private void chargementImage(String path, double ech, String unit, boolean reg, boolean zoom, boolean edition, String commentaire) {
		if (conteneur!= null) remove(conteneur);
		if (vuesBarre != null) remove(vuesBarre);
		image = new Images(path, ech, unit, reg, zoom, edition, diplomate, commentaire);
		conteneur = new JScrollPane(image);
		conteneur.setBorder(null);
		conteneur.revalidate();
		this.add(conteneur);
		texte = null;
		carte = null;
		this.validate();
	}
	
	/**
	 * affiche un  texte depuis les boutons de navigation -> acces non enregistr ds l'histo de navigation
	 */
	private void chargementTexte(String path, String commentaire) {
		if (conteneur!= null) remove(conteneur);
		if (vuesBarre != null) remove(vuesBarre);
		texte = new Texte(commentaire);
		texte.setEditable(false);
		texte.charger(path);
		conteneur = new JScrollPane(texte);
		conteneur.setBorder(null);
		conteneur.revalidate();
		this.add(conteneur);
		image = null;
		carte = null;
		this.validate();
	}
	
	/**
	 * appel  la bonne methode de chargement suivant la donnee a charger
	 * @param i
	 */
	private void chargement(int i) {
		if (hN.size()>i) {
			ArrayList boite = (ArrayList) hN.get(i);
			if (boite.size() == 2) {	//texte
				chargementTexte((String) boite.get(0), (String) boite.get(1));
			} else {
				if (boite.size()==7) {	//image
					chargementImage(
							(String) boite.get(0),
							Double.parseDouble((String) boite.get(1)),
							(String) boite.get(2),
							Boolean.parseBoolean((String) boite.get(3)),
							Boolean.parseBoolean((String) boite.get(4)),
							Boolean.parseBoolean((String) boite.get(5)),
							(String) boite.get(6)
					);
				} else {
					if (boite.size()==14) {	//carte
						chargementCarte(
								(String) boite.get(0),
								Double.parseDouble((String) boite.get(1)),
								(String) boite.get(2),
								Boolean.parseBoolean((String) boite.get(3)),
								Boolean.parseBoolean((String) boite.get(4)),
								Boolean.parseBoolean((String) boite.get(5)),
								(ArrayList) boite.get(6),
								Integer.parseInt((String) boite.get(7)),
								Integer.parseInt((String) boite.get(8)),
								Double.parseDouble((String) boite.get(9)),
								Double.parseDouble((String) boite.get(10)),
								(ArrayList) boite.get(11),
								(String) boite.get(12),
								(String) boite.get(13)
						);
					}
				}
			}
		}
	}
	
	/**
	 * affiche la donnee suivante
	 *
	 */
	public void suivant() {
		if (iCourant<hN.size()-1) {
			iCourant++;
			chargement(iCourant);
		}
	}
	
	/**
	 * affiche la donnee precedente
	 *
	 */
	public void precedent() {
		if (iCourant>0) {
			iCourant--;
			chargement(iCourant);
		}
	}
	
	/**
	 * permet a l'interface de savoir si la donnee affiche est la premiere de l'histo des acces
	 */
	public boolean premier() {
		return iCourant==0;
	}
	
	/**
	 * permet a l'interface de savoir si la donnee affiche est la derniere de l'histo des acces
	 */
	public boolean dernier() {
		return iCourant==hN.size()-1;
	}
	
	/**
	 * changement de l'image  afficher
	 * @param path
	 */
	public void chargerVue(String path) {
		carte.chargerVue(path);
	}
	
	/**
	 * rafraichit la couleur des arrets d'une carte
	 * @param c
	 */
	public void chargerCouleurArrets(String c) {
	    carte.chargerCouleurArrets(c);
	}
	
	/**
	 * rend la carte completement transparente
	 */
	public void masquerVuePrincipale() {
		carte.masquerCarte();
	}

	/**
	 * pour la copie vers le carnet
	 * @return
	 */
	public ImageIcon exporteCarte() {
		if (carte != null) {
			return carte.getImage();
		} else {
			return null;
		}
	}
	
	/**
	 * pour la copie vers le carnet
	 * @return
	 */
	public ImageIcon exporteImage() {
		if (image != null) {
			return image.getImage();
		} else {
			return null;
		}
	}
	
	/**
	 * pour la copie vers le carnet
	 * @return
	 */
	public Texte exporteTexte() {
		if (texte != null) {
			return texte;
		} else {
			return null;
		}
	}
	
	public String exporteTypeActif() {
		if (image != null) {
			return "image";
		} else {
			if (carte != null) {
				return "carte";
			} else {
				return "texte";
			}
		}
	}
	
	public String exporteUnite() {
		String result = "";
		if (carte != null) {
			result = carte.getUnit();
		} else {
			if (image != null) {
				result = image.getUnit();
			}
		}
		return result;
	}
	
	/**
	 * rafraichit la barre des vues
	 * @param l
	 * @param dossier
	 */
	public void rechargeTypBarre(ArrayList l, final String dossier) {
		Iterator i = l.iterator();
		if (vuesBarre != null) remove(vuesBarre); //reconstruction de la barre des vues
		if (!l.isEmpty()) {
			vuesBarre = new JMenuBar();
			while (i.hasNext()) {
				final ArrayList courant = (ArrayList) i.next();
				final JButton bouton = new JButton((String) courant.get(0));
				bouton.setName((String) courant.get(1));
				bouton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent arg0) {
					    BarreEtat.resetGauche();
						if (diplomate.isModeSuppVue()) {
//							carte.charger( dossier+(String) courant.get(1));
							diplomate.suppVueEffectue((String) courant.get(0), (String) courant.get(1));
						} else {
							carte.VueVersCarte();
							carte.chargerVue(dossier+(String) courant.get(1));
							rafraichirBoutons();
							carte.masquerCarte();
							diplomate.ajouteVue((String) courant.get(1));
							diplomate.rapportTrace("carte", "changement vue", (String) courant.get(1));
						}
					}
				});
				bouton.setFocusable(false);
				vuesBarre.add(bouton);
			}
			this.add(vuesBarre, BorderLayout.NORTH);
		}
		this.validate();
	}
	
	/**
	 * definit la couleur des boutons des vues suivant le premier et le second plan affichs ds navigation
	 */
	private void rafraichirBoutons() {
		if (vuesBarre != null) {
			Component[] l = vuesBarre.getComponents();
			int i = 0;
			while (i<l.length) {
				JButton b = (JButton) l[i];
				String nom = b.getName();
				if (carte.exporteCheminVue()!= null && carte.exporteCheminVue().endsWith(nom) && carte.exporteCheminCarte().endsWith(nom)) {
				    //meme vue au 1er et au 2d plan
				    ((AbstractButton) l[i]).setIcon(new ImageIcon(dossierSysteme+"partout.gif"));
				} else {
				    if (carte.exporteCheminVue()!= null && carte.exporteCheminVue().endsWith(nom)) {
				        ((AbstractButton) l[i]).setIcon(new ImageIcon(dossierSysteme+"devant.gif"));
				    } else {
				        if (carte.exporteCheminCarte().endsWith(nom)) {
				            ((AbstractButton) l[i]).setIcon(new ImageIcon(dossierSysteme+"derriere.gif"));    
				        } else {
				            ((AbstractButton) l[i]).setIcon(null);
				        }
				    }
				}
				i++;
			}
		}
	}
	
	/**
	 * efface ttes les donnees
	 */
	public void reset() {
		if (conteneur!= null) remove(conteneur);
		if (vuesBarre != null) remove(vuesBarre);
		texte = null;
		image = null;
		carte = null;
	}
	
	public void setEchelle(double e) {
		if (carte != null) {
			carte.setEchelle(e);
		} else {
			if (image != null) {
				image.setEchelle(e);
			}
		}
	}

	/**
	 * active le mode de definition des coords d'une carte
	 *
	 */
	public void activerModeDefCoord() {
		carte.activerModeDefCoord();
	}
		
	/**
	 * desactive le mode de definition des coords d'une carte
	 *
	 */
	public void desactiverModeDefCoord() {
		carte.desactiverModeDefCoord();
	}
	
	public void setUnite(String u) {
		if (carte != null) {
			carte.setUnit(u);
		} else {
			if (image != null) {
				image.setUnit(u);
			}
		}
	}
	
} // fin de classe
