/*
 * Decompiled with CFR 0.152.
 */
package geonoteOutils;

import geonoteInterface.BarreEtat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.text.DecimalFormat;

public class Reglet {
    private int x1 = -1;
    private int y1 = -1;
    private int x2 = -1;
    private int y2 = -1;
    private double longueur = 0.0;
    private boolean modeEdition = false;
    private boolean modeEcriture = false;

    public Reglet(boolean edition) {
        this.modeEdition = edition;
    }

    public void setDepart(int x, int y) {
        this.x1 = x;
        this.y1 = y;
    }

    public void setArriv\u00e9e(int x, int y) {
        this.x2 = x;
        this.y2 = y;
    }

    public double getLongueur() {
        this.longueur = Math.sqrt(Math.pow(Math.abs(this.x1 - this.x2), 2.0) + Math.pow(Math.abs(this.y1 - this.y2), 2.0));
        return this.longueur;
    }

    public void setModeEcriture(boolean b) {
        this.modeEcriture = b;
    }

    public void draw(Graphics2D g, double zoom, double echelle, String unite) {
        String longueurAffiche;
        this.longueur = Math.sqrt(Math.pow(Math.abs(this.x1 - this.x2), 2.0) + Math.pow(Math.abs(this.y1 - this.y2), 2.0));
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        int x1Affichage = this.x1;
        int y1Affichage = this.y1;
        int dxa = this.x2 - x1Affichage;
        int dya = this.y2 - y1Affichage;
        int dxb = dxa;
        int dyb = dya;
        int absdx = Math.abs(dxa);
        int absdy = Math.abs(dya);
        double theta = Math.atan2(absdy, absdx);
        int absdxa = absdx - (int)(10.0 / zoom * Math.cos(theta - 1.5707963267948966));
        int absdya = absdy - (int)(10.0 / zoom * Math.sin(theta - 1.5707963267948966));
        int absdxb = absdx - (int)(10.0 / zoom * Math.cos(theta + 1.5707963267948966));
        int absdyb = absdy - (int)(10.0 / zoom * Math.sin(theta + 1.5707963267948966));
        dxa = dxa < 0 ? -absdxa : absdxa;
        dya = dya < 0 ? -absdya : absdya;
        dxb = dxb < 0 ? -absdxb : absdxb;
        dyb = dyb < 0 ? -absdyb : absdyb;
        int xa = this.x2 - dxa;
        int ya = this.y2 - dya;
        int xb = this.x2 - dxb;
        int yb = this.y2 - dyb;
        g.setColor(Color.white);
        g.setStroke(new BasicStroke((float)(4.0 / zoom)));
        g.drawLine(x1Affichage, y1Affichage, this.x2, this.y2);
        g.drawLine(x1Affichage, y1Affichage, xa, ya);
        g.drawLine(x1Affichage, y1Affichage, xb, yb);
        g.setColor(Color.black);
        if (3.0 / zoom >= 1.0 / zoom / (echelle / zoom)) {
            g.setStroke(new BasicStroke((float)(2.0 / zoom)));
        } else {
            float epaisseur = (float)(2.0 / zoom);
            float[] style = new float[]{(float)(1.0 / zoom / (echelle / zoom) - 3.0 / zoom), (float)(3.0 / zoom)};
            g.setStroke(new BasicStroke(epaisseur, 0, 0, 2.0f, style, 0.0f));
        }
        g.drawLine(x1Affichage, y1Affichage, this.x2, this.y2);
        g.setStroke(new BasicStroke((float)(2.0 / zoom)));
        g.drawLine(x1Affichage, y1Affichage, xa, ya);
        g.drawLine(x1Affichage, y1Affichage, xb, yb);
        double mesure = echelle * this.longueur;
        if (this.modeEdition && this.modeEcriture) {
            DecimalFormat df = new DecimalFormat("########");
            longueurAffiche = String.valueOf(df.format(this.longueur)) + " px.";
        } else {
            DecimalFormat df = new DecimalFormat("########.##");
            longueurAffiche = String.valueOf(df.format(mesure)) + " " + unite;
        }
        BarreEtat.afficheDroite("MESURE : " + longueurAffiche);
    }
}

