/*
 * Decompiled with CFR 0.152.
 */
package geonoteZones;

import geonoteInterface.Interface;
import geonoteTypesDonnees.Arret;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Historique
extends JPanel {
    private JTree tree = null;
    private Interface diplomate = null;
    private JScrollPane conteneur = null;
    private boolean selectionListenerActif = true;
    private MyTreeCellRenderer renderer = null;
    private JScrollPane conteneurEcran = null;

    public Historique(Interface i) {
        this.setLayout(new BorderLayout());
        this.diplomate = i;
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void creerEcran(String texte, String fich) {
        if (this.conteneurEcran != null) {
            this.remove(this.conteneurEcran);
        }
        JTextPane ecranAnnotation = new JTextPane();
        ecranAnnotation.setBackground(new Color(168, 210, 159));
        ecranAnnotation.setText(texte);
        ecranAnnotation.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(fich), BorderFactory.createLineBorder(new Color(168, 210, 159), 5)));
        ecranAnnotation.setEditable(false);
        this.conteneurEcran = new JScrollPane(ecranAnnotation);
        this.conteneurEcran.setPreferredSize(new Dimension(this.getWidth(), 120));
        this.conteneur.revalidate();
        this.add((Component)this.conteneurEcran, "South");
        this.validate();
    }

    private void suppEcran() {
        if (this.conteneurEcran != null) {
            this.remove(this.conteneurEcran);
        }
        this.validate();
    }

    public void creerArbre(String racine) {
        if (this.conteneur != null) {
            if (this.tree != null) {
                this.conteneur.remove(this.tree);
            }
            this.remove(this.conteneur);
        }
        DefaultMutableTreeNode rac = new DefaultMutableTreeNode(racine);
        this.tree = new JTree(rac);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setBorder(BorderFactory.createLineBorder(Color.white, 5));
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.setVisible(true);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node;
                if (Historique.this.selectionListenerActif && (node = (DefaultMutableTreeNode)Historique.this.tree.getLastSelectedPathComponent()) != null) {
                    if (Historique.this.verifExtension(node.getUserObject().toString())) {
                        if (node.getParent().toString().equals("Vue(s)")) {
                            String fich = "";
                            fich = node.getUserObject().toString().contains(" ") ? node.getUserObject().toString().substring(0, node.getUserObject().toString().indexOf(" ")) : node.getUserObject().toString();
                            Historique.this.diplomate.afficheNav(fich, "carte");
                            Historique.this.diplomate.rapportTrace("historique", "affiche vue", fich);
                        } else if (node.getParent().toString().contains("Arr")) {
                            String fich = "";
                            fich = node.getUserObject().toString().contains(" ") ? node.getUserObject().toString().substring(0, node.getUserObject().toString().indexOf(" ")) : node.getUserObject().toString();
                            Historique.this.diplomate.afficheNav(fich, "arret");
                            Historique.this.diplomate.rapportTrace("historique", "affiche donnee georeferencee", fich);
                        } else if (node.getParent().toString().equals("Documentation")) {
                            String fich = "";
                            fich = node.getUserObject().toString().contains(" ") ? node.getUserObject().toString().substring(0, node.getUserObject().toString().indexOf(" ")) : node.getUserObject().toString();
                            Historique.this.diplomate.afficheDocs(fich);
                            Historique.this.diplomate.rapportTrace("historique", "affiche document", fich);
                        } else if (node.getParent().toString().equals("Recherches")) {
                            String fich = "";
                            fich = node.getUserObject().toString().contains(" ") ? node.getUserObject().toString().substring(0, node.getUserObject().toString().indexOf(" ")) : node.getUserObject().toString();
                            Historique.this.diplomate.afficheRech(fich);
                            Historique.this.diplomate.rapportTrace("historique", "affiche recherche", fich);
                        }
                        Historique.this.suppEcran();
                    } else if (node.toString().contains("Annotation")) {
                        String texte = node.toString();
                        texte = texte.substring(texte.indexOf(" : ") + 3, texte.length());
                        String fich = ((DefaultMutableTreeNode)node.getParent()).getUserObject().toString();
                        Historique.this.creerEcran(texte, fich);
                    } else {
                        Historique.this.suppEcran();
                    }
                }
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getButton() == 3) {
                    Historique.this.ouvreMenu(arg0.getX(), arg0.getY());
                }
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.conteneur = new JScrollPane(this.tree);
        this.conteneur.setBorder(null);
        this.add((Component)this.conteneur, "Center");
        this.validate();
    }

    private void ouvreMenu(int x, int y) {
        TreePath path = this.tree.getClosestPathForLocation(x, y);
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        String noeud = node.toString();
        final JPopupMenu menu = new JPopupMenu();
        if (node.isLeaf()) {
            if (noeud.contains(".")) {
                JMenuItem annoter = new JMenuItem("Annoter");
                annoter.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        menu.setVisible(false);
                        Historique.this.annote(node);
                    }
                });
                menu.add(annoter);
                menu.show(this, x, y);
            } else if (noeud.contains("Annotation")) {
                JMenuItem modifier = new JMenuItem("Modifier");
                modifier.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        menu.setVisible(false);
                        Historique.this.modifieAnnotation(node);
                    }
                });
                JMenuItem supprimer = new JMenuItem("Supprimer");
                supprimer.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        menu.setVisible(false);
                        Historique.this.supprimeAnnotation(node);
                    }
                });
                menu.add(modifier);
                menu.add(supprimer);
                menu.show(this, x, y);
            }
        }
    }

    private void supprimeAnnotation(DefaultMutableTreeNode elt) {
        int res;
        this.selectionListenerActif = false;
        if (elt != null && (res = JOptionPane.showConfirmDialog(this.diplomate, "Etes-vous s\u00fbr ?", "Confirmation", 2)) == 0) {
            this.diplomate.rapportTrace("historique", "suppression annotation", elt.toString());
            DefaultMutableTreeNode pere = (DefaultMutableTreeNode)elt.getParent();
            pere.remove(elt);
            if (this.diplomate != null) {
                this.diplomate.suppAnnotation(elt.toString());
            }
            this.tree.setModel(new DefaultTreeModel((DefaultMutableTreeNode)this.tree.getModel().getRoot()));
            this.tree.expandPath(new TreePath(((DefaultMutableTreeNode)pere.getParent()).getPath()));
        }
        this.selectionListenerActif = true;
    }

    private void modifieAnnotation(DefaultMutableTreeNode elt) {
        String saisie;
        this.selectionListenerActif = false;
        if (elt != null && (saisie = JOptionPane.showInputDialog(this.diplomate, "Votre texte :", "Annotation", 1)) != null && !saisie.matches("")) {
            this.diplomate.rapportTrace("historique", "modification annotation", elt.toString(), "nouvelle annottion : " + saisie);
            DefaultMutableTreeNode pere = (DefaultMutableTreeNode)elt.getParent();
            pere.remove(elt);
            elt = new DefaultMutableTreeNode("Annotation : " + saisie);
            pere.add(elt);
            if (this.diplomate != null) {
                this.diplomate.modifAnnotation(elt.toString(), saisie);
            }
            this.tree.setModel(new DefaultTreeModel((DefaultMutableTreeNode)this.tree.getModel().getRoot()));
            this.tree.expandPath(new TreePath(pere.getPath()));
        }
        this.selectionListenerActif = true;
    }

    private void annote(DefaultMutableTreeNode elt) {
        String saisie;
        this.selectionListenerActif = false;
        if (elt != null && (saisie = JOptionPane.showInputDialog(this.diplomate, "Votre texte :", "Annotation", 1)) != null && !saisie.matches("")) {
            this.diplomate.rapportTrace("historique", "annotation", saisie);
            DefaultMutableTreeNode annotation = new DefaultMutableTreeNode("Annotation : " + saisie);
            elt.add(annotation);
            this.tree.expandPath(new TreePath(elt.getPath()));
            System.out.println(elt.getParent().toString());
            this.diplomate.annoter(elt.toString(), elt.getParent().toString(), saisie);
        }
        this.selectionListenerActif = true;
    }

    public void ajouteAnnotation(String pere, String chemin, String annotation) {
        this.selectionListenerActif = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode eltPere = this.rechercher(root, pere);
        if (eltPere != null) {
            DefaultMutableTreeNode elt = this.rechercher(eltPere, chemin);
            if (elt != null) {
                DefaultMutableTreeNode eltAnnotation = new DefaultMutableTreeNode("Annotation : " + annotation);
                elt.add(eltAnnotation);
            } else {
                System.out.println("Erreur : nd non trouv\u00e9");
            }
        }
        this.selectionListenerActif = true;
    }

    private boolean verifExtension(String chemin) {
        return chemin.contains(".jpg") || chemin.contains(".JPG") || chemin.contains(".jpeg") || chemin.contains(".JPEG") || chemin.contains(".gif") || chemin.contains(".GIF") || chemin.contains(".png") || chemin.contains(".PNG") || chemin.contains(".rtf") || chemin.contains(".RTF");
    }

    public void ajouterVue(String nomCarte) {
        if (this.tree != null) {
            String aChercher;
            DefaultMutableTreeNode nouvo;
            this.selectionListenerActif = false;
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            DefaultMutableTreeNode vues = this.rechercherN1(root, "Vue(s)");
            if (vues == null) {
                vues = new DefaultMutableTreeNode("Vue(s)");
                root.add(vues);
            }
            if ((nouvo = this.rechercherN1(vues, aChercher = nomCarte.contains(" ") ? nomCarte.substring(0, nomCarte.indexOf(" ")) : nomCarte)) == null) {
                nouvo = new DefaultMutableTreeNode(nomCarte);
                vues.add(nouvo);
            }
            this.tree.setModel(new DefaultTreeModel(root));
            this.tree.expandPath(new TreePath(vues.getPath()));
            this.selectionListenerActif = true;
        }
    }

    private DefaultMutableTreeNode rechercherN1(DefaultMutableTreeNode racine, String cherch\u00e9) {
        DefaultMutableTreeNode cible = null;
        DefaultMutableTreeNode temp = null;
        boolean trouv\u00e9 = false;
        Enumeration<TreeNode> enumeration = racine.children();
        while (enumeration.hasMoreElements() && !trouv\u00e9) {
            temp = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!temp.toString().contains(cherch\u00e9)) continue;
            cible = temp;
            trouv\u00e9 = true;
        }
        return cible;
    }

    private DefaultMutableTreeNode rechercher(DefaultMutableTreeNode racine, String cherch\u00e9) {
        DefaultMutableTreeNode cible = null;
        if (racine.toString().equals(cherch\u00e9)) {
            cible = racine;
        } else {
            DefaultMutableTreeNode temp = null;
            boolean trouv\u00e9 = false;
            Enumeration<TreeNode> enumeration = racine.children();
            while (enumeration.hasMoreElements() && !trouv\u00e9) {
                temp = (DefaultMutableTreeNode)enumeration.nextElement();
                cible = this.rechercher(temp, cherch\u00e9);
                if (cible == null) continue;
                trouv\u00e9 = true;
            }
        }
        return cible;
    }

    public void ajouterDocs(String donn\u00e9e) {
        this.selectionListenerActif = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode docs = this.rechercherN1(root, "Documentation");
        if (docs == null) {
            docs = new DefaultMutableTreeNode("Documentation");
            root.add(docs);
        }
        String nomFichier = "";
        nomFichier = donn\u00e9e.contains(" ") ? donn\u00e9e.substring(0, donn\u00e9e.indexOf(" ")) : donn\u00e9e;
        DefaultMutableTreeNode nouvo = this.rechercherN1(docs, nomFichier);
        if (nouvo == null) {
            nouvo = new DefaultMutableTreeNode(donn\u00e9e);
            docs.add(nouvo);
        }
        this.tree.setModel(new DefaultTreeModel(root));
        this.tree.expandPath(new TreePath(docs.getPath()));
        this.selectionListenerActif = true;
    }

    public void ajouterDocs(ArrayList liste) {
        int i = 0;
        while (i < liste.size()) {
            this.ajouterDocs(liste.get(i).toString());
            ++i;
        }
    }

    public void ajoutRecherche(String fich) {
        this.selectionListenerActif = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode rech = this.rechercherN1(root, "Recherches");
        if (rech == null) {
            rech = new DefaultMutableTreeNode("Recherches");
            root.add(rech);
        }
        String nomFichier = "";
        nomFichier = fich.contains(" ") ? fich.substring(0, fich.indexOf(" ")) : fich;
        DefaultMutableTreeNode nouvo = this.rechercherN1(rech, nomFichier);
        if (nouvo == null) {
            nouvo = new DefaultMutableTreeNode(fich);
            rech.add(nouvo);
        }
        this.tree.setModel(new DefaultTreeModel(root));
        this.tree.expandPath(new TreePath(rech.getPath()));
        this.selectionListenerActif = true;
    }

    private ArrayList rechercheArrets() {
        ArrayList<DefaultMutableTreeNode> liste = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).children();
        DefaultMutableTreeNode temp = null;
        while (enumeration.hasMoreElements()) {
            temp = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!temp.toString().contains("Arr")) continue;
            liste.add(temp);
        }
        return liste;
    }

    public void ajoutArret(int id, String donnee) {
        this.selectionListenerActif = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode arret = this.rechercherN1(root, "Arr\u00eat " + id);
        if (arret == null) {
            arret = new DefaultMutableTreeNode("Arr\u00eat " + id);
            ArrayList liste = this.rechercheArrets();
            Iterator i = liste.iterator();
            int compteur = 2;
            boolean lieuTrouv\u00e9 = false;
            while (i.hasNext() && !lieuTrouv\u00e9) {
                String courant = ((DefaultMutableTreeNode)i.next()).toString();
                int idCourant = Integer.parseInt(courant.substring(courant.indexOf(" ") + 1));
                if (idCourant < id) {
                    ++compteur;
                    continue;
                }
                lieuTrouv\u00e9 = true;
            }
            root.insert(arret, compteur);
        }
        String nomFichier = "";
        nomFichier = donnee.contains(" ") ? donnee.substring(0, donnee.indexOf(" ")) : donnee;
        DefaultMutableTreeNode nouvo = this.rechercherN1(arret, nomFichier);
        if (nouvo == null) {
            nouvo = new DefaultMutableTreeNode(donnee);
            arret.add(nouvo);
        }
        this.tree.setModel(new DefaultTreeModel(root));
        this.tree.expandPath(new TreePath(arret.getPath()));
        this.selectionListenerActif = true;
    }

    public void reset() {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        if (this.conteneurEcran != null) {
            this.remove(this.conteneurEcran);
        }
        this.tree = null;
    }

    public void ajouterDateSession(String j, String m, String a, String h, String min, String s) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DefaultMutableTreeNode carte = new DefaultMutableTreeNode("Date de cr\u00e9ation (session)");
        String chaineDate = "le " + j + "/" + m + "/" + a + " (\u00e0 " + h + "h" + min + "m" + s + ")";
        DefaultMutableTreeNode nouvo = new DefaultMutableTreeNode(chaineDate);
        carte.add(nouvo);
        root.add(carte);
        this.tree.setModel(new DefaultTreeModel(root));
    }

    public void chargeArrets(ArrayList liste) {
        this.selectionListenerActif = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Iterator i = liste.iterator();
        while (i.hasNext()) {
            Arret courant = (Arret)i.next();
            DefaultMutableTreeNode temp = new DefaultMutableTreeNode("Arr\u00eat " + courant.getId());
            ArrayList listLiens = courant.exporteListeLiens();
            Iterator j = listLiens.iterator();
            while (j.hasNext()) {
                DefaultMutableTreeNode lien = new DefaultMutableTreeNode(j.next().toString());
                temp.add(lien);
            }
            ArrayList listeArrets = this.rechercheArrets();
            Iterator k = listeArrets.iterator();
            int compteur = 2;
            boolean lieuTrouv\u00e9 = false;
            while (k.hasNext() && !lieuTrouv\u00e9) {
                String temp2 = ((DefaultMutableTreeNode)k.next()).toString();
                int idCourant = Integer.parseInt(temp2.substring(temp2.indexOf(" ") + 1));
                if (idCourant < courant.getId()) {
                    ++compteur;
                    continue;
                }
                lieuTrouv\u00e9 = true;
            }
            root.insert(temp, compteur);
        }
        this.tree.setModel(new DefaultTreeModel(root));
        this.selectionListenerActif = true;
    }

    private class MyTreeCellRenderer
    extends JTextArea
    implements TreeCellRenderer {
        MyTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)value;
            Object o = dmt.getUserObject();
            String text = o.toString();
            this.setText(text);
            this.setBackground(Color.WHITE);
            this.setFont(new Font("Courrier", 1, 12));
            if (sel) {
                this.setBackground(Color.darkGray);
                this.setForeground(Color.white);
            } else {
                this.setBackground(tree.getBackground());
                this.setForeground(tree.getForeground());
            }
            if (!dmt.isLeaf()) {
                DefaultMutableTreeNode fils;
                Object oFils;
                String textFils;
                DefaultMutableTreeNode pere = (DefaultMutableTreeNode)dmt.getParent();
                if (pere == null) {
                    this.setBackground(tree.getBackground());
                    this.setForeground(new Color(255, 0, 0));
                }
                if ((textFils = (oFils = (fils = (DefaultMutableTreeNode)dmt.getFirstChild()).getUserObject()).toString()).contains("Annotation")) {
                    if (!sel) {
                        this.setBackground(new Color(168, 210, 159));
                        this.setForeground(tree.getForeground());
                    } else {
                        this.setBackground(Color.darkGray);
                        this.setForeground(Color.white);
                    }
                } else {
                    int nbFils = dmt.getChildCount();
                    boolean aColorer = false;
                    while (nbFils > 0 && !aColorer) {
                        Object oPetitFils;
                        String textPetitFils;
                        DefaultMutableTreeNode petitFils;
                        DefaultMutableTreeNode fiston = (DefaultMutableTreeNode)dmt.getChildAt(nbFils - 1);
                        if (!fiston.isLeaf() && (petitFils = (DefaultMutableTreeNode)fiston.getFirstChild()) != null && (textPetitFils = (oPetitFils = petitFils.getUserObject()).toString()).contains("Annotation")) {
                            aColorer = true;
                        }
                        --nbFils;
                    }
                    if (aColorer) {
                        if (!sel) {
                            this.setBackground(new Color(168, 210, 159));
                            this.setForeground(tree.getForeground());
                        } else {
                            this.setBackground(Color.darkGray);
                            this.setForeground(Color.white);
                        }
                    }
                }
            }
            return this;
        }
    }
}

