/*
 * Decompiled with CFR 0.152.
 */
package geonoteZones;

import geonoteInterface.Interface;
import geonoteOutils.FiltreSimple;
import geonoteOutilsCarnet.ColorMenu;
import geonoteOutilsCarnet.FontDialog;
import geonoteOutilsCarnet.ParagraphDialog;
import geonoteOutilsCarnet.SmallButton;
import geonoteOutilsCarnet.SmallToggleButton;
import geonoteTypesDonnees.Texte;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class Carnet
extends JPanel {
    private Texte texte;
    private JMenuBar menuBar;
    private JScrollPane conteneur;
    private JPanel barresConteneur = null;
    private StyleContext m_context;
    private DefaultStyledDocument m_doc;
    private RTFEditorKit m_kit;
    private JFileChooser m_chooser;
    private FiltreSimple m_rtfFilter;
    private JToolBar toolBar;
    private JComboBox m_cbFonts;
    private JComboBox m_cbSizes;
    private SmallToggleButton m_bBold;
    private SmallToggleButton m_bItalic;
    private FiltreSimple m_jpgFilter;
    private FiltreSimple m_gifFilter;
    private UndoManager m_undo = new UndoManager();
    private Action m_undoAction;
    private Action m_redoAction;
    private ColorMenu m_foreground;
    private ColorMenu m_background;
    private String m_fontName = "";
    private int m_fontSize = 0;
    private boolean m_skipUpdate;
    private String[] m_fontNames;
    private ParagraphDialog m_paragraphDialog;
    private String[] m_fontSizes;
    private FontDialog m_fontDialog;
    private int m_xStart = -1;
    private int m_xFinish = -1;
    private JComboBox m_cbStyles;
    private Interface diplomate = null;
    private String dossierSysteme = "";
    private String newline = "\n";
    public static final char[] WORD_SEPARATORS = new char[]{' ', '\t', '\n', '\r', '\f', '.', ',', ':', '-', '(', ')', '[', ']', '{', '}', '<', '>', '/', '|', '\\', '\'', '\"'};

    public Carnet(Interface i, String sys) {
        this.diplomate = i;
        this.dossierSysteme = sys;
        this.setLayout(new BorderLayout());
    }

    public static boolean isSeparator(char ch) {
        int k = 0;
        while (k < WORD_SEPARATORS.length) {
            if (ch == WORD_SEPARATORS[k]) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private void masquer() {
        this.diplomate.masquerCarnet();
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        JMenu mEdit = new JMenu("Edition");
        mEdit.setMnemonic('e');
        AbstractAction action = new AbstractAction("Copier", new ImageIcon(String.valueOf(this.dossierSysteme) + "copier.gif")){

            public void actionPerformed(ActionEvent e) {
                Carnet.this.texte.copy();
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        JMenuItem item = mEdit.add(action);
        item.setMnemonic('c');
        item.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        action = new AbstractAction("Couper", new ImageIcon(String.valueOf(this.dossierSysteme) + "couper.gif")){

            public void actionPerformed(ActionEvent e) {
                Carnet.this.texte.cut();
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        item = mEdit.add(action);
        item.setMnemonic('t');
        item.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        action = new AbstractAction("Coller", new ImageIcon(String.valueOf(this.dossierSysteme) + "coller.gif")){

            public void actionPerformed(ActionEvent e) {
                Carnet.this.texte.paste();
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        item = mEdit.add(action);
        item.setMnemonic('p');
        item.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        mEdit.addSeparator();
        this.m_undoAction = new AbstractAction("Annuler", new ImageIcon(String.valueOf(this.dossierSysteme) + "annuler.gif")){

            public void actionPerformed(ActionEvent e) {
                try {
                    Carnet.this.m_undo.undo();
                }
                catch (CannotUndoException ex) {
                    System.err.println("Unable to undo: " + ex);
                }
                Carnet.this.updateUndo();
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        item = mEdit.add(this.m_undoAction);
        item.setMnemonic('a');
        item.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.m_redoAction = new AbstractAction("R\u00e9tablir", new ImageIcon(String.valueOf(this.dossierSysteme) + "retablir.gif")){

            public void actionPerformed(ActionEvent e) {
                try {
                    Carnet.this.m_undo.redo();
                }
                catch (CannotRedoException ex) {
                    System.err.println("Unable to redo: " + ex);
                }
                Carnet.this.updateUndo();
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        item = mEdit.add(this.m_redoAction);
        item.setMnemonic('r');
        item.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.m_fontNames = ge.getAvailableFontFamilyNames();
        this.toolBar.addSeparator();
        this.m_cbFonts = new JComboBox<String>(this.m_fontNames);
        this.m_cbFonts.setMaximumSize(this.m_cbFonts.getPreferredSize());
        this.m_cbFonts.setEditable(true);
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Carnet.this.m_fontName = Carnet.this.m_cbFonts.getSelectedItem().toString();
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setFontFamily(attr, Carnet.this.m_fontName);
                Carnet.this.setAttributeSet(attr);
                Carnet.this.texte.grabFocus();
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        this.m_cbFonts.addActionListener(lst);
        this.toolBar.add(this.m_cbFonts);
        this.toolBar.addSeparator();
        this.m_fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        this.m_cbSizes = new JComboBox<String>(this.m_fontSizes);
        this.m_cbSizes.setMaximumSize(this.m_cbSizes.getPreferredSize());
        this.m_cbSizes.setEditable(true);
        this.m_fontDialog = new FontDialog(this.diplomate, this.m_fontNames, this.m_fontSizes);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int fontSize = 0;
                try {
                    fontSize = Integer.parseInt(Carnet.this.m_cbSizes.getSelectedItem().toString());
                }
                catch (NumberFormatException ex) {
                    return;
                }
                Carnet.this.m_fontSize = fontSize;
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setFontSize(attr, fontSize);
                Carnet.this.setAttributeSet(attr);
                Carnet.this.texte.grabFocus();
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        this.m_cbSizes.addActionListener(lst);
        this.toolBar.add(this.m_cbSizes);
        this.toolBar.addSeparator();
        ImageIcon img1 = new ImageIcon(String.valueOf(this.dossierSysteme) + "gras.gif");
        ImageIcon img2 = new ImageIcon(String.valueOf(this.dossierSysteme) + "gras2.gif");
        this.m_bBold = new SmallToggleButton(false, img1, img2, "Gras");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setBold(attr, Carnet.this.m_bBold.isSelected());
                Carnet.this.setAttributeSet(attr);
                Carnet.this.texte.grabFocus();
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        this.m_bBold.addActionListener(lst);
        this.toolBar.add(this.m_bBold);
        img1 = new ImageIcon(String.valueOf(this.dossierSysteme) + "italique.gif");
        img2 = new ImageIcon(String.valueOf(this.dossierSysteme) + "italique2.gif");
        this.m_bItalic = new SmallToggleButton(false, img1, img2, "Italique");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setItalic(attr, Carnet.this.m_bItalic.isSelected());
                Carnet.this.setAttributeSet(attr);
                Carnet.this.texte.grabFocus();
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        this.m_bItalic.addActionListener(lst);
        this.toolBar.add(this.m_bItalic);
        JMenu mFormat = new JMenu("Format");
        mFormat.setMnemonic('o');
        item = new JMenuItem("Police ...");
        item.setMnemonic('o');
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Carnet.this.repaint();
                AttributeSet a = Carnet.this.m_doc.getCharacterElement(Carnet.this.texte.getCaretPosition()).getAttributes();
                Carnet.this.m_fontDialog.setAttributes(a);
                Dimension d1 = Carnet.this.m_fontDialog.getSize();
                Dimension d2 = Carnet.this.getSize();
                int x = Math.max((d2.width - d1.width) / 2, 0);
                int y = Math.max((d2.height - d1.height) / 2, 0);
                Carnet.this.m_fontDialog.setBounds(x + Carnet.this.getX(), y + Carnet.this.getY(), d1.width, d1.height);
                Carnet.this.m_fontDialog.setVisible(true);
                if (Carnet.this.m_fontDialog.getOption() == 0) {
                    Carnet.this.setAttributeSet(Carnet.this.m_fontDialog.getAttributes());
                    Carnet.this.showAttributes(Carnet.this.texte.getCaretPosition());
                    Carnet.this.diplomate.modifTexteEffectuee(true);
                }
            }
        };
        item.addActionListener(lst);
        mFormat.add(item);
        mFormat.addSeparator();
        JMenu mStyle = new JMenu("Style");
        mStyle.setMnemonic('s');
        mFormat.add(mStyle);
        item = new JMenuItem("Mise \u00e0 jour");
        item.setMnemonic('m');
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = (String)Carnet.this.m_cbStyles.getSelectedItem();
                Style style = Carnet.this.m_doc.getStyle(name);
                int p = Carnet.this.texte.getCaretPosition();
                AttributeSet a = Carnet.this.m_doc.getCharacterElement(p).getAttributes();
                style.addAttributes(a);
                Carnet.this.texte.repaint();
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        item.addActionListener(lst);
        mStyle.add(item);
        item = new JMenuItem("R\u00e9tablir");
        item.setMnemonic('r');
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = (String)Carnet.this.m_cbStyles.getSelectedItem();
                Style style = Carnet.this.m_doc.getStyle(name);
                Carnet.this.setAttributeSet(style);
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        item.addActionListener(lst);
        mStyle.add(item);
        item = new JMenuItem("Paragraphe ...");
        item.setMnemonic('p');
        this.m_paragraphDialog = new ParagraphDialog(this.diplomate, this.dossierSysteme);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Carnet.this.repaint();
                AttributeSet a = Carnet.this.m_doc.getCharacterElement(Carnet.this.texte.getCaretPosition()).getAttributes();
                Carnet.this.m_paragraphDialog.setAttributes(a);
                Dimension d1 = Carnet.this.m_paragraphDialog.getSize();
                Dimension d2 = Carnet.this.getSize();
                int x = Math.max((d2.width - d1.width) / 2, 0);
                int y = Math.max((d2.height - d1.height) / 2, 0);
                Carnet.this.m_paragraphDialog.setBounds(x + Carnet.this.getX(), y + Carnet.this.getY(), d1.width, d1.height);
                Carnet.this.m_paragraphDialog.setVisible(true);
                if (Carnet.this.m_paragraphDialog.getOption() == 0) {
                    Carnet.this.setAttributeSet(Carnet.this.m_paragraphDialog.getAttributes(), true);
                    Carnet.this.showAttributes(Carnet.this.texte.getCaretPosition());
                    Carnet.this.diplomate.modifTexteEffectuee(true);
                }
            }
        };
        item.addActionListener(lst);
        mFormat.add(item);
        mFormat.addSeparator();
        this.m_foreground = new ColorMenu("Couleur de police");
        this.m_foreground.setColor(this.texte.getForeground());
        this.m_foreground.setMnemonic('f');
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setForeground(attr, Carnet.this.m_foreground.getColor());
                Carnet.this.setAttributeSet(attr);
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        this.m_foreground.addActionListener(lst);
        mFormat.add(this.m_foreground);
        MenuListener ml = new MenuListener(){

            public void menuSelected(MenuEvent e) {
                int p = Carnet.this.texte.getCaretPosition();
                AttributeSet a = Carnet.this.m_doc.getCharacterElement(p).getAttributes();
                Color c = StyleConstants.getForeground(a);
                Carnet.this.m_foreground.setColor(c);
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        };
        this.m_foreground.addMenuListener(ml);
        this.m_background = new ColorMenu("Couleur de fond");
        this.m_background.setColor(this.texte.getBackground());
        this.m_background.setMnemonic('b');
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setBackground(attr, Carnet.this.m_background.getColor());
                Carnet.this.setAttributeSet(attr);
                Carnet.this.diplomate.modifTexteEffectuee(true);
            }
        };
        this.m_background.addActionListener(lst);
        mFormat.add(this.m_background);
        ml = new MenuListener(){

            public void menuSelected(MenuEvent e) {
                int p = Carnet.this.texte.getCaretPosition();
                AttributeSet a = Carnet.this.m_doc.getCharacterElement(p).getAttributes();
                Color c = StyleConstants.getBackground(a);
                Carnet.this.m_background.setColor(c);
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        };
        this.m_background.addMenuListener(ml);
        action = new AbstractAction("masquer", new ImageIcon(String.valueOf(this.dossierSysteme) + "masquer.gif")){

            public void actionPerformed(ActionEvent e) {
                Carnet.this.masquer();
            }
        };
        SmallButton mask = new SmallButton(action, "Masquer le carnet");
        menuBar.add(mEdit);
        menuBar.add(mFormat);
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createGlue());
        hBox.add(mask);
        menuBar.add(hBox);
        this.toolBar.addSeparator();
        this.m_cbStyles = new JComboBox();
        this.m_cbStyles.setMaximumSize(new Dimension(100, 20));
        this.m_cbStyles.setEditable(true);
        this.toolBar.add(this.m_cbStyles);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Carnet.this.m_skipUpdate || Carnet.this.m_cbStyles.getItemCount() == 0) {
                    return;
                }
                String name = (String)Carnet.this.m_cbStyles.getSelectedItem();
                int index = Carnet.this.m_cbStyles.getSelectedIndex();
                int p = Carnet.this.texte.getCaretPosition();
                if (index == -1) {
                    Carnet.this.m_cbStyles.addItem(name);
                    Style style = Carnet.this.m_doc.addStyle(name, null);
                    AttributeSet a = Carnet.this.m_doc.getCharacterElement(p).getAttributes();
                    style.addAttributes(a);
                    return;
                }
                Style currStyle = Carnet.this.m_doc.getLogicalStyle(p);
                if (!currStyle.getName().equals(name)) {
                    Style style = Carnet.this.m_doc.getStyle(name);
                    Carnet.this.setAttributeSet(style);
                    Carnet.this.diplomate.modifTexteEffectuee(true);
                }
            }
        };
        this.m_cbStyles.addActionListener(lst);
        return menuBar;
    }

    protected void showAttributes(int p) {
        boolean italic;
        boolean bold;
        int size;
        this.m_skipUpdate = true;
        AttributeSet a = this.m_doc.getCharacterElement(p).getAttributes();
        String name = StyleConstants.getFontFamily(a);
        if (!this.m_fontName.equals(name)) {
            this.m_fontName = name;
            this.m_cbFonts.setSelectedItem(name);
        }
        if (this.m_fontSize != (size = StyleConstants.getFontSize(a))) {
            this.m_fontSize = size;
            this.m_cbSizes.setSelectedItem(Integer.toString(this.m_fontSize));
        }
        if ((bold = StyleConstants.isBold(a)) != this.m_bBold.isSelected()) {
            this.m_bBold.setSelected(bold);
        }
        if ((italic = StyleConstants.isItalic(a)) != this.m_bItalic.isSelected()) {
            this.m_bItalic.setSelected(italic);
        }
        Style style = this.m_doc.getLogicalStyle(p);
        name = style.getName();
        this.m_cbStyles.setSelectedItem(name);
        this.m_skipUpdate = false;
    }

    protected void setAttributeSet(AttributeSet attr) {
        this.setAttributeSet(attr, false);
    }

    protected void setAttributeSet(AttributeSet attr, boolean setParagraphAttributes) {
        if (this.m_skipUpdate) {
            return;
        }
        int xStart = this.texte.getSelectionStart();
        int xFinish = this.texte.getSelectionEnd();
        if (!this.texte.hasFocus()) {
            xStart = this.m_xStart;
            xFinish = this.m_xFinish;
        }
        if (setParagraphAttributes) {
            this.m_doc.setParagraphAttributes(xStart, xFinish - xStart, attr, false);
        } else if (xStart != xFinish) {
            this.m_doc.setCharacterAttributes(xStart, xFinish - xStart, attr, false);
        } else {
            MutableAttributeSet inputAttributes = this.m_kit.getInputAttributes();
            inputAttributes.addAttributes(attr);
        }
    }

    protected void showStyles() {
        this.m_skipUpdate = true;
        if (this.m_cbStyles.getItemCount() > 0) {
            this.m_cbStyles.removeAllItems();
        }
        Enumeration<?> en = this.m_doc.getStyleNames();
        while (en.hasMoreElements()) {
            String str = en.nextElement().toString();
            this.m_cbStyles.addItem(str);
        }
        this.m_skipUpdate = false;
    }

    protected void updateUndo() {
        if (this.m_undo.canUndo()) {
            this.m_undoAction.setEnabled(true);
            this.m_undoAction.putValue("Name", this.m_undo.getUndoPresentationName().replace("D\u00e9faire", "Annuler"));
        } else {
            this.m_undoAction.setEnabled(false);
            this.m_undoAction.putValue("Name", "Annuler");
        }
        if (this.m_undo.canRedo()) {
            this.m_redoAction.setEnabled(true);
            this.m_redoAction.putValue("Name", this.m_undo.getRedoPresentationName().replace("Refaire", "R\u00e9tablir"));
        } else {
            this.m_redoAction.setEnabled(false);
            this.m_redoAction.putValue("Name", "R\u00e9tablir");
        }
    }

    public Document getDocument() {
        return this.m_doc;
    }

    public JTextPane getTextPane() {
        return this.texte;
    }

    public void setSelection(int xStart, int xFinish, boolean moveUp) {
        if (moveUp) {
            this.texte.setCaretPosition(xFinish);
            this.texte.moveCaretPosition(xStart);
        } else {
            this.texte.select(xStart, xFinish);
        }
        this.m_xStart = this.texte.getSelectionStart();
        this.m_xFinish = this.texte.getSelectionEnd();
    }

    public boolean charger(String chemin) {
        this.nouveauTexte();
        boolean res = this.texte.charger(chemin);
        this.validate();
        this.repaint();
        return res;
    }

    public void creer(String path) {
        this.nouveauTexte();
        this.texte.setPath(path);
        this.texte.enregistrer();
    }

    public boolean enregistrer() {
        return this.texte.enregistrer();
    }

    public void coller() {
        this.texte.paste();
    }

    private void nouveauTexte() {
        if (this.conteneur != null) {
            if (this.texte != null) {
                this.conteneur.remove(this.texte);
            }
            this.remove(this.conteneur);
        }
        this.texte = new Texte("");
        this.texte.addKeyListener(this.diplomate);
        this.m_kit = new RTFEditorKit();
        this.texte.setEditorKit(this.m_kit);
        this.m_context = new StyleContext();
        this.m_doc = new DefaultStyledDocument(this.m_context);
        this.texte.setDocument(this.m_doc);
        this.conteneur = new JScrollPane(this.texte);
        this.menuBar = this.createMenuBar();
        this.m_chooser = new JFileChooser();
        this.m_chooser.setCurrentDirectory(new File("."));
        this.m_rtfFilter = new FiltreSimple("RTF Documents", ".rtf");
        this.m_chooser.setFileFilter(this.m_rtfFilter);
        this.m_gifFilter = new FiltreSimple("GIF images", ".gif");
        this.m_jpgFilter = new FiltreSimple("JPG images", ".jpg");
        CaretListener lst = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                Carnet.this.showAttributes(e.getDot());
            }
        };
        this.texte.addCaretListener(lst);
        FocusListener flst = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (Carnet.this.m_xStart >= 0 && Carnet.this.m_xFinish >= 0) {
                    if (Carnet.this.texte.getCaretPosition() == Carnet.this.m_xStart) {
                        Carnet.this.texte.setCaretPosition(Carnet.this.m_xFinish);
                        Carnet.this.texte.moveCaretPosition(Carnet.this.m_xStart);
                    } else {
                        Carnet.this.texte.select(Carnet.this.m_xStart, Carnet.this.m_xFinish);
                    }
                }
            }

            public void focusLost(FocusEvent e) {
                Carnet.this.m_xStart = Carnet.this.texte.getSelectionStart();
                Carnet.this.m_xFinish = Carnet.this.texte.getSelectionEnd();
            }
        };
        this.texte.addFocusListener(flst);
        this.showAttributes(0);
        this.showStyles();
        this.m_doc.addUndoableEditListener(new Undoer());
        this.barresConteneur = new JPanel();
        this.barresConteneur.setLayout(new BorderLayout());
        this.barresConteneur.add((Component)this.menuBar, "North");
        this.barresConteneur.add((Component)this.toolBar, "South");
        this.add((Component)this.barresConteneur, "North");
        this.conteneur.setPreferredSize(new Dimension(200, 200));
        this.add((Component)this.conteneur, "Center");
    }

    public void reset() {
        if (this.conteneur != null) {
            this.remove(this.conteneur);
        }
        if (this.barresConteneur != null) {
            this.barresConteneur.remove(this.menuBar);
            this.barresConteneur.remove(this.toolBar);
            this.remove(this.barresConteneur);
            this.barresConteneur = null;
        }
        this.texte = null;
    }

    private class Undoer
    implements UndoableEditListener {
        public Undoer() {
            Carnet.this.m_undo.die();
            Carnet.this.updateUndo();
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            UndoableEdit edit = e.getEdit();
            Carnet.this.m_undo.addEdit(e.getEdit());
            Carnet.this.updateUndo();
        }
    }
}

