/*
 * Decompiled with CFR 0.152.
 */
package geonoteOutils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Traceur {
    protected Document document = null;
    protected String chemin = "";

    public Traceur() {
    }

    public Traceur(String path, String rac) {
        this.chemin = path;
        Element racine = new Element(rac);
        this.document = new Document(racine);
    }

    protected void ajouter(String nomElt) {
        Element eltNouvo = new Element(nomElt);
        this.document.getRootElement().addContent((Content)eltNouvo);
    }

    public void ajouterElt(String nomElt, String texte) {
        Element eltNouvo = this.rechercher(this.document.getRootElement(), nomElt);
        if (eltNouvo == null) {
            eltNouvo = new Element(nomElt);
            this.document.getRootElement().addContent((Content)eltNouvo);
        }
        if (texte.length() == 0) {
            eltNouvo.setText("vide");
        } else {
            eltNouvo.setText(texte);
        }
    }

    protected int[] exporteDate(Element elt) {
        int[] tab = new int[]{Integer.parseInt(this.rechercher(elt, "jour").getText()), Integer.parseInt(this.rechercher(elt, "mois").getText()), Integer.parseInt(this.rechercher(elt, "annee").getText()), Integer.parseInt(this.rechercher(elt, "heures").getText()), Integer.parseInt(this.rechercher(elt, "minutes").getText()), Integer.parseInt(this.rechercher(elt, "secondes").getText())};
        return tab;
    }

    protected ArrayList exporteFichiersDates(Element elt) {
        ArrayList<String> liste = new ArrayList<String>();
        if (elt != null) {
            if (elt.getName().matches("fichier")) {
                liste.add(elt.getText());
            } else {
                List listElements = elt.getChildren();
                Iterator i = listElements.iterator();
                while (i.hasNext()) {
                    Element courant = (Element)i.next();
                    liste.addAll(this.exporteFichiersDates(courant));
                }
            }
        }
        return liste;
    }

    public void ajouterDate(String j, String m, String a, String h, String min, String s) {
        this.ajouterDate(this.document.getRootElement(), j, m, a, h, min, s);
    }

    protected void ajouterDate(Element elt, String j, String m, String a, String h, String min, String s) {
        Element date = new Element("date");
        Element jour = new Element("jour");
        jour.setText(j);
        Element mois = new Element("mois");
        mois.setText(m);
        Element annee = new Element("annee");
        annee.setText(a);
        Element heure = new Element("heures");
        heure.setText(h);
        Element minute = new Element("minutes");
        minute.setText(min);
        Element seconde = new Element("secondes");
        seconde.setText(s);
        date.addContent((Content)jour);
        date.addContent((Content)mois);
        date.addContent((Content)annee);
        date.addContent((Content)heure);
        date.addContent((Content)minute);
        date.addContent((Content)seconde);
        elt.addContent((Content)date);
    }

    public String exporteType() {
        return this.document.getRootElement().getName();
    }

    public String exporteInfo(String elt) {
        Element cible = this.rechercher(this.document.getRootElement(), elt);
        if (cible != null) {
            return cible.getText();
        }
        return null;
    }

    protected Element rechercheDonnee(Element elt, String nomFichier) {
        Element cible = null;
        if (elt != null) {
            if (elt.getName().matches("donnee")) {
                String text;
                Element elt2 = this.rechercher(elt, "fichier");
                if (elt2 != null && (text = elt2.getText()).equals(nomFichier)) {
                    cible = elt;
                }
            } else {
                List listElements = elt.getChildren();
                boolean trouv\u00e9 = false;
                Iterator i = listElements.iterator();
                while (i.hasNext() && !trouv\u00e9) {
                    Element courant = (Element)i.next();
                    cible = this.rechercheDonnee(courant, nomFichier);
                    if (cible == null) continue;
                    trouv\u00e9 = true;
                }
            }
        }
        return cible;
    }

    protected Element rechercher(Element elt, String cherch\u00e9) {
        Element cible = null;
        if (elt != null) {
            if (elt.getName().equals(cherch\u00e9)) {
                cible = elt;
            } else {
                List listElements = elt.getChildren();
                boolean trouv\u00e9 = false;
                Iterator i = listElements.iterator();
                while (i.hasNext() && !trouv\u00e9) {
                    Element courant = (Element)i.next();
                    cible = this.rechercher(courant, cherch\u00e9);
                    if (cible == null) continue;
                    trouv\u00e9 = true;
                }
            }
        }
        return cible;
    }

    protected String[] horodatage() {
        Date date = new Date();
        String[] dateTab = date.toString().split(" ");
        String[] dateH = dateTab[3].split(":");
        return dateH;
    }

    protected Element rechercheArret(Element elt, String idArret) {
        Element cible = null;
        if (elt != null) {
            List listElements = elt.getChildren();
            boolean trouv\u00e9 = false;
            Iterator i = listElements.iterator();
            while (i.hasNext() && !trouv\u00e9) {
                Element id;
                Element courant = (Element)i.next();
                if (courant.getName() != "arret" || !(id = this.rechercher(courant, "id")).getText().matches(idArret)) continue;
                trouv\u00e9 = true;
                cible = courant;
            }
        }
        return cible;
    }

    protected ArrayList rechercheArrets(Element elt) {
        ArrayList<Element> cible = new ArrayList<Element>();
        if (elt != null) {
            List listElements = elt.getChildren();
            Iterator i = listElements.iterator();
            while (i.hasNext()) {
                Element courant = (Element)i.next();
                if (courant.getName() != "arret") continue;
                cible.add(courant);
            }
        }
        return cible;
    }

    public void afficher() {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            sortie.output(this.document, (OutputStream)System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean enregistrer() {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            sortie.output(this.document, (OutputStream)new FileOutputStream(this.chemin, false));
            return true;
        }
        catch (IOException e) {
            System.out.println("ECHEC enregistrement du fichier : " + this.chemin);
            return false;
        }
    }

    public boolean charger(String path) {
        SAXBuilder sxb = new SAXBuilder();
        try {
            this.document = sxb.build(path);
            this.chemin = path;
            return true;
        }
        catch (Exception e) {
            System.out.println("ECHEC chargement du fichier : " + path);
            return false;
        }
    }
}

