/*
 * Decompiled with CFR 0.152.
 */
package geonoteOutils;

import geonoteOutils.Traceur;
import geonoteTypesDonnees.Arret;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class TraceurCarte
extends Traceur {
    public TraceurCarte() {
    }

    public TraceurCarte(String path, String rac) {
        super(path, rac);
    }

    public void ajouteArret(int id, int x, int y) {
        Element arret = this.rechercheArret(this.document.getRootElement(), Integer.toString(id));
        if (arret != null) {
            Element X = this.rechercher(arret, "abscisse");
            Element Y = this.rechercher(arret, "ordonnee");
            X.setText(Integer.toString(x));
            Y.setText(Integer.toString(y));
        } else {
            arret = new Element("arret");
            Element eltId = new Element("id");
            eltId.setText(Integer.toString(id));
            Element abs = new Element("abscisse");
            abs.setText(Integer.toString(x));
            Element ord = new Element("ordonnee");
            ord.setText(Integer.toString(y));
            arret.addContent((Content)eltId);
            arret.addContent((Content)abs);
            arret.addContent((Content)ord);
            this.document.getRootElement().addContent((Content)arret);
        }
    }

    public void suppArret(int id) {
        Element cible = this.rechercheArret(this.document.getRootElement(), Integer.toString(id));
        if (cible != null) {
            Element pere = cible.getParentElement();
            pere.removeContent((Content)cible);
        }
    }

    public void suppLien(int id, String lien) {
        Element lienASup;
        Element cible = this.rechercheArret(this.document.getRootElement(), Integer.toString(id));
        if (cible != null && (lienASup = this.rechercheDonnee(cible, lien)) != null) {
            cible.removeContent((Content)lienASup);
        }
    }

    public void suppVue(String vue, String fichier) {
        Element vues = this.rechercher(this.document.getRootElement(), "vues");
        if (vues != null) {
            List listeVues = vues.getChildren();
            Iterator it = listeVues.iterator();
            boolean trouv\u00e9 = false;
            Element cible = null;
            while (it.hasNext() && !trouv\u00e9) {
                Element courant = (Element)it.next();
                Element nom = this.rechercher(courant, "nom");
                Element fich = this.rechercher(courant, "fichier");
                if (!nom.getText().equals(vue) || !fich.getText().equals(fichier)) continue;
                cible = courant;
                trouv\u00e9 = true;
            }
            if (cible != null) {
                vues.removeContent(cible);
            }
        }
    }

    public void ajouteVue(String nom, String fichier) {
        Element vues = this.rechercher(this.document.getRootElement(), "vues");
        if (vues == null) {
            vues = new Element("vues");
            this.document.getRootElement().addContent((Content)vues);
        }
        List listeVues = vues.getChildren();
        Iterator i = listeVues.iterator();
        boolean fichierAbsent = true;
        Element courant = null;
        while (i.hasNext() && fichierAbsent) {
            courant = (Element)i.next();
            Element fichElt = this.rechercher(courant, "fichier");
            if (!fichElt.getText().equals(fichier)) continue;
            fichierAbsent = false;
        }
        if (fichierAbsent) {
            Element vue = new Element("vue");
            Element name = new Element("nom");
            name.setText(nom);
            Element file = new Element("fichier");
            file.setText(fichier);
            vue.addContent((Content)name);
            vue.addContent((Content)file);
            vues.addContent((Content)vue);
        } else {
            Element nomElt = this.rechercher(courant, "nom");
            nomElt.setText(nom);
        }
    }

    public ArrayList exporteVues() {
        Element vues = this.rechercher(this.document.getRootElement(), "vues");
        ArrayList liste = new ArrayList();
        if (vues != null) {
            List listeVues = vues.getChildren();
            Iterator i = listeVues.iterator();
            while (i.hasNext()) {
                Element courant = (Element)i.next();
                ArrayList<String> capsule = new ArrayList<String>();
                capsule.add(courant.getChild("nom").getText());
                capsule.add(courant.getChild("fichier").getText());
                liste.add(capsule);
            }
        }
        return liste;
    }

    public String exporteTypeVuePrincipale() {
        Element vues = this.rechercher(this.document.getRootElement(), "vues");
        Element carte = this.rechercher(vues, "vue");
        Element nom = this.rechercher(carte, "nom");
        if (nom == null) {
            return null;
        }
        return nom.getText();
    }

    public String exporteFichierVuePrincipale() {
        Element vues = this.rechercher(this.document.getRootElement(), "vues");
        Element carte = this.rechercher(vues, "vue");
        Element fich = this.rechercher(carte, "fichier");
        if (fich == null) {
            return null;
        }
        return fich.getText();
    }

    public ArrayList exporteFichiers() {
        return this.exporteFichiers(this.document.getRootElement());
    }

    private ArrayList exporteFichiers(Element elt) {
        ArrayList<String> liste = new ArrayList<String>();
        if (elt != null) {
            if (elt.getName().matches("donnee")) {
                liste.add(this.rechercher(elt, "fichier").getText());
            } else {
                List listElements = elt.getChildren();
                Iterator i = listElements.iterator();
                while (i.hasNext()) {
                    Element courant = (Element)i.next();
                    liste.addAll(this.exporteFichiers(courant));
                }
            }
        }
        return liste;
    }

    private ArrayList exporteFichiersTyp\u00e9s(Element elt) {
        ArrayList liste = new ArrayList();
        if (elt != null) {
            if (elt.getName().matches("donnee")) {
                ArrayList<String> capsule = new ArrayList<String>();
                Element pere = elt.getParentElement();
                capsule.add(this.rechercher(pere, "id").getText());
                capsule.add(this.rechercher(elt, "fichier").getText());
                capsule.add(this.rechercher(elt, "typeGeologique").getText());
                liste.add(capsule);
            } else {
                List listElements = elt.getChildren();
                Iterator i = listElements.iterator();
                while (i.hasNext()) {
                    Element courant = (Element)i.next();
                    liste.addAll(this.exporteFichiersTyp\u00e9s(courant));
                }
            }
        }
        return liste;
    }

    public void ajouteDonneeArret(String path, int idArret, String type) {
        Element arret = this.rechercheArret(this.document.getRootElement(), Integer.toString(idArret));
        if (arret == null) {
            System.out.println("Erreur : arret inexistant !");
        } else {
            Element donnee = new Element("donnee");
            Element fichier = new Element("fichier");
            fichier.setText(path);
            Element typeG = new Element("typeGeologique");
            typeG.setText(type);
            Element etat = new Element("etat");
            etat.setText("accessible");
            donnee.addContent((Content)fichier);
            donnee.addContent((Content)typeG);
            donnee.addContent((Content)etat);
            arret.addContent((Content)donnee);
        }
    }

    public void ajouteEtat(String donneeCible, String etat) {
        Element cible = this.rechercheDonnee(this.document.getRootElement(), donneeCible);
        Element etatElt = this.rechercher(cible, "etat");
        if (etatElt == null) {
            etatElt = new Element("etat");
            cible.addContent((Content)etatElt);
        }
        etatElt.setText(etat);
    }

    public String exporteEtat(String donneeCible) {
        Element cible = this.rechercheDonnee(this.document.getRootElement(), donneeCible);
        Element etat = this.rechercher(cible, "etat");
        if (etat == null) {
            etat = new Element("etat");
            cible.addContent((Content)etat);
        }
        return etat.getText();
    }

    public void ajouteEchelle(double ech) {
        Element echelle = this.rechercher(this.document.getRootElement(), "echelle");
        if (echelle == null) {
            echelle = new Element("echelle");
            this.document.getRootElement().addContent((Content)echelle);
        }
        echelle.setText(Double.toString(ech));
    }

    public ArrayList construitArrets() {
        ArrayList<Arret> liste = new ArrayList<Arret>();
        ArrayList listArrets = new ArrayList();
        listArrets = this.rechercheArrets(this.document.getRootElement());
        Iterator i = listArrets.iterator();
        while (i.hasNext()) {
            Element arret = (Element)i.next();
            int id = Integer.parseInt(this.rechercher(arret, "id").getText());
            int abs = Integer.parseInt(this.rechercher(arret, "abscisse").getText());
            int ord = Integer.parseInt(this.rechercher(arret, "ordonnee").getText());
            ArrayList listLiens = new ArrayList();
            listLiens.addAll(this.exporteLiens(arret));
            Arret nouvArret = new Arret(id, abs, ord);
            nouvArret.importeListeLiens(listLiens);
            liste.add(nouvArret);
        }
        return liste;
    }

    private ArrayList exporteLiens(Element elt) {
        ArrayList<ArrayList> liste = new ArrayList<ArrayList>();
        if (elt != null) {
            ArrayList listeTypes = this.rechercheTypes(elt);
            Iterator i = listeTypes.iterator();
            while (i.hasNext()) {
                String typeCourant = (String)i.next();
                ArrayList listeDonneesPourUnType = this.rechercheDonneesType(elt, typeCourant);
                liste.add(listeDonneesPourUnType);
            }
        }
        return liste;
    }

    public int exporteIdArret(String fichier) {
        int res = 0;
        Element data = this.rechercheDonnee(this.document.getRootElement(), fichier);
        if (data != null) {
            Element arret = data.getParentElement();
            String id = this.rechercher(arret, "id").getText();
            res = Integer.parseInt(id);
        }
        return res;
    }

    private ArrayList rechercheDonneesType(Element elt, String type) {
        ArrayList<String> liste = new ArrayList<String>();
        if (elt != null) {
            liste.add(type);
            List listFils = elt.getChildren();
            Iterator i = listFils.iterator();
            while (i.hasNext()) {
                String typeCourant;
                Element courant = (Element)i.next();
                if (!courant.getName().matches("donnee") || !(typeCourant = this.rechercher(courant, "typeGeologique").getText()).matches(type)) continue;
                liste.add(this.rechercher(courant, "fichier").getText());
            }
        }
        return liste;
    }

    private ArrayList rechercheTypes(Element racine) {
        ArrayList<String> liste = new ArrayList<String>();
        if (racine != null) {
            List listFils = racine.getChildren();
            Iterator i = listFils.iterator();
            while (i.hasNext()) {
                String typeCourant;
                Element courant = (Element)i.next();
                if (!courant.getName().matches("donnee") || liste.contains(typeCourant = this.rechercher(courant, "typeGeologique").getText())) continue;
                liste.add(typeCourant);
            }
        }
        return liste;
    }

    public void ajouteCoord(String latitudeOrigine, String longitudeOrigine, String echelleLat, String echelleLong) {
        Element coord = this.rechercher(this.document.getRootElement(), "coordonnees");
        Element lati = null;
        Element longi = null;
        Element echLat = null;
        Element echLong = null;
        if (coord == null) {
            coord = new Element("coordonnees");
            Element orig = new Element("origine");
            lati = new Element("latitude");
            longi = new Element("longitude");
            echLat = new Element("echelleLatitude");
            echLong = new Element("echelleLongitude");
            orig.addContent((Content)lati);
            orig.addContent((Content)longi);
            coord.addContent((Content)orig);
            coord.addContent((Content)echLat);
            coord.addContent((Content)echLong);
            this.document.getRootElement().addContent((Content)coord);
        } else {
            lati = this.rechercher(coord, "latitude");
            longi = this.rechercher(coord, "longitude");
            echLat = this.rechercher(coord, "echelleLatitude");
            echLong = this.rechercher(coord, "echelleLongitude");
        }
        lati.setText(latitudeOrigine);
        longi.setText(longitudeOrigine);
        echLat.setText(echelleLat);
        echLong.setText(echelleLong);
    }
}

