/*
 * Decompiled with CFR 0.152.
 */
package geonoteOutilsCarnet;

import geonoteInterface.Interface;
import geonoteOutilsCarnet.DialogLayout;
import geonoteZones.Carnet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class FindDialog
extends JDialog {
    protected Carnet m_owner;
    protected JTabbedPane m_tb;
    protected JTextField m_txtFind1;
    protected JTextField m_txtFind2;
    protected Document m_docFind;
    protected Document m_docReplace;
    protected ButtonModel m_modelWord;
    protected ButtonModel m_modelCase;
    protected ButtonModel m_modelUp;
    protected ButtonModel m_modelDown;
    protected int m_searchIndex = -1;
    protected boolean m_searchUp = false;
    protected String m_searchData;

    public FindDialog(Interface i, Carnet owner, int index) {
        super(i, "Find and Replace", false);
        this.m_owner = owner;
        this.m_tb = new JTabbedPane();
        JPanel p1 = new JPanel(new BorderLayout());
        JPanel pc1 = new JPanel(new BorderLayout());
        JPanel pf = new JPanel();
        pf.setLayout(new DialogLayout(20, 5));
        pf.setBorder(new EmptyBorder(8, 5, 8, 0));
        pf.add(new JLabel("Find what:"));
        this.m_txtFind1 = new JTextField();
        this.m_docFind = this.m_txtFind1.getDocument();
        pf.add(this.m_txtFind1);
        pc1.add((Component)pf, "Center");
        JPanel po = new JPanel(new GridLayout(2, 2, 8, 2));
        po.setBorder(new TitledBorder(new EtchedBorder(), "Options"));
        JCheckBox chkWord = new JCheckBox("Whole words only");
        chkWord.setMnemonic('w');
        this.m_modelWord = chkWord.getModel();
        po.add(chkWord);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton rdUp = new JRadioButton("Search up");
        rdUp.setMnemonic('u');
        this.m_modelUp = rdUp.getModel();
        bg.add(rdUp);
        po.add(rdUp);
        JCheckBox chkCase = new JCheckBox("Match case");
        chkCase.setMnemonic('c');
        this.m_modelCase = chkCase.getModel();
        po.add(chkCase);
        JRadioButton rdDown = new JRadioButton("Search down", true);
        rdDown.setMnemonic('d');
        this.m_modelDown = rdDown.getModel();
        bg.add(rdDown);
        po.add(rdDown);
        pc1.add((Component)po, "South");
        p1.add((Component)pc1, "Center");
        JPanel p01 = new JPanel(new FlowLayout());
        JPanel p = new JPanel(new GridLayout(2, 1, 2, 8));
        ActionListener findAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.findNext(false, true);
            }
        };
        JButton btFind = new JButton("Find Next");
        btFind.addActionListener(findAction);
        btFind.setMnemonic('f');
        p.add(btFind);
        ActionListener closeAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.setVisible(false);
            }
        };
        JButton btClose = new JButton("Close");
        btClose.addActionListener(closeAction);
        btClose.setDefaultCapable(true);
        p.add(btClose);
        p01.add(p);
        p1.add((Component)p01, "East");
        this.m_tb.addTab("Find", p1);
        JPanel p2 = new JPanel(new BorderLayout());
        JPanel pc2 = new JPanel(new BorderLayout());
        JPanel pc = new JPanel();
        pc.setLayout(new DialogLayout(20, 5));
        pc.setBorder(new EmptyBorder(8, 5, 8, 0));
        pc.add(new JLabel("Find what:"));
        this.m_txtFind2 = new JTextField();
        this.m_txtFind2.setDocument(this.m_docFind);
        pc.add(this.m_txtFind2);
        pc.add(new JLabel("Replace:"));
        JTextField txtReplace = new JTextField();
        this.m_docReplace = txtReplace.getDocument();
        pc.add(txtReplace);
        pc2.add((Component)pc, "Center");
        po = new JPanel(new GridLayout(2, 2, 8, 2));
        po.setBorder(new TitledBorder(new EtchedBorder(), "Options"));
        chkWord = new JCheckBox("Whole words only");
        chkWord.setMnemonic('w');
        chkWord.setModel(this.m_modelWord);
        po.add(chkWord);
        bg = new ButtonGroup();
        rdUp = new JRadioButton("Search up");
        rdUp.setMnemonic('u');
        rdUp.setModel(this.m_modelUp);
        bg.add(rdUp);
        po.add(rdUp);
        chkCase = new JCheckBox("Match case");
        chkCase.setMnemonic('c');
        chkCase.setModel(this.m_modelCase);
        po.add(chkCase);
        rdDown = new JRadioButton("Search down", true);
        rdDown.setMnemonic('d');
        rdDown.setModel(this.m_modelDown);
        bg.add(rdDown);
        po.add(rdDown);
        pc2.add((Component)po, "South");
        p2.add((Component)pc2, "Center");
        JPanel p02 = new JPanel(new FlowLayout());
        p = new JPanel(new GridLayout(3, 1, 2, 8));
        ActionListener replaceAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.findNext(true, true);
            }
        };
        JButton btReplace = new JButton("Replace");
        btReplace.addActionListener(replaceAction);
        btReplace.setMnemonic('r');
        p.add(btReplace);
        ActionListener replaceAllAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int counter = 0;
                while (true) {
                    int result;
                    if ((result = FindDialog.this.findNext(true, false)) < 0) {
                        return;
                    }
                    if (result == 0) break;
                    ++counter;
                }
                JOptionPane.showMessageDialog(FindDialog.this.m_owner, String.valueOf(counter) + " replacement(s) have been done", "Info", 1);
            }
        };
        JButton btReplaceAll = new JButton("Replace All");
        btReplaceAll.addActionListener(replaceAllAction);
        btReplaceAll.setMnemonic('a');
        p.add(btReplaceAll);
        btClose = new JButton("Close");
        btClose.addActionListener(closeAction);
        btClose.setDefaultCapable(true);
        p.add(btClose);
        p02.add(p);
        p2.add((Component)p02, "East");
        p01.setPreferredSize(p02.getPreferredSize());
        this.m_tb.addTab("Replace", p2);
        this.m_tb.setSelectedIndex(index);
        this.getContentPane().add((Component)this.m_tb, "Center");
        WindowAdapter flst = new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                FindDialog.this.m_searchIndex = -1;
                if (FindDialog.this.m_tb.getSelectedIndex() == 0) {
                    FindDialog.this.m_txtFind1.grabFocus();
                } else {
                    FindDialog.this.m_txtFind2.grabFocus();
                }
            }

            public void windowDeactivated(WindowEvent e) {
                FindDialog.this.m_searchData = null;
            }
        };
        this.addWindowListener(flst);
        this.pack();
        this.setResizable(false);
    }

    public void setSelectedIndex(int index) {
        this.m_tb.setSelectedIndex(index);
        this.setVisible(true);
        this.m_searchIndex = -1;
    }

    public int findNext(boolean doReplace, boolean showWarnings) {
        int xFinish;
        int xStart;
        String replacement;
        JTextPane monitor;
        block22: {
            monitor = this.m_owner.getTextPane();
            int pos = monitor.getCaretPosition();
            if (this.m_modelUp.isSelected() != this.m_searchUp) {
                this.m_searchUp = this.m_modelUp.isSelected();
                this.m_searchIndex = -1;
            }
            if (this.m_searchIndex == -1) {
                try {
                    Document doc = this.m_owner.getDocument();
                    this.m_searchData = this.m_searchUp ? doc.getText(0, pos) : doc.getText(pos, doc.getLength() - pos);
                    this.m_searchIndex = pos;
                }
                catch (BadLocationException ex) {
                    this.warning(ex.toString());
                    return -1;
                }
            }
            String key = "";
            try {
                key = this.m_docFind.getText(0, this.m_docFind.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (key.length() == 0) {
                this.warning("Please enter the target to search");
                return -1;
            }
            if (!this.m_modelCase.isSelected()) {
                this.m_searchData = this.m_searchData.toLowerCase();
                key = key.toLowerCase();
            }
            if (this.m_modelWord.isSelected()) {
                int k = 0;
                while (k < Carnet.WORD_SEPARATORS.length) {
                    if (key.indexOf(Carnet.WORD_SEPARATORS[k]) >= 0) {
                        this.warning("The text target contains an illegal character '" + Carnet.WORD_SEPARATORS[k] + "'");
                        return -1;
                    }
                    ++k;
                }
            }
            replacement = "";
            if (doReplace) {
                try {
                    replacement = this.m_docReplace.getText(0, this.m_docReplace.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            xStart = -1;
            xFinish = -1;
            while (true) {
                boolean b2;
                if ((xStart = this.m_searchUp ? this.m_searchData.lastIndexOf(key, pos - 1) : this.m_searchData.indexOf(key, pos - this.m_searchIndex)) < 0) {
                    if (showWarnings) {
                        this.warning("Text not found");
                    }
                    return 0;
                }
                xFinish = xStart + key.length();
                if (!this.m_modelWord.isSelected()) break block22;
                boolean s1 = xStart > 0;
                boolean b1 = s1 && !Carnet.isSeparator(this.m_searchData.charAt(xStart - 1));
                boolean s2 = xFinish < this.m_searchData.length();
                boolean bl = b2 = s2 && !Carnet.isSeparator(this.m_searchData.charAt(xFinish));
                if (!b1 && !b2) break block22;
                if (this.m_searchUp && s1) {
                    pos = xStart;
                    continue;
                }
                if (this.m_searchUp || !s2) break;
                pos = xFinish;
            }
            if (showWarnings) {
                this.warning("Text not found");
            }
            return 0;
        }
        if (!this.m_searchUp) {
            xStart += this.m_searchIndex;
            xFinish += this.m_searchIndex;
        }
        if (doReplace) {
            this.m_owner.setSelection(xStart, xFinish, this.m_searchUp);
            monitor.replaceSelection(replacement);
            this.m_owner.setSelection(xStart, xStart + replacement.length(), this.m_searchUp);
            this.m_searchIndex = -1;
        } else {
            this.m_owner.setSelection(xStart, xFinish, this.m_searchUp);
        }
        return 1;
    }

    protected void warning(String message) {
        JOptionPane.showMessageDialog(this.m_owner, message, "Warning", 1);
    }
}

