/*
 * Decompiled with CFR 0.152.
 */
package com.dyomedea.doa.oXygen;

import com.dyomedea.doa.oXygen.SADocbookTableCustomizer;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.docbook.table.ECDocbookInnerTableCustomizer;
import ro.sync.ecss.extensions.docbook.table.ECDocbookTableCustomizer;
import ro.sync.ecss.extensions.docbook.table.SADocbookInnerTableCustomizer;

public class InsertTableOperation
extends AbstractTableOperation {
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{NAMESPACE_ARGUMENT_DESCRIPTOR};

    public InsertTableOperation() {
        super((AuthorTableHelper)new CALSDocumentTypeHelper());
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws IllegalArgumentException, AuthorOperationException {
        Object namespaceObj = args.getArgumentValue("namespace");
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        boolean addInnerTable = false;
        AuthorNode[] rows = authorAccess.getDocumentController().findNodesByXPath("ancestor-or-self::*:row", true, true, true);
        addInnerTable = rows.length > 0;
        TableInfo tableInfo = null;
        tableInfo = authorAccess.getWorkspaceAccess().isStandalone() ? (addInnerTable ? new SADocbookInnerTableCustomizer().customizeTable(authorAccess) : new SADocbookTableCustomizer().customizeTable(authorAccess)) : (addInnerTable ? new ECDocbookInnerTableCustomizer().customizeTable(authorAccess) : new ECDocbookTableCustomizer().customizeTable(authorAccess));
        if (tableInfo != null) {
            StringBuffer tableXMLFragment = this.getXMLFragment(tableInfo, (String)namespaceObj, addInnerTable);
            if (addInnerTable && authorAccess.getDocumentController().findNodesByXPath("self::*:row", true, true, true).length == 0) {
                authorAccess.getDocumentController().insertXMLFragmentSchemaAware(tableXMLFragment.toString(), "ancestor-or-self::*:entry[1]", "After");
            } else {
                authorAccess.getDocumentController().insertXMLFragmentSchemaAware(tableXMLFragment.toString(), caretOffset);
            }
        }
    }

    StringBuffer getXMLFragment(TableInfo tableInfo, String namespace, boolean innerTable) {
        StringBuffer tableXMLFragment = new StringBuffer();
        if (innerTable) {
            tableXMLFragment.append("<entrytbl ");
            if (tableInfo.getTitle() != null && namespace == null) {
                tableXMLFragment.append("title=\"").append(tableInfo.getTitle()).append("\" ");
            }
            tableXMLFragment.append("cols=\"" + tableInfo.getColumnsNumber() + "\" ");
        } else if (tableInfo.getTitle() != null) {
            tableXMLFragment.append("<table ");
        } else {
            tableXMLFragment.append("<informaltable ");
        }
        if (namespace != null) {
            tableXMLFragment.append("xmlns=\"").append(namespace).append("\" ");
        }
        if (!innerTable) {
            tableXMLFragment.append("frame=\"" + tableInfo.getFrame() + "\"");
        }
        tableXMLFragment.append(">");
        this.addCALSXMLFragment(tableXMLFragment, tableInfo, namespace, innerTable);
        if (innerTable) {
            tableXMLFragment.append("</entrytbl>");
        } else if (tableInfo.getTitle() != null) {
            tableXMLFragment.append("</table>");
        } else {
            tableXMLFragment.append("</informaltable>");
        }
        return tableXMLFragment;
    }

    private void addCALSXMLFragment(StringBuffer tableXMLFragment, TableInfo tableInfo, String namespace, boolean innerTable) {
        if (!innerTable && tableInfo.getTitle() != null) {
            tableXMLFragment.append("<title>" + tableInfo.getTitle() + "</title>");
        }
        if (!innerTable) {
            tableXMLFragment.append("<tgroup cols=\"" + tableInfo.getColumnsNumber() + "\">");
        }
        this.addCALSColSpecs(tableXMLFragment, tableInfo);
        this.addCALSTableHeader(tableXMLFragment, tableInfo);
        if (!innerTable) {
            this.addCALSTableFooter(tableXMLFragment, tableInfo);
        }
        this.addCALSTableBody(tableXMLFragment, tableInfo);
        if (!innerTable) {
            tableXMLFragment.append("</tgroup>");
        }
    }

    private void addCALSTableBody(StringBuffer tableXMLFragment, TableInfo tableInfo) {
        tableXMLFragment.append("<tbody>");
        for (int i = 0; i < tableInfo.getRowsNumber(); ++i) {
            tableXMLFragment.append("<row>");
            for (int j = 0; j < tableInfo.getColumnsNumber(); ++j) {
                tableXMLFragment.append("<entry></entry>");
            }
            tableXMLFragment.append("</row>");
        }
        tableXMLFragment.append("</tbody>");
    }

    private void addCALSTableFooter(StringBuffer tableXMLFragment, TableInfo tableInfo) {
        if (tableInfo.isGenerateFooter()) {
            tableXMLFragment.append("<tfoot><row>");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<entry></entry>");
            }
            tableXMLFragment.append("</row></tfoot>");
        }
    }

    private void addCALSTableHeader(StringBuffer tableXMLFragment, TableInfo tableInfo) {
        if (tableInfo.isGenerateHeader()) {
            tableXMLFragment.append("<thead><row>");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<entry></entry>");
            }
            tableXMLFragment.append("</row></thead>");
        }
    }

    private void addCALSColSpecs(StringBuffer tableXMLFragment, TableInfo tableInfo) {
        TableCustomizerConstants.ColumnWidthsType columnsWidthsType = tableInfo.getColumnsWidthsType();
        String colWidth = null;
        if (columnsWidthsType == TableCustomizerConstants.ColumnWidthsType.PROPORTIONAL_COL_WIDTHS) {
            colWidth = "1.0*";
        } else if (columnsWidthsType == TableCustomizerConstants.ColumnWidthsType.FIXED_COL_WIDTHS) {
            colWidth = "75pt";
        }
        for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
            tableXMLFragment.append("<colspec colname=\"c" + i + "\" colnum=\"" + i + "\"");
            if (colWidth != null) {
                tableXMLFragment.append(" colwidth=\"" + colWidth + "\"");
            }
            tableXMLFragment.append("/>");
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Insert a docbook table";
    }
}

