/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.jimi;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.JimiWriter;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.options.JPGOptions;
import com.sun.jimi.core.options.OptionException;
import com.sun.jimi.core.options.PNGOptions;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.imagetoolkit.ImageConverter;
import com.xmlmind.xmledit.imagetoolkit.ImageRenderer;
import com.xmlmind.xmledit.imagetoolkit.ImageRendererAdapter;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkit;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkitUtil;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URL;

public class JimiImageToolkit
implements ImageToolkit {
    private JimiRegistry registry;

    public JimiImageToolkit() {
        String[] stringArray = Jimi.getDecoderTypes();
        String[] stringArray2 = Jimi.getEncoderTypes();
        this.registry = new JimiRegistry();
    }

    public String getName() {
        return "Jimi";
    }

    public String getDescription() {
        return "Jimi 1.0 is a class library for managing images. Its primary function is in image I/O.\nSee http://java.sun.com/products/jimi/.\nCan read: TIFF, GIF, BMP, JPEG, PICT, PNG, PSD, Sun Raster, TGA,  XBM, XPM, ICO, CUR, PCX.\nCan write: BMP, JPEG, PICT, PNG, PSD, Sun Raster, TGA, XBM, XPM, ICO, CUR, PCX.";
    }

    public ImageRenderer getImageRenderer(URL uRL) {
        block7: {
            block6: {
                String string = URLPathUtil.extension((String)uRL.toExternalForm());
                if (string.length() == 0) break block6;
                if (JimiRegistry.canRead(string)) break block7;
            }
            return null;
        }
        JimiReader jimiReader = null;
        try {
            jimiReader = Jimi.createJimiReader(uRL, 4);
        }
        catch (JimiException jimiException) {
            // empty catch block
        }
        if (jimiReader == null) {
            return null;
        }
        final JimiReader jimiReader2 = jimiReader;
        return new ImageRendererAdapter(){

            public Image createImage(URL uRL, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
                jimiReader2.setBlocking(true);
                Image image = jimiReader2.getImage();
                return ImageToolkitUtil.scaleImage((Image)image, (double)d, (int)n, (double)d2, (int)n2, (boolean)bl, (boolean)bl2);
            }
        };
    }

    public ImageRenderer getImageRenderer(byte[] byArray) {
        String[] stringArray;
        block7: {
            block6: {
                stringArray = ImageToolkitUtil.detectImageFormat((byte[])byArray);
                if (stringArray == null) break block6;
                if (JimiRegistry.canRead(stringArray[0])) break block7;
            }
            return null;
        }
        JimiReader jimiReader = null;
        try {
            jimiReader = Jimi.createTypedJimiReader(new ByteArrayInputStream(byArray), "image/" + stringArray[0], 4);
        }
        catch (JimiException jimiException) {
            // empty catch block
        }
        if (jimiReader == null) {
            return null;
        }
        final JimiReader jimiReader2 = jimiReader;
        return new ImageRendererAdapter(){

            public Image createImage(byte[] byArray, URL uRL, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
                jimiReader2.setBlocking(true);
                Image image = jimiReader2.getImage();
                return ImageToolkitUtil.scaleImage((Image)image, (double)d, (int)n, (double)d2, (int)n2, (boolean)bl, (boolean)bl2);
            }
        };
    }

    public ImageRenderer getImageRenderer(Element element) {
        return null;
    }

    public ImageConverter getImageConverter(File file, File file2) {
        String string;
        block15: {
            block14: {
                block13: {
                    block12: {
                        String string2 = FileUtil.fileExtension((String)file.getPath());
                        if (string2.length() == 0) break block12;
                        if (JimiRegistry.canRead(string2)) break block13;
                    }
                    return null;
                }
                string = FileUtil.fileExtension((String)file2.getPath());
                if (string.length() == 0) break block14;
                if (JimiRegistry.canWrite(string)) break block15;
            }
            return null;
        }
        JimiReader jimiReader = null;
        try {
            jimiReader = Jimi.createJimiReader(file.getPath(), 4);
        }
        catch (JimiException jimiException) {
            // empty catch block
        }
        if (jimiReader == null) {
            return null;
        }
        JimiWriter jimiWriter = null;
        try {
            jimiWriter = Jimi.createJimiWriter(file2.getPath());
        }
        catch (JimiException jimiException) {
            // empty catch block
        }
        if (jimiWriter == null) {
            return null;
        }
        final JimiReader jimiReader2 = jimiReader;
        final JimiWriter jimiWriter2 = jimiWriter;
        return new ImageConverter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void convertImage(File file, File file2, String[] stringArray, Console console) throws Exception {
                Object object;
                Object object2 = null;
                if (stringArray != null && stringArray.length > 0) {
                    if ("jpeg".equalsIgnoreCase(string) || "jpg".equalsIgnoreCase(string)) {
                        object = new JPGOptions();
                        int n = 0;
                        while (n < stringArray.length) {
                            String string4 = stringArray[n];
                            String string2 = stringArray[n + 1];
                            if (!"quality".equals(string4)) throw new OptionException("unknown JPEG option '" + string4 + "': should be quality");
                            int n2 = -1;
                            try {
                                n2 = Integer.parseInt(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n2 < 0 || n2 > 100) {
                                throw new OptionException("invalid JPEG quality '" + string2 + "': should be an integer" + " between 0 and 100");
                            }
                            ((JPGOptions)object).setQuality(n2);
                            n += 2;
                        }
                        object2 = object;
                    } else {
                        if (!"png".equalsIgnoreCase(string)) throw new OptionException("options are not supported when writing " + string.toUpperCase() + " images");
                        object = new PNGOptions();
                        int n = 0;
                        while (n < stringArray.length) {
                            int n3;
                            String string5 = stringArray[n];
                            String string3 = stringArray[n + 1];
                            if (!"compression".equals(string5)) throw new OptionException("unknown PNG option '" + string5 + "': should be compression");
                            if ("none".equals(string3)) {
                                n3 = 0;
                            } else if ("default".equals(string3)) {
                                n3 = 1;
                            } else if ("fast".equals(string3)) {
                                n3 = 2;
                            } else {
                                if (!"max".equals(string3)) throw new OptionException("invalid PNG compression '" + string3 + "': should be none, default," + " fast, max");
                                n3 = 3;
                            }
                            ((PNGOptions)object).setCompressionType(n3);
                            n += 2;
                        }
                        object2 = object;
                    }
                }
                object = jimiReader2.getImageProducer();
                jimiWriter2.setSource((ImageProducer)object);
                if (object2 != null) {
                    jimiWriter2.setOptions((FormatOptionSet)object2);
                }
                jimiWriter2.putImage(file2.getPath());
            }
        };
    }

    private static class JimiRegistry
    extends JimiControl {
        private JimiRegistry() {
        }

        public static boolean canRead(String string) {
            return JimiControl.getDecoderByFileExtension(string) != null;
        }

        public static boolean canWrite(String string) {
            return JimiControl.getEncoderByFileExtension(string) != null;
        }
    }
}

