/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.CopyEmitter;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class NumberLinesEmitter
extends CopyEmitter {
    protected Stack elementStack = new Stack();
    protected int lineNumber = 0;
    protected boolean firstElement = true;
    protected static String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static String xhURI = "http://www.w3.org/1999/xhtml";
    protected int startinglinenumber = 1;
    protected int modulus = 5;
    protected int width = 3;
    protected String separator = " ";
    protected boolean foStylesheet = false;

    public NumberLinesEmitter(Controller controller, NamePool namePool, int n, int n2, int n3, String string, boolean bl) {
        super(controller, namePool);
        this.modulus = n2;
        this.startinglinenumber = n;
        this.width = n3;
        this.separator = string;
        this.foStylesheet = bl;
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        this.firstElement = false;
        if (this.lineNumber == 0) {
            this.lineNumber = this.startinglinenumber;
            this.formatLineNumber(this.lineNumber);
        }
        char[] cArray2 = new char[n2];
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            if (cArray[n4] == '\n') {
                StartElementInfo startElementInfo;
                if (n3 > 0) {
                    this.rtfEmitter.characters(cArray2, 0, n3);
                    n3 = 0;
                }
                Stack<StartElementInfo> stack = new Stack<StartElementInfo>();
                while (!this.elementStack.empty()) {
                    startElementInfo = (StartElementInfo)this.elementStack.pop();
                    this.rtfEmitter.endElement(startElementInfo.getNameCode());
                    stack.push(startElementInfo);
                }
                cArray2[n3++] = cArray[n4];
                this.rtfEmitter.characters(cArray2, 0, n3);
                n3 = 0;
                this.formatLineNumber(++this.lineNumber);
                while (!stack.empty()) {
                    startElementInfo = (StartElementInfo)stack.pop();
                    AttributeCollection attributeCollection = (AttributeCollection)startElementInfo.getAttributes();
                    AttributeCollection attributeCollection2 = new AttributeCollection(this.namePool);
                    int n5 = 0;
                    while (n5 < attributeCollection.getLength()) {
                        String string = attributeCollection.getLocalName(n5);
                        int n6 = attributeCollection.getNameCode(n5);
                        String string2 = attributeCollection.getType(n5);
                        String string3 = attributeCollection.getValue(n5);
                        String string4 = attributeCollection.getURI(n5);
                        String string5 = "";
                        if (string.indexOf(58) > 0) {
                            string5 = string.substring(0, string.indexOf(58));
                            string = string.substring(string.indexOf(58) + 1);
                        }
                        if (!(string4.equals("") && (this.foStylesheet && string.equals("id") || !this.foStylesheet && (string.equals("id") || string.equals("name"))))) {
                            attributeCollection2.addAttribute(string5, string4, string, string2, string3);
                        }
                        ++n5;
                    }
                    this.rtfEmitter.startElement(startElementInfo.getNameCode(), (Attributes)attributeCollection2, startElementInfo.getNamespaces(), startElementInfo.getNSCount());
                    this.elementStack.push(startElementInfo);
                }
            } else {
                cArray2[n3++] = cArray[n4];
            }
            ++n4;
        }
        if (n3 > 0) {
            this.rtfEmitter.characters(cArray2, 0, n3);
            n3 = 0;
        }
    }

    protected void formatLineNumber(int n) throws TransformerException {
        char c = '\u00a0';
        String string = "";
        if (n == 1 || this.modulus >= 1 && n % this.modulus == 0) {
            string = "" + n;
        }
        while (string.length() < this.width) {
            string = c + string;
        }
        string = string + this.separator;
        char[] cArray = new char[string.length()];
        int n2 = 0;
        while (n2 < string.length()) {
            cArray[n2] = string.charAt(n2);
            ++n2;
        }
        this.characters(cArray, 0, string.length());
    }

    public void endElement(int n) throws TransformerException {
        if (!this.elementStack.empty()) {
            this.elementStack.pop();
        }
        this.rtfEmitter.endElement(n);
    }

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        if (!this.skipThisElement(n)) {
            StartElementInfo startElementInfo = new StartElementInfo(n, attributes, nArray, n2);
            this.elementStack.push(startElementInfo);
        }
        this.firstElement = false;
        this.rtfEmitter.startElement(n, attributes, nArray, n2);
    }

    protected boolean skipThisElement(int n) {
        if (this.firstElement) {
            int n2 = this.namePool.getFingerprint(n);
            int n3 = this.namePool.getFingerprint(foURI, "block");
            int n4 = this.namePool.getFingerprint("", "pre");
            int n5 = this.namePool.getFingerprint("", "div");
            int n6 = this.namePool.getFingerprint(xhURI, "pre");
            int n7 = this.namePool.getFingerprint(xhURI, "div");
            if (this.foStylesheet && n2 == n3 || !this.foStylesheet && (n2 == n4 || n2 == n5 || n2 == n6 || n2 == n7)) {
                return true;
            }
        }
        return false;
    }

    private class StartElementInfo {
        private int _nameCode;
        Attributes _attributes;
        int[] _namespaces;
        int _nscount;

        public StartElementInfo(int n, Attributes attributes, int[] nArray, int n2) {
            this._nameCode = n;
            this._attributes = attributes;
            this._namespaces = nArray;
            this._nscount = n2;
        }

        public int getNameCode() {
            return this._nameCode;
        }

        public Attributes getAttributes() {
            return this._attributes;
        }

        public int[] getNamespaces() {
            return this._namespaces;
        }

        public int getNSCount() {
            return this._nscount;
        }
    }
}

