/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Extensions;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.ColumnScanEmitter;
import com.nwalsh.saxon.ColumnUpdateEmitter;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;

public class Table {
    private static int pixelsPerInch = 96;
    private static int nominalWidth = 6 * pixelsPerInch;
    private static String tableWidth = "100%";
    private static boolean foStylesheet = false;
    protected static Hashtable unitHash = null;

    protected static void initializeHash() {
        unitHash = new Hashtable();
        unitHash.put("in", new Float(pixelsPerInch));
        unitHash.put("cm", new Float((double)pixelsPerInch / 2.54));
        unitHash.put("mm", new Float((double)pixelsPerInch / 25.4));
        unitHash.put("pc", new Float(pixelsPerInch / 72 * 12));
        unitHash.put("pt", new Float(pixelsPerInch / 72));
        unitHash.put("px", new Float(1.0f));
    }

    public static void setPixelsPerInch(int n) {
        if (n > 0) {
            pixelsPerInch = n;
            Table.initializeHash();
        }
    }

    public int getPixelsPerInch() {
        return pixelsPerInch;
    }

    public static int convertLength(String string) {
        int n = 1;
        String string2 = "";
        String string3 = "";
        char[] cArray = string.toCharArray();
        float f = 0.0f;
        boolean bl = false;
        int n2 = 0;
        float f2 = 1.0f;
        int n3 = 0;
        if (unitHash == null) {
            Table.initializeHash();
        }
        if (cArray[n2] == '+' || cArray[n2] == '-') {
            if (cArray[n2] == '-') {
                n = -1;
            }
            ++n2;
        }
        while (!bl) {
            if (n2 >= cArray.length) {
                bl = true;
                continue;
            }
            if ((cArray[n2] > '9' || cArray[n2] < '0') && cArray[n2] != '.') {
                bl = true;
                string3 = string.substring(n2);
                continue;
            }
            string2 = string2 + cArray[n2++];
        }
        try {
            f = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(string2 + " is not a number; 1 used instead.");
            f = 1.0f;
        }
        Float f3 = null;
        if (!string3.equals("")) {
            f3 = (Float)unitHash.get(string3);
            if (f3 == null) {
                System.out.println(string3 + " is not a known unit; 1 used instead.");
                f2 = 1.0f;
            } else {
                f2 = f3.floatValue();
            }
        } else {
            f2 = 1.0f;
        }
        f3 = new Float(f * f2);
        n3 = f3.intValue() * n;
        return n3;
    }

    protected static String getVariable(Context context, String string) throws TransformerException {
        Value value = null;
        String string2 = null;
        try {
            value = Extensions.evaluate((Context)context, (String)("$" + string));
            string2 = value.asString();
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Undefined variable: " + string);
            return "";
        }
    }

    private static void setupColumnWidths(Context context) {
        nominalWidth = 6 * pixelsPerInch;
        tableWidth = "100%";
        String string = null;
        try {
            string = Table.getVariable(context, "stylesheet.result.type");
            foStylesheet = string.equals("fo");
            string = Table.getVariable(context, "nominal.table.width");
            nominalWidth = Table.convertLength(string);
            tableWidth = string = Table.getVariable(context, "table.width");
        }
        catch (TransformerException transformerException) {}
    }

    public static NodeSetValue adjustColumnWidths(Context context, NodeSetValue nodeSetValue) {
        FragmentValue fragmentValue = (FragmentValue)nodeSetValue;
        Table.setupColumnWidths(context);
        try {
            int n;
            int n2;
            Object object;
            int n3;
            Controller controller = context.getController();
            NamePool namePool = controller.getNamePool();
            ColumnScanEmitter columnScanEmitter = new ColumnScanEmitter(namePool);
            fragmentValue.replay((Emitter)columnScanEmitter);
            int n4 = columnScanEmitter.columnCount();
            String[] stringArray = columnScanEmitter.columnWidths();
            float f = 0.0f;
            float[] fArray = new float[n4];
            float f2 = 0.0f;
            float[] fArray2 = new float[n4];
            int n5 = 0;
            while (n5 < n4) {
                String string = stringArray[n5];
                n3 = string.indexOf("*");
                if (n3 >= 0) {
                    String string2 = string.substring(0, n3);
                    object = string.substring(n3 + 1);
                    try {
                        float f3 = Float.parseFloat(string2);
                        f += f3;
                        fArray[n5] = f3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println(string2 + " is not a valid relative unit.");
                    }
                    n2 = 0;
                    if (object != null && !((String)object).equals("")) {
                        n2 = Table.convertLength((String)object);
                    }
                    f2 += (float)n2;
                    fArray2[n5] = n2;
                } else {
                    fArray[n5] = 0.0f;
                    int n6 = 0;
                    if (string != null && !string.equals("")) {
                        n6 = Table.convertLength(string);
                    }
                    f2 += (float)n6;
                    fArray2[n5] = n6;
                }
                ++n5;
            }
            if (f == 0.0f) {
                n = 0;
                while (n < n4) {
                    Float f4 = new Float(fArray2[n]);
                    if (foStylesheet) {
                        int n7 = f4.intValue();
                        float f5 = (float)n7 / (float)pixelsPerInch;
                        stringArray[n] = f5 + "in";
                    } else {
                        stringArray[n] = Integer.toString(f4.intValue());
                    }
                    ++n;
                }
            } else if (f2 == 0.0f) {
                n = 0;
                while (n < n4) {
                    float f6 = fArray[n] / f * 100.0f;
                    Float f7 = new Float(f6);
                    stringArray[n] = Integer.toString(f7.intValue());
                    ++n;
                }
                stringArray = Table.correctRoundingError(stringArray);
            } else {
                n = nominalWidth;
                if (tableWidth.indexOf("%") <= 0) {
                    n = Table.convertLength(tableWidth);
                }
                if ((float)n <= f2) {
                    System.out.println("Table is wider than table width.");
                } else {
                    n = (int)((float)n - f2);
                }
                f2 = 0.0f;
                n3 = 0;
                while (n3 < n4) {
                    float f8 = fArray[n3] / f * (float)n;
                    fArray[n3] = f8 + fArray2[n3];
                    f2 += f8 + fArray2[n3];
                    ++n3;
                }
                if (tableWidth.indexOf("%") <= 0) {
                    int n8 = 0;
                    while (n8 < n4) {
                        object = new Float(fArray[n8]);
                        if (foStylesheet) {
                            n2 = ((Float)object).intValue();
                            float f9 = (float)n2 / (float)pixelsPerInch;
                            stringArray[n8] = f9 + "in";
                        } else {
                            stringArray[n8] = Integer.toString(((Float)object).intValue());
                        }
                        ++n8;
                    }
                } else {
                    int n9 = 0;
                    while (n9 < n4) {
                        float f10 = fArray[n9] / f2 * 100.0f;
                        Float f11 = new Float(f10);
                        stringArray[n9] = Integer.toString(f11.intValue());
                        ++n9;
                    }
                    stringArray = Table.correctRoundingError(stringArray);
                }
            }
            ColumnUpdateEmitter columnUpdateEmitter = new ColumnUpdateEmitter(controller, namePool, stringArray);
            fragmentValue.replay((Emitter)columnUpdateEmitter);
            return columnUpdateEmitter.getResultTreeFragment();
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in adjustColumnWidths");
            return fragmentValue;
        }
    }

    protected static String[] correctRoundingError(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                int n3 = Integer.parseInt(stringArray[n2]);
                n += n3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        float f = 100 - n;
        float f2 = f / (float)stringArray.length;
        float f3 = 0.0f;
        int n4 = 0;
        while (n4 < stringArray.length) {
            try {
                int n5 = Integer.parseInt(stringArray[n4]);
                f3 += f2;
                if ((double)f3 >= 1.0) {
                    int n6 = (int)Math.round(Math.floor(f3));
                    f3 -= (float)Math.floor(f3);
                    stringArray[n4] = Integer.toString(n5 += n6) + "%";
                } else {
                    stringArray[n4] = Integer.toString(n5) + "%";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n4;
        }
        return stringArray;
    }
}

