/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.net.ftp.UnixFileParser;
import com.enterprisedt.net.ftp.WindowsFileParser;
import java.text.ParseException;
import java.util.Calendar;

public class FTPFileFactory {
    private static String cvsId = "@(#)$Id: FTPFileFactory.java,v 1.3 2004/05/01 11:44:21 bruceb Exp $";
    private static final String WINDOWS_STR = "WINDOWS";
    private static final String UNIX_STR = "UNIX";
    private Calendar cal = Calendar.getInstance();
    private String system;
    private FTPFileParser parser = null;

    FTPFileFactory(String system) throws FTPException {
        this.setParser(system);
    }

    private void setParser(String system) throws FTPException {
        this.system = system;
        if (system.toUpperCase().startsWith(WINDOWS_STR)) {
            this.parser = new WindowsFileParser();
        } else if (system.toUpperCase().startsWith(UNIX_STR)) {
            this.parser = new UnixFileParser();
        } else {
            throw new FTPException("Unknown SYST: " + system);
        }
    }

    FTPFile[] parse(String[] files) throws ParseException {
        FTPFile[] temp = new FTPFile[files.length];
        int count = 0;
        int i = 0;
        while (i < files.length) {
            FTPFile file = this.parser.parse(files[i]);
            if (file != null) {
                temp[count++] = file;
            }
            ++i;
        }
        FTPFile[] result = new FTPFile[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }
}

