/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class UnixFileParser
extends FTPFileParser {
    private static String cvsId = "@(#)$Id: UnixFileParser.java,v 1.3 2004/05/05 20:27:41 bruceb Exp $";
    private static final String TOTAL = "total";
    private static final SimpleDateFormat formatter1 = new SimpleDateFormat("MMM-dd-yyyy", Locale.US);
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("MMM-dd-yyyy-HH:mm", Locale.US);
    private static final int MIN_FIELD_COUNT = 9;
    private int year = Calendar.getInstance().get(1);

    public FTPFile parse(String raw) throws ParseException {
        String[] fields = this.split(raw);
        if (fields.length == 2 && TOTAL.equalsIgnoreCase(fields[0])) {
            return null;
        }
        if (fields.length < 9) {
            throw new ParseException("Unexpected number of fields: " + fields.length, 0);
        }
        String permissions = fields[0];
        char ch = permissions.charAt(0);
        boolean isDir = false;
        boolean isLink = false;
        if (ch == 'd') {
            isDir = true;
        } else if (ch == 'l') {
            isLink = true;
        }
        String owner = fields[2];
        String group = fields[3];
        long size = 0L;
        String sizeStr = fields[4];
        try {
            size = Long.parseLong(sizeStr);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Failed to parse size: " + sizeStr, 0);
        }
        Date lastModified = null;
        StringBuffer stamp = new StringBuffer(fields[5]);
        stamp.append('-').append(fields[6]).append('-');
        if (fields[7].indexOf(58) < 0) {
            stamp.append(fields[7]);
            lastModified = formatter1.parse(stamp.toString());
        } else {
            stamp.append(this.year).append('-').append(fields[7]);
            lastModified = formatter2.parse(stamp.toString());
        }
        String name = fields[8];
        String linkedname = null;
        if (isLink && fields.length >= 11 && fields[9] == "->") {
            linkedname = fields[10];
        }
        FTPFile file = new FTPFile(1, raw, name, size, isDir, lastModified);
        file.setGroup(group);
        file.setOwner(owner);
        file.setLink(isLink);
        return file;
    }
}

